/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class MinVersionTestRunner
extends BlockJUnit4ClassRunner {
    public MinVersionTestRunner(Class klass) throws InitializationError {
        super(klass);
    }

    public void runChild(FrameworkMethod method, RunNotifier notifier) {
        MinVersion methodCondition = (MinVersion)method.getAnnotation(MinVersion.class);
        MinVersion classCondition = this.getTestClass().getJavaClass().getAnnotation(MinVersion.class);
        String versionStr = VersionInfo.getVersion();
        int version = VersionUtil.encodeVersion((String)versionStr);
        if (!(methodCondition != null && version < VersionUtil.encodeVersion((String)methodCondition.value()) || classCondition != null && version < VersionUtil.encodeVersion((String)classCondition.value()))) {
            super.runChild(method, notifier);
        } else {
            notifier.fireTestIgnored(this.describeChild(method));
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MinVersion {
        public String value();
    }
}

