/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.RawCellBuilderFactory;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.coprocessorclient.MetaDataEndpointImplConstants;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MetaDataUtilTest {
    private static final byte[] ROW = Bytes.toBytes((String)"row");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"qual");
    private static final byte[] ORIGINAL_VALUE = Bytes.toBytes((String)"generic-value");
    private static final byte[] DUMMY_TAGS = Bytes.toBytes((String)"tags");
    private final ExtendedCellBuilder mockBuilder = (ExtendedCellBuilder)Mockito.mock(ExtendedCellBuilder.class);
    private final ExtendedCell mockCellWithTags = (ExtendedCell)Mockito.mock(ExtendedCell.class);

    @Before
    public void setupMockCellBuilder() {
        Mockito.when((Object)this.mockBuilder.setRow((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)this.mockBuilder);
        Mockito.when((Object)this.mockBuilder.setFamily((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)this.mockBuilder);
        Mockito.when((Object)this.mockBuilder.setQualifier((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)this.mockBuilder);
        Mockito.when((Object)this.mockBuilder.setValue((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)this.mockBuilder);
        Mockito.when((Object)this.mockBuilder.setTimestamp(Mockito.anyLong())).thenReturn((Object)this.mockBuilder);
        Mockito.when((Object)this.mockBuilder.setType((Cell.Type)Mockito.any(Cell.Type.class))).thenReturn((Object)this.mockBuilder);
        Mockito.when((Object)this.mockBuilder.setTags((byte[])Mockito.any(byte[].class))).thenReturn((Object)this.mockBuilder);
        Mockito.when((Object)this.mockBuilder.build()).thenReturn((Object)this.mockCellWithTags);
    }

    @Test
    public void testEncode() {
        Assert.assertEquals((long)VersionUtil.encodeVersion((String)"0.94.5"), (long)VersionUtil.encodeVersion((String)"0.94.5-mapR"));
        Assert.assertTrue((VersionUtil.encodeVersion((String)"0.94.6") > VersionUtil.encodeVersion((String)"0.94.5-mapR") ? 1 : 0) != 0);
        Assert.assertTrue((VersionUtil.encodeVersion((String)"0.94.6") > VersionUtil.encodeVersion((String)"0.94.5") ? 1 : 0) != 0);
        Assert.assertTrue((VersionUtil.encodeVersion((String)"0.94.1-mapR") > VersionUtil.encodeVersion((String)"0.94") ? 1 : 0) != 0);
        Assert.assertTrue((VersionUtil.encodeVersion((String)"1", (String)"1", (String)"3") > VersionUtil.encodeVersion((String)"1", (String)"1", (String)"1") ? 1 : 0) != 0);
    }

    @Test
    public void testDecode() {
        int encodedVersion = VersionUtil.encodeVersion((String)"4.15.5");
        Assert.assertEquals((long)VersionUtil.decodeMajorVersion((int)encodedVersion), (long)4L);
        Assert.assertEquals((long)VersionUtil.decodeMinorVersion((int)encodedVersion), (long)15L);
        Assert.assertEquals((long)VersionUtil.decodePatchVersion((int)encodedVersion), (long)5L);
    }

    @Test
    public void testCompatibility() {
        Assert.assertTrue((boolean)MetaDataUtil.areClientAndServerCompatible((int)VersionUtil.encodeVersion((int)1, (int)2, (int)1), (int)1, (int)2).getIsCompatible());
        Assert.assertTrue((boolean)MetaDataUtil.areClientAndServerCompatible((int)VersionUtil.encodeVersion((int)1, (int)2, (int)10), (int)1, (int)1).getIsCompatible());
        Assert.assertTrue((boolean)MetaDataUtil.areClientAndServerCompatible((int)VersionUtil.encodeVersion((int)1, (int)2, (int)0), (int)1, (int)2).getIsCompatible());
        Assert.assertTrue((boolean)MetaDataUtil.areClientAndServerCompatible((int)VersionUtil.encodeVersion((int)1, (int)2, (int)255), (int)1, (int)2).getIsCompatible());
        Assert.assertTrue((boolean)MetaDataUtil.areClientAndServerCompatible((int)VersionUtil.encodeVersion((int)2, (int)2, (int)0), (int)2, (int)0).getIsCompatible());
        Assert.assertTrue((boolean)MetaDataUtil.areClientAndServerCompatible((int)VersionUtil.encodeVersion((int)2, (int)10, (int)36), (int)2, (int)9).getIsCompatible());
        Assert.assertFalse((boolean)MetaDataUtil.areClientAndServerCompatible((int)VersionUtil.encodeVersion((int)3, (int)1, (int)10), (int)4, (int)0).getIsCompatible());
        Assert.assertFalse((boolean)MetaDataUtil.areClientAndServerCompatible((int)VersionUtil.encodeVersion((int)3, (int)1, (int)10), (int)2, (int)0).getIsCompatible());
        Assert.assertFalse((boolean)MetaDataUtil.areClientAndServerCompatible((int)VersionUtil.encodeVersion((int)3, (int)1, (int)10), (int)3, (int)2).getIsCompatible());
        Assert.assertFalse((boolean)MetaDataUtil.areClientAndServerCompatible((int)VersionUtil.encodeVersion((int)3, (int)1, (int)10), (int)3, (int)5).getIsCompatible());
    }

    @Test
    public void testCompatibilityNewerClient() {
        MetaDataUtil.ClientServerCompatibility compatibility1 = MetaDataUtil.areClientAndServerCompatible((int)VersionUtil.encodeVersion((int)3, (int)1, (int)10), (int)4, (int)0);
        Assert.assertFalse((boolean)compatibility1.getIsCompatible());
        Assert.assertEquals((long)compatibility1.getErrorCode(), (long)SQLExceptionCode.OUTDATED_JARS.getErrorCode());
        MetaDataUtil.ClientServerCompatibility compatibility2 = MetaDataUtil.areClientAndServerCompatible((int)VersionUtil.encodeVersion((int)3, (int)1, (int)10), (int)3, (int)2);
        Assert.assertFalse((boolean)compatibility2.getIsCompatible());
        Assert.assertEquals((long)compatibility2.getErrorCode(), (long)SQLExceptionCode.OUTDATED_JARS.getErrorCode());
    }

    @Test
    public void testCompatibilityMismatchedMajorVersions() {
        MetaDataUtil.ClientServerCompatibility compatibility = MetaDataUtil.areClientAndServerCompatible((int)VersionUtil.encodeVersion((int)3, (int)1, (int)10), (int)2, (int)0);
        Assert.assertFalse((boolean)compatibility.getIsCompatible());
        Assert.assertEquals((long)compatibility.getErrorCode(), (long)SQLExceptionCode.INCOMPATIBLE_CLIENT_SERVER_JAR.getErrorCode());
    }

    @Test
    public void testMutatingAPut() throws Exception {
        Put put = this.generateOriginalPut();
        byte[] newValue = Bytes.toBytes((String)"new-value");
        Cell cell = (Cell)put.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, QUALIFIER).get(0);
        Assert.assertEquals((Object)Bytes.toString((byte[])ORIGINAL_VALUE), (Object)Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
        MetaDataUtil.mutatePutValue((Put)put, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])QUALIFIER, (byte[])newValue);
        cell = (Cell)put.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, QUALIFIER).get(0);
        Assert.assertEquals((Object)Bytes.toString((byte[])newValue), (Object)Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
    }

    @Test
    public void testTaggingAPutWrongQualifier() throws Exception {
        Put put = this.generateOriginalPut();
        Cell initialCell = (Cell)put.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, QUALIFIER).get(0);
        MetaDataUtil.conditionallyAddTagsToPutCells((Put)put, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])HConstants.EMPTY_BYTE_ARRAY, (ExtendedCellBuilder)this.mockBuilder, (byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])DUMMY_TAGS);
        ((ExtendedCellBuilder)Mockito.verify((Object)this.mockBuilder, (VerificationMode)Mockito.never())).setTags((byte[])Mockito.any(byte[].class));
        Cell newCell = (Cell)((List)put.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES)).get(0);
        Assert.assertEquals((Object)initialCell, (Object)newCell);
        Assert.assertNull((Object)TagUtil.carryForwardTags((Cell)newCell));
    }

    @Test
    public void testTaggingAPutUnconditionally() throws Exception {
        Put put = this.generateOriginalPut();
        MetaDataUtil.conditionallyAddTagsToPutCells((Put)put, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])QUALIFIER, (ExtendedCellBuilder)this.mockBuilder, null, (byte[])DUMMY_TAGS);
        ((ExtendedCellBuilder)Mockito.verify((Object)this.mockBuilder, (VerificationMode)Mockito.times((int)1))).setTags((byte[])Mockito.any(byte[].class));
        Cell newCell = (Cell)((List)put.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES)).get(0);
        Assert.assertEquals((Object)this.mockCellWithTags, (Object)newCell);
    }

    @Test
    public void testSkipTaggingAPutDueToSameCellValue() throws Exception {
        Put put = this.generateOriginalPut();
        Cell initialCell = (Cell)put.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, QUALIFIER).get(0);
        MetaDataUtil.conditionallyAddTagsToPutCells((Put)put, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])QUALIFIER, (ExtendedCellBuilder)this.mockBuilder, (byte[])ORIGINAL_VALUE, (byte[])DUMMY_TAGS);
        ((ExtendedCellBuilder)Mockito.verify((Object)this.mockBuilder, (VerificationMode)Mockito.never())).setTags((byte[])Mockito.any(byte[].class));
        Cell newCell = (Cell)((List)put.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES)).get(0);
        Assert.assertEquals((Object)initialCell, (Object)newCell);
        Assert.assertNull((Object)TagUtil.carryForwardTags((Cell)newCell));
    }

    @Test
    public void testTaggingAPutDueToDifferentCellValue() throws Exception {
        Put put = this.generateOriginalPut();
        MetaDataUtil.conditionallyAddTagsToPutCells((Put)put, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])QUALIFIER, (ExtendedCellBuilder)this.mockBuilder, (byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])DUMMY_TAGS);
        ((ExtendedCellBuilder)Mockito.verify((Object)this.mockBuilder, (VerificationMode)Mockito.times((int)1))).setTags((byte[])Mockito.any(byte[].class));
        Cell newCell = (Cell)((List)put.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES)).get(0);
        Assert.assertEquals((Object)this.mockCellWithTags, (Object)newCell);
    }

    @Test
    public void testGetMutationKeyValue() throws Exception {
        String version = VersionInfo.getVersion();
        KeyValueBuilder builder = KeyValueBuilder.get((String)version);
        KeyValue kv = builder.buildPut((ImmutableBytesWritable)MetaDataUtilTest.wrap(ROW), (ImmutableBytesWritable)MetaDataUtilTest.wrap(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES), (ImmutableBytesWritable)MetaDataUtilTest.wrap(QUALIFIER), (ImmutableBytesWritable)MetaDataUtilTest.wrap(ORIGINAL_VALUE));
        Put put = new Put(ROW);
        KeyValueBuilder.addQuietly((Mutation)put, (KeyValue)kv);
        ImmutableBytesPtr ptr = new ImmutableBytesPtr();
        Assert.assertTrue((boolean)MetaDataUtil.getMutationValue((Mutation)put, (byte[])QUALIFIER, (KeyValueBuilder)builder, (ImmutableBytesWritable)ptr));
        Assert.assertEquals((String)("Value returned doesn't match stored value for " + builder.getClass().getName() + "!"), (long)0L, (long)ByteUtil.BYTES_PTR_COMPARATOR.compare(ptr, MetaDataUtilTest.wrap(ORIGINAL_VALUE)));
        if (builder != GenericKeyValueBuilder.INSTANCE) {
            builder = GenericKeyValueBuilder.INSTANCE;
            byte[] value = Bytes.toBytes((String)"client-value");
            kv = builder.buildPut((ImmutableBytesWritable)MetaDataUtilTest.wrap(ROW), (ImmutableBytesWritable)MetaDataUtilTest.wrap(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES), (ImmutableBytesWritable)MetaDataUtilTest.wrap(QUALIFIER), (ImmutableBytesWritable)MetaDataUtilTest.wrap(value));
            put = new Put(ROW);
            KeyValueBuilder.addQuietly((Mutation)put, (KeyValue)kv);
            Assert.assertTrue((boolean)MetaDataUtil.getMutationValue((Mutation)put, (byte[])QUALIFIER, (KeyValueBuilder)builder, (ImmutableBytesWritable)ptr));
            Assert.assertEquals((String)("Value returned doesn't match stored value for " + builder.getClass().getName() + "!"), (long)0L, (long)ByteUtil.BYTES_PTR_COMPARATOR.compare(ptr, MetaDataUtilTest.wrap(value)));
            Assert.assertFalse((boolean)MetaDataUtil.getMutationValue((Mutation)put, (byte[])Bytes.toBytes((String)"not a match"), (KeyValueBuilder)builder, (ImmutableBytesWritable)ptr));
        }
    }

    private static ImmutableBytesPtr wrap(byte[] bytes) {
        return new ImmutableBytesPtr(bytes);
    }

    @Test
    public void testEncodeDecode() {
        String hbaseVersionStr = "0.98.14";
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        config.setBoolean("phoenix.schema.mapSystemTablesToNamespace", false);
        config.setBoolean("phoenix.schema.isNamespaceMappingEnabled", false);
        long version = MetaDataUtil.encodeVersion((String)hbaseVersionStr, (Configuration)config);
        int hbaseVersion = MetaDataUtil.decodeHBaseVersion((long)version);
        int expectedHBaseVersion = VersionUtil.encodeVersion((int)0, (int)98, (int)14);
        Assert.assertEquals((long)expectedHBaseVersion, (long)hbaseVersion);
        boolean isTableNamespaceMappingEnabled = MetaDataUtil.decodeTableNamespaceMappingEnabled((long)version);
        Assert.assertFalse((boolean)isTableNamespaceMappingEnabled);
        int phoenixVersion = MetaDataUtil.decodePhoenixVersion((long)version);
        int expectedPhoenixVersion = VersionUtil.encodeVersion((int)5, (int)3, (int)0);
        Assert.assertEquals((long)expectedPhoenixVersion, (long)phoenixVersion);
        config.setBoolean("phoenix.schema.isNamespaceMappingEnabled", true);
        version = MetaDataUtil.encodeVersion((String)hbaseVersionStr, (Configuration)config);
        hbaseVersion = MetaDataUtil.decodeHBaseVersion((long)version);
        expectedHBaseVersion = VersionUtil.encodeVersion((int)0, (int)98, (int)14);
        Assert.assertEquals((long)expectedHBaseVersion, (long)hbaseVersion);
        isTableNamespaceMappingEnabled = MetaDataUtil.decodeTableNamespaceMappingEnabled((long)version);
        Assert.assertTrue((boolean)isTableNamespaceMappingEnabled);
        phoenixVersion = MetaDataUtil.decodePhoenixVersion((long)version);
        expectedPhoenixVersion = VersionUtil.encodeVersion((int)5, (int)3, (int)0);
        Assert.assertEquals((long)expectedPhoenixVersion, (long)phoenixVersion);
    }

    private Put generateOriginalPut() {
        String version = VersionInfo.getVersion();
        KeyValueBuilder builder = KeyValueBuilder.get((String)version);
        KeyValue kv = builder.buildPut((ImmutableBytesWritable)MetaDataUtilTest.wrap(ROW), (ImmutableBytesWritable)MetaDataUtilTest.wrap(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES), (ImmutableBytesWritable)MetaDataUtilTest.wrap(QUALIFIER), (ImmutableBytesWritable)MetaDataUtilTest.wrap(ORIGINAL_VALUE));
        Put put = new Put(ROW);
        KeyValueBuilder.addQuietly((Mutation)put, (KeyValue)kv);
        return put;
    }

    @Test
    public void testConditionallyAddTagsToPutCells() {
        List tags = TagUtil.asList((byte[])MetaDataEndpointImplConstants.VIEW_MODIFIED_PROPERTY_BYTES, (int)0, (int)MetaDataEndpointImplConstants.VIEW_MODIFIED_PROPERTY_BYTES.length);
        Assert.assertEquals((long)tags.size(), (long)1L);
        Tag expectedTag = (Tag)tags.get(0);
        String version = VersionInfo.getVersion();
        KeyValueBuilder builder = KeyValueBuilder.get((String)version);
        KeyValue kv = builder.buildPut((ImmutableBytesWritable)MetaDataUtilTest.wrap(ROW), (ImmutableBytesWritable)MetaDataUtilTest.wrap(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES), (ImmutableBytesWritable)MetaDataUtilTest.wrap(PhoenixDatabaseMetaData.UPDATE_CACHE_FREQUENCY_BYTES), (ImmutableBytesWritable)MetaDataUtilTest.wrap(PLong.INSTANCE.toBytes((Object)0)));
        Put put = new Put(ROW);
        KeyValueBuilder.addQuietly((Mutation)put, (KeyValue)kv);
        ExtendedCellBuilder cellBuilder = (ExtendedCellBuilder)RawCellBuilderFactory.create();
        MetaDataUtil.conditionallyAddTagsToPutCells((Put)put, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.UPDATE_CACHE_FREQUENCY_BYTES, (ExtendedCellBuilder)cellBuilder, (byte[])PInteger.INSTANCE.toBytes((Object)1), (byte[])MetaDataEndpointImplConstants.VIEW_MODIFIED_PROPERTY_BYTES);
        Cell cell = (Cell)((List)put.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES)).get(0);
        Assert.assertTrue((Bytes.compareTo((byte[])expectedTag.getValueArray(), (byte[])TagUtil.concatTags((byte[])HConstants.EMPTY_BYTE_ARRAY, (Cell)cell)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.contains((byte[])TagUtil.concatTags((byte[])HConstants.EMPTY_BYTE_ARRAY, (Cell)cell), (byte[])expectedTag.getValueArray()));
        Iterator tagIterator = PrivateCellUtil.tagsIterator((Cell)cell);
        Assert.assertTrue((boolean)tagIterator.hasNext());
        Tag actualTag = (Tag)tagIterator.next();
        Assert.assertTrue((Bytes.compareTo((byte[])actualTag.getValueArray(), (int)actualTag.getValueOffset(), (int)actualTag.getValueLength(), (byte[])expectedTag.getValueArray(), (int)expectedTag.getValueOffset(), (int)expectedTag.getValueLength()) == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)tagIterator.hasNext());
    }

    @Test
    public void testGetLastDDLTimestampUpdate() throws Exception {
        byte[] tableHeaderRowKey = SchemaUtil.getTableKey((String)"TenantId", (String)"schema", (String)"table");
        long serverTimestamp = EnvironmentEdgeManager.currentTimeMillis();
        long clientTimestamp = serverTimestamp - 1000L;
        Put p = MetaDataUtil.getLastDDLTimestampUpdate((byte[])tableHeaderRowKey, (long)clientTimestamp, (long)serverTimestamp);
        Assert.assertNotNull((Object)p);
        Assert.assertFalse((String)"Mutation is empty!", (boolean)p.isEmpty());
        Assert.assertArrayEquals((byte[])tableHeaderRowKey, (byte[])p.getRow());
        Assert.assertEquals((long)clientTimestamp, (long)p.getTimestamp());
        Assert.assertTrue((boolean)p.cellScanner().advance());
        List cells = p.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LAST_DDL_TIMESTAMP_BYTES);
        Assert.assertNotNull((Object)cells);
        Assert.assertTrue((cells.size() > 0 ? 1 : 0) != 0);
        Cell c = (Cell)cells.get(0);
        Assert.assertNotNull((String)"Cell is null!", (Object)c);
        Assert.assertEquals((long)serverTimestamp, (long)PLong.INSTANCE.getCodec().decodeLong(CellUtil.cloneValue((Cell)c), 0, SortOrder.ASC));
    }
}

