/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.util.LogUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LogUtilTest {
    @Mock
    PhoenixConnection con;

    @Test
    public void testAddCustomAnnotationsWithNullConnection() {
        String logLine = LogUtil.addCustomAnnotations((String)"log line", (PhoenixConnection)null);
        Assert.assertEquals((Object)logLine, (Object)"log line");
    }

    @Test
    public void testAddCustomAnnotationsWithNullAnnotations() {
        Mockito.when((Object)this.con.getCustomTracingAnnotations()).thenReturn(null);
        String logLine = LogUtil.addCustomAnnotations((String)"log line", (PhoenixConnection)this.con);
        Assert.assertEquals((Object)logLine, (Object)"log line");
    }

    @Test
    public void testAddCustomAnnotations() {
        Mockito.when((Object)this.con.getCustomTracingAnnotations()).thenReturn((Object)ImmutableMap.of((Object)"a1", (Object)"v1", (Object)"a2", (Object)"v2"));
        String logLine = LogUtil.addCustomAnnotations((String)"log line", (PhoenixConnection)this.con);
        Assert.assertTrue((boolean)logLine.contains("log line"));
        Assert.assertTrue((boolean)logLine.contains("a1=v1"));
        Assert.assertTrue((boolean)logLine.contains("a2=v2"));
    }
}

