/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.JDBCUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.Test;

public class JDBCUtilTest {
    @Test
    public void testGetCustomTracingAnnotationsWithNone() {
        String url = "localhost;TenantId=abc;";
        Map customAnnotations = JDBCUtil.getAnnotations((String)url, (Properties)new Properties());
        Assert.assertTrue((boolean)customAnnotations.isEmpty());
    }

    @Test
    public void testGetCustomTracingAnnotationInBothPropertiesAndURL() {
        String annotKey1 = "key1";
        String annotVal1 = "val1";
        String annotKey2 = "key2";
        String annotVal2 = "val2";
        String annotKey3 = "key3";
        String annotVal3 = "val3";
        String url = "localhost;phoenix.annotation." + annotKey1 + "=" + annotVal1;
        Properties prop = new Properties();
        prop.put("phoenix.annotation." + annotKey2, annotVal2);
        prop.put("phoenix.annotation." + annotKey3, annotVal3);
        Map customAnnotations = JDBCUtil.getAnnotations((String)url, (Properties)prop);
        Assert.assertEquals((long)3L, (long)customAnnotations.size());
        Assert.assertEquals((Object)annotVal1, customAnnotations.get(annotKey1));
        Assert.assertEquals((Object)annotVal2, customAnnotations.get(annotKey2));
        Assert.assertEquals((Object)annotVal3, customAnnotations.get(annotKey3));
    }

    @Test
    public void testRemoveProperty() {
        Assert.assertEquals((Object)"localhost;", (Object)JDBCUtil.removeProperty((String)"localhost;TenantId=abc;", (String)"TenantId"));
        Assert.assertEquals((Object)"localhost;foo=bar", (Object)JDBCUtil.removeProperty((String)"localhost;TenantId=abc;foo=bar", (String)"TenantId"));
        Assert.assertEquals((Object)"localhost;TenantId=abc", (Object)JDBCUtil.removeProperty((String)"localhost;TenantId=abc;foo=bar", (String)"foo"));
        Assert.assertEquals((Object)"localhost;TenantId=abc;foo=bar", (Object)JDBCUtil.removeProperty((String)"localhost;TenantId=abc;foo=bar", (String)"bar"));
    }

    @Test
    public void testGetAutoCommit_NotSpecified_DefaultTrue() {
        Assert.assertTrue((boolean)JDBCUtil.getAutoCommit((String)"localhost", (Properties)new Properties(), (boolean)true));
    }

    @Test
    public void testGetAutoCommit_NotSpecified_DefaultFalse() {
        Assert.assertFalse((boolean)JDBCUtil.getAutoCommit((String)"localhost", (Properties)new Properties(), (boolean)false));
    }

    @Test
    public void testGetAutoCommit_TrueInUrl() {
        Assert.assertTrue((boolean)JDBCUtil.getAutoCommit((String)"localhost;AutoCommit=TrUe", (Properties)new Properties(), (boolean)false));
    }

    @Test
    public void testGetAutoCommit_FalseInUrl() {
        Assert.assertFalse((boolean)JDBCUtil.getAutoCommit((String)"localhost;AutoCommit=FaLse", (Properties)new Properties(), (boolean)false));
    }

    @Test
    public void testGetAutoCommit_TrueInProperties() {
        Properties props = new Properties();
        props.setProperty("AutoCommit", "true");
        Assert.assertTrue((boolean)JDBCUtil.getAutoCommit((String)"localhost", (Properties)props, (boolean)false));
    }

    @Test
    public void testGetAutoCommit_FalseInProperties() {
        Properties props = new Properties();
        props.setProperty("AutoCommit", "false");
        Assert.assertFalse((boolean)JDBCUtil.getAutoCommit((String)"localhost", (Properties)props, (boolean)false));
    }

    @Test
    public void testGetConsistency_TIMELINE_InUrl() {
        Assert.assertTrue((JDBCUtil.getConsistencyLevel((String)"localhost;Consistency=TIMELINE", (Properties)new Properties(), (String)Consistency.STRONG.toString()) == Consistency.TIMELINE ? 1 : 0) != 0);
    }

    @Test
    public void testSchema() {
        Assert.assertTrue((boolean)JDBCUtil.getSchema((String)"localhost;schema=TEST", (Properties)new Properties(), null).equals("TEST"));
        Assert.assertNull((Object)JDBCUtil.getSchema((String)"localhost;schema=", (Properties)new Properties(), null));
        Assert.assertNull((Object)JDBCUtil.getSchema((String)"localhost;", (Properties)new Properties(), null));
    }

    @Test
    public void testGetConsistency_TIMELINE_InProperties() {
        Properties props = new Properties();
        props.setProperty("Consistency", "TIMELINE");
        Assert.assertTrue((JDBCUtil.getConsistencyLevel((String)"localhost", (Properties)props, (String)Consistency.STRONG.toString()) == Consistency.TIMELINE ? 1 : 0) != 0);
    }

    @Test
    public void testGetMaxMutateBytes() throws Exception {
        Assert.assertEquals((long)1000L, (long)JDBCUtil.getMutateBatchSizeBytes((String)"localhost;UpsertBatchSizeBytes=1000", (Properties)new Properties(), (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS));
        Properties props = new Properties();
        props.setProperty("UpsertBatchSizeBytes", "2000");
        Assert.assertEquals((long)2000L, (long)JDBCUtil.getMutateBatchSizeBytes((String)"localhost", (Properties)props, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS));
        HashMap propMap = Maps.newHashMap();
        propMap.put("phoenix.mutate.batchSizeBytes", "3000");
        ReadOnlyProps readOnlyProps = new ReadOnlyProps((Map)propMap);
        Assert.assertEquals((long)3000L, (long)JDBCUtil.getMutateBatchSizeBytes((String)"localhost", (Properties)new Properties(), (ReadOnlyProps)readOnlyProps));
    }

    @Test
    public void formatZookeeperUrlSameOrderTest() {
        String zk1 = "zk1.net\\:2181,zk2.net\\:2181,zk3.net\\:2181::/hbase";
        String result = JDBCUtil.formatUrl((String)zk1);
        Assert.assertEquals((Object)zk1, (Object)result);
    }

    @Test
    public void formatZookeeperUrlDifferentOrderTest() {
        String zk1 = "zk3.net,zk2.net,zk1.net:2181:/hbase";
        String result = JDBCUtil.formatUrl((String)zk1);
        Assert.assertEquals((Object)"zk1.net\\:2181,zk2.net\\:2181,zk3.net\\:2181::/hbase", (Object)result);
    }

    @Test
    public void formatZookeeperUrlNoTrailersTest() {
        String zk1 = "zk1.net,zk2.net,zk3.net";
        String result = JDBCUtil.formatUrl((String)zk1);
        Assert.assertEquals((Object)"zk1.net\\:2181,zk2.net\\:2181,zk3.net\\:2181::/hbase", (Object)result);
    }

    @Test
    public void formatZookeeperUrlToLowercaseTest() {
        String zk1 = "MYHOST1.NET,MYHOST2.NET";
        String result = JDBCUtil.formatUrl((String)zk1);
        Assert.assertEquals((Object)"myhost1.net\\:2181,myhost2.net\\:2181::/hbase", (Object)result);
    }
}

