/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.IndexScrutiny;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class IndexScrutinyIT
extends ParallelStatsDisabledIT {
    @Test
    public void testRowCountIndexScrutiny() throws Throwable {
        String schemaName = IndexScrutinyIT.generateUniqueName();
        String tableName = IndexScrutinyIT.generateUniqueName();
        String indexName = IndexScrutinyIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = DriverManager.getConnection(IndexScrutinyIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true, SALT_BUCKETS=2");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('b','bb')");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','ccc')");
            conn.commit();
            int count = conn.createStatement().executeUpdate("DELETE FROM " + fullIndexName + " WHERE \":K\"='a' AND \"0:V\"='ccc'");
            Assert.assertEquals((long)1L, (long)count);
            conn.commit();
            try {
                IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
                Assert.fail();
            }
            catch (AssertionError e) {
                Assert.assertEquals((Object)"Expected data table row count to match expected:<2> but was:<1>", (Object)((Throwable)((Object)e)).getMessage());
            }
        }
    }

    @Test
    public void testExtraRowIndexScrutiny() throws Throwable {
        String schemaName = IndexScrutinyIT.generateUniqueName();
        String tableName = IndexScrutinyIT.generateUniqueName();
        String indexName = IndexScrutinyIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = DriverManager.getConnection(IndexScrutinyIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v VARCHAR, v2 VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + fullTableName + " (v) INCLUDE (v2)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('b','bb','0')");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','ccc','1')");
            conn.commit();
            conn.createStatement().executeUpdate("UPSERT INTO " + fullIndexName + " VALUES ('bbb','x','0')");
            conn.commit();
            try {
                IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
                Assert.fail();
            }
            catch (AssertionError e) {
                Assert.assertEquals((Object)"Expected to find PK in data table: ('x')", (Object)((Throwable)((Object)e)).getMessage());
            }
        }
    }

    @Test
    public void testValueIndexScrutiny() throws Throwable {
        String schemaName = IndexScrutinyIT.generateUniqueName();
        String tableName = IndexScrutinyIT.generateUniqueName();
        String indexName = IndexScrutinyIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = DriverManager.getConnection(IndexScrutinyIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v VARCHAR, v2 VARCHAR) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v) INCLUDE (v2)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('b','bb','0')");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','ccc','1')");
            conn.commit();
            conn.createStatement().executeUpdate("UPSERT INTO " + fullIndexName + " VALUES ('ccc','a','2')");
            conn.commit();
            Assert.assertEquals((long)2L, (long)IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName));
        }
    }
}

