/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.phoenix.util.DelayedRegionServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedOrFailingRegionServer
extends DelayedRegionServer {
    private static String injectFailureForRegionOfTable = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayedOrFailingRegionServer.class);
    public static final String INJECTED_EXCEPTION_STRING = "Injected exception message";

    public DelayedOrFailingRegionServer(Configuration conf) throws IOException, InterruptedException {
        super(conf);
    }

    @Override
    protected RSRpcServices createRpcServices() throws IOException {
        return new DelayedOrFailingRSRpcServices((HRegionServer)this);
    }

    public static void injectFailureForRegionOfTable(String tableName) {
        injectFailureForRegionOfTable = tableName;
    }

    public static class DelayedOrFailingRSRpcServices
    extends DelayedRegionServer.DelayedRSRpcServices {
        DelayedOrFailingRSRpcServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        @Override
        public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
            this.optionallyInjectFailureIfRegionBelongsToTable(request.getRegion(), "get");
            return super.get(controller, request);
        }

        @Override
        public ClientProtos.MutateResponse mutate(RpcController controller, ClientProtos.MutateRequest request) throws ServiceException {
            this.optionallyInjectFailureIfRegionBelongsToTable(request.getRegion(), "mutate");
            return super.mutate(controller, request);
        }

        @Override
        public ClientProtos.MultiResponse multi(RpcController controller, ClientProtos.MultiRequest request) throws ServiceException {
            for (ClientProtos.RegionAction req : request.getRegionActionList()) {
                try {
                    if (!this.doesRegionBelongToTable(req.getRegion())) continue;
                    boolean isBatchOfOnlyPuts = true;
                    boolean isBatchOfOnlyDeletes = true;
                    for (ClientProtos.Action action : req.getActionList()) {
                        ClientProtos.MutationProto.MutationType type = action.getMutation().getMutateType();
                        if (type.equals((Object)ClientProtos.MutationProto.MutationType.PUT)) {
                            isBatchOfOnlyDeletes = false;
                            continue;
                        }
                        if (type.equals((Object)ClientProtos.MutationProto.MutationType.DELETE)) {
                            isBatchOfOnlyPuts = false;
                            continue;
                        }
                        isBatchOfOnlyPuts = false;
                        isBatchOfOnlyDeletes = false;
                    }
                    if (isBatchOfOnlyPuts) {
                        this.optionallyInjectFailureIfRegionBelongsToTable(req.getRegion(), "put");
                        continue;
                    }
                    if (!isBatchOfOnlyDeletes) continue;
                    this.optionallyInjectFailureIfRegionBelongsToTable(req.getRegion(), "delete");
                }
                catch (IOException e) {
                    LOGGER.error("Mutate failed with exception: ", (Throwable)e);
                }
            }
            return super.multi(controller, request);
        }

        @Override
        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            this.optionallyInjectFailureIfRegionBelongsToTable(request.getRegion(), "scan");
            return super.scan(controller, request);
        }

        private void optionallyInjectFailureIfRegionBelongsToTable(HBaseProtos.RegionSpecifier specifier, String op) throws ServiceException {
            try {
                if (this.doesRegionBelongToTable(specifier)) {
                    throw new ServiceException((Throwable)new DoNotRetryIOException(DelayedOrFailingRegionServer.INJECTED_EXCEPTION_STRING));
                }
            }
            catch (IOException e) {
                LOGGER.error("Not injecting failure since getting region during " + op + " failed with: ", (Throwable)e);
            }
        }

        private boolean doesRegionBelongToTable(HBaseProtos.RegionSpecifier specifier) throws IOException {
            return injectFailureForRegionOfTable != null && this.getRegion(specifier).getTableDescriptor().getTableName().getNameAsString().equals(injectFailureForRegionOfTable);
        }
    }
}

