/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ServerUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class CoprocessorHConnectionTableFactoryIT
extends BaseTest {
    private static String ORG_PREFIX = "ORG";
    private static final Logger LOGGER = LoggerFactory.getLogger(CoprocessorHConnectionTableFactoryIT.class);

    @BeforeClass
    public static final synchronized void doSetup() throws Exception {
        CoprocessorHConnectionTableFactoryIT.setUpTestDriver(ReadOnlyProps.EMPTY_PROPS);
    }

    static String getOrgId(long id) {
        return ORG_PREFIX + "-" + id;
    }

    static String getRandomOrgId(int maxOrgId) {
        return CoprocessorHConnectionTableFactoryIT.getOrgId(Math.round(Math.random() * (double)maxOrgId));
    }

    static void writeToTable(String tableName, Connection conn, int maxOrgId) throws SQLException {
        try {
            String orgId = CoprocessorHConnectionTableFactoryIT.getRandomOrgId(maxOrgId);
            Statement stmt = conn.createStatement();
            for (int i = 0; i < 10; ++i) {
                stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('" + orgId + "'," + i + "," + (i + 1) + "," + (i + 2) + ")");
            }
            conn.commit();
        }
        catch (Exception e) {
            LOGGER.error("Client side exception:" + e);
        }
    }

    static int getActiveConnections(HRegionServer regionServer, Configuration conf) throws Exception {
        return ServerUtil.ConnectionFactory.getConnectionsCount();
    }

    @Test
    public void testCachedConnections() throws Exception {
        String tableName = CoprocessorHConnectionTableFactoryIT.generateUniqueName();
        String index1Name = CoprocessorHConnectionTableFactoryIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(CoprocessorHConnectionTableFactoryIT.getUrl());
        Admin admin = CoprocessorHConnectionTableFactoryIT.getUtility().getAdmin();
        MiniHBaseCluster cluster = CoprocessorHConnectionTableFactoryIT.getUtility().getHBaseCluster();
        HRegionServer regionServer = cluster.getRegionServer(0);
        Configuration conf = admin.getConfiguration();
        int noOfOrgs = 20;
        AtomicBoolean flag = new AtomicBoolean();
        flag.set(false);
        String createTableSql = "CREATE TABLE " + tableName + "(org_id VARCHAR NOT NULL PRIMARY KEY, v1 INTEGER, v2 INTEGER, v3 INTEGER) VERSIONS=1 SPLIT ON ('" + ORG_PREFIX + "-10')";
        conn.createStatement().execute(createTableSql);
        conn.createStatement().execute("CREATE INDEX " + index1Name + " ON " + tableName + "(v1)");
        List regions = admin.getRegions(TableName.valueOf((String)tableName));
        RegionInfo regionInfo = (RegionInfo)regions.get(0);
        CoprocessorHConnectionTableFactoryIT.writeToTable(tableName, conn, 20);
        int beforeRegionCloseCount = CoprocessorHConnectionTableFactoryIT.getActiveConnections(regionServer, conf);
        int regionsCount = admin.getRegions(regionServer.getServerName()).size();
        admin.unassign(regionInfo.getEncodedNameAsBytes(), true);
        while (admin.getRegions(regionServer.getServerName()).size() >= regionsCount) {
        }
        int afterRegionCloseCount = CoprocessorHConnectionTableFactoryIT.getActiveConnections(regionServer, conf);
        Assert.assertTrue((String)"Cached connections not closed when region closes: ", (afterRegionCloseCount == beforeRegionCloseCount && afterRegionCloseCount > 0 ? 1 : 0) != 0);
    }
}

