/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.write.IndexWriterUtils;
import org.apache.phoenix.util.ClientUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ClientUtilTest {
    String existingNamespaceOne = "existingNamespaceOne";
    String existingNamespaceTwo = "existingNamespaceTwo";
    String nonExistingNamespace = "nonExistingNamespace";
    String[] namespaces = new String[]{this.existingNamespaceOne, this.existingNamespaceTwo};

    @Test
    public void testIsHbaseNamespaceAvailableWithExistingNamespace() throws Exception {
        Admin mockAdmin = this.getMockedAdmin();
        Assert.assertTrue((boolean)ClientUtil.isHBaseNamespaceAvailable((Admin)mockAdmin, (String)this.existingNamespaceOne));
    }

    @Test
    public void testIsHbaseNamespaceAvailableWithNonExistingNamespace() throws Exception {
        Admin mockAdmin = this.getMockedAdmin();
        Assert.assertFalse((boolean)ClientUtil.isHBaseNamespaceAvailable((Admin)mockAdmin, (String)this.nonExistingNamespace));
    }

    private Admin getMockedAdmin() throws Exception {
        Admin mockAdmin = (Admin)Mockito.mock(Admin.class);
        Mockito.when((Object)mockAdmin.listNamespaces()).thenReturn((Object)this.namespaces);
        return mockAdmin;
    }

    @Test
    public void testCoprocessorHConnectionGetTableWithClosedConnection() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException()}).when((Object)connection)).getTable((TableName)Mockito.any());
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException()}).when((Object)connection)).getTable((TableName)Mockito.any(), (ExecutorService)Mockito.any());
        ((Connection)Mockito.doReturn((Object)true).when((Object)connection)).isClosed();
        RegionCoprocessorEnvironment mockEnv = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class);
        HTableFactory hTableFactory = IndexWriterUtils.getDefaultDelegateHTableFactory((RegionCoprocessorEnvironment)mockEnv);
        IndexWriterUtils.CoprocessorHConnectionTableFactory spyedObj = (IndexWriterUtils.CoprocessorHConnectionTableFactory)Mockito.spy((Object)hTableFactory);
        ((IndexWriterUtils.CoprocessorHConnectionTableFactory)Mockito.doReturn((Object)connection).when((Object)spyedObj)).getConnection();
        try {
            spyedObj.getTable(new ImmutableBytesPtr(Bytes.toBytes((String)"test_table")));
            Assert.fail((String)"IOException exception expected as connection was closed");
        }
        catch (DoNotRetryIOException e) {
            Assert.fail((String)"DoNotRetryIOException not expected instead should throw IOException");
        }
        catch (IOException e1) {
            try {
                spyedObj.getTable(new ImmutableBytesPtr(Bytes.toBytes((String)"test_table")), null);
                Assert.fail((String)"IOException exception expected as connection was closed");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

