/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.CDCUtil;
import org.junit.Assert;
import org.junit.Test;

public class CDCUtilTest {
    @Test
    public void testScopeSetConstruction() throws Exception {
        Assert.assertEquals(new HashSet<PTable.CDCChangeScope>(Arrays.asList(PTable.CDCChangeScope.PRE)), (Object)CDCUtil.makeChangeScopeEnumsFromString((String)"PRE"));
        Assert.assertEquals(new HashSet<PTable.CDCChangeScope>(Arrays.asList(PTable.CDCChangeScope.PRE)), (Object)CDCUtil.makeChangeScopeEnumsFromString((String)"PRE,"));
        Assert.assertEquals(new HashSet<PTable.CDCChangeScope>(Arrays.asList(PTable.CDCChangeScope.PRE)), (Object)CDCUtil.makeChangeScopeEnumsFromString((String)"PRE, PRE"));
        Assert.assertEquals(new HashSet<PTable.CDCChangeScope>(Arrays.asList(PTable.CDCChangeScope.CHANGE, PTable.CDCChangeScope.PRE, PTable.CDCChangeScope.POST)), (Object)CDCUtil.makeChangeScopeEnumsFromString((String)"POST,PRE,CHANGE"));
        try {
            CDCUtil.makeChangeScopeEnumsFromString((String)"DUMMY");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.UNKNOWN_INCLUDE_CHANGE_SCOPE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().endsWith("DUMMY"));
        }
    }

    @Test
    public void testScopeStringConstruction() throws Exception {
        Assert.assertEquals(null, (Object)CDCUtil.makeChangeScopeStringFromEnums(null));
        Assert.assertEquals((Object)"", (Object)CDCUtil.makeChangeScopeStringFromEnums(new HashSet()));
        Assert.assertEquals((Object)"CHANGE,PRE,POST", (Object)CDCUtil.makeChangeScopeStringFromEnums(new HashSet<PTable.CDCChangeScope>(Arrays.asList(PTable.CDCChangeScope.CHANGE, PTable.CDCChangeScope.PRE, PTable.CDCChangeScope.POST))));
    }
}

