/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.util.ByteUtil;
import org.junit.Assert;
import org.junit.Test;

public class ByteUtilTest {
    @Test
    public void testSplitBytes() {
        byte[][] splitPoints;
        byte[] startRow = Bytes.toBytes((String)"EA");
        byte[] stopRow = Bytes.toBytes((String)"EZ");
        for (byte[] splitPoint : splitPoints = Bytes.split((byte[])startRow, (byte[])stopRow, (int)10)) {
            Assert.assertTrue((String)Bytes.toStringBinary((byte[])splitPoint), (Bytes.compareTo((byte[])startRow, (byte[])splitPoint) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)Bytes.toStringBinary((byte[])splitPoint), (Bytes.compareTo((byte[])stopRow, (byte[])splitPoint) >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testVIntToBytes() {
        for (int i = -10000; i <= 10000; ++i) {
            byte[] vint = Bytes.vintToBytes((long)i);
            int vintSize = vint.length;
            byte[] vint2 = new byte[vint.length];
            Assert.assertEquals((long)vintSize, (long)ByteUtil.vintToBytes((byte[])vint2, (int)0, (long)i));
            Assert.assertTrue((Bytes.BYTES_COMPARATOR.compare(vint, vint2) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNextKey() {
        byte[] key = new byte[]{1};
        Assert.assertEquals((long)2L, (long)ByteUtil.nextKey((byte[])key)[0]);
        key = new byte[]{1, -1};
        byte[] nextKey = ByteUtil.nextKey((byte[])key);
        byte[] expectedKey = new byte[]{2, 0};
        Assert.assertArrayEquals((byte[])expectedKey, (byte[])nextKey);
        key = ByteUtil.concat((byte[])Bytes.toBytes((String)"00D300000000XHP"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)Integer.MAX_VALUE)});
        nextKey = ByteUtil.nextKey((byte[])key);
        expectedKey = ByteUtil.concat((byte[])Bytes.toBytes((String)"00D300000000XHQ"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)Integer.MIN_VALUE)});
        Assert.assertArrayEquals((byte[])expectedKey, (byte[])nextKey);
        key = new byte[]{-1};
        Assert.assertNull((Object)ByteUtil.nextKey((byte[])key));
    }
}

