/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;

public class AssertResults {
    public static final AssertingIterator NONE = new NoopAssertingIterator();

    private AssertResults() {
    }

    public static void assertResults(ResultIterator scanner, Tuple[] results) throws Exception {
        AssertResults.assertResults(scanner, new ResultAssertingIterator(Arrays.asList(results).iterator()));
    }

    public static void assertUnorderedResults(ResultIterator scanner, Tuple[] results) throws Exception {
        AssertResults.assertResults(scanner, new UnorderedResultAssertingIterator(Arrays.asList(results)));
    }

    public static void assertResults(ResultIterator scanner, AssertingIterator iterator) throws Exception {
        try {
            Tuple result = scanner.next();
            while (result != null) {
                iterator.assertNext(result);
                result = scanner.next();
            }
            iterator.assertDone();
        }
        finally {
            scanner.close();
        }
    }

    public static class ResultAssertingIterator
    implements AssertingIterator {
        private final Iterator<Tuple> expectedResults;

        public ResultAssertingIterator(Iterator<Tuple> expectedResults) {
            this.expectedResults = expectedResults;
        }

        @Override
        public void assertDone() {
            Assert.assertTrue((!this.expectedResults.hasNext() ? 1 : 0) != 0);
        }

        @Override
        public void assertNext(Tuple result) throws Exception {
            Assert.assertTrue((boolean)this.expectedResults.hasNext());
            Tuple expected = this.expectedResults.next();
            TestUtil.compareTuples(expected, result);
        }
    }

    public static interface AssertingIterator {
        public void assertNext(Tuple var1) throws Exception;

        public void assertDone() throws Exception;
    }

    public static class UnorderedResultAssertingIterator
    implements AssertingIterator {
        private final ImmutableBytesWritable tempPtr = new ImmutableBytesWritable();
        private final Map<ImmutableBytesWritable, Tuple> expectedResults;

        public UnorderedResultAssertingIterator(Collection<Tuple> expectedResults) {
            this.expectedResults = new HashMap<ImmutableBytesWritable, Tuple>(expectedResults.size());
            for (Tuple result : expectedResults) {
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                result.getKey(ptr);
                this.expectedResults.put(ptr, result);
            }
        }

        @Override
        public void assertDone() {
            Assert.assertTrue((boolean)this.expectedResults.isEmpty());
        }

        @Override
        public void assertNext(Tuple result) throws Exception {
            result.getKey(this.tempPtr);
            Tuple expected = this.expectedResults.remove(this.tempPtr);
            TestUtil.compareTuples(expected, result);
        }
    }

    private static final class NoopAssertingIterator
    implements AssertingIterator {
        private NoopAssertingIterator() {
        }

        @Override
        public void assertDone() throws Exception {
        }

        @Override
        public void assertNext(Tuple result) throws Exception {
        }
    }
}

