/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PIntegerArray;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.UpsertExecutor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public abstract class AbstractUpsertExecutorTest<R, F>
extends BaseConnectionlessQueryTest {
    protected Connection conn;
    protected List<ColumnInfo> columnInfoList;
    protected PreparedStatement preparedStatement;
    protected UpsertExecutor.UpsertListener<R> upsertListener;
    private static String TIMESTAMP_WITH_NANOS = "2006-11-03 00:00:00.001003000";

    protected abstract UpsertExecutor<R, F> getUpsertExecutor();

    protected abstract R createRecord(Object ... var1) throws IOException;

    protected abstract UpsertExecutor<R, F> getUpsertExecutor(Connection var1);

    @Before
    public void setUp() throws SQLException {
        this.columnInfoList = ImmutableList.of((Object)new ColumnInfo("ID", -5), (Object)new ColumnInfo("NAME", 12), (Object)new ColumnInfo("AGE", 4), (Object)new ColumnInfo("VALUES", PIntegerArray.INSTANCE.getSqlType()), (Object)new ColumnInfo("BEARD", 16), (Object)new ColumnInfo("PIC", -2), (Object)new ColumnInfo("T", 93));
        this.preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.upsertListener = (UpsertExecutor.UpsertListener)Mockito.mock(UpsertExecutor.UpsertListener.class);
        Properties properties = new Properties();
        properties.setProperty("phoenix.query.dateFormatTimeZone", "GMT");
        this.conn = DriverManager.getConnection(AbstractUpsertExecutorTest.getUrl(), properties);
    }

    @After
    public void tearDown() throws SQLException {
        this.conn.close();
    }

    @Test
    public void testExecute() throws Exception {
        byte[] binaryData = (byte[])PBinary.INSTANCE.getSampleValue();
        String encodedBinaryData = Bytes.toString((byte[])Base64.getEncoder().encode(binaryData));
        this.getUpsertExecutor().execute(this.createRecord(123L, "NameValue", 42, Arrays.asList(1, 2, 3), true, encodedBinaryData, Timestamp.valueOf(TIMESTAMP_WITH_NANOS)));
        ((UpsertExecutor.UpsertListener)Mockito.verify(this.upsertListener)).upsertDone(1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.upsertListener});
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(1, 123L);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(2, "NameValue");
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(3, 42);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(4, PArrayDataType.instantiatePhoenixArray((PDataType)PInteger.INSTANCE, (Object[])new Object[]{1, 2, 3}));
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(5, Boolean.TRUE);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(6, binaryData);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(7, DateUtil.parseTimestamp((String)TIMESTAMP_WITH_NANOS));
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.preparedStatement});
    }

    @Test
    public void testExecute_TooFewFields() throws Exception {
        R recordWithTooFewFields = this.createRecord(123L, "NameValue");
        this.getUpsertExecutor().execute(recordWithTooFewFields);
        ((UpsertExecutor.UpsertListener)Mockito.verify(this.upsertListener)).errorOnRecord(ArgumentMatchers.eq(recordWithTooFewFields), (Throwable)ArgumentMatchers.any(Throwable.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.upsertListener});
    }

    @Test
    public void testExecute_TooManyFields() throws Exception {
        byte[] binaryData = (byte[])PBinary.INSTANCE.getSampleValue();
        String encodedBinaryData = Bytes.toString((byte[])Base64.getEncoder().encode(binaryData));
        R recordWithTooManyFields = this.createRecord(123L, "NameValue", 42, Arrays.asList(1, 2, 3), true, encodedBinaryData, Timestamp.valueOf(TIMESTAMP_WITH_NANOS), "garbage");
        this.getUpsertExecutor().execute(recordWithTooManyFields);
        ((UpsertExecutor.UpsertListener)Mockito.verify(this.upsertListener)).upsertDone(1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.upsertListener});
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(1, 123L);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(2, "NameValue");
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(3, 42);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(4, PArrayDataType.instantiatePhoenixArray((PDataType)PInteger.INSTANCE, (Object[])new Object[]{1, 2, 3}));
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(5, Boolean.TRUE);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(6, binaryData);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(7, DateUtil.parseTimestamp((String)TIMESTAMP_WITH_NANOS));
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.preparedStatement});
    }

    @Test
    public void testExecute_NullField() throws Exception {
        byte[] binaryData = (byte[])PBinary.INSTANCE.getSampleValue();
        String encodedBinaryData = Bytes.toString((byte[])Base64.getEncoder().encode(binaryData));
        this.getUpsertExecutor().execute(this.createRecord(123L, "NameValue", null, Arrays.asList(1, 2, 3), false, encodedBinaryData, Timestamp.valueOf(TIMESTAMP_WITH_NANOS)));
        ((UpsertExecutor.UpsertListener)Mockito.verify(this.upsertListener)).upsertDone(1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.upsertListener});
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(1, 123L);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(2, "NameValue");
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setNull(3, this.columnInfoList.get(2).getSqlType());
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(4, PArrayDataType.instantiatePhoenixArray((PDataType)PInteger.INSTANCE, (Object[])new Object[]{1, 2, 3}));
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(5, Boolean.FALSE);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(6, binaryData);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(7, DateUtil.parseTimestamp((String)TIMESTAMP_WITH_NANOS));
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.preparedStatement});
    }

    @Test
    public void testExecute_InvalidType() throws Exception {
        byte[] binaryData = (byte[])PBinary.INSTANCE.getSampleValue();
        String encodedBinaryData = Bytes.toString((byte[])Base64.getEncoder().encode(binaryData));
        R recordWithInvalidType = this.createRecord(123L, "NameValue", "ThisIsNotANumber", Arrays.asList(1, 2, 3), true, encodedBinaryData, Timestamp.valueOf(TIMESTAMP_WITH_NANOS));
        this.getUpsertExecutor().execute(recordWithInvalidType);
        ((UpsertExecutor.UpsertListener)Mockito.verify(this.upsertListener)).errorOnRecord(ArgumentMatchers.eq(recordWithInvalidType), (Throwable)ArgumentMatchers.any(Throwable.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.upsertListener});
    }

    @Test
    public void testExecute_InvalidBoolean() throws Exception {
        byte[] binaryData = (byte[])PBinary.INSTANCE.getSampleValue();
        String encodedBinaryData = Bytes.toString((byte[])Base64.getEncoder().encode(binaryData));
        R csvRecordWithInvalidType = this.createRecord("123,NameValue,42,1:2:3,NotABoolean," + encodedBinaryData + "," + TIMESTAMP_WITH_NANOS);
        this.getUpsertExecutor().execute(csvRecordWithInvalidType);
        ((UpsertExecutor.UpsertListener)Mockito.verify(this.upsertListener)).errorOnRecord(ArgumentMatchers.eq(csvRecordWithInvalidType), (Throwable)ArgumentMatchers.any(Throwable.class));
    }

    @Test
    public void testExecute_InvalidBinary() throws Exception {
        String notBase64Encoded = "#@$df";
        R csvRecordWithInvalidType = this.createRecord("123,NameValue,42,1:2:3,true," + notBase64Encoded + "," + TIMESTAMP_WITH_NANOS);
        this.getUpsertExecutor().execute(csvRecordWithInvalidType);
        ((UpsertExecutor.UpsertListener)Mockito.verify(this.upsertListener)).errorOnRecord(ArgumentMatchers.eq(csvRecordWithInvalidType), (Throwable)ArgumentMatchers.any(Throwable.class));
    }

    @Test
    public void testExecute_AsciiEncoded() throws Exception {
        String asciiValue = "#@$df";
        Properties info = new Properties();
        info.setProperty("phoenix.upload.binaryDataType.encoding", "ASCII");
        this.getUpsertExecutor(DriverManager.getConnection(AbstractUpsertExecutorTest.getUrl(), info)).execute(this.createRecord(123L, "NameValue", 42, Arrays.asList(1, 2, 3), true, asciiValue, Timestamp.valueOf(TIMESTAMP_WITH_NANOS)));
        ((UpsertExecutor.UpsertListener)Mockito.verify(this.upsertListener)).upsertDone(1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.upsertListener});
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(1, 123L);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(2, "NameValue");
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(3, 42);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(4, PArrayDataType.instantiatePhoenixArray((PDataType)PInteger.INSTANCE, (Object[])new Object[]{1, 2, 3}));
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(5, Boolean.TRUE);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(6, Bytes.toBytes((String)asciiValue));
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).setObject(7, DateUtil.parseTimestamp((String)TIMESTAMP_WITH_NANOS));
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.preparedStatement});
    }
}

