/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.tx;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class TxCheckpointIT
extends ParallelStatsDisabledIT {
    private final boolean localIndex;
    private final String tableDDLOptions;

    @BeforeClass
    public static synchronized void forceClearTables() throws Exception {
        TxCheckpointIT.resetHbase();
        TxCheckpointIT.doSetup();
    }

    public TxCheckpointIT(boolean localIndex, boolean mutable, boolean columnEncoded, String transactionProvider) {
        StringBuilder optionBuilder = new StringBuilder();
        optionBuilder.append("TRANSACTION_PROVIDER='" + transactionProvider + "'");
        this.localIndex = localIndex;
        if (!columnEncoded) {
            optionBuilder.append(",COLUMN_ENCODED_BYTES=0");
        }
        if (!mutable) {
            optionBuilder.append(",IMMUTABLE_ROWS=true");
            if (!columnEncoded) {
                optionBuilder.append(",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN);
            }
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    private static Connection getConnection() throws SQLException {
        return TxCheckpointIT.getConnection(PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
    }

    private static Connection getConnection(Properties props) throws SQLException {
        props.setProperty("phoenix.table.istransactional.default", Boolean.toString(true));
        Connection conn = DriverManager.getConnection(TxCheckpointIT.getUrl(), props);
        return conn;
    }

    @Parameterized.Parameters(name="TxCheckpointIT_localIndex={0},mutable={1},columnEncoded={2},transactionProvider={3}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({false, false, false, "OMID"}, {false, true, false, "OMID"});
    }

    @Test
    public void testUpsertSelectDoesntSeeUpsertedData() throws Exception {
        String tableName = "TBL_" + TxCheckpointIT.generateUniqueName();
        String indexName = "IDX_" + TxCheckpointIT.generateUniqueName();
        String seqName = "SEQ_" + TxCheckpointIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)tableName, (String)tableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.mutate.batchSizeBytes", Integer.toString(512));
        props.setProperty("hbase.client.scanner.caching", Integer.toString(3));
        props.setProperty("phoenix.query.scanResultChunkSize", Integer.toString(3));
        Connection conn = TxCheckpointIT.getConnection(props);
        conn.setAutoCommit(true);
        conn.createStatement().execute("CREATE SEQUENCE " + seqName);
        conn.createStatement().execute("CREATE TABLE " + fullTableName + "(pk INTEGER PRIMARY KEY, val INTEGER)" + this.tableDDLOptions);
        conn.createStatement().execute("CREATE " + (this.localIndex ? "LOCAL " : "") + "INDEX " + indexName + " ON " + fullTableName + "(val)");
        conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES (NEXT VALUE FOR " + seqName + ",1)");
        for (int i = 0; i < 6; ++i) {
            Statement stmt = conn.createStatement();
            int upsertCount = stmt.executeUpdate("UPSERT INTO " + fullTableName + " SELECT NEXT VALUE FOR " + seqName + ", val FROM " + fullTableName);
            Assert.assertEquals((long)((int)Math.pow(2.0, i)), (long)upsertCount);
        }
        conn.close();
    }

    @Test
    public void testRollbackOfUncommittedDeleteSingleCol() throws Exception {
        String tableName = "TBL_" + TxCheckpointIT.generateUniqueName();
        String indexName = "IDX_" + TxCheckpointIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)tableName, (String)tableName);
        String indexDDL = "CREATE " + (this.localIndex ? "LOCAL " : "") + "INDEX " + indexName + " ON " + fullTableName + " (v1) INCLUDE(v2)";
        this.testRollbackOfUncommittedDelete(indexDDL, fullTableName);
    }

    @Test
    public void testRollbackOfUncommittedDeleteMultiCol() throws Exception {
        String tableName = "TBL_" + TxCheckpointIT.generateUniqueName();
        String indexName = "IDX_" + TxCheckpointIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)tableName, (String)tableName);
        String indexDDL = "CREATE " + (this.localIndex ? "LOCAL " : "") + "INDEX " + indexName + " ON " + fullTableName + " (v1, v2)";
        this.testRollbackOfUncommittedDelete(indexDDL, fullTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRollbackOfUncommittedDelete(String indexDDL, String fullTableName) throws Exception {
        conn.setAutoCommit(false);
        try (Connection conn = TxCheckpointIT.getConnection();){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + this.tableDDLOptions);
            stmt.execute(indexDDL);
            stmt.executeUpdate("upsert into " + fullTableName + " values('x1', 'y1', 'a1')");
            stmt.executeUpdate("upsert into " + fullTableName + " values('x2', 'y2', 'a2')");
            ResultSet rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName + " ORDER BY k");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x2", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a2", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName + " ORDER BY v1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x2", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a2", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            conn.commit();
            stmt.executeUpdate("DELETE FROM " + fullTableName + " WHERE k='x1' AND v1='y1' AND v2='a1'");
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName + " ORDER BY k");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x2", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a2", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName + " ORDER BY k");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x2", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a2", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName + " ORDER BY v1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x2", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a2", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            conn.rollback();
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName + " ORDER BY k");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x2", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a2", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName + " ORDER BY v1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x2", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a2", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testCheckpointForUpsertSelect() throws Exception {
        String tableName = "TBL_" + TxCheckpointIT.generateUniqueName();
        String indexName = "IDX_" + TxCheckpointIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)tableName, (String)tableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = TxCheckpointIT.getConnection();){
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + "(ID BIGINT NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + this.tableDDLOptions);
            stmt.execute("CREATE " + (this.localIndex ? "LOCAL " : "") + "INDEX " + indexName + " ON " + fullTableName + " (v1) INCLUDE(v2)");
            stmt.executeUpdate("upsert into " + fullTableName + " values(1, 'a2', 'b1')");
            stmt.executeUpdate("upsert into " + fullTableName + " values(2, 'a2', 'b2')");
            stmt.executeUpdate("upsert into " + fullTableName + " values(3, 'a3', 'b3')");
            conn.commit();
            this.upsertRows(conn, fullTableName);
            conn.rollback();
            this.verifyRows(conn, fullTableName, 3);
            this.upsertRows(conn, fullTableName);
            conn.commit();
            this.verifyRows(conn, fullTableName, 6);
        }
    }

    private void verifyRows(Connection conn, String fullTableName, int expectedMaxId) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("select /*+ NO_INDEX */ max(id) from " + fullTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)expectedMaxId, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select /*+ INDEX(DEMO IDX) */ max(id) from " + fullTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)expectedMaxId, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
    }

    private void upsertRows(Connection conn, String fullTableName) throws SQLException {
        MutationState state = conn.unwrap(PhoenixConnection.class).getMutationState();
        conn.createStatement().executeQuery("select 1 from " + fullTableName + " LIMIT 1").next();
        long wp = state.getWritePointer();
        conn.createStatement().execute("upsert into " + fullTableName + " select max(id)+1, 'a4', 'b4' from " + fullTableName);
        Assert.assertEquals((Object)PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT, (Object)state.getVisibilityLevel());
        ResultSet rs = conn.createStatement().executeQuery("select max(id) from " + fullTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("upsert into " + fullTableName + " select max(id)+1, 'a5', 'b5' from " + fullTableName);
        Assert.assertEquals((Object)PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT, (Object)state.getVisibilityLevel());
        Assert.assertNotEquals((long)wp, (long)state.getWritePointer());
        wp = state.getWritePointer();
        rs = conn.createStatement().executeQuery("select max(id) from " + fullTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)5L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("upsert into " + fullTableName + " select max(id)+1, 'a6', 'b6' from " + fullTableName);
        Assert.assertEquals((Object)PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT, (Object)state.getVisibilityLevel());
        Assert.assertNotEquals((long)wp, (long)state.getWritePointer());
        wp = state.getWritePointer();
        rs = conn.createStatement().executeQuery("select max(id) from " + fullTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)6L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testCheckpointForDeleteAndUpsert() throws Exception {
        String tableName = "TBL_" + TxCheckpointIT.generateUniqueName();
        String indexName = "IDX_" + TxCheckpointIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)tableName, (String)tableName);
        try (Connection conn = TxCheckpointIT.getConnection();){
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + "1(ID1 BIGINT NOT NULL PRIMARY KEY, FK1A INTEGER, FK1B INTEGER)" + this.tableDDLOptions);
            stmt.execute("CREATE TABLE " + fullTableName + "2(ID2 BIGINT NOT NULL PRIMARY KEY, FK2 INTEGER)" + this.tableDDLOptions);
            stmt.execute("CREATE " + (this.localIndex ? "LOCAL " : "") + "INDEX " + indexName + " ON " + fullTableName + "1 (FK1B)");
            stmt.executeUpdate("upsert into " + fullTableName + "1 values (1, 3, 3)");
            stmt.executeUpdate("upsert into " + fullTableName + "1 values (2, 2, 2)");
            stmt.executeUpdate("upsert into " + fullTableName + "1 values (3, 1, 1)");
            stmt.executeUpdate("upsert into " + fullTableName + "2 values (1, 1)");
            conn.commit();
            MutationState state = conn.unwrap(PhoenixConnection.class).getMutationState();
            stmt.executeQuery("select 1 from " + fullTableName + "1 LIMIT 1").next();
            long wp = state.getWritePointer();
            conn.createStatement().execute("delete from " + fullTableName + "1 where id1=fk1b AND fk1b=id1");
            Assert.assertEquals((Object)PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT, (Object)state.getVisibilityLevel());
            Assert.assertEquals((long)wp, (long)state.getWritePointer());
            ResultSet rs = conn.createStatement().executeQuery("select /*+ NO_INDEX */ id1 from " + fullTableName + "1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("select /*+ INDEX(DEMO IDX) */ id1 from " + fullTableName + "1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("delete from " + fullTableName + "1 where id1 in (select fk1a from " + fullTableName + "1 join " + fullTableName + "2 on (fk2=id1))");
            Assert.assertEquals((Object)PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT, (Object)state.getVisibilityLevel());
            Assert.assertNotEquals((long)wp, (long)state.getWritePointer());
            rs = conn.createStatement().executeQuery("select /*+ NO_INDEX */ id1 from " + fullTableName + "1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("select /*+ INDEX(DEMO IDX) */ id1 from " + fullTableName + "1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            stmt.executeUpdate("upsert into " + fullTableName + "1 SELECT id1 + 3, id1, id1 FROM " + fullTableName + "1");
            stmt.executeUpdate("upsert into " + fullTableName + "2 values (2, 4)");
            conn.createStatement().execute("delete from " + fullTableName + "1 where id1 in (select fk1a from " + fullTableName + "1 join " + fullTableName + "2 on (fk2=id1))");
            Assert.assertEquals((Object)PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT, (Object)state.getVisibilityLevel());
            Assert.assertNotEquals((long)wp, (long)state.getWritePointer());
            rs = conn.createStatement().executeQuery("select /*+ NO_INDEX */ id1 from " + fullTableName + "1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("select /*+ INDEX(DEMO IDX) */ id1 from " + fullTableName + "1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            conn.rollback();
            rs = conn.createStatement().executeQuery("select /*+ NO_INDEX */ id1 from " + fullTableName + "1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("select /*+ INDEX(DEMO IDX) */ id1 from " + fullTableName + "1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("drop index " + indexName + " on " + fullTableName + "1");
            conn.createStatement().execute("delete from " + fullTableName + "1 where id1=fk1b AND fk1b=id1");
            conn.createStatement().execute("delete from " + fullTableName + "1 where id1 in (select fk1a from " + fullTableName + "1 join " + fullTableName + "2 on (fk2=id1))");
            Assert.assertEquals((Object)PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT, (Object)state.getVisibilityLevel());
            Assert.assertNotEquals((long)wp, (long)state.getWritePointer());
            rs = conn.createStatement().executeQuery("select /*+ NO_INDEX */ id1 from " + fullTableName + "1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("select /*+ INDEX(DEMO IDX) */ id1 from " + fullTableName + "1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

