/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.tx;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class TransactionIT
extends ParallelStatsDisabledIT {
    private final String txProvider;
    private final String tableDDLOptions;

    public TransactionIT(String provider) {
        this.txProvider = provider;
        this.tableDDLOptions = "TRANSACTION_PROVIDER='" + provider + "'";
    }

    @Parameterized.Parameters(name="TransactionIT_provider={0}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{"OMID"}});
    }

    @Test
    public void testFailureToRollbackAfterDelete() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransactionIT.getUrl(), props);){
            String tableName = TransactionIT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE " + tableName + " (k VARCHAR NOT NULL PRIMARY KEY) TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + this.txProvider + "'");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('b')");
            conn.commit();
            conn.createStatement().execute("DELETE FROM " + tableName + " WHERE k='a'");
            conn.createStatement().executeQuery("SELECT * FROM " + tableName).next();
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('c')");
            TestUtil.addCoprocessor(conn, tableName, WriteFailingRegionObserver.class);
            try {
                conn.commit();
                Assert.fail();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUpsertSelectDoesntSeeUpsertedData() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.mutate.batchSizeBytes", Integer.toString(512));
        props.setProperty("hbase.client.scanner.caching", Integer.toString(3));
        props.setProperty("phoenix.query.scanResultChunkSize", Integer.toString(3));
        try (Connection conn = DriverManager.getConnection(TransactionIT.getUrl(), props);
             Connection otherConn = DriverManager.getConnection(TransactionIT.getUrl());
             Admin admin = driver.getConnectionQueryServices(TransactionIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();){
            conn.setAutoCommit(true);
            otherConn.setAutoCommit(true);
            String tableName = TransactionIT.generateUniqueName();
            conn.createStatement().execute("CREATE SEQUENCE " + tableName + "_seq CACHE 1000");
            conn.createStatement().execute("CREATE TABLE " + tableName + " (pk INTEGER PRIMARY KEY, val INTEGER) UPDATE_CACHE_FREQUENCY=3600000, TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + this.txProvider + "'");
            conn.createStatement().executeUpdate("UPSERT INTO " + tableName + " VALUES (NEXT VALUE FOR " + tableName + "_seq,1)");
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " SELECT NEXT VALUE FOR " + tableName + "_seq, val FROM " + tableName);
            PreparedStatement query = otherConn.prepareStatement("SELECT COUNT(*) FROM " + tableName);
            for (int i = 0; i < 12; ++i) {
                try {
                    admin.split(TableName.valueOf((String)tableName));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                int upsertCount = stmt.executeUpdate();
                Assert.assertEquals((long)((int)Math.pow(2.0, i)), (long)upsertCount);
                ResultSet rs = query.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)((int)Math.pow(2.0, i + 1)), (long)rs.getLong(1));
                rs.close();
            }
        }
    }

    @Test
    public void testWithMixOfTxProviders() throws Exception {
        if (!TransactionFactory.Provider.valueOf((String)this.txProvider).equals((Object)TransactionFactory.Provider.getDefault())) {
            return;
        }
        ArrayList tableNames = Lists.newArrayList();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransactionIT.getUrl(), props);){
            for (TransactionFactory.Provider provider : TransactionFactory.Provider.available()) {
                String tableName = TransactionIT.generateUniqueName();
                tableNames.add(tableName);
                conn.createStatement().execute("CREATE TABLE " + tableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR) TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + provider + "'");
            }
            if (tableNames.size() < 2) {
                return;
            }
            Iterator iterator = tableNames.iterator();
            String tableName1 = (String)iterator.next();
            conn.createStatement().execute("UPSERT INTO " + tableName1 + " VALUES('a')");
            String tableName2 = (String)iterator.next();
            try {
                conn.createStatement().execute("UPSERT INTO " + tableName2 + " VALUES('a')");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_MIX_TXN_PROVIDERS.getErrorCode(), (long)e.getErrorCode());
            }
            conn.rollback();
            conn.setAutoCommit(true);
            for (String tableName : tableNames) {
                conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a')");
            }
            for (String tableName : tableNames) {
                ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"a", (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    @Test
    public void testPreventLocalIndexCreation() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransactionIT.getUrl(), props);){
            for (TransactionFactory.Provider provider : TransactionFactory.Provider.available()) {
                if (!provider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.ALLOW_LOCAL_INDEX)) continue;
                String tableName = TransactionIT.generateUniqueName();
                conn.createStatement().execute("CREATE TABLE " + tableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR) TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + provider + "'");
                String indexName = TransactionIT.generateUniqueName();
                try {
                    conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + "_IDX ON " + tableName + " (v1) INCLUDE(v2)");
                    Assert.fail();
                }
                catch (SQLException e) {
                    Assert.assertEquals((long)SQLExceptionCode.CANNOT_CREATE_LOCAL_INDEX_FOR_TXN_TABLE.getErrorCode(), (long)e.getErrorCode());
                }
            }
        }
    }

    @Test
    public void testQueryWithSCN() throws Exception {
        String tableName = TransactionIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransactionIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR) TRANSACTIONAL=true," + this.tableDDLOptions);
        }
        props.put("CurrentSCN", Long.toString(EnvironmentEdgeManager.currentTimeMillis()));
        conn = DriverManager.getConnection(TransactionIT.getUrl(), props);
        try {
            try {
                conn.createStatement().executeQuery("SELECT * FROM " + tableName);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected Exception", (long)SQLExceptionCode.CANNOT_START_TRANSACTION_WITH_SCN_SET.getErrorCode(), (long)e.getErrorCode());
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testReCreateTxnTableAfterDroppingExistingNonTxnTable() throws Exception {
        String tableName = TransactionIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(TransactionIT.getUrl(), props);
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE " + tableName + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)");
        stmt.execute("DROP TABLE " + tableName);
        Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
        admin.disableTable(TableName.valueOf((String)tableName));
        admin.deleteTable(TableName.valueOf((String)tableName));
        stmt.execute("CREATE TABLE " + tableName + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) TRANSACTIONAL=true," + this.tableDDLOptions);
        stmt.execute("CREATE INDEX " + tableName + "_IDX ON " + tableName + " (v1) INCLUDE(v2)");
        Assert.assertTrue((boolean)conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, tableName)).isTransactional());
        Assert.assertTrue((boolean)conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, tableName + "_IDX")).isTransactional());
    }

    @Test
    public void testRowTimestampDisabled() throws SQLException {
        String tableName = TransactionIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TransactionIT.getUrl(), props);){
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement();
            try {
                stmt.execute("CREATE TABLE " + tableName + "(k VARCHAR, v VARCHAR, d DATE NOT NULL, CONSTRAINT PK PRIMARY KEY(k,d ROW_TIMESTAMP)) TRANSACTIONAL=true," + this.tableDDLOptions);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_CREATE_TXN_TABLE_WITH_ROW_TIMESTAMP.getErrorCode(), (long)e.getErrorCode());
            }
            stmt.execute("CREATE TABLE " + tableName + "(k VARCHAR, v VARCHAR, d DATE NOT NULL, CONSTRAINT PK PRIMARY KEY(k,d ROW_TIMESTAMP))");
            try {
                stmt.execute("ALTER TABLE " + tableName + " SET TRANSACTIONAL=true");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_ALTER_TO_BE_TXN_WITH_ROW_TIMESTAMP.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testTransactionalTableMetadata() throws SQLException {
        try (Connection conn = DriverManager.getConnection(TransactionIT.getUrl());){
            String transactTableName = TransactionIT.generateUniqueName();
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + transactTableName + " (k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) TRANSACTIONAL=true," + this.tableDDLOptions);
            conn.commit();
            DatabaseMetaData dbmd = conn.getMetaData();
            ResultSet rs = dbmd.getTables(null, null, StringUtil.escapeLike((String)transactTableName), null);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((String)"Transactional table was not marked as transactional in JDBC API.", (Object)"true", (Object)rs.getString("TRANSACTIONAL"));
            Assert.assertEquals((Object)this.txProvider, (Object)rs.getString("TRANSACTION_PROVIDER"));
            PTable table = conn.unwrap(PhoenixConnection.class).getTableNoCache(transactTableName);
            Assert.assertEquals((Object)this.txProvider, (Object)table.getTransactionProvider().name());
            String nonTransactTableName = TransactionIT.generateUniqueName();
            Statement stmt2 = conn.createStatement();
            stmt2.execute("CREATE TABLE " + nonTransactTableName + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) ");
            conn.commit();
            ResultSet rs2 = dbmd.getTables(null, null, StringUtil.escapeLike((String)nonTransactTableName), null);
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((String)"Non-transactional table was marked as transactional in JDBC API.", (Object)"false", (Object)rs2.getString("TRANSACTIONAL"));
            Assert.assertNull((Object)rs2.getString("TRANSACTION_PROVIDER"));
            try {
                stmt.execute("CREATE TABLE " + transactTableName + " (k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) TRANSACTION_PROVIDER=foo");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.UNKNOWN_TRANSACTION_PROVIDER.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testOnDupKeyForTransactionalTable() throws Exception {
        try (Connection conn = DriverManager.getConnection(TransactionIT.getUrl());){
            String transactTableName = TransactionIT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE " + transactTableName + " (k integer not null primary key, v bigint) TRANSACTIONAL=true," + this.tableDDLOptions);
            conn.createStatement().execute("UPSERT INTO " + transactTableName + " VALUES(0,0) ON DUPLICATE KEY UPDATE v = v + 1");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_USE_ON_DUP_KEY_FOR_TRANSACTIONAL.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testProperties() throws Exception {
        byte[] propertyTTL;
        String nonTxTableName = TransactionIT.generateUniqueName();
        String txTableName = TransactionIT.generateUniqueName();
        String idx1 = TransactionIT.generateUniqueName();
        String idx2 = TransactionIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(TransactionIT.getUrl());
        conn.createStatement().execute("CREATE TABLE " + nonTxTableName + "1(k INTEGER PRIMARY KEY, a.v VARCHAR, b.v VARCHAR, c.v VARCHAR) TTL=1000");
        conn.createStatement().execute("CREATE INDEX " + idx1 + " ON " + nonTxTableName + "1(a.v, b.v)");
        conn.createStatement().execute("CREATE INDEX " + idx2 + " ON " + nonTxTableName + "1(c.v) INCLUDE (a.v, b.v)");
        try {
            conn.createStatement().execute("ALTER TABLE " + nonTxTableName + "1 SET TRANSACTIONAL=true," + this.tableDDLOptions);
            if (TransactionFactory.Provider.valueOf((String)this.txProvider).getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.ALTER_NONTX_TO_TX)) {
                Assert.fail((String)(this.txProvider + " should not allow converting a non transactional table to be transactional"));
            }
        }
        catch (SQLException e) {
            if (!TransactionFactory.Provider.valueOf((String)this.txProvider).getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.ALTER_NONTX_TO_TX)) {
                throw e;
            }
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_ALTER_TABLE_FROM_NON_TXN_TO_TXNL.getErrorCode(), (long)e.getErrorCode());
            return;
        }
        TableDescriptor desc = conn.unwrap(PhoenixConnection.class).getQueryServices().getTableDescriptor(Bytes.toBytes((String)(nonTxTableName + "1")));
        for (ColumnFamilyDescriptor colDesc : desc.getColumnFamilies()) {
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)colDesc.getMaxVersions());
            Assert.assertEquals((long)1000L, (long)colDesc.getTimeToLive());
            propertyTTL = colDesc.getValue(PhoenixTransactionContext.PROPERTY_TTL_BYTES);
            Assert.assertEquals((long)1000L, (long)Integer.parseInt(Bytes.toString((byte[])propertyTTL)));
        }
        desc = conn.unwrap(PhoenixConnection.class).getQueryServices().getTableDescriptor(Bytes.toBytes((String)idx1));
        for (ColumnFamilyDescriptor colDesc : desc.getColumnFamilies()) {
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)colDesc.getMaxVersions());
            Assert.assertEquals((long)1000L, (long)colDesc.getTimeToLive());
            propertyTTL = colDesc.getValue(PhoenixTransactionContext.PROPERTY_TTL_BYTES);
            Assert.assertEquals((long)1000L, (long)Integer.parseInt(Bytes.toString((byte[])propertyTTL)));
        }
        desc = conn.unwrap(PhoenixConnection.class).getQueryServices().getTableDescriptor(Bytes.toBytes((String)idx2));
        for (ColumnFamilyDescriptor colDesc : desc.getColumnFamilies()) {
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)colDesc.getMaxVersions());
            Assert.assertEquals((long)1000L, (long)colDesc.getTimeToLive());
            propertyTTL = colDesc.getValue(PhoenixTransactionContext.PROPERTY_TTL_BYTES);
            Assert.assertEquals((long)1000L, (long)Integer.parseInt(Bytes.toString((byte[])propertyTTL)));
        }
        conn.createStatement().execute("CREATE TABLE " + nonTxTableName + "2(k INTEGER PRIMARY KEY, a.v VARCHAR, b.v VARCHAR, c.v VARCHAR)");
        conn.createStatement().execute("ALTER TABLE " + nonTxTableName + "2 SET TRANSACTIONAL=true, VERSIONS=10, " + this.tableDDLOptions);
        desc = conn.unwrap(PhoenixConnection.class).getQueryServices().getTableDescriptor(Bytes.toBytes((String)(nonTxTableName + "2")));
        for (ColumnFamilyDescriptor colDesc : desc.getColumnFamilies()) {
            Assert.assertEquals((long)10L, (long)colDesc.getMaxVersions());
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)colDesc.getTimeToLive());
            Assert.assertEquals(null, (Object)colDesc.getValue(PhoenixTransactionContext.PROPERTY_TTL_BYTES));
        }
        conn.createStatement().execute("ALTER TABLE " + nonTxTableName + "2 SET TTL=1000");
        desc = conn.unwrap(PhoenixConnection.class).getQueryServices().getTableDescriptor(Bytes.toBytes((String)(nonTxTableName + "2")));
        for (ColumnFamilyDescriptor colDesc : desc.getColumnFamilies()) {
            Assert.assertEquals((long)10L, (long)colDesc.getMaxVersions());
            Assert.assertEquals((long)1000L, (long)colDesc.getTimeToLive());
            propertyTTL = colDesc.getValue(PhoenixTransactionContext.PROPERTY_TTL_BYTES);
            Assert.assertEquals((long)1000L, (long)Integer.parseInt(Bytes.toString((byte[])propertyTTL)));
        }
        conn.createStatement().execute("CREATE TABLE " + nonTxTableName + "3(k INTEGER PRIMARY KEY, a.v VARCHAR, b.v VARCHAR, c.v VARCHAR)");
        conn.createStatement().execute("ALTER TABLE " + nonTxTableName + "3 SET TRANSACTIONAL=true, b.VERSIONS=10, c.VERSIONS=20," + this.tableDDLOptions);
        desc = conn.unwrap(PhoenixConnection.class).getQueryServices().getTableDescriptor(Bytes.toBytes((String)(nonTxTableName + "3")));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)desc.getColumnFamily(Bytes.toBytes((String)"A")).getMaxVersions());
        Assert.assertEquals((long)10L, (long)desc.getColumnFamily(Bytes.toBytes((String)"B")).getMaxVersions());
        Assert.assertEquals((long)20L, (long)desc.getColumnFamily(Bytes.toBytes((String)"C")).getMaxVersions());
        conn.createStatement().execute("CREATE TABLE " + nonTxTableName + "4(k INTEGER PRIMARY KEY, a.v VARCHAR, b.v VARCHAR, c.v VARCHAR)");
        try {
            conn.createStatement().execute("ALTER TABLE " + nonTxTableName + "4 SET TRANSACTIONAL=true, VERSIONS=1," + this.tableDDLOptions);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TX_MAX_VERSIONS_MUST_BE_GREATER_THAN_ONE.getErrorCode(), (long)e.getErrorCode());
        }
        try {
            conn.createStatement().execute("ALTER TABLE " + nonTxTableName + "4 SET TRANSACTIONAL=true, b.VERSIONS=1," + this.tableDDLOptions);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TX_MAX_VERSIONS_MUST_BE_GREATER_THAN_ONE.getErrorCode(), (long)e.getErrorCode());
        }
        conn.createStatement().execute("CREATE TABLE " + txTableName + "(k INTEGER PRIMARY KEY, v VARCHAR) TTL=1000, TRANSACTIONAL=true," + this.tableDDLOptions);
        desc = conn.unwrap(PhoenixConnection.class).getQueryServices().getTableDescriptor(Bytes.toBytes((String)txTableName));
        for (ColumnFamilyDescriptor colDesc : desc.getColumnFamilies()) {
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)colDesc.getMaxVersions());
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)colDesc.getTimeToLive());
            propertyTTL = colDesc.getValue(PhoenixTransactionContext.PROPERTY_TTL_BYTES);
            Assert.assertEquals((long)1000L, (long)Integer.parseInt(Bytes.toString((byte[])propertyTTL)));
        }
    }

    @Test
    public void testColConflicts() throws Exception {
        String transTableName = TransactionIT.generateUniqueName();
        String fullTableName = "INDEX_TEST." + transTableName;
        try (Connection conn1 = DriverManager.getConnection(TransactionIT.getUrl());
             Connection conn2 = DriverManager.getConnection(TransactionIT.getUrl());){
            TestUtil.createTransactionalTable(conn1, fullTableName, this.tableDDLOptions);
            conn1.setAutoCommit(false);
            conn2.setAutoCommit(false);
            String selectSql = "SELECT * FROM " + fullTableName;
            conn1.setAutoCommit(false);
            ResultSet rs = conn1.createStatement().executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            String upsertSql = "UPSERT INTO " + fullTableName + "(varchar_pk, char_pk, int_pk, long_pk, decimal_pk, date_pk, a.int_col1) VALUES(?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = conn1.prepareStatement(upsertSql);
            TestUtil.setRowKeyColumns(stmt, 1);
            stmt.setInt(7, 10);
            stmt.execute();
            stmt = conn2.prepareStatement(upsertSql);
            TestUtil.setRowKeyColumns(stmt, 1);
            stmt.setInt(7, 11);
            stmt.execute();
            conn1.commit();
            try {
                conn2.commit();
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.TRANSACTION_CONFLICT_EXCEPTION.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointAndRollback() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(TransactionIT.getUrl(), props);
        String fullTableName = TransactionIT.generateUniqueName();
        conn.setAutoCommit(false);
        try {
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) TRANSACTIONAL=true," + this.tableDDLOptions);
            stmt.executeUpdate("upsert into " + fullTableName + " values('x', 'a', 'a')");
            conn.commit();
            stmt.executeUpdate("upsert into " + fullTableName + "(k,v1) SELECT k,v1||'a' FROM " + fullTableName);
            ResultSet rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"aa", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            stmt.executeUpdate("upsert into " + fullTableName + "(k,v1) SELECT k,v1||'a' FROM " + fullTableName);
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"aaa", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            conn.rollback();
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    private static void assertTTL(Admin admin, String tableName, int ttl) throws Exception {
        TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((String)tableName));
        for (ColumnFamilyDescriptor colDesc : tableDesc.getColumnFamilies()) {
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)colDesc.getTimeToLive());
        }
    }

    @Test
    public void testSetTTL() throws Exception {
        block20: {
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            TransactionFactory.Provider txProvider = TransactionFactory.Provider.valueOf((String)this.txProvider);
            try (Connection conn = DriverManager.getConnection(TransactionIT.getUrl(), props);
                 Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                String tableName = TransactionIT.generateUniqueName();
                try {
                    conn.createStatement().execute("CREATE TABLE " + tableName + "(K VARCHAR PRIMARY KEY) TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + txProvider + "',TTL=100");
                    if (txProvider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.SET_TTL)) {
                        Assert.fail();
                    }
                    TransactionIT.assertTTL(admin, tableName, 100);
                }
                catch (SQLException e) {
                    if (txProvider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.SET_TTL)) {
                        Assert.assertEquals((long)SQLExceptionCode.TTL_UNSUPPORTED_FOR_TXN_TABLE.getErrorCode(), (long)e.getErrorCode());
                    }
                    throw e;
                }
                tableName = TransactionIT.generateUniqueName();
                conn.createStatement().execute("CREATE TABLE " + tableName + "(K VARCHAR PRIMARY KEY) TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + txProvider + "'");
                try {
                    conn.createStatement().execute("ALTER TABLE " + tableName + " SET TTL=200");
                    if (txProvider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.SET_TTL)) {
                        Assert.fail();
                    }
                    TransactionIT.assertTTL(admin, tableName, 200);
                }
                catch (SQLException e) {
                    if (txProvider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.SET_TTL)) {
                        Assert.assertEquals((long)SQLExceptionCode.TTL_UNSUPPORTED_FOR_TXN_TABLE.getErrorCode(), (long)e.getErrorCode());
                        break block20;
                    }
                    throw e;
                }
            }
        }
    }

    @Test
    public void testParallelConnectionOnlySeesCommittedData() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.mutate.batchSizeBytes", Integer.toString(512));
        props.setProperty("hbase.client.scanner.caching", Integer.toString(3));
        props.setProperty("phoenix.query.scanResultChunkSize", Integer.toString(3));
        try (Connection conn = DriverManager.getConnection(TransactionIT.getUrl(), props);
             Connection otherConn = DriverManager.getConnection(TransactionIT.getUrl());
             Admin admin = driver.getConnectionQueryServices(TransactionIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();){
            ResultSet rs;
            conn.setAutoCommit(false);
            otherConn.setAutoCommit(true);
            String tableName = TransactionIT.generateUniqueName();
            conn.createStatement().execute("CREATE SEQUENCE " + tableName + "_seq CACHE 1000");
            conn.createStatement().execute("CREATE TABLE " + tableName + " (pk INTEGER PRIMARY KEY, val INTEGER) UPDATE_CACHE_FREQUENCY=3600000, TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + this.txProvider + "'");
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " SELECT NEXT VALUE FOR " + tableName + "_seq, val FROM " + tableName);
            PreparedStatement seed = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (NEXT VALUE FOR " + tableName + "_seq,1)");
            PreparedStatement query = conn.prepareStatement("SELECT COUNT(*) FROM " + tableName);
            PreparedStatement otherQuery = otherConn.prepareStatement("SELECT COUNT(*) FROM " + tableName);
            seed.executeUpdate();
            for (int i = 0; i < 12; ++i) {
                try {
                    admin.split(TableName.valueOf((String)tableName));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                int upsertCount = stmt.executeUpdate();
                Assert.assertEquals((long)((int)Math.pow(2.0, i)), (long)upsertCount);
                rs = query.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)((int)Math.pow(2.0, i + 1)), (long)rs.getLong(1));
                rs.close();
                rs = otherQuery.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)0L, (long)rs.getLong(1));
                rs.close();
            }
            ParallelQuery q = new ParallelQuery(otherQuery);
            Thread t = new Thread(q);
            t.start();
            q.started.await();
            conn.commit();
            q.done.set(true);
            t.join();
            Assert.assertTrue((String)("Expected 0 or 4096 but got these intermediary counts " + (ConcurrentHashMap.KeySetView)q.failCounts.keySet()), (boolean)q.failCounts.isEmpty());
            rs = otherQuery.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)((int)Math.pow(2.0, 12.0)), (long)rs.getLong(1));
            rs.close();
        }
    }

    public static class WriteFailingRegionObserver
    extends SimpleRegionObserver {
        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws HBaseIOException {
            throw new DoNotRetryIOException();
        }
    }

    private class ParallelQuery
    implements Runnable {
        PreparedStatement query;
        CountDownLatch started = new CountDownLatch(1);
        AtomicBoolean done = new AtomicBoolean(false);
        ConcurrentHashMap<Long, Long> failCounts = new ConcurrentHashMap();

        public ParallelQuery(PreparedStatement query) {
            this.query = query;
        }

        @Override
        public void run() {
            try {
                this.started.countDown();
                while (!this.done.get()) {
                    ResultSet rs = this.query.executeQuery();
                    Assert.assertTrue((boolean)rs.next());
                    long count = rs.getLong(1);
                    rs.close();
                    if (count == 0L || count == (long)((int)Math.pow(2.0, 12.0))) continue;
                    this.failCounts.put(count, count);
                }
            }
            catch (SQLException x) {
                throw new RuntimeException(x);
            }
        }
    }
}

