/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.tx;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class ParameterizedTransactionIT
extends ParallelStatsDisabledIT {
    private final String tableDDLOptions;
    private final String tableDDLOptionsWithoutProvider;
    private final PhoenixTransactionProvider transactionProvider;

    public ParameterizedTransactionIT(Boolean mutable, Boolean columnEncoded, String transactionProvider) {
        StringBuilder optionBuilder = new StringBuilder();
        optionBuilder.append("TRANSACTION_PROVIDER='" + transactionProvider + "',");
        this.transactionProvider = TransactionFactory.Provider.valueOf((String)transactionProvider).getTransactionProvider();
        StringBuilder optionBuilder2 = new StringBuilder();
        if (!columnEncoded.booleanValue()) {
            optionBuilder2.append("COLUMN_ENCODED_BYTES=0,");
        }
        if (!mutable.booleanValue()) {
            optionBuilder2.append("IMMUTABLE_ROWS=true,");
            if (!columnEncoded.booleanValue()) {
                optionBuilder2.append("IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN + ",");
            }
        }
        if (optionBuilder2.length() > 0) {
            optionBuilder2.setLength(optionBuilder2.length() - 1);
            optionBuilder.append((CharSequence)optionBuilder2);
        } else {
            optionBuilder.setLength(optionBuilder.length() - 1);
        }
        this.tableDDLOptions = optionBuilder.toString();
        this.tableDDLOptionsWithoutProvider = optionBuilder2.toString();
    }

    @Parameterized.Parameters(name="ParameterizedTransactionIT_mutable={0},columnEncoded={1},transactionProvider={2}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({false, false, "OMID"}, {true, false, "OMID"});
    }

    @Test
    public void testReadOwnWrites() throws Exception {
        String transTableName = ParameterizedTransactionIT.generateUniqueName();
        String fullTableName = "INDEX_TEST." + transTableName;
        String selectSql = "SELECT * FROM " + fullTableName;
        try (Connection conn = DriverManager.getConnection(ParameterizedTransactionIT.getUrl());){
            conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions + (this.tableDDLOptions.length() > 0 ? "," : "") + "TRANSACTIONAL=true");
            conn.setAutoCommit(false);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            String upsert = "UPSERT INTO " + fullTableName + "(varchar_pk, char_pk, int_pk, long_pk, decimal_pk, date_pk) VALUES(?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = conn.prepareStatement(upsert);
            TestUtil.setRowKeyColumns(stmt, 1);
            stmt.execute();
            TestUtil.setRowKeyColumns(stmt, 2);
            stmt.execute();
            rs = conn.createStatement().executeQuery(selectSql);
            TestUtil.validateRowKeyColumns(rs, 1);
            TestUtil.validateRowKeyColumns(rs, 2);
            Assert.assertFalse((boolean)rs.next());
            conn.commit();
            rs = conn.createStatement().executeQuery(selectSql);
            TestUtil.validateRowKeyColumns(rs, 1);
            TestUtil.validateRowKeyColumns(rs, 2);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    public void testTxnClosedCorrecty() throws Exception {
        String transTableName = ParameterizedTransactionIT.generateUniqueName();
        String fullTableName = "INDEX_TEST." + transTableName;
        String selectSql = "SELECT * FROM " + fullTableName;
        try (Connection conn = DriverManager.getConnection(ParameterizedTransactionIT.getUrl());){
            String ddl = "create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions + (this.tableDDLOptions.length() > 0 ? "," : "") + "TRANSACTIONAL=true";
            conn.createStatement().execute(ddl);
            conn.setAutoCommit(false);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            String upsert = "UPSERT INTO " + fullTableName + "(varchar_pk, char_pk, int_pk, long_pk, decimal_pk, date_pk) VALUES(?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = conn.prepareStatement(upsert);
            TestUtil.setRowKeyColumns(stmt, 1);
            stmt.execute();
            TestUtil.setRowKeyColumns(stmt, 2);
            stmt.execute();
            rs = conn.createStatement().executeQuery(selectSql);
            TestUtil.validateRowKeyColumns(rs, 1);
            TestUtil.validateRowKeyColumns(rs, 2);
            Assert.assertFalse((boolean)rs.next());
            conn.close();
        }
    }

    @Test
    public void testAutoCommitQuery() throws Exception {
        String transTableName = ParameterizedTransactionIT.generateUniqueName();
        String fullTableName = "INDEX_TEST." + transTableName;
        try (Connection conn = DriverManager.getConnection(ParameterizedTransactionIT.getUrl());){
            conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions + (this.tableDDLOptions.length() > 0 ? "," : "") + "TRANSACTIONAL=true");
            conn.setAutoCommit(true);
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + fullTableName);
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT * FROM " + fullTableName + " x JOIN " + fullTableName + " y ON (x.long_pk = y.int_pk)");
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSelfJoin() throws Exception {
        String t1 = ParameterizedTransactionIT.generateUniqueName();
        String t2 = ParameterizedTransactionIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ParameterizedTransactionIT.getUrl());){
            conn.createStatement().execute("create table " + t1 + " (varchar_pk VARCHAR NOT NULL primary key, a.varchar_col1 VARCHAR, b.varchar_col2 VARCHAR)" + this.tableDDLOptions + (this.tableDDLOptions.length() > 0 ? "," : "") + "TRANSACTIONAL=true");
            conn.createStatement().execute("create table " + t2 + " (varchar_pk VARCHAR NOT NULL primary key, a.varchar_col1 VARCHAR, b.varchar_col1 VARCHAR)" + this.tableDDLOptions + (this.tableDDLOptions.length() > 0 ? "," : "") + "TRANSACTIONAL=true");
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + t1 + " x JOIN " + t1 + " y ON (x.varchar_pk = y.a.varchar_col1)");
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT * FROM " + t2 + " x JOIN " + t2 + " y ON (x.varchar_pk = y.a.varchar_col1)");
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void testRowConflicts(String fullTableName) throws Exception {
        try (Connection conn1 = DriverManager.getConnection(ParameterizedTransactionIT.getUrl());
             Connection conn2 = DriverManager.getConnection(ParameterizedTransactionIT.getUrl());){
            conn1.setAutoCommit(false);
            conn2.setAutoCommit(false);
            String selectSql = "SELECT * FROM " + fullTableName;
            conn1.setAutoCommit(false);
            ResultSet rs = conn1.createStatement().executeQuery(selectSql);
            boolean immutableRows = conn1.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, fullTableName)).isImmutableRows();
            Assert.assertFalse((boolean)rs.next());
            String upsertSql = "UPSERT INTO " + fullTableName + "(varchar_pk, char_pk, int_pk, long_pk, decimal_pk, date_pk, a.int_col1) VALUES(?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = conn1.prepareStatement(upsertSql);
            TestUtil.setRowKeyColumns(stmt, 1);
            stmt.setInt(7, 10);
            stmt.execute();
            upsertSql = "UPSERT INTO " + fullTableName + "(varchar_pk, char_pk, int_pk, long_pk, decimal_pk, date_pk, b.int_col2) VALUES(?, ?, ?, ?, ?, ?, ?)";
            stmt = conn2.prepareStatement(upsertSql);
            TestUtil.setRowKeyColumns(stmt, 1);
            stmt.setInt(7, 11);
            stmt.execute();
            conn1.commit();
            try {
                conn2.commit();
                if (!immutableRows) {
                    Assert.fail();
                }
            }
            catch (SQLException e) {
                if (immutableRows) {
                    Assert.fail();
                }
                Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.TRANSACTION_CONFLICT_EXCEPTION.getErrorCode());
            }
        }
    }

    @Test
    public void testRowConflictDetected() throws Exception {
        String transTableName = ParameterizedTransactionIT.generateUniqueName();
        String fullTableName = "INDEX_TEST." + transTableName;
        Connection conn = DriverManager.getConnection(ParameterizedTransactionIT.getUrl());
        conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions + (this.tableDDLOptions.length() > 0 ? "," : "") + "TRANSACTIONAL=true");
        this.testRowConflicts(fullTableName);
    }

    @Test
    public void testNoConflictDetectionForImmutableRows() throws Exception {
        if (this.tableDDLOptions.contains("IMMUTABLE_ROWS=true")) {
            String transTableName = ParameterizedTransactionIT.generateUniqueName();
            String fullTableName = "INDEX_TEST." + transTableName;
            Connection conn = DriverManager.getConnection(ParameterizedTransactionIT.getUrl());
            conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions + (this.tableDDLOptions.length() > 0 ? "," : "") + "TRANSACTIONAL=true");
            this.testRowConflicts(fullTableName);
        }
    }

    @Test
    public void testNonTxToTxTable() throws Exception {
        String nonTxTableName = ParameterizedTransactionIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(ParameterizedTransactionIT.getUrl());
        conn.createStatement().execute("CREATE TABLE " + nonTxTableName + "(k INTEGER PRIMARY KEY, v VARCHAR)" + this.tableDDLOptionsWithoutProvider);
        conn.createStatement().execute("UPSERT INTO " + nonTxTableName + " VALUES (1)");
        conn.createStatement().execute("UPSERT INTO " + nonTxTableName + " VALUES (2, 'a')");
        conn.createStatement().execute("UPSERT INTO " + nonTxTableName + " VALUES (3, 'b')");
        conn.commit();
        String index = ParameterizedTransactionIT.generateUniqueName();
        conn.createStatement().execute("CREATE INDEX " + index + " ON " + nonTxTableName + "(v)");
        Table htable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)nonTxTableName));
        ArrayList puts = Lists.newArrayList((Object[])new Put[]{new Put(PInteger.INSTANCE.toBytes((Object)1)), new Put(PInteger.INSTANCE.toBytes((Object)2)), new Put(PInteger.INSTANCE.toBytes((Object)3))});
        for (Put put : puts) {
            put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, ByteUtil.EMPTY_BYTE_ARRAY);
        }
        htable.put((List)puts);
        try {
            conn.createStatement().execute("ALTER TABLE " + nonTxTableName + " SET TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + this.transactionProvider + "'");
            if (this.transactionProvider.isUnsupported(PhoenixTransactionProvider.Feature.ALTER_NONTX_TO_TX)) {
                Assert.fail();
            }
        }
        catch (SQLException e) {
            if (this.transactionProvider.isUnsupported(PhoenixTransactionProvider.Feature.ALTER_NONTX_TO_TX)) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_ALTER_TABLE_FROM_NON_TXN_TO_TXNL.getErrorCode(), (long)e.getErrorCode());
                return;
            }
            throw e;
        }
        conn.createStatement().execute("UPSERT INTO " + nonTxTableName + " VALUES (4, 'c')");
        ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ k FROM " + nonTxTableName + " WHERE v IS NULL");
        Assert.assertTrue((boolean)conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, nonTxTableName)).isTransactional());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        conn.commit();
        conn.createStatement().execute("UPSERT INTO " + nonTxTableName + " VALUES (5, 'd')");
        rs = conn.createStatement().executeQuery("SELECT k FROM " + nonTxTableName);
        Assert.assertTrue((boolean)conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, index)).isTransactional());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)5L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        conn.rollback();
        rs = conn.createStatement().executeQuery("SELECT k FROM " + nonTxTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonTxToTxTableFailure() throws Exception {
        if (this.tableDDLOptions.contains("COLUMN_ENCODED_BYTES")) {
            return;
        }
        String nonTxTableName = ParameterizedTransactionIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(ParameterizedTransactionIT.getUrl());
        conn.createStatement().execute("CREATE TABLE \"SYSTEM\"." + nonTxTableName + "(k INTEGER PRIMARY KEY, v VARCHAR)" + this.tableDDLOptionsWithoutProvider);
        conn.createStatement().execute("UPSERT INTO \"SYSTEM\"." + nonTxTableName + " VALUES (1)");
        conn.commit();
        Table htable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)("SYSTEM." + nonTxTableName)));
        Put put = new Put(PInteger.INSTANCE.toBytes((Object)1));
        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, ByteUtil.EMPTY_BYTE_ARRAY);
        htable.put(put);
        Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
        admin.disableTable(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME));
        try {
            conn.createStatement().execute("ALTER TABLE \"SYSTEM\"." + nonTxTableName + " SET TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + this.transactionProvider + "'");
            Assert.fail();
        }
        catch (SQLException e) {
            if (this.transactionProvider.isUnsupported(PhoenixTransactionProvider.Feature.ALTER_NONTX_TO_TX)) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_ALTER_TABLE_FROM_NON_TXN_TO_TXNL.getErrorCode(), (long)e.getErrorCode());
            } else {
                Assert.assertTrue((boolean)e.getMessage().contains(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " is disabled"));
            }
        }
        finally {
            admin.enableTable(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME));
            admin.close();
        }
        ResultSet rs = conn.createStatement().executeQuery("SELECT k FROM \"SYSTEM\"." + nonTxTableName + " WHERE v IS NULL");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        htable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)("SYSTEM." + nonTxTableName)));
        Assert.assertFalse((boolean)htable.getDescriptor().getCoprocessorDescriptors().stream().map(CoprocessorDescriptor::getClassName).collect(Collectors.toList()).contains(this.transactionProvider.getCoprocessorClassName()));
        Assert.assertEquals((long)1L, (long)conn.unwrap(PhoenixConnection.class).getQueryServices().getTableDescriptor(Bytes.toBytes((String)("SYSTEM." + nonTxTableName))).getColumnFamily(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES).getMaxVersions());
    }

    @Test
    public void testCreateTableToBeTransactional() throws Exception {
        if (this.tableDDLOptions.contains("COLUMN_ENCODED_BYTES")) {
            return;
        }
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(ParameterizedTransactionIT.getUrl(), props);
        String t1 = ParameterizedTransactionIT.generateUniqueName();
        String t2 = ParameterizedTransactionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + t1 + " (k varchar primary key)" + this.tableDDLOptions + (this.tableDDLOptions.length() > 0 ? "," : "") + "TRANSACTIONAL=true";
        conn.createStatement().execute(ddl);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable table = pconn.getTable(new PTableKey(null, t1));
        Table htable = pconn.getQueryServices().getTable(Bytes.toBytes((String)t1));
        Assert.assertTrue((boolean)table.isTransactional());
        Assert.assertTrue((boolean)htable.getDescriptor().getCoprocessorDescriptors().stream().map(CoprocessorDescriptor::getClassName).collect(Collectors.toList()).contains(this.transactionProvider.getCoprocessorClassName()));
        try {
            ddl = "ALTER TABLE " + t1 + " SET transactional=false";
            conn.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TX_MAY_NOT_SWITCH_TO_NON_TX.getErrorCode(), (long)e.getErrorCode());
        }
        Admin admin = pconn.getQueryServices().getAdmin();
        admin.createTable(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)t2)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES)).build());
        try {
            ddl = "CREATE TABLE " + t2 + " (k varchar primary key) transactional=true,transaction_provider='" + this.transactionProvider + "'";
            conn.createStatement().execute(ddl);
            if (this.transactionProvider.isUnsupported(PhoenixTransactionProvider.Feature.ALTER_NONTX_TO_TX)) {
                Assert.fail();
            }
        }
        catch (SQLException e) {
            if (this.transactionProvider.isUnsupported(PhoenixTransactionProvider.Feature.ALTER_NONTX_TO_TX)) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_ALTER_TABLE_FROM_NON_TXN_TO_TXNL.getErrorCode(), (long)e.getErrorCode());
                return;
            }
            throw e;
        }
        TableDescriptor tableDescriptor = admin.getDescriptor(TableName.valueOf((String)t2));
        String str = tableDescriptor.getValue("data.tx.read.pre.existing");
        Assert.assertEquals((Object)Boolean.TRUE.toString(), (Object)str);
        ddl = "CREATE TABLE IF NOT EXISTS " + t1 + " (k varchar primary key)";
        try {
            conn.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TX_MAY_NOT_SWITCH_TO_NON_TX.getErrorCode(), (long)e.getErrorCode());
        }
        ddl = ddl + " transactional=true,transaction_provider='" + this.transactionProvider + "'";
        conn.createStatement().execute(ddl);
        table = pconn.getTable(new PTableKey(null, t1));
        htable = pconn.getQueryServices().getTable(Bytes.toBytes((String)t1));
        Assert.assertTrue((boolean)table.isTransactional());
        Assert.assertTrue((boolean)htable.getDescriptor().getCoprocessorDescriptors().stream().map(CoprocessorDescriptor::getClassName).collect(Collectors.toList()).contains(this.transactionProvider.getCoprocessorClassName()));
    }

    @Test
    public void testCurrentDate() throws Exception {
        String transTableName = ParameterizedTransactionIT.generateUniqueName();
        String fullTableName = "INDEX_TEST." + transTableName;
        String selectSql = "SELECT current_date() FROM " + fullTableName;
        try (Connection conn = DriverManager.getConnection(ParameterizedTransactionIT.getUrl());){
            conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions + (this.tableDDLOptions.length() > 0 ? "," : "") + "TRANSACTIONAL=true");
            conn.setAutoCommit(false);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            String upsert = "UPSERT INTO " + fullTableName + "(varchar_pk, char_pk, int_pk, long_pk, decimal_pk, date_pk) VALUES(?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = conn.prepareStatement(upsert);
            TestUtil.setRowKeyColumns(stmt, 1);
            stmt.execute();
            conn.commit();
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Date date1 = rs.getDate(1);
            Assert.assertFalse((boolean)rs.next());
            Thread.sleep(1000L);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Date date2 = rs.getDate(1);
            Assert.assertFalse((boolean)rs.next());
            Assert.assertTrue((String)"current_date() should change while executing multiple statements", (date2.getTime() > date1.getTime() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testParallelUpsertSelect() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.mutate.batchSizeBytes", Integer.toString(512));
        props.setProperty("hbase.client.scanner.caching", Integer.toString(3));
        props.setProperty("phoenix.query.scanResultChunkSize", Integer.toString(3));
        Connection conn = DriverManager.getConnection(ParameterizedTransactionIT.getUrl(), props);
        conn.setAutoCommit(false);
        String fullTableName1 = ParameterizedTransactionIT.generateUniqueName();
        String fullTableName2 = ParameterizedTransactionIT.generateUniqueName();
        String sequenceName = "S_" + ParameterizedTransactionIT.generateUniqueName();
        conn.createStatement().execute("CREATE SEQUENCE " + sequenceName);
        conn.createStatement().execute("CREATE TABLE " + fullTableName1 + " (pk INTEGER PRIMARY KEY, val INTEGER) SALT_BUCKETS=4, TRANSACTIONAL=true" + (this.tableDDLOptions.length() > 0 ? "," : "") + this.tableDDLOptions);
        conn.createStatement().execute("CREATE TABLE " + fullTableName2 + " (pk INTEGER PRIMARY KEY, val INTEGER)");
        for (int i = 0; i < 100; ++i) {
            conn.createStatement().execute("UPSERT INTO " + fullTableName1 + " VALUES (NEXT VALUE FOR " + sequenceName + ", " + i % 10 + ")");
        }
        conn.commit();
        conn.setAutoCommit(true);
        int upsertCount = conn.createStatement().executeUpdate("UPSERT INTO " + fullTableName2 + " SELECT pk, val FROM " + fullTableName1);
        Assert.assertEquals((long)100L, (long)upsertCount);
        conn.close();
    }

    @Test
    public void testInflightPartialEval() throws SQLException {
        try (Connection conn = DriverManager.getConnection(ParameterizedTransactionIT.getUrl());){
            String transactTableName = ParameterizedTransactionIT.generateUniqueName();
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + transactTableName + " (k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) " + this.tableDDLOptions + (this.tableDDLOptions.length() > 0 ? "," : "") + "TRANSACTIONAL=true");
            try (Connection conn1 = DriverManager.getConnection(ParameterizedTransactionIT.getUrl());
                 Connection conn2 = DriverManager.getConnection(ParameterizedTransactionIT.getUrl());){
                conn1.createStatement().execute("UPSERT INTO " + transactTableName + " VALUES ('a','b','x')");
                ResultSet rs = conn1.createStatement().executeQuery("SELECT * FROM " + transactTableName);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"a", (Object)rs.getString(1));
                Assert.assertEquals((Object)"b", (Object)rs.getString(2));
                Assert.assertFalse((boolean)rs.next());
                conn2.createStatement().execute("UPSERT INTO " + transactTableName + " VALUES ('a','c','x')");
                rs = conn2.createStatement().executeQuery("SELECT * FROM " + transactTableName);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"a", (Object)rs.getString(1));
                Assert.assertEquals((Object)"c", (Object)rs.getString(2));
                Assert.assertFalse((boolean)rs.next());
                rs = conn1.createStatement().executeQuery("SELECT * FROM " + transactTableName + " WHERE v1 != 'c' AND v2 = 'x'");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"a", (Object)rs.getString(1));
                Assert.assertEquals((Object)"b", (Object)rs.getString(2));
                Assert.assertFalse((boolean)rs.next());
                rs = conn2.createStatement().executeQuery("SELECT * FROM " + transactTableName + " WHERE v1 != 'b' AND v2 = 'x'");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"a", (Object)rs.getString(1));
                Assert.assertEquals((Object)"c", (Object)rs.getString(2));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }
}

