/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.committable.InMemoryCommitTable;
import org.apache.omid.transaction.HBaseOmidClientConfiguration;
import org.apache.omid.transaction.HBaseTransactionManager;
import org.apache.omid.tso.TSOMockModule;
import org.apache.omid.tso.TSOServer;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.client.OmidClientConfiguration;
import org.apache.omid.tso.client.TSOClient;
import org.apache.omid.tso.client.TSOProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.transaction.OmidTransactionProvider;
import org.apache.phoenix.transaction.PhoenixTransactionService;

public class OmidTransactionService
implements PhoenixTransactionService {
    private static final String OMID_TSO_PORT = "phoenix.omid.tso.port";
    private static final String OMID_TSO_CONFLICT_MAP_SIZE = "phoenix.omid.tso.conflict.map.size";
    private static final String OMID_TSO_TIMESTAMP_TYPE = "phoenix.omid.tso.timestamp.type";
    private static final int DEFAULT_OMID_TSO_CONFLICT_MAP_SIZE = 1000;
    private static final String DEFAULT_OMID_TSO_TIMESTAMP_TYPE = "WORLD_TIME";
    private final HBaseTransactionManager transactionManager;
    private TSOServer tso;

    public OmidTransactionService(TSOServer tso, HBaseTransactionManager transactionManager) {
        this.tso = tso;
        this.transactionManager = transactionManager;
    }

    public static OmidTransactionService startAndInjectOmidTransactionService(OmidTransactionProvider transactionProvider, Configuration config, ConnectionInfo connectionInfo, int port) throws SQLException {
        HBaseTransactionManager transactionManager;
        CommitTable.Client commitTableClient;
        TSOServerConfig tsoConfig = new TSOServerConfig();
        tsoConfig.setPort(port);
        tsoConfig.setConflictMapSize(config.getInt(OMID_TSO_CONFLICT_MAP_SIZE, 1000));
        tsoConfig.setTimestampType(config.get(OMID_TSO_TIMESTAMP_TYPE, DEFAULT_OMID_TSO_TIMESTAMP_TYPE));
        tsoConfig.setWaitStrategy(TSOServerConfig.WAIT_STRATEGY.LOW_CPU.toString());
        Injector injector = Guice.createInjector((Module[])new Module[]{new TSOMockModule(tsoConfig)});
        TSOServer tso = (TSOServer)injector.getInstance(TSOServer.class);
        tso.startAsync();
        tso.awaitRunning();
        OmidClientConfiguration clientConfig = new OmidClientConfiguration();
        clientConfig.setConnectionString("localhost:" + port);
        clientConfig.setConflictAnalysisLevel(OmidClientConfiguration.ConflictDetectionLevel.ROW);
        InMemoryCommitTable commitTable = (InMemoryCommitTable)injector.getInstance(CommitTable.class);
        try {
            TSOClient client = TSOClient.newInstance((OmidClientConfiguration)clientConfig);
            HBaseOmidClientConfiguration clientConf = new HBaseOmidClientConfiguration();
            clientConf.setConnectionString("localhost:" + port);
            clientConf.setConflictAnalysisLevel(OmidClientConfiguration.ConflictDetectionLevel.ROW);
            clientConf.setHBaseConfiguration(config);
            commitTableClient = commitTable.getClient();
            CommitTable.Writer commitTableWriter = commitTable.getWriter();
            transactionManager = HBaseTransactionManager.builder((HBaseOmidClientConfiguration)clientConf).commitTableClient(commitTableClient).commitTableWriter(commitTableWriter).tsoClient((TSOProtocol)client).build();
        }
        catch (IOException | InterruptedException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause((Throwable)e).build().buildException();
        }
        transactionProvider.injectTestService(transactionManager, commitTableClient);
        return new OmidTransactionService(tso, transactionManager);
    }

    public void start() {
    }

    @Override
    public void close() throws IOException {
        if (this.transactionManager != null) {
            this.transactionManager.close();
        }
        if (this.tso != null) {
            this.tso.stopAsync();
            this.tso.awaitTerminated();
        }
    }
}

