/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.trace;

import java.sql.Connection;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.htrace.Span;
import org.apache.htrace.Tracer;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.trace.BaseTracingTestIT;
import org.apache.phoenix.trace.TraceReader;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class PhoenixTableMetricsWriterIT
extends BaseTracingTestIT {
    @Test
    public void testCreatesTable() throws Exception {
        Connection conn = PhoenixTableMetricsWriterIT.getConnectionWithoutTracing();
        try {
            String ddl = "CREATE TABLE SYSTEM.TRACING_STATS";
            conn.createStatement().execute(ddl);
            Assert.fail((String)"Table SYSTEM.TRACING_STATS was not created by the metrics sink");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void writeMetrics() throws Exception {
        Connection conn = PhoenixTableMetricsWriterIT.getConnectionWithoutTracing();
        this.latch = new CountDownLatch(1);
        this.testTraceWriter.start();
        long traceid = 987654L;
        String description = "Some generic trace";
        long spanid = 10L;
        long parentid = 11L;
        long startTime = 12L;
        long endTime = 13L;
        String processid = "Some process";
        String annotation = "test annotation for a span";
        Span span = this.createNewSpan(traceid, parentid, spanid, description, startTime, endTime, processid, annotation);
        Tracer.getInstance().deliver(span);
        Assert.assertTrue((String)"Span never committed to table", (boolean)this.latch.await(30L, TimeUnit.SECONDS));
        TraceReader reader = new TraceReader(conn, this.tracingTableName);
        Collection traces = reader.readAll(10);
        Assert.assertEquals((String)"Wrong number of traces in the tracing table", (long)1L, (long)traces.size());
        TraceReader.TraceHolder trace = (TraceReader.TraceHolder)traces.iterator().next();
        Assert.assertEquals((String)("Didn't get expected orphaned spans!" + trace.orphans), (long)1L, (long)trace.orphans.size());
        Assert.assertEquals((long)traceid, (long)trace.traceid);
        TraceReader.SpanInfo spanInfo = (TraceReader.SpanInfo)trace.orphans.get(0);
        Assert.assertEquals((Object)description, (Object)spanInfo.description);
        Assert.assertEquals((long)parentid, (long)spanInfo.getParentIdForTesting());
        Assert.assertEquals((long)startTime, (long)spanInfo.start);
        Assert.assertEquals((long)endTime, (long)spanInfo.end);
        Assert.assertEquals((String)"Wrong number of tags", (long)0L, (long)spanInfo.tagCount);
        Assert.assertEquals((String)"Wrong number of annotations", (long)1L, (long)spanInfo.annotationCount);
    }
}

