/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.trace;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.Trace;
import org.apache.htrace.impl.MilliSpan;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.jdbc.DelegateConnection;
import org.apache.phoenix.trace.TraceSpanReceiver;
import org.apache.phoenix.trace.TraceWriter;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTracingTestIT
extends ParallelStatsDisabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTracingTestIT.class);
    protected CountDownLatch latch;
    protected int defaultTracingThreadPoolForTest = 1;
    protected int defaultTracingBatchSizeForTest = 1;
    protected String tracingTableName;
    protected TraceSpanReceiver traceSpanReceiver = null;
    protected TestTraceWriter testTraceWriter = null;

    @Before
    public void setup() {
        this.tracingTableName = "TRACING_" + BaseTracingTestIT.generateUniqueName();
        this.traceSpanReceiver = new TraceSpanReceiver();
        Trace.addReceiver((SpanReceiver)this.traceSpanReceiver);
        this.testTraceWriter = new TestTraceWriter(this.tracingTableName, this.defaultTracingThreadPoolForTest, this.defaultTracingBatchSizeForTest);
    }

    @After
    public void cleanUp() {
        Trace.removeReceiver((SpanReceiver)this.traceSpanReceiver);
        if (this.testTraceWriter != null) {
            this.testTraceWriter.stop();
        }
    }

    public static Connection getConnectionWithoutTracing() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        return BaseTracingTestIT.getConnectionWithoutTracing(props);
    }

    public static Connection getConnectionWithoutTracing(Properties props) throws SQLException {
        Connection conn = BaseTracingTestIT.getConnectionWithTracingFrequency(props, Tracing.Frequency.NEVER);
        return conn;
    }

    public static Connection getTracingConnection() throws Exception {
        return BaseTracingTestIT.getTracingConnection(Collections.emptyMap(), null);
    }

    public static Connection getTracingConnection(Map<String, String> customAnnotations, String tenantId) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        for (Map.Entry<String, String> annot : customAnnotations.entrySet()) {
            props.put("phoenix.annotation." + annot.getKey(), annot.getValue());
        }
        if (tenantId != null) {
            props.put("TenantId", tenantId);
        }
        return BaseTracingTestIT.getConnectionWithTracingFrequency(props, Tracing.Frequency.ALWAYS);
    }

    public static Connection getConnectionWithTracingFrequency(Properties props, Tracing.Frequency frequency) throws SQLException {
        Tracing.setSampling((Properties)props, (Tracing.Frequency)frequency);
        return DriverManager.getConnection(BaseTracingTestIT.getUrl(), props);
    }

    protected Span createNewSpan(long traceid, long parentid, long spanid, String description, long startTime, long endTime, String processid, String ... tags) {
        MilliSpan span = new MilliSpan.Builder().description(description).traceId(traceid).parents(new long[]{parentid}).spanId(spanid).processId(processid).begin(startTime).end(endTime).build();
        int tagCount = 0;
        for (String annotation : tags) {
            span.addKVAnnotation(Integer.toString(tagCount++).getBytes(), annotation.getBytes());
        }
        return span;
    }

    protected class TestTraceWriter
    extends TraceWriter {
        public TestTraceWriter(String tableName, int numThreads, int batchSize) {
            super(tableName, numThreads, batchSize);
        }

        protected Connection getConnection(String tableName) {
            try {
                CountDownConnection connection = new CountDownConnection(BaseTracingTestIT.getConnectionWithoutTracing(), BaseTracingTestIT.this.latch);
                if (!this.traceTableExists((Connection)((Object)connection), tableName)) {
                    this.createTable((Connection)((Object)connection), tableName);
                }
                return connection;
            }
            catch (SQLException e) {
                LOGGER.error("New connection failed for tracing Table: " + tableName, (Throwable)e);
                return null;
            }
        }

        protected TraceSpanReceiver getTraceSpanReceiver() {
            return BaseTracingTestIT.this.traceSpanReceiver;
        }

        public void stop() {
            if (this.executor == null) {
                return;
            }
            try {
                this.executor.shutdownNow();
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.error("Failed to stop the thread. ", (Throwable)e);
            }
        }
    }

    private static class CountDownConnection
    extends DelegateConnection {
        private CountDownLatch commit;

        public CountDownConnection(Connection conn, CountDownLatch commit) {
            super(conn);
            this.commit = commit;
        }

        public void commit() throws SQLException {
            super.commit();
            this.commit.countDown();
        }
    }
}

