/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.phoenix.schema.types.BasePhoenixArrayToStringTest;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PDateArrayToStringTest
extends BasePhoenixArrayToStringTest {
    private static final String DATE1 = "2001-01-01 12:15:15.123";
    private static final String DATE2 = "2002-02-02 14:30:30.456";
    private static final String DATE3 = "2003-03-03 16:45:45.789";

    @Override
    protected PDataType getBaseType() {
        return PDate.INSTANCE;
    }

    @Override
    protected boolean isPrimitive(PhoenixArray arr) {
        return false;
    }

    @Override
    protected Object getElement1() {
        return this.parseDate(DATE1);
    }

    @Override
    protected String getString1() {
        return "'2001-01-01 12:15:15.123'";
    }

    @Override
    protected Object getElement2() {
        return this.parseDate(DATE2);
    }

    @Override
    protected String getString2() {
        return "'2002-02-02 14:30:30.456'";
    }

    @Override
    protected Object getElement3() {
        return this.parseDate(DATE3);
    }

    @Override
    protected String getString3() {
        return "'2003-03-03 16:45:45.789'";
    }

    private Object parseDate(String dateString) {
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").parse(dateString);
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(date.getTime());
            cal.add(14, TimeZone.getDefault().getOffset(date.getTime()));
            return cal.getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

