/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tuple;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.tuple.DelegateTuple;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.junit.Assert;
import org.junit.Test;

public class TupleKeyValueBytesSizeTest {
    private static final byte[] ROW = Bytes.toBytes((String)UUID.randomUUID().toString());
    private static final byte[] FAMILY = Bytes.toBytes((String)UUID.randomUUID().toString());

    @Test
    public void testEmptyTuple() {
        SingleKeyValueTuple tuple = new SingleKeyValueTuple();
        Assert.assertEquals((long)0L, (long)tuple.getSerializedSize());
    }

    @Test
    public void testSingleKeyValueTuple() {
        ExtendedCell kv = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(ROW).setFamily(FAMILY).setQualifier(Bytes.toBytes((String)UUID.randomUUID().toString())).setTimestamp(1294754L).setType(Cell.Type.Put).setValue(Bytes.toBytes((String)UUID.randomUUID().toString())).build();
        SingleKeyValueTuple tuple = new SingleKeyValueTuple((Cell)kv);
        long expectedSize = ((KeyValue)kv).getLength();
        Assert.assertEquals((long)expectedSize, (long)tuple.getSerializedSize());
    }

    @Test
    public void testMultiKeyValueTuple() {
        ExtendedCell kv1 = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(ROW).setFamily(FAMILY).setQualifier(Bytes.toBytes((String)UUID.randomUUID().toString())).setTimestamp(999999999L).setType(Cell.Type.Put).setValue(Bytes.toBytes((String)UUID.randomUUID().toString())).build();
        ExtendedCell kv2 = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(ROW).setFamily(FAMILY).setQualifier(Bytes.toBytes((String)UUID.randomUUID().toString())).setTimestamp(0L).setType(Cell.Type.Put).setValue(Bytes.toBytes((String)UUID.randomUUID().toString())).build();
        List<Cell> kvs = Arrays.asList(kv1, kv2);
        MultiKeyValueTuple tuple = new MultiKeyValueTuple(kvs);
        long expectedSize = ((KeyValue)kv1).getLength() + ((KeyValue)kv2).getLength();
        Assert.assertEquals((long)expectedSize, (long)tuple.getSerializedSize());
    }

    @Test
    public void testDelegateTuple() {
        ExtendedCell kv = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(ROW).setFamily(FAMILY).setQualifier(Bytes.toBytes((String)UUID.randomUUID().toString())).setTimestamp(75304756904L).setType(Cell.Type.Put).setValue(Bytes.toBytes((String)UUID.randomUUID().toString())).build();
        SingleKeyValueTuple delegate = new SingleKeyValueTuple((Cell)kv);
        DelegateTuple tuple = new DelegateTuple((Tuple)delegate);
        Assert.assertEquals((long)delegate.getSerializedSize(), (long)tuple.getSerializedSize());
    }

    @Test
    public void testMultiCellResultTuple() {
        byte[] row = Bytes.toBytes((String)UUID.randomUUID().toString());
        byte[] family = Bytes.toBytes((String)UUID.randomUUID().toString());
        byte[] qual1 = Bytes.toBytes((String)UUID.randomUUID().toString());
        byte[] qual2 = Bytes.toBytes((String)UUID.randomUUID().toString());
        byte[] qual3 = Bytes.toBytes((String)UUID.randomUUID().toString());
        byte[] val1 = Bytes.toBytes((String)UUID.randomUUID().toString());
        byte[] val2 = Bytes.toBytes((String)UUID.randomUUID().toString());
        byte[] val3 = Bytes.toBytes((String)UUID.randomUUID().toString());
        ExtendedCell cell1 = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(row).setFamily(family).setQualifier(qual1).setTimestamp(100L).setType(Cell.Type.Put).setValue(val1).build();
        ExtendedCell cell2 = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(row).setFamily(family).setQualifier(qual2).setTimestamp(101L).setType(Cell.Type.Put).setValue(val2).build();
        ExtendedCell cell3 = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(row).setFamily(family).setQualifier(qual3).setTimestamp(102L).setType(Cell.Type.Put).setValue(val3).build();
        List<Cell> cells = Arrays.asList(cell1, cell2, cell3);
        ResultTuple tuple = new ResultTuple(Result.create(cells));
        long expectedSize = ((KeyValue)cell1).getLength() + ((KeyValue)cell2).getLength() + ((KeyValue)cell3).getLength();
        Assert.assertEquals((long)expectedSize, (long)tuple.getSerializedSize());
    }
}

