/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.ParseException;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.tool.SchemaExtractionProcessor;
import org.apache.phoenix.schema.tool.SchemaTool;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class SchemaToolExtractionIT
extends ParallelStatsEnabledIT {
    @BeforeClass
    public static synchronized void setup() throws Exception {
        Map props = Collections.emptyMap();
        SchemaToolExtractionIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testCreateTableStatement() throws Exception {
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String createTableStmt = "CREATE TABLE " + pTableFullName + "(K VARCHAR NOT NULL PRIMARY KEY, V1 VARCHAR, V2 VARCHAR) TTL=2592000, IMMUTABLE_ROWS=TRUE, DISABLE_WAL=TRUE";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(createTableStmt);
        String result = this.runSchemaExtractionTool(schemaName, tableName, null, (List<String>)queries);
        Assert.assertEquals((Object)createTableStmt, (Object)result.toUpperCase());
    }

    @Test
    public void testCreateTableStatementLowerCase() throws Exception {
        String tableName = "lowecasetbl1";
        String schemaName = "lowecaseschemaname1";
        String pTableFullName = SchemaUtil.getEscapedTableName((String)schemaName, (String)tableName);
        String createTableStmt = "CREATE TABLE " + pTableFullName + "(\"smallK\" VARCHAR NOT NULL PRIMARY KEY, \"asd\".V1 VARCHAR, \"foo\".\"bar\" VARCHAR) TTL=2592000, IMMUTABLE_ROWS=true, DISABLE_WAL=true";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(createTableStmt);
        String result = this.runSchemaExtractionTool("\"" + schemaName + "\"", "\"" + tableName + "\"", null, (List<String>)queries);
        Assert.assertEquals((Object)createTableStmt, (Object)result);
    }

    @Test
    public void testCreateIndexStatement() throws Exception {
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String indexName = SchemaToolExtractionIT.generateUniqueName();
        String indexName1 = SchemaToolExtractionIT.generateUniqueName();
        String indexName2 = SchemaToolExtractionIT.generateUniqueName();
        String indexName3 = SchemaToolExtractionIT.generateUniqueName();
        String properties = "TTL=2592000,IMMUTABLE_ROWS=true,DISABLE_WAL=true";
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String createTableStatement = "CREATE TABLE " + pTableFullName + "(k VARCHAR NOT NULL PRIMARY KEY, \"v1\" VARCHAR, v2 VARCHAR)" + properties;
        String createIndexStatement = "CREATE INDEX " + indexName + " ON " + pTableFullName + "(\"v1\" DESC) INCLUDE (v2)";
        String createIndexStatement1 = "CREATE INDEX " + indexName1 + " ON " + pTableFullName + "(v2 DESC) INCLUDE (\"v1\")";
        String createIndexStatement2 = "CREATE INDEX " + indexName2 + " ON " + pTableFullName + "(k)";
        String createIndexStatement3 = "CREATE INDEX " + indexName3 + " ON " + pTableFullName + "('QUOTED' || \"v1\" || V2 DESC, \"v1\" DESC, K) INCLUDE (V2)";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(createTableStatement);
        queries.add(createIndexStatement);
        queries.add(createIndexStatement1);
        queries.add(createIndexStatement2);
        String result = this.runSchemaExtractionTool(schemaName, indexName2, null, (List<String>)queries);
        Assert.assertEquals((Object)createIndexStatement2.toUpperCase(), (Object)result.toUpperCase());
        ArrayList<String> queries3 = new ArrayList<String>(){};
        queries3.add(createIndexStatement3);
        String result3 = this.runSchemaExtractionTool(schemaName, indexName3, null, (List<String>)queries3);
        Assert.assertEquals((Object)createIndexStatement3, (Object)result3);
    }

    @Test
    public void testDDLsWithDefaults() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String indexName = SchemaToolExtractionIT.generateUniqueName();
        String properties = "COLUMN_ENCODED_BYTES=4";
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String pIndexFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)indexName);
        String createTableStatement = "CREATE TABLE " + pTableFullName + "(k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)";
        String createIndexStatement = "CREATE INDEX " + indexName + " ON " + pTableFullName + "(v1 DESC) INCLUDE (v2)" + properties;
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(createTableStatement);
        queries.add(createIndexStatement);
        try (PhoenixConnection conn = DriverManager.getConnection(SchemaToolExtractionIT.getUrl(), props).unwrap(PhoenixConnection.class);){
            this.executeCreateStatements((Connection)conn, (List<String>)queries);
            PTable pData = conn.getTable(pTableFullName);
            PTable pIndex = conn.getTable(pIndexFullName);
            SchemaExtractionProcessor schemaExtractionProcessor = new SchemaExtractionProcessor(null, config, pData, true);
            String tableDDL = schemaExtractionProcessor.process();
            TestCase.assertTrue((boolean)tableDDL.contains("IMMUTABLE_STORAGE_SCHEME"));
            SchemaExtractionProcessor schemaExtractionProcessorIndex = new SchemaExtractionProcessor(null, config, pIndex, true);
            String indexDDL = schemaExtractionProcessorIndex.process();
            TestCase.assertTrue((boolean)indexDDL.contains("IMMUTABLE_STORAGE_SCHEME"));
            TestCase.assertTrue((boolean)indexDDL.contains("ENCODING_SCHEME='FOUR_BYTE_QUALIFIERS'"));
        }
    }

    @Test
    public void testCreateLocalIndexStatement() throws Exception {
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String indexName = SchemaToolExtractionIT.generateUniqueName();
        String indexName2 = SchemaToolExtractionIT.generateUniqueName();
        String properties = "TTL=2592000,IMMUTABLE_ROWS=true,DISABLE_WAL=true";
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String createTableStatement = "CREATE TABLE " + pTableFullName + "(k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + properties;
        String createIndexStatement = "CREATE LOCAL INDEX " + indexName + " ON " + pTableFullName + "(v1 DESC, k) INCLUDE (v2)";
        String createIndexStatement2 = "CREATE LOCAL INDEX " + indexName2 + " ON " + pTableFullName + "( LPAD(v1,10) DESC, k) INCLUDE (v2)";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(createTableStatement);
        queries.add(createIndexStatement);
        String result = this.runSchemaExtractionTool(schemaName, indexName, null, (List<String>)queries);
        Assert.assertEquals((Object)createIndexStatement.toUpperCase(), (Object)result.toUpperCase());
        ArrayList<String> queries2 = new ArrayList<String>(){};
        queries2.add(createIndexStatement2);
        String result2 = this.runSchemaExtractionTool(schemaName, indexName2, null, (List<String>)queries2);
        Assert.assertEquals((Object)createIndexStatement2.toUpperCase(), (Object)result2.toUpperCase());
    }

    @Test
    public void testCreateLocalIndexStatementLowerCase() throws Exception {
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String indexName = SchemaToolExtractionIT.generateUniqueName();
        String properties = "TTL=2592000,IMMUTABLE_ROWS=true,DISABLE_WAL=true";
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String createTableStatement = "CREATE TABLE " + pTableFullName + "(K VARCHAR NOT NULL PRIMARY KEY, \"v1\" VARCHAR, V2 VARCHAR)" + properties;
        String createIndexStatement = "CREATE LOCAL INDEX " + indexName + " ON " + pTableFullName + "( LPAD(\"v1\",10) DESC, K) INCLUDE (V2)";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(createTableStatement);
        queries.add(createIndexStatement);
        String result = this.runSchemaExtractionTool(schemaName, indexName, null, (List<String>)queries);
        Assert.assertEquals((Object)createIndexStatement, (Object)result);
    }

    @Test
    public void testCreateIndexStatementLowerCase() throws Exception {
        String tableName = "lowercase" + SchemaToolExtractionIT.generateUniqueName();
        String schemaName = "lowercase" + SchemaToolExtractionIT.generateUniqueName();
        String indexName = "\"lowercaseIND" + SchemaToolExtractionIT.generateUniqueName() + "\"";
        String properties = "TTL=2592000,IMMUTABLE_ROWS=true,DISABLE_WAL=true";
        String pTableFullName = SchemaUtil.getEscapedTableName((String)schemaName, (String)tableName);
        String createTableStatement = "CREATE TABLE " + pTableFullName + "(\"k\" VARCHAR NOT NULL PRIMARY KEY, \"a\".V1 VARCHAR, \"v2\" VARCHAR)" + properties;
        String createIndexStatement = "CREATE INDEX " + indexName + " ON " + pTableFullName + "(\"a\".V1 DESC, \"k\") INCLUDE (\"v2\")";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(createTableStatement);
        queries.add(createIndexStatement);
        String result = this.runSchemaExtractionTool("\"" + schemaName + "\"", indexName, null, (List<String>)queries);
        Assert.assertEquals((Object)createIndexStatement, (Object)result);
    }

    @Test
    public void testCreateIndexStatementLowerCaseCombined() throws Exception {
        String tableName = "lowercase" + SchemaToolExtractionIT.generateUniqueName();
        String schemaName = "lowercase" + SchemaToolExtractionIT.generateUniqueName();
        String indexName = "\"lowercaseIND" + SchemaToolExtractionIT.generateUniqueName() + "\"";
        String properties = "TTL=2592000,IMMUTABLE_ROWS=true,DISABLE_WAL=true";
        String pTableFullName = SchemaUtil.getEscapedTableName((String)schemaName, (String)tableName);
        String createTableStatement = "CREATE TABLE " + pTableFullName + "(ID varchar primary key, \"number\" integer, \"currency\" decimal(6,2), lista varchar[])" + properties;
        String createIndexStatement = "CREATE INDEX " + indexName + " ON " + pTableFullName + "(\"number\" * \"currency\", ID) INCLUDE (LISTA)";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(createTableStatement);
        queries.add(createIndexStatement);
        String result = this.runSchemaExtractionTool("\"" + schemaName + "\"", indexName, null, (List<String>)queries);
        Assert.assertEquals((Object)createIndexStatement, (Object)result);
    }

    @Test
    public void testCreateViewStatement() throws Exception {
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String viewName = SchemaToolExtractionIT.generateUniqueName();
        String properties = "TTL=2592000,IMMUTABLE_ROWS=true,DISABLE_WAL=true";
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String createTableStmt = "CREATE TABLE " + pTableFullName + "(k BIGINT NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + properties;
        String viewFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)viewName);
        String createView = "CREATE VIEW " + viewFullName + "(id1 BIGINT, id2 BIGINT NOT NULL, id3 VARCHAR NOT NULL CONSTRAINT PKVIEW PRIMARY KEY (id2, id3 DESC)) AS SELECT * FROM " + pTableFullName;
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(createTableStmt);
        queries.add(createView);
        String result = this.runSchemaExtractionTool(schemaName, viewName, null, (List<String>)queries);
        Assert.assertEquals((Object)createView.toUpperCase(), (Object)result.toUpperCase());
    }

    @Test
    public void testCreateViewStatementLowerCase() throws Exception {
        String tableName = "lowercase" + SchemaToolExtractionIT.generateUniqueName();
        String schemaName = "lowercase" + SchemaToolExtractionIT.generateUniqueName();
        String viewName = "lowercase" + SchemaToolExtractionIT.generateUniqueName();
        String properties = "TTL=2592000,IMMUTABLE_ROWS=true,DISABLE_WAL=true";
        String pTableFullName = SchemaUtil.getEscapedTableName((String)schemaName, (String)tableName);
        String createTableStmt = "CREATE TABLE " + pTableFullName + "(\"k\" BIGINT NOT NULL PRIMARY KEY, \"a\".V1 VARCHAR, v2 VARCHAR)" + properties;
        String viewFullName = SchemaUtil.getEscapedTableName((String)schemaName, (String)viewName);
        String createView = "CREATE VIEW " + viewFullName + "(ID1 BIGINT, \"id2\" BIGINT NOT NULL, ID3 VARCHAR NOT NULL CONSTRAINT PKVIEW PRIMARY KEY (\"id2\", ID3 DESC)) AS SELECT * FROM " + pTableFullName + " WHERE \"k\" > 3";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(createTableStmt);
        queries.add(createView);
        String result = this.runSchemaExtractionTool("\"" + schemaName + "\"", "\"" + viewName + "\"", null, (List<String>)queries);
        Assert.assertEquals((Object)createView, (Object)result);
    }

    @Test
    public void testCreateViewStatement_customName() throws Exception {
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String viewName = SchemaToolExtractionIT.generateUniqueName() + "@@";
        String properties = "TTL=2592000,IMMUTABLE_ROWS=true,DISABLE_WAL=true";
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String createTableStmt = "CREATE TABLE " + pTableFullName + "(k BIGINT NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + properties;
        String viewFullName = SchemaUtil.getPTableFullNameWithQuotes((String)schemaName, (String)viewName);
        String createView = "CREATE VIEW " + viewFullName + "(id1 BIGINT, id2 BIGINT NOT NULL, id3 VARCHAR NOT NULL CONSTRAINT PKVIEW PRIMARY KEY (id2, id3 DESC)) AS SELECT * FROM " + pTableFullName;
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(createTableStmt);
        queries.add(createView);
        String result = this.runSchemaExtractionTool(schemaName, viewName, null, (List<String>)queries);
        Assert.assertEquals((Object)createView.toUpperCase(), (Object)result.toUpperCase());
    }

    @Test
    public void testCreateViewIndexStatement() throws Exception {
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String viewName = SchemaToolExtractionIT.generateUniqueName();
        String childView = SchemaToolExtractionIT.generateUniqueName();
        String indexName = SchemaToolExtractionIT.generateUniqueName();
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String createTableStmt = "CREATE TABLE " + pTableFullName + "(k BIGINT NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)";
        String viewFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)viewName);
        String childviewName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)childView);
        String createView = "CREATE VIEW " + viewFullName + "(id1 BIGINT, id2 BIGINT NOT NULL, id3 VARCHAR NOT NULL CONSTRAINT PKVIEW PRIMARY KEY (id2, id3 DESC)) AS SELECT * FROM " + pTableFullName;
        String createView1 = "CREATE VIEW " + childviewName + " AS SELECT * FROM " + viewFullName;
        String createIndexStatement = "CREATE INDEX " + indexName + " ON " + childviewName + "(id2, id1) INCLUDE (v1)";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(createTableStmt);
        queries.add(createView);
        queries.add(createView1);
        queries.add(createIndexStatement);
        String expected = "CREATE INDEX %s ON " + childviewName + "(ID2, ID1, K, ID3 DESC) INCLUDE (V1)";
        String result = this.runSchemaExtractionTool(schemaName, indexName, null, (List<String>)queries);
        Assert.assertEquals((Object)String.format(expected, indexName).toUpperCase(), (Object)result.toUpperCase());
        queries.clear();
        String newIndex = indexName + "_NEW";
        queries.add(String.format(expected, newIndex));
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(SchemaToolExtractionIT.getUrl(), props);){
            this.executeCreateStatements(conn, (List<String>)queries);
        }
        this.compareOrdinalPositions(indexName, newIndex);
    }

    private void compareOrdinalPositions(String table, String newTable) throws SQLException {
        String ordinalQuery = "SELECT COLUMN_NAME, ORDINAL_POSITION FROM SYSTEM.CATALOG WHERE TABLE_NAME='%s' AND ORDINAL_POSITION IS NOT NULL ORDER BY COLUMN_NAME";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        HashMap<String, Integer> ordinalMap = new HashMap<String, Integer>();
        try (Connection conn = DriverManager.getConnection(SchemaToolExtractionIT.getUrl(), props);){
            ResultSet rs = conn.createStatement().executeQuery(String.format(ordinalQuery, table));
            while (rs.next()) {
                ordinalMap.put(rs.getString(1), rs.getInt(2));
            }
            rs = conn.createStatement().executeQuery(String.format(ordinalQuery, newTable));
            while (rs.next()) {
                Assert.assertEquals((long)((Integer)ordinalMap.get(rs.getString(1))).intValue(), (long)rs.getInt(2));
            }
        }
    }

    @Test
    public void testCreateViewStatement_tenant() throws Exception {
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String viewName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String tenantId = "abc";
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String createTableStmt = "CREATE TABLE " + pTableFullName + "(k BIGINT NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)";
        String viewFullName = SchemaUtil.getPTableFullNameWithQuotes((String)schemaName, (String)viewName);
        String createViewStmt = "CREATE VIEW " + viewFullName + "(id1 BIGINT, id2 BIGINT NOT NULL, id3 VARCHAR NOT NULL CONSTRAINT PKVIEW PRIMARY KEY (id2, id3 DESC)) AS SELECT * FROM " + pTableFullName;
        ArrayList<String> queries1 = new ArrayList<String>(){};
        queries1.add(createTableStmt);
        this.runSchemaExtractionTool(schemaName, tableName, null, (List<String>)queries1);
        ArrayList<String> queries2 = new ArrayList<String>();
        queries2.add(createViewStmt);
        String result2 = this.runSchemaExtractionTool(schemaName, viewName, tenantId, queries2);
        Assert.assertEquals((Object)createViewStmt.toUpperCase(), (Object)result2.toUpperCase());
    }

    @Test
    public void testSaltedTableStatement() throws Exception {
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String query = "create table " + pTableFullName + "(a_integer integer not null CONSTRAINT pk PRIMARY KEY (a_integer)) SALT_BUCKETS=16";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(query);
        String result = this.runSchemaExtractionTool(schemaName, tableName, null, (List<String>)queries);
        Assert.assertTrue((boolean)this.getProperties(result).contains("SALT_BUCKETS=16"));
    }

    @Test
    public void testCreateTableWithPKConstraint() throws Exception {
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String query = "create table " + pTableFullName + "(a_char CHAR(15) NOT NULL, b_char CHAR(15) NOT NULL, c_bigint BIGINT NOT NULL CONSTRAINT PK PRIMARY KEY (a_char, b_char, c_bigint)) IMMUTABLE_ROWS=TRUE";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(query);
        String result = this.runSchemaExtractionTool(schemaName, tableName, null, (List<String>)queries);
        Assert.assertEquals((Object)query.toUpperCase(), (Object)result.toUpperCase());
    }

    @Test
    public void testCreateTableWithArrayColumn() throws Exception {
        String tableName;
        String pTableFullName = tableName = SchemaToolExtractionIT.generateUniqueName();
        String query = "create table " + pTableFullName + "(a_char CHAR(15) NOT NULL, b_char CHAR(10) NOT NULL, c_var_array VARCHAR ARRAY, d_char_array CHAR(15) ARRAY[3] CONSTRAINT PK PRIMARY KEY (a_char, b_char)) TTL=2592000, IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN', REPLICATION_SCOPE=1";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(query);
        String result = this.runSchemaExtractionTool("", tableName, null, (List<String>)queries);
        Assert.assertEquals((Object)query.toUpperCase(), (Object)result.toUpperCase());
    }

    @Test
    public void testCreateTableWithDefaultCFProperties() throws Exception {
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String properties = "KEEP_DELETED_CELLS=TRUE, TTL=1209600, IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN', REPLICATION_SCOPE=1, DEFAULT_COLUMN_FAMILY='cv', SALT_BUCKETS=16, MULTI_TENANT=true, TIME_TEST='72HOURS'";
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String query = "create table " + pTableFullName + "(a_char CHAR(15) NOT NULL, b_char CHAR(10) NOT NULL, \"av\".\"_\" CHAR(1), \"bv\".\"_\" CHAR(1), \"cv\".\"_\" CHAR(1), \"dv\".\"_\" CHAR(1) CONSTRAINT PK PRIMARY KEY (a_char, b_char)) " + properties;
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(query);
        String result = this.runSchemaExtractionTool(schemaName, tableName, null, (List<String>)queries);
        Assert.assertTrue((boolean)this.compareProperties(properties, this.getProperties(result)));
    }

    @Test
    public void testCreateTableWithCFProperties() throws Exception {
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String properties = "\"av\".VERSIONS=2, \"bv\".VERSIONS=2, DATA_BLOCK_ENCODING='DIFF', IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN', SALT_BUCKETS=16, MULTI_TENANT=true";
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String query = "create table " + pTableFullName + "(a_char CHAR(15) NOT NULL, b_char CHAR(10) NOT NULL, \"av\".\"_\" CHAR(1), \"bv\".\"_\" CHAR(1), \"cv\".\"_\" CHAR(1) CONSTRAINT PK PRIMARY KEY (a_char, b_char)) " + properties;
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(query);
        String result = this.runSchemaExtractionTool(schemaName, tableName, null, (List<String>)queries);
        Assert.assertTrue((boolean)this.compareProperties(properties, this.getProperties(result)));
    }

    @Test
    public void testCreateTableWithMultipleCF() throws Exception {
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String properties = "\"av\".VERSIONS=2, \"bv\".VERSIONS=3, \"cv\".VERSIONS=4, DATA_BLOCK_ENCODING='DIFF', IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN', SALT_BUCKETS=16, MULTI_TENANT=true";
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String query = "create table " + pTableFullName + "(a_char CHAR(15) NOT NULL, b_char CHAR(10) NOT NULL, \"av\".\"_\" CHAR(1), \"bv\".\"_\" CHAR(1), \"cv\".\"_\" CHAR(1), \"dv\".\"_\" CHAR(1) CONSTRAINT PK PRIMARY KEY (a_char, b_char)) " + properties;
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(query);
        String result = this.runSchemaExtractionTool(schemaName, tableName, null, (List<String>)queries);
        Assert.assertTrue((boolean)this.compareProperties(properties, this.getProperties(result)));
    }

    @Test
    public void testCreateTableWithMultipleCFProperties() throws Exception {
        String tableName = "07" + SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String properties = "\"av\".DATA_BLOCK_ENCODING='DIFF', \"bv\".DATA_BLOCK_ENCODING='DIFF', \"cv\".DATA_BLOCK_ENCODING='DIFF', IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN', SALT_BUCKETS=16, MULTI_TENANT=true, BLOOMFITER='ROW'";
        String simplifiedProperties = "DATA_BLOCK_ENCODING='DIFF', IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN', SALT_BUCKETS=16, MULTI_TENANT=true, BLOOMFITER='ROW'";
        String query = "create table " + schemaName + ".\"" + tableName + "\"(a_char CHAR(15) NOT NULL, b_char CHAR(10) NOT NULL, \"av\".\"_\" CHAR(1), \"bv\".\"_\" CHAR(1), \"cv\".\"_\" CHAR(1) CONSTRAINT PK PRIMARY KEY (a_char, b_char)) " + properties;
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(query);
        String result = this.runSchemaExtractionTool(schemaName, tableName, null, (List<String>)queries);
        try {
            new SQLParser(result).parseStatement();
        }
        catch (ParseException pe) {
            TestCase.fail((String)"This should not happen!");
        }
        Assert.assertTrue((boolean)this.compareProperties(simplifiedProperties, this.getProperties(result)));
    }

    @Test
    public void testColumnAndPKOrdering() throws Exception {
        String table = "CREATE TABLE IF NOT EXISTS MY_SCHEMA.MY_DATA_TABLE (\n    ORGANIZATION_ID CHAR(15) NOT NULL, \n    KEY_PREFIX CHAR(3) NOT NULL,\n    CREATED_DATE DATE,\n    CREATED_BY CHAR(15) \n    CONSTRAINT PK PRIMARY KEY (\n        ORGANIZATION_ID, \n        KEY_PREFIX\n    )\n) VERSIONS=1, IMMUTABLE_ROWS=true, MULTI_TENANT=true, REPLICATION_SCOPE=1";
        String view = "CREATE VIEW IF NOT EXISTS MY_SCHEMA.MY_DATA_VIEW  (\n    DATE_TIME1 DATE NOT NULL,\n    TEXT1 VARCHAR NOT NULL,\n    INT1 BIGINT NOT NULL,\n    DOUBLE1 DECIMAL(12, 3),\n    DOUBLE2 DECIMAL(12, 3),\n    DOUBLE3 DECIMAL(12, 3),\n    CONSTRAINT PKVIEW PRIMARY KEY\n    (\n        DATE_TIME1, TEXT1, INT1\n    )\n)\nAS SELECT * FROM MY_SCHEMA.MY_DATA_TABLE WHERE KEY_PREFIX = '9Yj'";
        String index = "CREATE INDEX IF NOT EXISTS MY_VIEW_INDEX\nON MY_SCHEMA.MY_DATA_VIEW (TEXT1, DATE_TIME1 DESC, DOUBLE1)\nINCLUDE (CREATED_BY, CREATED_DATE)";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(table);
        queries.add(view);
        queries.add(index);
        String expectedIndex = "CREATE INDEX MY_VIEW_INDEX ON MY_SCHEMA.MY_DATA_VIEW(TEXT1, DATE_TIME1 DESC, DOUBLE1, INT1) INCLUDE (CREATED_BY, CREATED_DATE)";
        String result = this.runSchemaExtractionTool("MY_SCHEMA", "MY_VIEW_INDEX", null, (List<String>)queries);
        Assert.assertEquals((Object)expectedIndex.toUpperCase(), (Object)result.toUpperCase());
        String expectedView = "CREATE VIEW MY_SCHEMA.MY_DATA_VIEW(DATE_TIME1 DATE NOT NULL, TEXT1 VARCHAR NOT NULL, INT1 BIGINT NOT NULL, DOUBLE1 DECIMAL(12,3), DOUBLE2 DECIMAL(12,3), DOUBLE3 DECIMAL(12,3) CONSTRAINT PKVIEW PRIMARY KEY (DATE_TIME1, TEXT1, INT1)) AS SELECT * FROM MY_SCHEMA.MY_DATA_TABLE WHERE KEY_PREFIX = '9YJ'";
        result = this.runSchemaExtractionTool("MY_SCHEMA", "MY_DATA_VIEW", null, new ArrayList<String>());
        Assert.assertEquals((Object)expectedView.toUpperCase(), (Object)result.toUpperCase());
    }

    @Test
    public void testColumnAndPKOrdering_nonView() throws Exception {
        String indexName = "MY_DATA_TABLE_INDEX";
        String table = "CREATE TABLE MY_SCHEMA.MY_SAMPLE_DATA_TABLE(ORGANIZATION_ID CHAR(15) NOT NULL, SOME_ID_COLUMN CHAR(3) NOT NULL, SOME_ID_COLUMN_2 CHAR(15) NOT NULL, CREATED_DATE DATE NOT NULL, SOME_ID_COLUMN_3 CHAR(15) NOT NULL, SOME_ID_COLUMN_4 CHAR(15), CREATED_BY_ID VARCHAR, VALUE_FIELD VARCHAR CONSTRAINT PK PRIMARY KEY (ORGANIZATION_ID, SOME_ID_COLUMN, SOME_ID_COLUMN_2, CREATED_DATE DESC, SOME_ID_COLUMN_3)) IMMUTABLE_ROWS=true, IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN', MULTI_TENANT=true, REPLICATION_SCOPE=1\n";
        String index = "CREATE INDEX IF NOT EXISTS MY_DATA_TABLE_INDEX\n ON MY_SCHEMA.MY_SAMPLE_DATA_TABLE (SOME_ID_COLUMN, CREATED_DATE DESC, SOME_ID_COLUMN_2, SOME_ID_COLUMN_3)\n INCLUDE\n(SOME_ID_COLUMN_4, CREATED_BY_ID, VALUE_FIELD)\n";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(table);
        queries.add(index);
        String result = this.runSchemaExtractionTool("MY_SCHEMA", "MY_DATA_TABLE_INDEX", null, (List<String>)queries);
        String expected = "CREATE INDEX %s ON MY_SCHEMA.MY_SAMPLE_DATA_TABLE(SOME_ID_COLUMN, CREATED_DATE DESC, SOME_ID_COLUMN_2, SOME_ID_COLUMN_3) INCLUDE (SOME_ID_COLUMN_4, CREATED_BY_ID, VALUE_FIELD)";
        Assert.assertEquals((Object)String.format(expected, indexName).toUpperCase(), (Object)result.toUpperCase());
        queries.clear();
        String newIndex = indexName + "_NEW";
        queries.add(String.format(expected, newIndex));
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(SchemaToolExtractionIT.getUrl(), props);){
            this.executeCreateStatements(conn, (List<String>)queries);
        }
        this.compareOrdinalPositions(indexName, newIndex);
    }

    @Test
    public void testCreateIndexStatementWithColumnFamily() throws Exception {
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String indexName = SchemaToolExtractionIT.generateUniqueName();
        String pTableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String createTableStmt = "CREATE TABLE " + pTableFullName + "(k VARCHAR NOT NULL PRIMARY KEY, \"av\".\"_\" CHAR(1), v2 VARCHAR)";
        String createIndexStmt = "CREATE INDEX " + indexName + " ON " + pTableFullName + "(\"av\".\"_\")";
        ArrayList<String> queries = new ArrayList<String>(){};
        queries.add(createTableStmt);
        queries.add(createIndexStmt);
        String expected = "CREATE INDEX %s ON " + pTableFullName + "(\"av\".\"_\", K)";
        String result = this.runSchemaExtractionTool(schemaName, indexName, null, (List<String>)queries);
        Assert.assertEquals((Object)String.format(expected, indexName).toUpperCase(), (Object)result.toUpperCase());
        queries.clear();
        String newIndex = indexName + "_NEW";
        queries.add(String.format(expected, newIndex));
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(SchemaToolExtractionIT.getUrl(), props);){
            this.executeCreateStatements(conn, (List<String>)queries);
        }
        this.compareOrdinalPositions(indexName, newIndex);
    }

    @Test
    public void testSaltingWithOOOPKDefinitions() throws Exception {
        String schemaName = SchemaToolExtractionIT.generateUniqueName();
        String tableName = SchemaToolExtractionIT.generateUniqueName();
        String fullTableName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String ddl = "CREATE TABLE IF NOT EXISTS " + fullTableName + "(ID1 CHAR(15) NOT NULL,\nID2 INTEGER NOT NULL,\nTEXT VARCHAR,\nINT INTEGER,\nDOUBLE DECIMAL(12,3),\nCREATED_DATE DATE NOT NULL,\nTS TIMESTAMP\nCONSTRAINT PK PRIMARY KEY (ID1, ID2, CREATED_DATE))\nSALT_BUCKETS=16,MULTI_TENANT=true";
        ArrayList<String> queries = new ArrayList<String>();
        queries.add(ddl);
        String result = this.runSchemaExtractionTool(schemaName, tableName, null, queries);
        String expected = "CREATE TABLE %s(ID1 CHAR(15) NOT NULL, ID2 INTEGER NOT NULL, TEXT VARCHAR, INT INTEGER, DOUBLE DECIMAL(12,3), CREATED_DATE DATE NOT NULL, TS TIMESTAMP CONSTRAINT PK PRIMARY KEY (ID1, ID2, CREATED_DATE)) IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN', SALT_BUCKETS=16, MULTI_TENANT=true";
        Assert.assertEquals((Object)String.format(expected, fullTableName), (Object)result);
    }

    private Connection getTenantConnection(String url, String tenantId) throws SQLException {
        Properties props = new Properties();
        props.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(url, props);
    }

    private String runSchemaExtractionTool(String schemaName, String tableName, String tenantId, List<String> queries) throws Exception {
        String output;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        if (tenantId == null) {
            try (Connection conn = DriverManager.getConnection(SchemaToolExtractionIT.getUrl(), props);){
                this.executeCreateStatements(conn, queries);
                String[] args = new String[]{"-m", "EXTRACT", "-tb", tableName, "-s", schemaName};
                output = SchemaToolExtractionIT.runSchemaTool(conn, args);
            }
        }
        try (Connection conn = this.getTenantConnection(SchemaToolExtractionIT.getUrl(), tenantId);){
            this.executeCreateStatements(conn, queries);
            String[] args = new String[]{"-m", "EXTRACT", "-tb", tableName, "-s", schemaName, "-t", tenantId};
            output = SchemaToolExtractionIT.runSchemaTool(conn, args);
        }
        return output;
    }

    private void executeCreateStatements(Connection conn, List<String> queries) throws SQLException {
        for (String query : queries) {
            conn.createStatement().execute(query);
        }
        conn.commit();
    }

    public static String runSchemaTool(Connection conn, String[] args) throws Exception {
        int ret;
        SchemaTool set = new SchemaTool();
        if (conn != null) {
            set.setConf(conn.unwrap(PhoenixConnection.class).getQueryServices().getConfiguration());
        }
        if ((ret = set.run(args)) != 0) {
            throw new RuntimeException(String.format("Schema tool failed with error %d", ret));
        }
        return set.getOutput();
    }

    private String getProperties(String query) {
        return query.substring(query.lastIndexOf(")") + 1);
    }

    private boolean compareProperties(String prop1, String prop2) {
        String[] propArray1 = prop1.toUpperCase().replaceAll("\\s+", "").split(",");
        String[] propArray2 = prop2.toUpperCase().replaceAll("\\s+", "").split(",");
        HashSet<String> set1 = new HashSet<String>(Arrays.asList(propArray1));
        HashSet<String> set2 = new HashSet<String>(Arrays.asList(propArray2));
        return set1.equals(set2);
    }
}

