/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.stats.StatisticsCollectionRunTracker;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsScanner;
import org.apache.phoenix.schema.stats.StatisticsWriter;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class StatisticsScannerTest {
    private Region region;
    private RegionServerServices rsServices;
    private StatisticsWriter statsWriter;
    private StatisticsScanner.StatisticsScannerCallable callable;
    private StatisticsCollectionRunTracker runTracker;
    private StatisticsScanner mockScanner;
    private StatisticsCollector tracker;
    private InternalScanner delegate;
    private RegionInfo regionInfo;
    private Configuration config;
    private RegionCoprocessorEnvironment env;
    private Connection conn;

    @Before
    public void setupMocks() throws Exception {
        this.config = new Configuration(false);
        this.region = (Region)Mockito.mock(Region.class);
        this.rsServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        this.statsWriter = (StatisticsWriter)Mockito.mock(StatisticsWriter.class);
        this.callable = (StatisticsScanner.StatisticsScannerCallable)Mockito.mock(StatisticsScanner.StatisticsScannerCallable.class);
        this.runTracker = (StatisticsCollectionRunTracker)Mockito.mock(StatisticsCollectionRunTracker.class);
        this.mockScanner = (StatisticsScanner)Mockito.mock(StatisticsScanner.class);
        this.tracker = (StatisticsCollector)Mockito.mock(StatisticsCollector.class);
        this.delegate = (InternalScanner)Mockito.mock(InternalScanner.class);
        this.regionInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        this.env = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class);
        this.conn = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.mockScanner.getStatisticsWriter()).thenReturn((Object)this.statsWriter);
        Mockito.when((Object)this.mockScanner.createCallable()).thenReturn((Object)this.callable);
        Mockito.when((Object)this.mockScanner.getStatsCollectionRunTracker((Configuration)ArgumentMatchers.any())).thenReturn((Object)this.runTracker);
        Mockito.when((Object)this.mockScanner.getRegion()).thenReturn((Object)this.region);
        Mockito.when((Object)this.mockScanner.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.mockScanner.getTracker()).thenReturn((Object)this.tracker);
        Mockito.when((Object)this.mockScanner.getDelegate()).thenReturn((Object)this.delegate);
        Mockito.when((Object)this.env.getConnection()).thenReturn((Object)this.conn);
        Mockito.when((Object)this.mockScanner.getConnection()).thenReturn((Object)this.conn);
        Mockito.when((Object)this.region.getRegionInfo()).thenReturn((Object)this.regionInfo);
        ((StatisticsScanner)Mockito.doCallRealMethod().when((Object)this.mockScanner)).close();
    }

    @Test
    public void testCheckRegionServerStoppingOnClose() throws Exception {
        Mockito.when((Object)this.conn.isClosed()).thenReturn((Object)true);
        Mockito.when((Object)this.conn.isAborted()).thenReturn((Object)false);
        this.mockScanner.close();
        ((Connection)Mockito.verify((Object)this.conn)).isClosed();
        ((StatisticsScanner.StatisticsScannerCallable)Mockito.verify((Object)this.callable, (VerificationMode)Mockito.never())).call();
        ((StatisticsCollectionRunTracker)Mockito.verify((Object)this.runTracker, (VerificationMode)Mockito.never())).runTask((Callable)this.callable);
    }

    @Test
    public void testCheckRegionServerStoppedOnClose() throws Exception {
        Mockito.when((Object)this.conn.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.conn.isAborted()).thenReturn((Object)true);
        this.mockScanner.close();
        ((Connection)Mockito.verify((Object)this.conn)).isClosed();
        ((Connection)Mockito.verify((Object)this.conn)).isAborted();
        ((StatisticsScanner.StatisticsScannerCallable)Mockito.verify((Object)this.callable, (VerificationMode)Mockito.never())).call();
        ((StatisticsCollectionRunTracker)Mockito.verify((Object)this.runTracker, (VerificationMode)Mockito.never())).runTask((Callable)this.callable);
    }

    @Test
    public void testCheckRegionServerStoppingOnException() throws Exception {
        StatisticsScanner.StatisticsScannerCallable realCallable = new StatisticsScanner.StatisticsScannerCallable(this.mockScanner);
        ((StatisticsWriter)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.statsWriter)).deleteStatsForRegion((Region)ArgumentMatchers.any(), (StatisticsCollector)ArgumentMatchers.any(), (ImmutableBytesPtr)ArgumentMatchers.any(), (List)ArgumentMatchers.any());
        Mockito.when((Object)this.conn.isClosed()).thenReturn((Object)true);
        Mockito.when((Object)this.conn.isAborted()).thenReturn((Object)false);
        realCallable.call();
        ((Connection)Mockito.verify((Object)this.conn)).isClosed();
    }

    @Test
    public void testCheckRegionServerStoppedOnException() throws Exception {
        StatisticsScanner.StatisticsScannerCallable realCallable = new StatisticsScanner.StatisticsScannerCallable(this.mockScanner);
        ((StatisticsWriter)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.statsWriter)).deleteStatsForRegion((Region)ArgumentMatchers.any(), (StatisticsCollector)ArgumentMatchers.any(), (ImmutableBytesPtr)ArgumentMatchers.any(), (List)ArgumentMatchers.any());
        Mockito.when((Object)this.conn.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.conn.isAborted()).thenReturn((Object)true);
        realCallable.call();
        ((Connection)Mockito.verify((Object)this.conn)).isClosed();
        ((Connection)Mockito.verify((Object)this.conn)).isAborted();
    }
}

