/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.schema.stats.BaseStatsCollectorIT;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
public class NamespaceEnabledStatsCollectorIT
extends BaseStatsCollectorIT {
    public NamespaceEnabledStatsCollectorIT(boolean userTableNamespaceMapped, boolean collectStatsOnSnapshot) {
        super(userTableNamespaceMapped, collectStatsOnSnapshot);
    }

    @Parameterized.Parameters(name="userTableNamespaceMapped={0},collectStatsOnSnapshot={1}")
    public static Collection<Object[]> provideData() {
        return Arrays.asList({true, true}, {true, false});
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)7);
        serverProps.put("phoenix.schema.isNamespaceMappingEnabled", Boolean.TRUE.toString());
        serverProps.put("phoenix.stats.guidepost.width", Long.toString(20L));
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("phoenix.schema.isNamespaceMappingEnabled", Boolean.TRUE.toString());
        clientProps.put("phoenix.stats.guidepost.width", Long.toString(20L));
        NamespaceEnabledStatsCollectorIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }
}

