/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.phoenix.schema.SequenceAllocation;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class SequenceAllocationTest {
    @Test
    public void testSortingSequenceAllocation() {
        SequenceKey sequenceKey1 = new SequenceKey(null, "seqalloc", "sequenceC", 0);
        SequenceKey sequenceKey2 = new SequenceKey(null, "seqalloc", "sequenceB", 0);
        SequenceKey sequenceKey3 = new SequenceKey(null, "seqalloc", "sequenceA", 0);
        ArrayList sequenceKeys = Lists.newArrayList((Object[])new SequenceKey[]{sequenceKey1, sequenceKey2, sequenceKey3});
        ArrayList sequenceAllocations = Lists.newArrayList((Object[])new SequenceAllocation[]{new SequenceAllocation(sequenceKey2, 1L), new SequenceAllocation(sequenceKey1, 1L), new SequenceAllocation(sequenceKey3, 1L)});
        Collections.sort(sequenceKeys);
        Collections.sort(sequenceAllocations);
        int i = 0;
        for (SequenceKey sequenceKey : sequenceKeys) {
            Assert.assertEquals((Object)sequenceKey, (Object)((SequenceAllocation)sequenceAllocations.get(i)).getSequenceKey());
            ++i;
        }
    }

    @Test
    public void testSortingSequenceAllocationPreservesAllocations() {
        SequenceKey sequenceKeyC = new SequenceKey(null, "seqalloc", "sequenceC", 0);
        SequenceKey sequenceKeyB = new SequenceKey(null, "seqalloc", "sequenceB", 0);
        SequenceKey sequenceKeyA = new SequenceKey(null, "seqalloc", "sequenceA", 0);
        ArrayList sequenceAllocations = Lists.newArrayList((Object[])new SequenceAllocation[]{new SequenceAllocation(sequenceKeyB, 15L), new SequenceAllocation(sequenceKeyC, 11L), new SequenceAllocation(sequenceKeyA, 1000L)});
        Collections.sort(sequenceAllocations);
        Assert.assertEquals((Object)"sequenceA", (Object)((SequenceAllocation)sequenceAllocations.get(0)).getSequenceKey().getSequenceName());
        Assert.assertEquals((long)1000L, (long)((SequenceAllocation)sequenceAllocations.get(0)).getNumAllocations());
        Assert.assertEquals((long)15L, (long)((SequenceAllocation)sequenceAllocations.get(1)).getNumAllocations());
        Assert.assertEquals((long)11L, (long)((SequenceAllocation)sequenceAllocations.get(2)).getNumAllocations());
    }
}

