/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;

public class RowKeyValueAccessorTest
extends BaseConnectionlessQueryTest {
    private void assertExpectedRowKeyValue(String dataColumns, String pk, Object[] values, int index) throws Exception {
        this.assertExpectedRowKeyValue(dataColumns, pk, values, index, "");
    }

    private void assertExpectedRowKeyValue(String dataColumns, String pk, Object[] values, int index, String dataProps) throws Exception {
        String schemaName = "";
        String tableName = "T";
        Connection conn = DriverManager.getConnection(RowKeyValueAccessorTest.getUrl());
        String fullTableName = SchemaUtil.getTableName((String)SchemaUtil.normalizeIdentifier((String)schemaName), (String)SchemaUtil.normalizeIdentifier((String)tableName));
        conn.createStatement().execute("CREATE TABLE " + fullTableName + "(" + dataColumns + " CONSTRAINT pk PRIMARY KEY (" + pk + "))  " + (dataProps.isEmpty() ? "" : dataProps));
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable table = pconn.getTable(new PTableKey(pconn.getTenantId(), fullTableName));
        StringBuilder buf = new StringBuilder("UPSERT INTO " + fullTableName + " VALUES(");
        for (int i = 0; i < values.length; ++i) {
            buf.append("?,");
        }
        buf.setCharAt(buf.length() - 1, ')');
        PreparedStatement stmt = conn.prepareStatement(buf.toString());
        for (int i = 0; i < values.length; ++i) {
            stmt.setObject(i + 1, values[i]);
        }
        stmt.execute();
        Iterator iterator = PhoenixRuntime.getUncommittedDataIterator((Connection)conn);
        List dataKeyValues = (List)((Pair)iterator.next()).getSecond();
        KeyValue keyValue = PhoenixKeyValueUtil.maybeCopyCell((Cell)((Cell)dataKeyValues.get(0)));
        List pkColumns = table.getPKColumns();
        RowKeyValueAccessor accessor = new RowKeyValueAccessor(pkColumns, 3);
        int offset = accessor.getOffset(keyValue.getRowArray(), keyValue.getRowOffset());
        int length = accessor.getLength(keyValue.getRowArray(), offset, keyValue.getOffset() + keyValue.getLength(), null, null);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(keyValue.getRowArray(), offset, length);
        PDataType dataType = ((PColumn)pkColumns.get(index)).getDataType();
        Object expectedObject = dataType.toObject(values[index], PDataType.fromLiteral((Object)values[index]));
        dataType.coerceBytes(ptr, dataType, ((PColumn)pkColumns.get(index)).getSortOrder(), SortOrder.getDefault());
        Object actualObject = dataType.toObject(ptr);
        Assert.assertEquals((Object)expectedObject, (Object)actualObject);
        conn.close();
    }

    @Test
    public void testFixedLengthValueAtEnd() throws Exception {
        this.assertExpectedRowKeyValue("n VARCHAR NOT NULL, s CHAR(1) NOT NULL, y SMALLINT NOT NULL, o BIGINT NOT NULL", "n,s,y DESC,o DESC", new Object[]{"Abbey", "F", 2012, 253}, 3);
    }
}

