/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PMetaDataImpl;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.SchemaNotFoundException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TimeKeeper;
import org.junit.Assert;
import org.junit.Test;

public class PMetaDataImplTest {
    private static void addToTable(PMetaData metaData, String name, int size, TestTimeKeeper timeKeeper) throws SQLException {
        PSizedTable table = new PSizedTable(new PTableKey(null, name), size);
        metaData.addTable((PTable)table, System.currentTimeMillis());
        timeKeeper.incrementTime();
    }

    private static void removeFromTable(PMetaData metaData, String name, TestTimeKeeper timeKeeper) throws SQLException {
        metaData.removeTable(null, name, null, Long.MAX_VALUE);
        timeKeeper.incrementTime();
    }

    private static PTable getFromTable(PMetaData metaData, String name, TestTimeKeeper timeKeeper) throws TableNotFoundException {
        PTable table = metaData.getTableRef(new PTableKey(null, name)).getTable();
        timeKeeper.incrementTime();
        return table;
    }

    private static void assertNames(PMetaData metaData, String ... names) {
        HashSet actualTables = Sets.newHashSet();
        for (PTable table : metaData) {
            actualTables.add(table.getKey().getName());
        }
        HashSet expectedTables = Sets.newHashSet((Object[])names);
        Assert.assertEquals((Object)expectedTables, (Object)actualTables);
    }

    @Test
    public void testEviction() throws Exception {
        TestTimeKeeper timeKeeper = new TestTimeKeeper();
        HashMap props = Maps.newHashMapWithExpectedSize((int)2);
        props.put("phoenix.client.maxMetaDataCacheSize", "10");
        props.put("phoenix.table.client.cache.encoding", "object");
        PMetaDataImpl metaData = new PMetaDataImpl(5, Long.MAX_VALUE, (TimeKeeper)timeKeeper, new ReadOnlyProps((Map)props));
        PMetaDataImplTest.addToTable((PMetaData)metaData, "a", 5, timeKeeper);
        Assert.assertEquals((long)1L, (long)metaData.size());
        PMetaDataImplTest.addToTable((PMetaData)metaData, "b", 4, timeKeeper);
        Assert.assertEquals((long)2L, (long)metaData.size());
        PMetaDataImplTest.addToTable((PMetaData)metaData, "c", 3, timeKeeper);
        Assert.assertEquals((long)2L, (long)metaData.size());
        PMetaDataImplTest.assertNames((PMetaData)metaData, "b", "c");
        PMetaDataImplTest.addToTable((PMetaData)metaData, "b", 8, timeKeeper);
        Assert.assertEquals((long)1L, (long)metaData.size());
        PMetaDataImplTest.assertNames((PMetaData)metaData, "b");
        PMetaDataImplTest.addToTable((PMetaData)metaData, "d", 11, timeKeeper);
        Assert.assertEquals((long)1L, (long)metaData.size());
        PMetaDataImplTest.assertNames((PMetaData)metaData, "b");
        PMetaDataImplTest.removeFromTable((PMetaData)metaData, "b", timeKeeper);
        PMetaDataImplTest.assertNames((PMetaData)metaData, new String[0]);
        PMetaDataImplTest.addToTable((PMetaData)metaData, "a", 4, timeKeeper);
        Assert.assertEquals((long)1L, (long)metaData.size());
        PMetaDataImplTest.addToTable((PMetaData)metaData, "b", 3, timeKeeper);
        Assert.assertEquals((long)2L, (long)metaData.size());
        PMetaDataImplTest.addToTable((PMetaData)metaData, "c", 2, timeKeeper);
        Assert.assertEquals((long)3L, (long)metaData.size());
        PMetaDataImplTest.assertNames((PMetaData)metaData, "a", "b", "c");
        PMetaDataImplTest.getFromTable((PMetaData)metaData, "a", timeKeeper);
        PMetaDataImplTest.addToTable((PMetaData)metaData, "d", 3, timeKeeper);
        Assert.assertEquals((long)3L, (long)metaData.size());
        PMetaDataImplTest.assertNames((PMetaData)metaData, "c", "a", "d");
    }

    @Test
    public void shouldNotEvictMoreEntriesThanNecessary() throws Exception {
        TestTimeKeeper timeKeeper = new TestTimeKeeper();
        HashMap props = Maps.newHashMapWithExpectedSize((int)2);
        props.put("phoenix.client.maxMetaDataCacheSize", "5");
        props.put("phoenix.table.client.cache.encoding", "object");
        PMetaDataImpl metaData = new PMetaDataImpl(5, Long.MAX_VALUE, (TimeKeeper)timeKeeper, new ReadOnlyProps((Map)props));
        PMetaDataImplTest.addToTable((PMetaData)metaData, "a", 1, timeKeeper);
        Assert.assertEquals((long)1L, (long)metaData.size());
        PMetaDataImplTest.addToTable((PMetaData)metaData, "b", 1, timeKeeper);
        Assert.assertEquals((long)2L, (long)metaData.size());
        PMetaDataImplTest.assertNames((PMetaData)metaData, "a", "b");
        PMetaDataImplTest.addToTable((PMetaData)metaData, "c", 3, timeKeeper);
        Assert.assertEquals((long)3L, (long)metaData.size());
        PMetaDataImplTest.assertNames((PMetaData)metaData, "a", "b", "c");
        PMetaDataImplTest.getFromTable((PMetaData)metaData, "a", timeKeeper);
        PMetaDataImplTest.getFromTable((PMetaData)metaData, "b", timeKeeper);
        PMetaDataImplTest.addToTable((PMetaData)metaData, "d", 3, timeKeeper);
        Assert.assertEquals((long)3L, (long)metaData.size());
        PMetaDataImplTest.assertNames((PMetaData)metaData, "a", "b", "d");
    }

    @Test
    public void shouldAlwaysKeepAtLeastOneEntryEvenIfTooLarge() throws Exception {
        TestTimeKeeper timeKeeper = new TestTimeKeeper();
        HashMap props = Maps.newHashMapWithExpectedSize((int)2);
        props.put("phoenix.client.maxMetaDataCacheSize", "5");
        props.put("phoenix.table.client.cache.encoding", "object");
        PMetaDataImpl metaData = new PMetaDataImpl(5, Long.MAX_VALUE, (TimeKeeper)timeKeeper, new ReadOnlyProps((Map)props));
        PMetaDataImplTest.addToTable((PMetaData)metaData, "a", 1, timeKeeper);
        Assert.assertEquals((long)1L, (long)metaData.size());
        PMetaDataImplTest.addToTable((PMetaData)metaData, "b", 1, timeKeeper);
        Assert.assertEquals((long)2L, (long)metaData.size());
        PMetaDataImplTest.addToTable((PMetaData)metaData, "c", 5, timeKeeper);
        Assert.assertEquals((long)1L, (long)metaData.size());
        PMetaDataImplTest.addToTable((PMetaData)metaData, "d", 20, timeKeeper);
        Assert.assertEquals((long)1L, (long)metaData.size());
        PMetaDataImplTest.assertNames((PMetaData)metaData, "c");
        PMetaDataImplTest.addToTable((PMetaData)metaData, "e", 1, timeKeeper);
        Assert.assertEquals((long)1L, (long)metaData.size());
        PMetaDataImplTest.addToTable((PMetaData)metaData, "f", 2, timeKeeper);
        Assert.assertEquals((long)2L, (long)metaData.size());
        PMetaDataImplTest.assertNames((PMetaData)metaData, "e", "f");
    }

    @Test
    public void testAge() throws Exception {
        TestTimeKeeper timeKeeper = new TestTimeKeeper();
        HashMap props = Maps.newHashMapWithExpectedSize((int)2);
        props.put("phoenix.client.maxMetaDataCacheSize", "10");
        props.put("phoenix.table.client.cache.encoding", "object");
        PMetaDataImpl metaData = new PMetaDataImpl(5, Long.MAX_VALUE, (TimeKeeper)timeKeeper, new ReadOnlyProps((Map)props));
        String tableName = "a";
        PMetaDataImplTest.addToTable((PMetaData)metaData, tableName, 1, timeKeeper);
        PTableRef aTableRef = metaData.getTableRef(new PTableKey(null, tableName));
        Assert.assertNotNull((Object)aTableRef);
        Assert.assertEquals((long)1L, (long)metaData.getAge(aTableRef));
        tableName = "b";
        PMetaDataImplTest.addToTable((PMetaData)metaData, tableName, 1, timeKeeper);
        PTableRef bTableRef = metaData.getTableRef(new PTableKey(null, tableName));
        Assert.assertNotNull((Object)bTableRef);
        Assert.assertEquals((long)1L, (long)metaData.getAge(bTableRef));
        Assert.assertEquals((long)2L, (long)metaData.getAge(aTableRef));
    }

    @Test
    public void testSchema() throws Exception {
        TestTimeKeeper timeKeeper = new TestTimeKeeper();
        PMetaDataImpl metaData = new PMetaDataImpl(5, Long.MAX_VALUE, (TimeKeeper)timeKeeper, new ReadOnlyProps(Collections.EMPTY_MAP));
        PSchema schema = new PSchema("testSchema");
        metaData.addSchema(schema);
        Assert.assertEquals((Object)schema, (Object)metaData.getSchema(schema.getSchemaKey()));
        metaData.removeSchema(schema, schema.getTimeStamp());
        try {
            metaData.getSchema(schema.getSchemaKey());
            Assert.fail((String)"the schema should be removed");
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            // empty catch block
        }
    }

    private static class PSizedTable
    extends PTableImpl {
        private final int size;
        private final PTableKey key;

        public PSizedTable(PTableKey key, int size) {
            this.key = key;
            this.size = size;
        }

        public int getEstimatedSize() {
            return this.size;
        }

        public PTableKey getKey() {
            return this.key;
        }
    }

    private static class TestTimeKeeper
    implements TimeKeeper {
        private long time = 0L;

        private TestTimeKeeper() {
        }

        public long getCurrentTime() {
            return this.time;
        }

        public void incrementTime() {
            ++this.time;
        }
    }
}

