/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.junit.Assert;
import org.junit.Test;

public class PCharPadTest {
    public void test(String value, PDataType dataType, int length, SortOrder sortOrder, byte[] result) throws SQLException {
        LiteralExpression expr = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)sortOrder);
        ImmutableBytesPtr ptr = new ImmutableBytesPtr(expr.getBytes());
        dataType.pad((ImmutableBytesWritable)ptr, Integer.valueOf(length), sortOrder);
        String resultValue = (String)dataType.toObject((ImmutableBytesWritable)ptr, dataType, sortOrder);
        Assert.assertTrue((boolean)Arrays.equals(result, ptr.get()));
        Assert.assertEquals((Object)value, (Object)resultValue);
    }

    @Test
    public void testCharPaddingAsc1() throws SQLException {
        PChar dataType = PChar.INSTANCE;
        String str = "hellow";
        byte[] result = new byte[]{104, 101, 108, 108, 111, 119, 32, 32, 32, 32};
        this.test(str, (PDataType)dataType, 10, SortOrder.ASC, result);
    }

    @Test
    public void testCharPaddingAsc2() throws SQLException {
        PChar dataType = PChar.INSTANCE;
        String str = "phoenix";
        byte[] result = new byte[]{112, 104, 111, 101, 110, 105, 120, 32, 32, 32, 32, 32, 32, 32};
        this.test(str, (PDataType)dataType, 14, SortOrder.ASC, result);
    }

    @Test
    public void testCharPaddingAsc3() throws SQLException {
        PChar dataType = PChar.INSTANCE;
        String str = "phoenix";
        byte[] result = new byte[]{112, 104, 111, 101, 110, 105, 120};
        this.test(str, (PDataType)dataType, 7, SortOrder.ASC, result);
    }

    @Test
    public void testCharPaddingAsc4() throws SQLException {
        PChar dataType = PChar.INSTANCE;
        String str = "hello world";
        byte[] result = new byte[]{104, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100, 32, 32, 32, 32, 32};
        this.test(str, (PDataType)dataType, 16, SortOrder.ASC, result);
    }

    @Test
    public void testCharPaddingDesc1() throws SQLException {
        PChar dataType = PChar.INSTANCE;
        String str = "hellow";
        byte[] result = new byte[]{-105, -102, -109, -109, -112, -120, -33, -33, -33, -33};
        this.test(str, (PDataType)dataType, 10, SortOrder.DESC, result);
    }

    @Test
    public void testCharPaddingDesc2() throws SQLException {
        PChar dataType = PChar.INSTANCE;
        String str = "phoenix";
        byte[] result = new byte[]{-113, -105, -112, -102, -111, -106, -121, -33, -33, -33, -33, -33, -33, -33, -33};
        this.test(str, (PDataType)dataType, 15, SortOrder.DESC, result);
    }

    @Test
    public void testCharPaddingDesc3() throws SQLException {
        PChar dataType = PChar.INSTANCE;
        String str = "phoenix";
        byte[] result = new byte[]{-113, -105, -112, -102, -111, -106, -121};
        this.test(str, (PDataType)dataType, 7, SortOrder.DESC, result);
    }

    @Test
    public void testCharPaddingDesc4() throws SQLException {
        PChar dataType = PChar.INSTANCE;
        String str = "hello world";
        byte[] result = new byte[]{-105, -102, -109, -109, -112, -33, -120, -112, -115, -109, -101, -33, -33, -33, -33, -33};
        this.test(str, (PDataType)dataType, 16, SortOrder.DESC, result);
    }

    @Test
    public void testRelativeByteArrayOrder() throws SQLException {
        Object[] inputs = new String[]{"foo", "foo!", "fooA", "foo~"};
        PChar dataType = PChar.INSTANCE;
        Arrays.sort(inputs);
        ArrayList<byte[]> ascOrderedInputs = new ArrayList<byte[]>(inputs.length);
        SortOrder sortOrder = SortOrder.ASC;
        for (Object input : inputs) {
            LiteralExpression expr = LiteralExpression.newConstant((Object)input, (PDataType)dataType, (SortOrder)sortOrder);
            ImmutableBytesPtr ptr = new ImmutableBytesPtr(expr.getBytes());
            dataType.pad((ImmutableBytesWritable)ptr, Integer.valueOf(8), sortOrder);
            ascOrderedInputs.add(ptr.copyBytes());
        }
        Collections.sort(ascOrderedInputs, Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < inputs.length; ++i) {
            byte[] bytes = (byte[])ascOrderedInputs.get(i);
            String resultValue = (String)dataType.toObject(bytes, 0, bytes.length, (PDataType)dataType, sortOrder);
            Assert.assertEquals((Object)inputs[i], (Object)resultValue);
        }
        ArrayList<byte[]> descOrderedInputs = new ArrayList<byte[]>(inputs.length);
        sortOrder = SortOrder.DESC;
        for (Object input : inputs) {
            LiteralExpression expr = LiteralExpression.newConstant((Object)input, (PDataType)dataType, (SortOrder)sortOrder);
            ImmutableBytesPtr ptr = new ImmutableBytesPtr(expr.getBytes());
            dataType.pad((ImmutableBytesWritable)ptr, Integer.valueOf(8), sortOrder);
            descOrderedInputs.add(ptr.copyBytes());
        }
        Collections.sort(descOrderedInputs, Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < inputs.length; ++i) {
            byte[] bytes = (byte[])descOrderedInputs.get(i);
            String resultValue = (String)dataType.toObject(bytes, 0, bytes.length, (PDataType)dataType, sortOrder);
            Assert.assertEquals((Object)inputs[inputs.length - 1 - i], (Object)resultValue);
        }
    }
}

