/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.DelegateExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.SingleCellConstructorExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnValueDecoder;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ImmutableStorageSchemeTest {
    protected static final LiteralExpression CONSTANT_EXPRESSION = LiteralExpression.newConstant((Object)QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
    protected static final byte[] BYTE_ARRAY1 = new byte[]{1, 2, 3, 4, 5};
    protected static final byte[] BYTE_ARRAY2 = new byte[]{6, 7, 8};
    protected Expression FALSE_EVAL_EXPRESSION = new DelegateExpression((Expression)LiteralExpression.newConstant(null)){

        public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
            return false;
        }
    };
    private PTable.ImmutableStorageScheme immutableStorageScheme;
    byte serializationVersion;

    @Parameterized.Parameters(name="ImmutableStorageSchemeTest_immutableStorageScheme={0},serializationVersion={1}}")
    public static synchronized List<Object[]> data() {
        return Arrays.asList({PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, (byte)2}, {PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, (byte)3});
    }

    public ImmutableStorageSchemeTest(PTable.ImmutableStorageScheme immutableStorageScheme, byte serializationVersion) {
        this.immutableStorageScheme = immutableStorageScheme;
        this.immutableStorageScheme.setSerializationVersion(serializationVersion);
        this.serializationVersion = serializationVersion;
    }

    @Test
    public void testWithExpressionsThatEvaluatetoFalse() throws Exception {
        ArrayList children = Lists.newArrayListWithExpectedSize((int)4);
        children.add(CONSTANT_EXPRESSION);
        children.add(this.FALSE_EVAL_EXPRESSION);
        children.add(LiteralExpression.newConstant((Object)BYTE_ARRAY1, (PDataType)PVarbinary.INSTANCE));
        children.add(this.FALSE_EVAL_EXPRESSION);
        children.add(LiteralExpression.newConstant((Object)BYTE_ARRAY2, (PDataType)PVarbinary.INSTANCE));
        ImmutableBytesPtr ptr = this.evaluate(children);
        ImmutableBytesPtr ptrCopy = new ImmutableBytesPtr(ptr);
        ColumnValueDecoder decoder = this.immutableStorageScheme.getDecoder();
        Assert.assertTrue((boolean)decoder.decode((ImmutableBytesWritable)ptrCopy, 0));
        Assert.assertArrayEquals((byte[])QueryConstants.EMPTY_COLUMN_VALUE_BYTES, (byte[])ptrCopy.copyBytesIfNecessary());
        ptrCopy = new ImmutableBytesPtr(ptr);
        Assert.assertFalse((boolean)decoder.decode((ImmutableBytesWritable)ptrCopy, 1));
        Assert.assertArrayEquals((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])ptrCopy.copyBytesIfNecessary());
        ptrCopy = new ImmutableBytesPtr(ptr);
        Assert.assertTrue((boolean)decoder.decode((ImmutableBytesWritable)ptrCopy, 2));
        Assert.assertArrayEquals((byte[])BYTE_ARRAY1, (byte[])ptrCopy.copyBytesIfNecessary());
        ptrCopy = new ImmutableBytesPtr(ptr);
        Assert.assertFalse((boolean)decoder.decode((ImmutableBytesWritable)ptrCopy, 3));
        Assert.assertArrayEquals((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])ptrCopy.copyBytesIfNecessary());
        ptrCopy = new ImmutableBytesPtr(ptr);
        Assert.assertTrue((boolean)decoder.decode((ImmutableBytesWritable)ptrCopy, 4));
        Assert.assertArrayEquals((byte[])BYTE_ARRAY2, (byte[])ptrCopy.copyBytesIfNecessary());
    }

    @Test
    public void testWithMaxOffsetLargerThanShortMax() throws Exception {
        int numElements = 32769;
        ArrayList children = Lists.newArrayListWithExpectedSize((int)numElements);
        for (int i = 0; i < numElements; ++i) {
            children.add(CONSTANT_EXPRESSION);
        }
        SingleCellConstructorExpression singleCellConstructorExpression = new SingleCellConstructorExpression(this.immutableStorageScheme, (List)children);
        ImmutableBytesPtr ptr = new ImmutableBytesPtr();
        singleCellConstructorExpression.evaluate(null, (ImmutableBytesWritable)ptr);
        ImmutableBytesPtr ptrCopy = new ImmutableBytesPtr(ptr);
        ColumnValueDecoder decoder = this.immutableStorageScheme.getDecoder();
        Assert.assertTrue((boolean)decoder.decode((ImmutableBytesWritable)ptrCopy, 0));
        Assert.assertArrayEquals((byte[])QueryConstants.EMPTY_COLUMN_VALUE_BYTES, (byte[])ptrCopy.copyBytesIfNecessary());
        ptrCopy = new ImmutableBytesPtr(ptr);
        Assert.assertTrue((boolean)decoder.decode((ImmutableBytesWritable)ptrCopy, 14999));
        Assert.assertArrayEquals((byte[])QueryConstants.EMPTY_COLUMN_VALUE_BYTES, (byte[])ptrCopy.copyBytesIfNecessary());
        ptrCopy = new ImmutableBytesPtr(ptr);
        Assert.assertTrue((boolean)decoder.decode((ImmutableBytesWritable)ptrCopy, numElements - 1));
        Assert.assertArrayEquals((byte[])QueryConstants.EMPTY_COLUMN_VALUE_BYTES, (byte[])ptrCopy.copyBytesIfNecessary());
    }

    @Test
    public void testWithMaxOffsetSmallerThanShortMin() throws Exception {
        int numElements = 32769;
        ArrayList children = Lists.newArrayListWithExpectedSize((int)numElements);
        for (int i = 0; i <= numElements; i += 2) {
            children.add(CONSTANT_EXPRESSION);
            children.add(this.FALSE_EVAL_EXPRESSION);
        }
        SingleCellConstructorExpression singleCellConstructorExpression = new SingleCellConstructorExpression(this.immutableStorageScheme, (List)children);
        ImmutableBytesPtr ptr = new ImmutableBytesPtr();
        singleCellConstructorExpression.evaluate(null, (ImmutableBytesWritable)ptr);
        ImmutableBytesPtr ptrCopy = new ImmutableBytesPtr(ptr);
        ColumnValueDecoder decoder = this.immutableStorageScheme.getDecoder();
        Assert.assertTrue((boolean)decoder.decode((ImmutableBytesWritable)ptrCopy, 0));
        Assert.assertArrayEquals((byte[])QueryConstants.EMPTY_COLUMN_VALUE_BYTES, (byte[])ptrCopy.copyBytesIfNecessary());
        ptrCopy = new ImmutableBytesPtr(ptr);
        Assert.assertFalse((boolean)decoder.decode((ImmutableBytesWritable)ptrCopy, 1));
        Assert.assertArrayEquals((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])ptrCopy.copyBytesIfNecessary());
        ptrCopy = new ImmutableBytesPtr(ptr);
        Assert.assertTrue((boolean)decoder.decode((ImmutableBytesWritable)ptrCopy, numElements - 1));
        Assert.assertArrayEquals((byte[])QueryConstants.EMPTY_COLUMN_VALUE_BYTES, (byte[])ptrCopy.copyBytesIfNecessary());
        ptrCopy = new ImmutableBytesPtr(ptr);
        Assert.assertFalse((boolean)decoder.decode((ImmutableBytesWritable)ptrCopy, numElements));
        Assert.assertArrayEquals((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])ptrCopy.copyBytesIfNecessary());
    }

    @Test
    public void testLeadingNulls() throws Exception {
        ArrayList children = Lists.newArrayListWithExpectedSize((int)4);
        LiteralExpression nullExpression = LiteralExpression.newConstant(null);
        children.add(nullExpression);
        children.add(nullExpression);
        children.add(LiteralExpression.newConstant((Object)BYTE_ARRAY1, (PDataType)PVarbinary.INSTANCE));
        children.add(LiteralExpression.newConstant((Object)BYTE_ARRAY2, (PDataType)PVarbinary.INSTANCE));
        ImmutableBytesPtr ptr = this.evaluate(children);
        this.assertDecodedContents(ptr, ByteUtil.EMPTY_BYTE_ARRAY, ByteUtil.EMPTY_BYTE_ARRAY, BYTE_ARRAY1, BYTE_ARRAY2);
    }

    @Test
    public void testTrailingNulls() throws Exception {
        ArrayList children = Lists.newArrayListWithExpectedSize((int)4);
        LiteralExpression nullExpression = LiteralExpression.newConstant(null);
        children.add(LiteralExpression.newConstant((Object)BYTE_ARRAY1, (PDataType)PVarbinary.INSTANCE));
        children.add(LiteralExpression.newConstant((Object)BYTE_ARRAY2, (PDataType)PVarbinary.INSTANCE));
        children.add(nullExpression);
        children.add(nullExpression);
        ImmutableBytesPtr ptr = this.evaluate(children);
        this.assertDecodedContents(ptr, BYTE_ARRAY1, BYTE_ARRAY2, ByteUtil.EMPTY_BYTE_ARRAY, ByteUtil.EMPTY_BYTE_ARRAY);
    }

    @Test
    public void testManyNulls() throws Exception {
        ArrayList children = Lists.newArrayListWithExpectedSize((int)4);
        LiteralExpression nullExpression = LiteralExpression.newConstant(null);
        byte[][] testData = new byte[300][];
        children.add(LiteralExpression.newConstant((Object)BYTE_ARRAY1, (PDataType)PVarbinary.INSTANCE));
        testData[0] = BYTE_ARRAY1;
        for (int i = 1; i < testData.length - 1; ++i) {
            children.add(nullExpression);
            testData[i] = ByteUtil.EMPTY_BYTE_ARRAY;
        }
        children.add(LiteralExpression.newConstant((Object)BYTE_ARRAY2, (PDataType)PVarbinary.INSTANCE));
        testData[299] = BYTE_ARRAY2;
        ImmutableBytesPtr ptr = this.evaluate(children);
        this.assertDecodedContents(ptr, testData);
    }

    @Test
    public void testSingleLeadingTrailingNull() throws Exception {
        ArrayList children = Lists.newArrayListWithExpectedSize((int)4);
        LiteralExpression nullExpression = LiteralExpression.newConstant(null);
        children.add(nullExpression);
        children.add(LiteralExpression.newConstant((Object)BYTE_ARRAY1, (PDataType)PVarbinary.INSTANCE));
        children.add(nullExpression);
        ImmutableBytesPtr ptr = this.evaluate(children);
        this.assertDecodedContents(ptr, ByteUtil.EMPTY_BYTE_ARRAY, BYTE_ARRAY1, ByteUtil.EMPTY_BYTE_ARRAY);
    }

    @Test
    public void testSingleMiddleNull() throws Exception {
        ArrayList children = Lists.newArrayListWithExpectedSize((int)4);
        LiteralExpression nullExpression = LiteralExpression.newConstant(null);
        children.add(LiteralExpression.newConstant((Object)BYTE_ARRAY1, (PDataType)PVarbinary.INSTANCE));
        children.add(nullExpression);
        children.add(LiteralExpression.newConstant((Object)BYTE_ARRAY2, (PDataType)PVarbinary.INSTANCE));
        ImmutableBytesPtr ptr = this.evaluate(children);
        this.assertDecodedContents(ptr, BYTE_ARRAY1, ByteUtil.EMPTY_BYTE_ARRAY, BYTE_ARRAY2);
    }

    @Test
    public void testAllShortValues() throws Exception {
        ArrayList children = Lists.newArrayListWithExpectedSize((int)1);
        ArrayList failedValues = Lists.newArrayList();
        for (int curr = Short.MIN_VALUE; curr <= Short.MAX_VALUE; ++curr) {
            children.add(LiteralExpression.newConstant((Object)curr, (PDataType)PSmallint.INSTANCE));
            ImmutableBytesPtr ptr = this.evaluate(children);
            ColumnValueDecoder decoder = this.immutableStorageScheme.getDecoder();
            Assert.assertTrue((boolean)decoder.decode((ImmutableBytesWritable)ptr, 0));
            if (ptr.getLength() == 0) {
                failedValues.add(curr);
            } else if (curr != PSmallint.INSTANCE.getCodec().decodeShort(ptr.copyBytesIfNecessary(), 0, SortOrder.ASC)) {
                failedValues.add(curr);
            }
            children.remove(0);
        }
        if (this.serializationVersion == 2) {
            Assert.assertTrue((String)(failedValues.size() + " values were not properly decoded: " + failedValues), (failedValues.size() == 2 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)(failedValues.size() + " values were not properly decoded: " + failedValues), (failedValues.size() == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSingleByteValues() throws Exception {
        ArrayList children = Lists.newArrayListWithExpectedSize((int)4);
        LiteralExpression nullExpression = LiteralExpression.newConstant(null);
        children.add(nullExpression);
        children.add(LiteralExpression.newConstant((Object)-128, (PDataType)PTinyint.INSTANCE));
        children.add(nullExpression);
        children.add(LiteralExpression.newConstant((Object)0, (PDataType)PUnsignedTinyint.INSTANCE));
        children.add(nullExpression);
        children.add(LiteralExpression.newConstant((Object)127, (PDataType)PUnsignedTinyint.INSTANCE));
        ImmutableBytesPtr ptr = this.evaluate(children);
        this.assertNullAtIndex(ptr, 0);
        this.assertValueAtIndex(ptr, 1, (byte)-128, (PDataType)PTinyint.INSTANCE);
        this.assertNullAtIndex(ptr, 2);
        this.assertValueAtIndex(ptr, 3, (byte)0, (PDataType)PUnsignedTinyint.INSTANCE);
        this.assertNullAtIndex(ptr, 4);
        this.assertValueAtIndex(ptr, 5, (byte)127, (PDataType)PUnsignedTinyint.INSTANCE);
    }

    @Test
    public void testSeparatorByteValues() throws Exception {
        ImmutableBytesPtr ptr;
        block5: {
            block4: {
                ArrayList children = Lists.newArrayListWithExpectedSize((int)4);
                LiteralExpression nullExpression = LiteralExpression.newConstant(null);
                children.add(nullExpression);
                children.add(LiteralExpression.newConstant((Object)-32513, (PDataType)PSmallint.INSTANCE));
                children.add(nullExpression);
                children.add(LiteralExpression.newConstant((Object)Short.MAX_VALUE, (PDataType)PSmallint.INSTANCE));
                children.add(nullExpression);
                children.add(LiteralExpression.newConstant((Object)Integer.MAX_VALUE, (PDataType)PInteger.INSTANCE));
                children.add(nullExpression);
                children.add(LiteralExpression.newConstant((Object)Integer.MIN_VALUE, (PDataType)PInteger.INSTANCE));
                children.add(nullExpression);
                children.add(nullExpression);
                children.add(LiteralExpression.newConstant((Object)-32514, (PDataType)PSmallint.INSTANCE));
                ptr = this.evaluate(children);
                this.assertNullAtIndex(ptr, 0);
                try {
                    this.assertValueAtIndex(ptr, 1, (short)-32513, (PDataType)PSmallint.INSTANCE);
                }
                catch (Exception e) {
                    if (this.serializationVersion == 2) break block4;
                    Assert.fail((String)("Failed on exception " + e));
                }
            }
            this.assertNullAtIndex(ptr, 2);
            try {
                this.assertValueAtIndex(ptr, 3, (short)Short.MAX_VALUE, (PDataType)PSmallint.INSTANCE);
            }
            catch (Exception e) {
                if (this.serializationVersion == 2) break block5;
                Assert.fail((String)("Failed on exception " + e));
            }
        }
        this.assertNullAtIndex(ptr, 4);
        this.assertValueAtIndex(ptr, 5, Integer.MAX_VALUE, (PDataType)PInteger.INSTANCE);
        this.assertNullAtIndex(ptr, 6);
        this.assertValueAtIndex(ptr, 7, Integer.MIN_VALUE, (PDataType)PInteger.INSTANCE);
        this.assertNullAtIndex(ptr, 8);
        this.assertNullAtIndex(ptr, 9);
        this.assertValueAtIndex(ptr, 10, (short)-32514, (PDataType)PSmallint.INSTANCE);
    }

    private void assertNullAtIndex(ImmutableBytesPtr ptr, int index) {
        this.assertValueAtIndex(ptr, index, null, null);
    }

    private void assertValueAtIndex(ImmutableBytesPtr ptr, int index, Object value, PDataType type) {
        ImmutableBytesPtr ptrCopy = new ImmutableBytesPtr(ptr);
        ColumnValueDecoder decoder = this.immutableStorageScheme.getDecoder();
        Assert.assertTrue((boolean)decoder.decode((ImmutableBytesWritable)ptrCopy, index));
        if (value == null) {
            Assert.assertArrayEquals((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])ptrCopy.copyBytesIfNecessary());
            return;
        }
        Number decoded = type.equals((Object)PSmallint.INSTANCE) ? (Number)type.getCodec().decodeShort(ptrCopy.copyBytesIfNecessary(), 0, SortOrder.ASC) : (Number)(type.equals((Object)PInteger.INSTANCE) ? (Number)type.getCodec().decodeInt(ptrCopy.copyBytesIfNecessary(), 0, SortOrder.ASC) : (Number)type.getCodec().decodeByte(ptrCopy.copyBytesIfNecessary(), 0, SortOrder.ASC));
        Assert.assertEquals((Object)value, (Object)decoded);
    }

    private ImmutableBytesPtr evaluate(List<Expression> children) {
        SingleCellConstructorExpression singleCellConstructorExpression = new SingleCellConstructorExpression(this.immutableStorageScheme, children);
        ImmutableBytesPtr ptr = new ImmutableBytesPtr();
        singleCellConstructorExpression.evaluate(null, (ImmutableBytesWritable)ptr);
        return ptr;
    }

    private void assertDecodedContents(ImmutableBytesPtr ptr, byte[] ... contents) {
        ColumnValueDecoder decoder = this.immutableStorageScheme.getDecoder();
        for (int i = 0; i < contents.length; ++i) {
            ImmutableBytesPtr ptrCopy = new ImmutableBytesPtr(ptr);
            Assert.assertTrue((boolean)decoder.decode((ImmutableBytesWritable)ptrCopy, i));
            Assert.assertArrayEquals((byte[])contents[i], (byte[])ptrCopy.copyBytesIfNecessary());
        }
    }
}

