/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.exception.PhoenixParserException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.CompiledConditionalTTLExpression;
import org.apache.phoenix.schema.ConditionalTTLExpression;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class ConditionalTTLExpressionTest
extends BaseConnectionlessQueryTest {
    private static void assertConditonTTL(Connection conn, String tableName, String ttlExpr) throws SQLException {
        ConditionalTTLExpression expected = new ConditionalTTLExpression(ttlExpr);
        ConditionalTTLExpressionTest.assertTTL(conn, tableName, (TTLExpression)expected);
    }

    private static void assertTTL(Connection conn, String tableName, TTLExpression expected) throws SQLException {
        PTable table = conn.unwrap(PhoenixConnection.class).getTable(tableName);
        Assert.assertEquals((Object)expected, (Object)table.getTTLExpression());
    }

    private void validateScan(Connection conn, String tableName, String query, String ttl, boolean useIndex, List<String> expectedColsInScan) throws SQLException {
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = new PhoenixPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        if (useIndex) {
            Assert.assertTrue((plan.getTableRef().getTable().getType() == PTableType.INDEX ? 1 : 0) != 0);
        }
        plan.iterator();
        PTable table = plan.getTableRef().getTable();
        Scan scan = plan.getContext().getScan();
        Map familyMap = scan.getFamilyMap();
        Assert.assertTrue((!familyMap.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((familyMap.size() == 1 ? 1 : 0) != 0);
        byte[] family = scan.getFamilies()[0];
        Assert.assertNotNull((Object)family);
        NavigableSet qualifiers = (NavigableSet)familyMap.get(family);
        if (expectedColsInScan.isEmpty()) {
            Assert.assertNull((Object)qualifiers);
        } else {
            for (String col : expectedColsInScan) {
                PColumn column = table.getColumnForColumnName(col.toUpperCase());
                Assert.assertTrue((boolean)Bytes.equals((byte[])family, (byte[])column.getFamilyName().getBytes()));
                Assert.assertTrue((boolean)qualifiers.contains(column.getColumnQualifierBytes()));
            }
        }
    }

    @Test
    public void testBasicExpression() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,col1 varchar, col2 date constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String ttl = "k1 > 5 AND col1 < 'zzzzzz'";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, TestUtil.retainSingleQuotes(ttl));
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, tableName, ttl);
            String query = String.format("SELECT count(*) from %s where k1 > 3", tableName);
            this.validateScan(conn, tableName, query, ttl, false, Lists.newArrayList((Object[])new String[]{"col1"}));
        }
    }

    @Test(expected=TypeMismatchException.class)
    public void testNotBooleanExpr() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,col1 varchar, col2 date constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String ttl = "k1 + 100";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, ttl);
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
        }
    }

    @Test(expected=TypeMismatchException.class)
    public void testWrongArgumentValue() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,col1 varchar, col2 date constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String ttl = "k1 = ''abc''";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, ttl);
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
        }
    }

    @Test(expected=PhoenixParserException.class)
    public void testParsingError() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,col1 varchar, col2 date constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String ttl = "k2 == 23";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, ttl);
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
        }
    }

    @Test
    public void testMultipleColumnFamilyNotAllowed() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,A.col1 varchar, col2 date constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String ttl = "A.col1 = 'expired'";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, TestUtil.retainSingleQuotes(ttl));
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_CONDITIONAL_TTL_ON_TABLE_WITH_MULTIPLE_COLUMN_FAMILIES.getErrorCode(), (long)e.getErrorCode());
        }
        catch (Exception e) {
            Assert.fail((String)("Unknown exception " + e));
        }
    }

    @Test
    public void testSingleNonDefaultColumnFamilyIsAllowed() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,A.col1 varchar, A.col2 date constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String ttl = "col1 = 'expired' AND col2 + 10 > CURRENT_DATE()";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, TestUtil.retainSingleQuotes(ttl));
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, tableName, ttl);
            String indexName = "I_" + ConditionalTTLExpressionTest.generateUniqueName();
            ddl = String.format("create index %s on %s (col2) include(col1)", indexName, tableName);
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, indexName, ttl);
            indexName = "L_" + ConditionalTTLExpressionTest.generateUniqueName();
            ddl = String.format("create local index %s on %s (col2) include(col1)", indexName, tableName);
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, indexName, ttl);
        }
    }

    @Test
    public void testDefaultColumnFamily() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,col1 varchar, col2 date constraint pk primary key (k1,k2 desc)) TTL = '%s',DEFAULT_COLUMN_FAMILY='CF'";
        String ttl = "col1 = 'expired' AND CF.col2 + 10 > CURRENT_DATE()";
        String tableName = "T_" + ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, TestUtil.retainSingleQuotes(ttl));
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, tableName, ttl);
            String viewName = "GV_" + ConditionalTTLExpressionTest.generateUniqueName();
            ddl = String.format("create view %s (col3 varchar) as select * from %s where k1 = 2", viewName, tableName);
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, viewName, ttl);
            String indexName = "I_" + ConditionalTTLExpressionTest.generateUniqueName();
            ddl = String.format("create index %s on %s (col2) include(col1)", indexName, tableName);
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, indexName, ttl);
            indexName = "L_" + ConditionalTTLExpressionTest.generateUniqueName();
            ddl = String.format("create local index %s on %s (col2) include(col1)", indexName, tableName);
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, indexName, ttl);
        }
    }

    @Test
    public void testMultipleColumnFamilyNotAllowedOnAlter() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,A.col1 varchar, col2 date constraint pk primary key (k1,k2 desc))";
        String ttl = "A.col1 = 'expired'";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName);
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            String alterDDL = String.format("alter table %s set TTL = '%s'", tableName, TestUtil.retainSingleQuotes(ttl));
            conn.createStatement().execute(alterDDL);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_CONDITIONAL_TTL_ON_TABLE_WITH_MULTIPLE_COLUMN_FAMILIES.getErrorCode(), (long)e.getErrorCode());
        }
        catch (Exception e) {
            Assert.fail((String)("Unknown exception " + e));
        }
    }

    @Test
    public void testMultipleColumnFamilyNotAllowedOnAddColumn() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,A.col1 varchar, A.col2 date constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String ttl = "A.col1 = 'expired'";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, TestUtil.retainSingleQuotes(ttl));
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            String alterDDL = String.format("alter table %s add col3 varchar", tableName);
            try {
                conn.createStatement().execute(alterDDL);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_CONDITIONAL_TTL_ON_TABLE_WITH_MULTIPLE_COLUMN_FAMILIES.getErrorCode(), (long)e.getErrorCode());
            }
            catch (Exception e) {
                Assert.fail((String)("Unknown exception " + e));
            }
            alterDDL = String.format("alter table %s add A.col3 varchar", tableName);
            conn.createStatement().execute(alterDDL);
        }
    }

    @Test
    public void testMultipleColumnFamilyNotAllowedOnAddColumn2() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,col1 varchar, col2 date constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String ttl = "col1 = 'expired'";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, TestUtil.retainSingleQuotes(ttl));
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            String alterDDL = String.format("alter table %s add A.col3 varchar", tableName);
            try {
                conn.createStatement().execute(alterDDL);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_CONDITIONAL_TTL_ON_TABLE_WITH_MULTIPLE_COLUMN_FAMILIES.getErrorCode(), (long)e.getErrorCode());
            }
            catch (Exception e) {
                Assert.fail((String)("Unknown exception " + e));
            }
            alterDDL = String.format("alter table %s add col3 varchar", tableName);
            conn.createStatement().execute(alterDDL);
        }
    }

    @Test
    public void testMultipleColumnFamilyNotAllowedOnAddColumn3() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,col1 varchar, col2 date constraint pk primary key (k1,k2 desc)) TTL = '%s',DEFAULT_COLUMN_FAMILY='CF'";
        String ttl = "col1 = 'expired' AND CF.col2 + 10 > CURRENT_DATE()";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, TestUtil.retainSingleQuotes(ttl));
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, tableName, ttl);
            String alterDDL = String.format("alter table %s add A.col3 varchar", tableName);
            try {
                conn.createStatement().execute(alterDDL);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_CONDITIONAL_TTL_ON_TABLE_WITH_MULTIPLE_COLUMN_FAMILIES.getErrorCode(), (long)e.getErrorCode());
            }
            catch (Exception e) {
                Assert.fail((String)("Unknown exception " + e));
            }
            alterDDL = String.format("alter table %s add col3 varchar", tableName);
            conn.createStatement().execute(alterDDL);
        }
    }

    @Test
    public void testDropColumnNotAllowed() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,col1 varchar, col2 date constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String ttl = "col1 = 'expired' AND col2 + 30 < CURRENT_DATE()";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, TestUtil.retainSingleQuotes(ttl));
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            String alterDDL = String.format("alter table %s drop column col2", tableName);
            try {
                conn.createStatement().execute(alterDDL);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_DROP_COL_REFERENCED_IN_CONDITIONAL_TTL.getErrorCode(), (long)e.getErrorCode());
            }
            catch (Exception e) {
                Assert.fail((String)("Unknown exception " + e));
            }
        }
    }

    @Test
    public void testAggregateExpressionNotAllowed() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,col1 varchar, col2 date constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String ttl = "SUM(k2) > 23";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, ttl);
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.AGGREGATE_EXPRESSION_NOT_ALLOWED_IN_CONDITIONAL_TTL.getErrorCode(), (long)e.getErrorCode());
        }
        catch (Exception e) {
            Assert.fail((String)("Unknown exception " + e));
        }
    }

    @Test
    public void testNullExpression() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,col1 varchar, col2 date constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ttl = "col1 is NULL AND col2 < CURRENT_DATE() + 30000";
        String ddl = String.format(ddlTemplate, tableName, ttl);
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, tableName, ttl);
            String query = String.format("SELECT count(*) from %s", tableName);
            this.validateScan(conn, tableName, query, ttl, false, Lists.newArrayList((Object[])new String[]{"col1", "col2"}));
        }
    }

    @Test
    public void testBooleanColumn() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,val varchar, expired BOOLEAN constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String indexName = "I_" + tableName;
        String indexTemplate = "create index %s on %s (val) include (expired)";
        String ttl = "expired";
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            String ddl = String.format(ddlTemplate, tableName, ttl);
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, tableName, ttl);
            String query = String.format("SELECT k1, k2 from %s where (k1,k2) IN ((1,2), (3,4))", tableName);
            this.validateScan(conn, tableName, query, ttl, false, Lists.newArrayList((Object[])new String[]{"expired"}));
            ddl = String.format(indexTemplate, indexName, tableName);
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, indexName, ttl);
            query = String.format("SELECT count(*) from %s", tableName);
            this.validateScan(conn, tableName, query, ttl, true, Lists.newArrayList((Object[])new String[]{"0:expired"}));
        }
    }

    @Test
    public void testNot() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,expired BOOLEAN constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String ttl = "NOT expired";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, ttl);
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, tableName, ttl);
        }
    }

    @Test
    public void testPhoenixRowTimestamp() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,col1 varchar, col2 date constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ttl = "PHOENIX_ROW_TIMESTAMP() < CURRENT_DATE() - 100";
        String ddl = String.format(ddlTemplate, tableName, ttl);
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, tableName, ttl);
            String query = String.format("select col1 from %s where k1 = 7 AND k2 > 12", tableName);
            this.validateScan(conn, tableName, query, ttl, false, Lists.newArrayList((Object[])new String[]{"col1"}));
        }
    }

    @Test
    public void testBooleanCaseExpression() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,col1 varchar, status char(1) constraint pk primary key (k1,k2 desc)) TTL = '%s'";
        String ttl = "CASE WHEN status = ''E'' THEN TRUE ELSE FALSE END";
        String expectedTTLExpr = "CASE WHEN status = 'E' THEN TRUE ELSE FALSE END";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, ttl);
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, tableName, expectedTTLExpr);
        }
    }

    @Test
    public void testCondTTLOnTopLevelView() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null primary key,k2 bigint, col1 varchar, status char(1))";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String viewName = ConditionalTTLExpressionTest.generateUniqueName();
        String viewTemplate = "create view %s (k3 smallint) as select * from %s WHERE k1=7 TTL = '%s'";
        String ttl = "k2 = 34 and k3 = -1";
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            String ddl = String.format(ddlTemplate, tableName);
            conn.createStatement().execute(ddl);
            ddl = String.format(viewTemplate, viewName, tableName, ttl);
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertTTL(conn, tableName, (TTLExpression)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, viewName, ttl);
            String query = String.format("select k3 from %s", viewName);
            this.validateScan(conn, viewName, query, ttl, false, Lists.newArrayList((Object[])new String[]{"k2", "k3"}));
        }
    }

    @Test
    public void testCondTTLOnMultiLevelView() throws SQLException {
        String ddlTemplate = "create table %s (k1 bigint not null primary key,k2 bigint, col1 varchar, status char(1))";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String parentView = ConditionalTTLExpressionTest.generateUniqueName();
        String childView = ConditionalTTLExpressionTest.generateUniqueName();
        String indexName = ConditionalTTLExpressionTest.generateUniqueName();
        String parentViewTemplate = "create view %s (k3 smallint) as select * from %s WHERE k1=7";
        String childViewTemplate = "create view %s as select * from %s TTL = '%s'";
        String indexOnChildTemplate = "create index %s ON %s (k3) include (col1, k2)";
        String ttl = "k2 = 34 and k3 = -1";
        String ddl = String.format(ddlTemplate, tableName);
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            ddl = String.format(parentViewTemplate, parentView, tableName);
            conn.createStatement().execute(ddl);
            ddl = String.format(childViewTemplate, childView, parentView, ttl);
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertTTL(conn, tableName, (TTLExpression)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED);
            ConditionalTTLExpressionTest.assertTTL(conn, parentView, (TTLExpression)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, childView, ttl);
            ddl = String.format(indexOnChildTemplate, indexName, childView);
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, indexName, ttl);
        }
    }

    @Test
    public void testInListTTLExpr() throws Exception {
        String ddlTemplate = "create table %s (id varchar not null primary key, col1 integer, col2 varchar) TTL = '%s'";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ttl = "col2 IN ('expired', 'cancelled')";
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            String ddl = String.format(ddlTemplate, tableName, TestUtil.retainSingleQuotes(ttl));
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, tableName, ttl);
            String query = String.format("select col1 from %s where id IN ('abc', 'fff')", tableName);
            this.validateScan(conn, tableName, query, ttl, false, Lists.newArrayList((Object[])new String[]{"col1", "col2"}));
        }
    }

    @Test
    public void testPartialIndex() throws Exception {
        String ddlTemplate = "create table %s (id varchar not null primary key, col1 integer, col2 integer, col3 double, col4 varchar) TTL = '%s'";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String indexTemplate = "create index %s on %s (col1) include (col2, col3, col4) where col1 > 50";
        String indexName = ConditionalTTLExpressionTest.generateUniqueName();
        String ttl = "col2 > 100 AND col4='expired'";
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            String ddl = String.format(ddlTemplate, tableName, TestUtil.retainSingleQuotes(ttl));
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, tableName, ttl);
            ddl = String.format(indexTemplate, indexName, tableName);
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, indexName, ttl);
            String query = String.format("select col3 from %s where col1 > 60", tableName);
            this.validateScan(conn, tableName, query, ttl, true, Lists.newArrayList((Object[])new String[]{"0:col2", "0:col3", "0:col4"}));
        }
    }

    @Test
    public void testUncoveredIndex() throws Exception {
        String ddlTemplate = "create table %s (id varchar not null primary key, col1 integer, col2 integer, col3 double, col4 varchar) TTL = '%s'";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String indexTemplate = "create uncovered index %s on %s (col1) ";
        String indexName = ConditionalTTLExpressionTest.generateUniqueName();
        String ttl = "col2 > 100 AND col4='expired'";
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            String ddl = String.format(ddlTemplate, tableName, TestUtil.retainSingleQuotes(ttl));
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, tableName, ttl);
            ddl = String.format(indexTemplate, indexName, tableName);
            try {
                conn.createStatement().execute(ddl);
                Assert.fail((String)"Should have thrown ColumnNotFoundException");
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof ColumnNotFoundException));
            }
            indexTemplate = "create uncovered index %s on %s (col4, col2) ";
            ddl = String.format(indexTemplate, indexName, tableName);
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, indexName, ttl);
        }
    }

    @Test
    public void testCreatingIndexWithMissingExprCols() throws Exception {
        String ddlTemplate = "create table %s (id varchar not null primary key, col1 integer, col2 integer, col3 double, col4 varchar) TTL = '%s'";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String indexTemplate = "create index %s on %s (col1) include (col2)";
        String indexName = ConditionalTTLExpressionTest.generateUniqueName();
        String ttl = "col2 > 100 AND col4='expired'";
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            String ddl = String.format(ddlTemplate, tableName, TestUtil.retainSingleQuotes(ttl));
            conn.createStatement().execute(ddl);
            ddl = String.format(indexTemplate, indexName, tableName);
            try {
                conn.createStatement().execute(ddl);
                Assert.fail((String)"Should have thrown ColumnNotFoundException");
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof ColumnNotFoundException));
            }
        }
    }

    @Test
    public void testSettingCondTTLOnTableWithIndexWithMissingExprCols() throws Exception {
        String ddlTemplate = "create table %s (id varchar not null primary key, col1 integer, col2 integer, col3 double, col4 varchar)";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String indexTemplate = "create index %s on %s (col1) include (col2)";
        String indexName = ConditionalTTLExpressionTest.generateUniqueName();
        String ttl = "col2 > 100 AND col4='expired'";
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            String ddl = String.format(ddlTemplate, tableName);
            conn.createStatement().execute(ddl);
            ddl = String.format(indexTemplate, indexName, tableName);
            conn.createStatement().execute(ddl);
            ddl = String.format("alter table %s set TTL = '%s'", tableName, TestUtil.retainSingleQuotes(ttl));
            try {
                conn.createStatement().execute(ddl);
                Assert.fail((String)"Should have thrown ColumnNotFoundException");
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof ColumnNotFoundException));
            }
        }
    }

    @Test
    public void testScanColumns() throws Exception {
        String ddlTemplate = "create table %s (k1 bigint not null, k2 bigint not null,col1 varchar, col2 date constraint pk primary key (k1,k2 desc)) COLUMN_ENCODED_BYTES=0, TTL = '%s'";
        String ttl = "k1 > 5 AND col1 < 'zzzzzz'";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ddl = String.format(ddlTemplate, tableName, TestUtil.retainSingleQuotes(ttl));
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            conn.createStatement().execute(ddl);
            ConditionalTTLExpressionTest.assertConditonTTL(conn, tableName, ttl);
            String query = String.format("select * from %s where k1 > 3", tableName);
            this.validateScan(conn, tableName, query, ttl, false, Collections.EMPTY_LIST);
            query = String.format("select count(*) from %s where k1 > 3", tableName);
            this.validateScan(conn, tableName, query, ttl, false, Lists.newArrayList((Object[])new String[]{"col1"}));
            query = String.format("select k1, k2 from %s where k1 > 3", tableName);
            this.validateScan(conn, tableName, query, ttl, false, Lists.newArrayList((Object[])new String[]{"col1"}));
            query = String.format("select col1, col2 from %s where k1 > 3", tableName);
            this.validateScan(conn, tableName, query, ttl, false, Lists.newArrayList((Object[])new String[]{"col1", "col2"}));
        }
    }

    @Test
    public void testLatestRowVersion() throws Exception {
        String ddlTemplate = "create table %s (id varchar not null primary key, col1 integer, col2 integer, col3 varchar) TTL = '%s'";
        String tableName = ConditionalTTLExpressionTest.generateUniqueName();
        String ttl = "col2 > 100 AND col3='expired'";
        long currentTS = EnvironmentEdgeManager.currentTimeMillis();
        try (Connection conn = DriverManager.getConnection(ConditionalTTLExpressionTest.getUrl());){
            String ddl = String.format(ddlTemplate, tableName, TestUtil.retainSingleQuotes(ttl));
            conn.createStatement().execute(ddl);
            PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
            PTable table = pconn.getTable(tableName);
            int updateCount = 5;
            String id = "a";
            ImmutableBytesPtr rowKey = new ImmutableBytesPtr(Bytes.toBytes((String)id));
            ArrayList<Cell> updates = new ArrayList<Cell>();
            for (int i = 0; i < updateCount; ++i) {
                updates.addAll(this.generateUpdate(id, i, i * i, "val_" + i, currentTS + (long)(i * 10)));
            }
            long lastupdateTS = currentTS + (long)((updateCount - 1) * 10);
            CompiledConditionalTTLExpression ttlExpr = (CompiledConditionalTTLExpression)table.getCompiledTTLExpression(pconn);
            ArrayList row = Lists.newArrayList(updates);
            row.sort(CellComparator.getInstance());
            List latestRowVersion = ttlExpr.getLatestRowVersion((List)row);
            Assert.assertEquals((long)3L, (long)latestRowVersion.size());
            for (Cell cell : latestRowVersion) {
                Assert.assertEquals((long)lastupdateTS, (long)cell.getTimestamp());
            }
            row = Lists.newArrayList(updates);
            KeyValue df = new KeyValue(Bytes.toBytes((String)id), Bytes.toBytes((String)"f"), null, lastupdateTS + 5L, KeyValue.Type.DeleteFamily, null);
            row.add(df);
            row.sort(CellComparator.getInstance());
            latestRowVersion = ttlExpr.getLatestRowVersion((List)row);
            Assert.assertTrue((boolean)latestRowVersion.isEmpty());
            row = Lists.newArrayList(updates);
            KeyValue dfv = new KeyValue(Bytes.toBytes((String)id), Bytes.toBytes((String)"f"), null, lastupdateTS, KeyValue.Type.DeleteFamilyVersion, null);
            row.add(dfv);
            row.sort(CellComparator.getInstance());
            latestRowVersion = ttlExpr.getLatestRowVersion((List)row);
            Assert.assertEquals((long)3L, (long)latestRowVersion.size());
            for (Cell cell : latestRowVersion) {
                Assert.assertEquals((long)(lastupdateTS - 10L), (long)cell.getTimestamp());
            }
            row = Lists.newArrayList(updates);
            df = new KeyValue(Bytes.toBytes((String)id), Bytes.toBytes((String)"f"), null, lastupdateTS - 25L, KeyValue.Type.DeleteFamily, null);
            row.add(df);
            row.add(dfv);
            row.sort(CellComparator.getInstance());
            latestRowVersion = ttlExpr.getLatestRowVersion((List)row);
            Assert.assertEquals((long)3L, (long)latestRowVersion.size());
            for (Cell cell : latestRowVersion) {
                Assert.assertEquals((long)(lastupdateTS - 10L), (long)cell.getTimestamp());
            }
            row = Lists.newArrayList(updates);
            row.add(dfv);
            dfv = new KeyValue(Bytes.toBytes((String)id), Bytes.toBytes((String)"f"), null, lastupdateTS - 10L, KeyValue.Type.DeleteFamilyVersion, null);
            row.add(dfv);
            row.sort(CellComparator.getInstance());
            latestRowVersion = ttlExpr.getLatestRowVersion((List)row);
            Assert.assertEquals((long)3L, (long)latestRowVersion.size());
            for (Cell cell : latestRowVersion) {
                Assert.assertEquals((long)(lastupdateTS - 20L), (long)cell.getTimestamp());
            }
            row = Lists.newArrayList(updates);
            df = new KeyValue(Bytes.toBytes((String)id), Bytes.toBytes((String)"f"), null, lastupdateTS - 5L, KeyValue.Type.DeleteFamily, null);
            row.add(df);
            row.sort(CellComparator.getInstance());
            latestRowVersion = ttlExpr.getLatestRowVersion((List)row);
            Assert.assertEquals((long)3L, (long)latestRowVersion.size());
            for (Cell cell : latestRowVersion) {
                Assert.assertEquals((long)lastupdateTS, (long)cell.getTimestamp());
            }
            row = Lists.newArrayList(updates);
            row.addAll(this.generateUpdate(id, 12, null, null, lastupdateTS + 10L));
            row.sort(CellComparator.getInstance());
            latestRowVersion = ttlExpr.getLatestRowVersion((List)row);
            Assert.assertEquals((long)1L, (long)latestRowVersion.size());
            for (Cell cell : latestRowVersion) {
                Assert.assertEquals((long)(lastupdateTS + 10L), (long)cell.getTimestamp());
            }
        }
    }

    private List<Cell> generateUpdate(String id, Integer col1, Integer col2, String col3, long ts) {
        KeyValue kv;
        ArrayList update = Lists.newArrayList();
        if (col1 != null) {
            kv = new KeyValue(Bytes.toBytes((String)id), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"col1"), ts, KeyValue.Type.Put, Bytes.toBytes((int)col1));
            update.add(kv);
        } else {
            kv = new KeyValue(Bytes.toBytes((String)id), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"col1"), ts, KeyValue.Type.DeleteColumn, null);
            update.add(kv);
        }
        if (col2 != null) {
            kv = new KeyValue(Bytes.toBytes((String)id), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"col2"), ts, KeyValue.Type.Put, Bytes.toBytes((int)col2));
            update.add(kv);
        } else {
            kv = new KeyValue(Bytes.toBytes((String)id), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"col2"), ts, KeyValue.Type.DeleteColumn, null);
            update.add(kv);
        }
        if (col3 != null) {
            kv = new KeyValue(Bytes.toBytes((String)id), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"col3"), ts, KeyValue.Type.Put, Bytes.toBytes((String)col3));
            update.add(kv);
        } else {
            kv = new KeyValue(Bytes.toBytes((String)id), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"col3"), ts, KeyValue.Type.DeleteColumn, null);
            update.add(kv);
        }
        return update;
    }
}

