/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class SkipSystemTablesExistenceCheckIT
extends ParallelStatsDisabledIT {
    @Test
    public void testTableResultIterator() throws Exception {
        Connection conn = DriverManager.getConnection(SkipSystemTablesExistenceCheckIT.getUrl());
        PhoenixConnection phoenixConnection = conn.unwrap(PhoenixConnection.class);
        String tableName = SkipSystemTablesExistenceCheckIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + " (A UNSIGNED_LONG NOT NULL PRIMARY KEY, B VARCHAR(10))");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (1, 'A')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (2, 'B')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (3, 'C')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (4, 'D')");
        conn.commit();
        this.scanTable(conn, tableName);
        Properties props = new Properties();
        props.setProperty("phoenix.skip.system.tables.existence.check", "true");
        ConnectionQueryServicesImpl queryServices = (ConnectionQueryServicesImpl)phoenixConnection.getQueryServices();
        phoenixConnection.close();
        queryServices.setInitialized(false);
        queryServices.init(SkipSystemTablesExistenceCheckIT.getUrl(), props);
        Assert.assertTrue((boolean)queryServices.isInitialized());
        conn = DriverManager.getConnection(SkipSystemTablesExistenceCheckIT.getUrl(), props);
        this.scanTable(conn, tableName);
    }

    private void scanTable(Connection conn, String tableName) throws SQLException {
        String sql = "SELECT A, B FROM " + tableName + " ORDER BY A DESC";
        PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
        ResultSet rs = stmt.executeQuery(sql);
        int cnt = 0;
        while (rs.next()) {
            Assert.assertTrue((String)"too many results returned", (++cnt <= 4 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)4L, (long)cnt);
    }
}

