/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.query.PropertyNotAllowedException;
import org.apache.phoenix.query.PropertyPolicy;
import org.apache.phoenix.query.PropertyPolicyProvider;
import org.apache.phoenix.query.TestPropertyPolicy;
import org.junit.Assert;
import org.junit.Test;

public class PropertyPolicyProviderTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testPropertyPolicyProvider() {
        PropertyPolicy provided = PropertyPolicyProvider.getPropertyPolicy();
        Assert.assertTrue((boolean)(provided instanceof TestPropertyPolicy));
    }

    @Test(expected=PropertyNotAllowedException.class)
    public void testPropertyPolicyBlacklisted() throws SQLException {
        Properties properties = new Properties();
        properties.put("DisallowedProperty", "value");
        Connection conn = DriverManager.getConnection(PropertyPolicyProviderTest.getUrl(), properties);
        if (conn != null) {
            conn.close();
        }
    }

    @Test
    public void testPropertyPolicyWhitelisted() throws SQLException {
        Properties properties = new Properties();
        properties.put("allowedProperty", "value");
        Connection conn = DriverManager.getConnection(PropertyPolicyProviderTest.getUrl(), properties);
        if (conn != null) {
            conn.close();
        }
    }

    @Test
    public void testDisablePropertyPolicyProvider() throws SQLException {
        Properties properties = new Properties();
        properties.put("DisallowedProperty", "value");
        properties.put("phoenix.property.policy.provider.enabled", "false");
        Connection conn = DriverManager.getConnection(PropertyPolicyProviderTest.getUrl(), properties);
        if (conn != null) {
            conn.close();
        }
    }
}

