/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.ParallelIterators;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SpoolingResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixParameterMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ParallelIteratorsSplitTest
extends BaseConnectionlessQueryTest {
    private static final String TABLE_NAME = "TEST_SKIP_RANGE_PARALLEL_ITERATOR";
    private static final String DDL = "CREATE TABLE TEST_SKIP_RANGE_PARALLEL_ITERATOR (id char(3) NOT NULL PRIMARY KEY, \"value\" integer)";
    private static final byte[] Ka1A = Bytes.toBytes((String)"a1A");
    private static final byte[] Ka1B = Bytes.toBytes((String)"a1B");
    private static final byte[] Ka1E = Bytes.toBytes((String)"a1E");
    private static final byte[] Ka1G = Bytes.toBytes((String)"a1G");
    private static final byte[] Ka1I = Bytes.toBytes((String)"a1I");
    private static final byte[] Ka2A = Bytes.toBytes((String)"a2A");
    private final Scan scan;
    private final ScanRanges scanRanges;
    private final List<KeyRange> expectedSplits;
    private static final Function<KeyRange[], List<KeyRange>> ARRAY_TO_LIST = new Function<KeyRange[], List<KeyRange>>(){

        public List<KeyRange> apply(KeyRange[] input) {
            return Lists.newArrayList((Object[])input);
        }
    };

    public ParallelIteratorsSplitTest(Scan scan, ScanRanges scanRanges, List<KeyRange> expectedSplits) {
        this.scan = scan;
        this.scanRanges = scanRanges;
        this.expectedSplits = expectedSplits;
    }

    @Test
    public void testGetSplitsWithSkipScanFilter() throws Exception {
        byte[][] splits = new byte[][]{Ka1A, Ka1B, Ka1E, Ka1G, Ka1I, Ka2A};
        ParallelIteratorsSplitTest.createTestTable(ParallelIteratorsSplitTest.getUrl(), DDL, splits, null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(ParallelIteratorsSplitTest.getUrl(), props);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable table = pconn.getTable(new PTableKey(pconn.getTenantId(), TABLE_NAME));
        TableRef tableRef = new TableRef(table);
        List regions = pconn.getQueryServices().getAllTableRegions(tableRef.getTable().getPhysicalName().getBytes(), 60000);
        List<KeyRange> ranges = ParallelIteratorsSplitTest.getSplits(tableRef, this.scan, regions, this.scanRanges);
        Assert.assertEquals((String)("Unexpected number of splits: " + ranges.size()), (long)this.expectedSplits.size(), (long)ranges.size());
        for (int i = 0; i < this.expectedSplits.size(); ++i) {
            Assert.assertEquals((Object)this.expectedSplits.get(i), (Object)ranges.get(i));
        }
    }

    private static KeyRange getKeyRange(byte[] lowerRange, boolean lowerInclusive, byte[] upperRange, boolean upperInclusive) {
        return PChar.INSTANCE.getKeyRange(lowerRange, lowerInclusive, upperRange, upperInclusive, SortOrder.ASC);
    }

    private static KeyRange getKeyRange(String lowerRange, boolean lowerInclusive, String upperRange, boolean upperInclusive) {
        return PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)lowerRange), lowerInclusive, Bytes.toBytes((String)upperRange), upperInclusive, SortOrder.ASC);
    }

    private static KeyRange getKeyRange(String lowerRange, boolean lowerInclusive, byte[] upperRange, boolean upperInclusive) {
        return PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)lowerRange), lowerInclusive, upperRange, upperInclusive, SortOrder.ASC);
    }

    private static KeyRange getKeyRange(byte[] lowerRange, boolean lowerInclusive, String upperRange, boolean upperInclusive) {
        return PChar.INSTANCE.getKeyRange(lowerRange, lowerInclusive, Bytes.toBytes((String)upperRange), upperInclusive, SortOrder.ASC);
    }

    private static String nextKey(String s) {
        return Bytes.toString((byte[])ByteUtil.nextKey((byte[])Bytes.toBytes((String)s)));
    }

    @Parameterized.Parameters(name="{1} {2}")
    public static synchronized Collection<Object> data() {
        ArrayList testCases = Lists.newArrayList();
        testCases.addAll(ParallelIteratorsSplitTest.foreach(ScanRanges.NOTHING, new int[]{1, 1, 1}, new KeyRange[0]));
        testCases.addAll(ParallelIteratorsSplitTest.foreach(ScanRanges.EVERYTHING, new int[]{1, 1, 1}, new KeyRange[]{ParallelIteratorsSplitTest.getKeyRange(KeyRange.UNBOUND, true, Ka1A, false), ParallelIteratorsSplitTest.getKeyRange(Ka1A, true, Ka1B, false), ParallelIteratorsSplitTest.getKeyRange(Ka1B, true, Ka1E, false), ParallelIteratorsSplitTest.getKeyRange(Ka1E, true, Ka1G, false), ParallelIteratorsSplitTest.getKeyRange(Ka1G, true, Ka1I, false), ParallelIteratorsSplitTest.getKeyRange(Ka1I, true, Ka2A, false), ParallelIteratorsSplitTest.getKeyRange(Ka2A, true, KeyRange.UNBOUND, false)}));
        testCases.addAll(ParallelIteratorsSplitTest.foreach(new KeyRange[][]{{ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true)}, {ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"0"), true, Bytes.toBytes((String)"0"), true)}, {ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"Z"), true)}}, new int[]{1, 1, 1}, new KeyRange[]{ParallelIteratorsSplitTest.getKeyRange("a0A", true, ParallelIteratorsSplitTest.nextKey("a0Z"), false)}));
        testCases.addAll(ParallelIteratorsSplitTest.foreach(new KeyRange[][]{{ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true)}, {ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"0"), true, Bytes.toBytes((String)"0"), true), ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true)}, {ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"A"), true)}}, new int[]{1, 1, 1}, new KeyRange[]{ParallelIteratorsSplitTest.getKeyRange("a0A", true, Ka1A, false), ParallelIteratorsSplitTest.getKeyRange(Ka1A, true, Ka1B, false)}));
        testCases.addAll(ParallelIteratorsSplitTest.foreach(new KeyRange[][]{{ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true)}, {ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true)}, {ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"E"), false)}}, new int[]{1, 1, 1}, new KeyRange[]{ParallelIteratorsSplitTest.getKeyRange(Ka1B, true, Ka1E, false)}));
        testCases.addAll(ParallelIteratorsSplitTest.foreach(new KeyRange[][]{{ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true)}, {ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true)}, {ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"E"), false)}}, new int[]{1, 1, 1}, new KeyRange[]{ParallelIteratorsSplitTest.getKeyRange(Ka1B, true, Ka1E, false)}));
        testCases.addAll(ParallelIteratorsSplitTest.foreach(new KeyRange[][]{{ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true)}, {ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true)}, {ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"F"), true, Bytes.toBytes((String)"H"), false)}}, new int[]{1, 1, 1}, new KeyRange[]{ParallelIteratorsSplitTest.getKeyRange("a1F", true, Ka1G, false), ParallelIteratorsSplitTest.getKeyRange(Ka1G, true, "a1H", false)}));
        testCases.addAll(ParallelIteratorsSplitTest.foreach(new KeyRange[][]{{ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true), ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true)}, {ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true), ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"2"), true)}, {ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"A"), true), ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true), ParallelIteratorsSplitTest.getKeyRange(Bytes.toBytes((String)"G"), true, Bytes.toBytes((String)"G"), true)}}, new int[]{1, 1, 1}, new KeyRange[]{ParallelIteratorsSplitTest.getKeyRange(Ka1A, true, Ka1B, false), ParallelIteratorsSplitTest.getKeyRange(Ka1B, true, Ka1E, false), ParallelIteratorsSplitTest.getKeyRange(Ka1G, true, Ka1I, false), ParallelIteratorsSplitTest.getKeyRange(Ka2A, true, ParallelIteratorsSplitTest.nextKey("b2G"), false)}));
        return testCases;
    }

    private static RowKeySchema buildSchema(int[] widths) {
        RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(10);
        for (final int width : widths) {
            builder.addField(new PDatum(){

                public boolean isNullable() {
                    return false;
                }

                public PDataType getDataType() {
                    return PChar.INSTANCE;
                }

                public Integer getMaxLength() {
                    return width;
                }

                public Integer getScale() {
                    return null;
                }

                public SortOrder getSortOrder() {
                    return SortOrder.getDefault();
                }
            }, false, SortOrder.getDefault());
        }
        return builder.build();
    }

    private static Collection<?> foreach(ScanRanges scanRanges, int[] widths, KeyRange[] expectedSplits) {
        SkipScanFilter filter = new SkipScanFilter(scanRanges.getRanges(), ParallelIteratorsSplitTest.buildSchema(widths), false);
        Scan scan = new Scan().setFilter((Filter)filter).withStartRow(KeyRange.UNBOUND).withStopRow(KeyRange.UNBOUND, true);
        ArrayList ret = Lists.newArrayList();
        ret.add(new Object[]{scan, scanRanges, Arrays.asList(expectedSplits)});
        return ret;
    }

    private static Collection<?> foreach(KeyRange[][] ranges, int[] widths, KeyRange[] expectedSplits) {
        RowKeySchema schema = ParallelIteratorsSplitTest.buildSchema(widths);
        List slots = Lists.transform((List)Lists.newArrayList((Object[])ranges), ARRAY_TO_LIST);
        SkipScanFilter filter = new SkipScanFilter(slots, schema, false);
        Scan scan = new Scan().setFilter((Filter)filter);
        ScanRanges scanRanges = ScanRanges.createSingleSpan((RowKeySchema)schema, (List)slots);
        ArrayList ret = Lists.newArrayList();
        ret.add(new Object[]{scan, scanRanges, Arrays.asList(expectedSplits)});
        return ret;
    }

    private static List<KeyRange> getSplits(final TableRef tableRef, Scan scan, List<HRegionLocation> regions, ScanRanges scanRanges) throws SQLException {
        final List<TableRef> tableRefs = Collections.singletonList(tableRef);
        ColumnResolver resolver = new ColumnResolver(){

            public List<PFunction> getFunctions() {
                return Collections.emptyList();
            }

            public List<TableRef> getTables() {
                return tableRefs;
            }

            public TableRef resolveTable(String schemaName, String tableName) throws SQLException {
                throw new UnsupportedOperationException();
            }

            public ColumnRef resolveColumn(String schemaName, String tableName, String colName) throws SQLException {
                throw new UnsupportedOperationException();
            }

            public PFunction resolveFunction(String functionName) throws SQLException {
                throw new UnsupportedOperationException();
            }

            public boolean hasUDFs() {
                return false;
            }

            public PSchema resolveSchema(String schemaName) throws SQLException {
                return null;
            }

            public List<PSchema> getSchemas() {
                return null;
            }
        };
        PhoenixConnection connection = DriverManager.getConnection(ParallelIteratorsSplitTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixStatement statement = new PhoenixStatement(connection);
        final StatementContext context = new StatementContext(statement, resolver, scan, new SequenceManager(statement));
        context.setScanRanges(scanRanges);
        ParallelIterators parallelIterators = new ParallelIterators(new QueryPlan(){
            private final Set<TableRef> tableRefs;
            {
                this.tableRefs = ImmutableSet.of((Object)tableRef);
            }

            public StatementContext getContext() {
                return context;
            }

            public ParameterMetaData getParameterMetaData() {
                return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
            }

            public ExplainPlan getExplainPlan() throws SQLException {
                return ExplainPlan.EMPTY_PLAN;
            }

            public ResultIterator iterator(ParallelScanGrouper scanGrouper) throws SQLException {
                return ResultIterator.EMPTY_ITERATOR;
            }

            public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
                return ResultIterator.EMPTY_ITERATOR;
            }

            public ResultIterator iterator() throws SQLException {
                return ResultIterator.EMPTY_ITERATOR;
            }

            public long getEstimatedSize() {
                return 0L;
            }

            public Set<TableRef> getSourceRefs() {
                return this.tableRefs;
            }

            public TableRef getTableRef() {
                return tableRef;
            }

            public RowProjector getProjector() {
                return RowProjector.EMPTY_PROJECTOR;
            }

            public Integer getLimit() {
                return null;
            }

            public Integer getOffset() {
                return null;
            }

            public OrderByCompiler.OrderBy getOrderBy() {
                return OrderByCompiler.OrderBy.EMPTY_ORDER_BY;
            }

            public GroupByCompiler.GroupBy getGroupBy() {
                return GroupByCompiler.GroupBy.EMPTY_GROUP_BY;
            }

            public List<KeyRange> getSplits() {
                return null;
            }

            public FilterableStatement getStatement() {
                return SelectStatement.SELECT_ONE;
            }

            public boolean isDegenerate() {
                return false;
            }

            public boolean isRowKeyOrdered() {
                return true;
            }

            public List<List<Scan>> getScans() {
                return null;
            }

            public PhoenixStatement.Operation getOperation() {
                return PhoenixStatement.Operation.QUERY;
            }

            public boolean useRoundRobinIterator() {
                return false;
            }

            public <T> T accept(QueryPlanVisitor<T> visitor) {
                return (T)visitor.defaultReturn((QueryPlan)this);
            }

            public Long getEstimatedRowsToScan() {
                return null;
            }

            public Long getEstimatedBytesToScan() {
                return null;
            }

            public Long getEstimateInfoTimestamp() throws SQLException {
                return null;
            }

            public Cost getCost() {
                return Cost.ZERO;
            }

            public List<OrderByCompiler.OrderBy> getOutputOrderBys() {
                return Collections.emptyList();
            }

            public boolean isApplicable() {
                return true;
            }
        }, null, (ParallelIteratorFactory)new SpoolingResultIterator.SpoolingResultIteratorFactory((QueryServices)context.getConnection().getQueryServices()), context.getScan(), false, null, null);
        List keyRanges = parallelIterators.getSplits();
        return keyRanges;
    }
}

