/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.DelayedRegionServer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class MaxConcurrentConnectionsIT
extends BaseTest {
    private static HBaseTestingUtility hbaseTestUtil;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        MaxConcurrentConnectionsIT.setUpConfigForMiniCluster(conf);
        hbaseTestUtil = new HBaseTestingUtility(conf);
        hbaseTestUtil.startMiniCluster(1, 1, null, null, DelayedRegionServer.class);
        String zkQuorum = "localhost:" + hbaseTestUtil.getZkCluster().getClientPort();
        url = "jdbc:phoenix+zk:" + zkQuorum + ":uniqueConn=A";
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
        DriverManager.registerDriver((Driver)((Object)new PhoenixTestDriver()));
    }

    private String getUniqueUrl() {
        return url + MaxConcurrentConnectionsIT.generateUniqueName();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        ServerMetadataCacheTestImpl.resetCache();
        hbaseTestUtil.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRuntimeFailureClosesConnections() throws Exception {
        Statement statement;
        String tableName = MaxConcurrentConnectionsIT.generateUniqueName();
        String connectionUrl = this.getUniqueUrl();
        String ddl = "create table " + tableName + "  (i integer not null primary key, j integer) SALT_BUCKETS=256 ";
        Properties props = new Properties();
        props.setProperty("phoenix.client.connection.max.allowed.connections", String.valueOf(10));
        props.setProperty("phoenix.internal.connection.max.allowed.connections", String.valueOf(10));
        props.setProperty("phoenix.task.handling.interval.ms", String.valueOf(600000));
        props.setProperty("phoenix.task.handling.initial.delay.ms", String.valueOf(600000));
        String deleteStmt = "DELETE FROM " + tableName + " WHERE 20 = j";
        try (Connection conn = DriverManager.getConnection(connectionUrl, props);){
            statement = conn.createStatement();
            try {
                statement.execute(ddl);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.getMetric().getValue());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_OPEN_INTERNAL_PHOENIX_CONNECTIONS.getMetric().getValue());
        conn = null;
        try {
            conn = DriverManager.getConnection(connectionUrl, props);
            DelayedRegionServer.setDelayEnabled(true);
            statement = conn.createStatement();
            try {
                statement.execute(deleteStmt);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            Assert.fail();
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.NEW_INTERNAL_CONNECTION_THROTTLED.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.NEW_INTERNAL_CONNECTION_THROTTLED.getSQLState(), (Object)e.getSQLState());
            }
            catch (Throwable throwable) {
                DelayedRegionServer.setDelayEnabled(false);
                if (conn != null) {
                    conn.close();
                }
                long connections = GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.getMetric().getValue();
                Assert.assertEquals((String)String.format("Found %d connections still open.", connections), (long)0L, (long)connections);
                connections = GlobalClientMetrics.GLOBAL_OPEN_INTERNAL_PHOENIX_CONNECTIONS.getMetric().getValue();
                Assert.assertEquals((String)String.format("Found %d internal connections still open.", connections), (long)0L, (long)connections);
                throw throwable;
            }
            DelayedRegionServer.setDelayEnabled(false);
            if (conn != null) {
                conn.close();
            }
            long connections = GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.getMetric().getValue();
            Assert.assertEquals((String)String.format("Found %d connections still open.", connections), (long)0L, (long)connections);
            connections = GlobalClientMetrics.GLOBAL_OPEN_INTERNAL_PHOENIX_CONNECTIONS.getMetric().getValue();
            Assert.assertEquals((String)String.format("Found %d internal connections still open.", connections), (long)0L, (long)connections);
        }
        DelayedRegionServer.setDelayEnabled(false);
        if (conn != null) {
            conn.close();
        }
        long connections = GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.getMetric().getValue();
        Assert.assertEquals((String)String.format("Found %d connections still open.", connections), (long)0L, (long)connections);
        connections = GlobalClientMetrics.GLOBAL_OPEN_INTERNAL_PHOENIX_CONNECTIONS.getMetric().getValue();
        Assert.assertEquals((String)String.format("Found %d internal connections still open.", connections), (long)0L, (long)connections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClosedChildConnectionsRemovedFromParentQueue() throws SQLException {
        int i;
        String tableName = MaxConcurrentConnectionsIT.generateUniqueName();
        String connectionUrl = this.getUniqueUrl();
        int NUMBER_OF_ROWS = 10;
        String ddl = "CREATE TABLE " + tableName + " (V BIGINT PRIMARY KEY, K BIGINT)";
        Properties props = new Properties();
        props.setProperty("phoenix.client.connection.max.allowed.connections", String.valueOf(10));
        props.setProperty("phoenix.internal.connection.max.allowed.connections", String.valueOf(10));
        try (Connection conn = DriverManager.getConnection(connectionUrl, props);
             Statement statement = conn.createStatement();){
            statement.execute(ddl);
        }
        PhoenixConnection connection = (PhoenixConnection)DriverManager.getConnection(connectionUrl, props);
        for (i = 0; i < NUMBER_OF_ROWS; ++i) {
            connection.createStatement().execute("UPSERT INTO " + tableName + " VALUES (" + i + ", " + i + ")");
            connection.commit();
        }
        connection.setAutoCommit(false);
        try {
            for (i = 0; i < NUMBER_OF_ROWS; ++i) {
                connection.createStatement().execute("DELETE FROM " + tableName + " WHERE K = " + i);
            }
        }
        catch (SQLException e) {
            Assert.fail();
        }
        finally {
            connection.close();
        }
        Assert.assertEquals((long)0L, (long)connection.getChildConnectionsCount());
    }
}

