/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PChar;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class KeyRangeUnionTest
extends TestCase {
    private final KeyRange a;
    private final KeyRange b;
    private final KeyRange union;

    public KeyRangeUnionTest(KeyRange a, KeyRange b, KeyRange union) {
        this.a = a;
        this.b = b;
        this.union = union;
    }

    @Parameterized.Parameters(name="union of {0} and {1} is {2}")
    public static synchronized Collection<?> data() {
        return Arrays.asList({PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"F"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"F"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), false, Bytes.toBytes((String)"E"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"F"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), false, Bytes.toBytes((String)"F"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), false, Bytes.toBytes((String)"E"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), false, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), false, Bytes.toBytes((String)"E"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), false, SortOrder.ASC), KeyRange.EMPTY_RANGE, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), false, SortOrder.ASC)}, {KeyRange.EVERYTHING_RANGE, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"E"), false, Bytes.toBytes((String)"F"), true, SortOrder.ASC), KeyRange.EVERYTHING_RANGE}, {KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE}, {KeyRange.EMPTY_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE});
    }

    @Test
    public void union() {
        KeyRangeUnionTest.assertEquals((Object)this.union, (Object)this.a.union(this.b));
        KeyRangeUnionTest.assertEquals((Object)this.union, (Object)this.b.union(this.a));
    }
}

