/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.query.GuidePostsCache;
import org.apache.phoenix.query.GuidePostsCacheWrapper;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class GuidePostsCacheWrapperTest {
    @Mock
    GuidePostsCache cache;
    GuidePostsCacheWrapper wrapper;
    byte[] table = Bytes.toBytes((String)"tableName");
    byte[] columnFamily1 = Bytes.toBytesBinary((String)"cf1");
    byte[] columnFamily2 = Bytes.toBytesBinary((String)"cf2");

    @Before
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
        this.wrapper = new GuidePostsCacheWrapper(this.cache);
    }

    @Test
    public void invalidateAllTableDescriptor() {
        HashSet<byte[]> cfSet = new HashSet<byte[]>();
        cfSet.add(this.columnFamily1);
        cfSet.add(this.columnFamily2);
        TableDescriptor tableDesc = (TableDescriptor)Mockito.mock(TableDescriptor.class);
        TableName tableName = TableName.valueOf((byte[])this.table);
        Mockito.when((Object)tableDesc.getColumnFamilyNames()).thenReturn(cfSet);
        Mockito.when((Object)tableDesc.getTableName()).thenReturn((Object)tableName);
        this.wrapper.invalidateAll(tableDesc);
        ((GuidePostsCache)Mockito.verify((Object)this.cache, (VerificationMode)Mockito.times((int)1))).invalidate(new GuidePostsKey(this.table, this.columnFamily1));
        ((GuidePostsCache)Mockito.verify((Object)this.cache, (VerificationMode)Mockito.times((int)1))).invalidate(new GuidePostsKey(this.table, this.columnFamily2));
    }

    @Test
    public void invalidateAllPTable() {
        PTable ptable = (PTable)Mockito.mock(PTable.class);
        PName pname = (PName)Mockito.mock(PName.class);
        PName pnamecf1 = (PName)Mockito.mock(PName.class);
        PName pnamecf2 = (PName)Mockito.mock(PName.class);
        Mockito.when((Object)ptable.getPhysicalName()).thenReturn((Object)pname);
        Mockito.when((Object)pname.getBytes()).thenReturn((Object)this.table);
        PColumnFamily cf1 = (PColumnFamily)Mockito.mock(PColumnFamily.class);
        PColumnFamily cf2 = (PColumnFamily)Mockito.mock(PColumnFamily.class);
        Mockito.when((Object)cf1.getName()).thenReturn((Object)pnamecf1);
        Mockito.when((Object)cf2.getName()).thenReturn((Object)pnamecf2);
        Mockito.when((Object)pnamecf1.getBytes()).thenReturn((Object)this.columnFamily1);
        Mockito.when((Object)pnamecf2.getBytes()).thenReturn((Object)this.columnFamily2);
        ArrayList cfList = Lists.newArrayList((Object[])new PColumnFamily[]{cf1, cf2});
        Mockito.when((Object)ptable.getColumnFamilies()).thenReturn((Object)cfList);
        this.wrapper.invalidateAll(ptable);
        ((GuidePostsCache)Mockito.verify((Object)this.cache, (VerificationMode)Mockito.times((int)1))).invalidate(new GuidePostsKey(this.table, this.columnFamily1));
        ((GuidePostsCache)Mockito.verify((Object)this.cache, (VerificationMode)Mockito.times((int)1))).invalidate(new GuidePostsKey(this.table, this.columnFamily2));
    }

    @Test(expected=NullPointerException.class)
    public void invalidateAllTableDescriptorNull() {
        TableDescriptor tableDesc = null;
        this.wrapper.invalidateAll(tableDesc);
    }

    @Test(expected=NullPointerException.class)
    public void invalidateAllPTableNull() {
        PTable ptable = null;
        this.wrapper.invalidateAll(ptable);
    }
}

