/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class ExplainPlanTextTest
extends BaseConnectionlessQueryTest {
    String defaultDeleteStatement = "DELETE FROM ATABLE WHERE entity_id='abc'";

    @Test
    public void explainDeleteClientTest() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        List<String> plan = this.getExplain(this.defaultDeleteStatement, props);
        Assert.assertEquals((Object)"DELETE ROWS CLIENT SELECT", (Object)plan.get(0));
    }

    @Test
    public void explainDeleteServerTest() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.connection.autoCommit", "true");
        List<String> plan = this.getExplain(this.defaultDeleteStatement, props);
        Assert.assertEquals((Object)"DELETE ROWS SERVER SELECT", (Object)plan.get(0));
    }

    private List<String> getExplain(String query, Properties props) throws SQLException {
        ArrayList<String> explainPlan = new ArrayList<String>();
        try (Connection conn = DriverManager.getConnection(ExplainPlanTextTest.getUrl(), props);
             PreparedStatement statement = conn.prepareStatement("EXPLAIN " + query);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                String plan = rs.getString(1);
                explainPlan.add(plan);
            }
        }
        return explainPlan;
    }
}

