/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.query.DelegateConnectionQueryServices;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ParallelStatsEnabledTest.class})
@RunWith(value=Parameterized.class)
public class ConnectionCachingIT
extends ParallelStatsEnabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionCachingIT.class);
    private String leaseRenewal;

    @Parameterized.Parameters(name="phoenix.scanner.lease.renew.enabled={0}")
    public static synchronized Iterable<String> data() {
        return Arrays.asList("true", "false");
    }

    public ConnectionCachingIT(String leaseRenewalValue) {
        this.leaseRenewal = leaseRenewalValue;
    }

    @Test
    public void test() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.scanner.lease.renew.enabled", this.leaseRenewal);
        String url = ConnectionCachingIT.getUrl();
        url = url.replace(";test=true", "");
        LOGGER.info("URL to use is: {}", (Object)url);
        Connection conn = DriverManager.getConnection(url, props);
        long before = this.getNumCachedConnections(conn);
        for (int i = 0; i < 10000; ++i) {
            Connection c = DriverManager.getConnection(url, props);
            c.close();
        }
        Thread.sleep(15000L);
        long after = this.getNumCachedConnections(conn);
        for (int i = 0; i < 6; ++i) {
            LOGGER.info("Found {} connections cached", (Object)after);
            if (after <= before) break;
            Thread.sleep(15000L);
            after = this.getNumCachedConnections(conn);
        }
        Assert.assertTrue((String)("Saw " + before + " connections, but ended with " + after), (after <= before ? 1 : 0) != 0);
    }

    long getNumCachedConnections(Connection conn) throws Exception {
        PhoenixConnection pConn = conn.unwrap(PhoenixConnection.class);
        ConnectionQueryServices cqs = pConn.getQueryServices();
        if (cqs instanceof DelegateConnectionQueryServices) {
            cqs = ((DelegateConnectionQueryServices)cqs).getDelegate();
        }
        Assert.assertTrue((String)("ConnectionQueryServices was a " + cqs.getClass()), (boolean)(cqs instanceof ConnectionQueryServicesImpl));
        ConnectionQueryServicesImpl cqsi = (ConnectionQueryServicesImpl)cqs;
        long cachedConnections = 0L;
        for (LinkedBlockingQueue queue : cqsi.getCachedConnections()) {
            cachedConnections += (long)queue.size();
        }
        return cachedConnections;
    }
}

