/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.ipc.PhoenixRpcSchedulerFactory;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.SystemExitRule;
import org.apache.phoenix.end2end.PhoenixRegionServerEndpointTestImpl;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.schema.NewerTableAlreadyExistsException;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.phoenix.util.ConfigUtil;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryBuilder;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTest {
    public static final String DRIVER_CLASS_NAME_ATTRIB = "phoenix.driver.class.name";
    protected static final String NULL_STRING = "NULL";
    private static final double ZERO = 1.0E-9;
    private static final Map<String, String> tableDDLMap;
    private static final Logger LOGGER;
    @ClassRule
    public static TemporaryFolder tmpFolder;
    private static final int dropTableTimeout = 120;
    private static final ThreadFactory factory;
    private static final ExecutorService dropHTableService;
    @ClassRule
    public static final SystemExitRule SYSTEM_EXIT_RULE;
    private static final String ORG_ID = "00D300000000XHP";
    protected static int NUM_SLAVES_BASE;
    private static final String DEFAULT_RPC_SCHEDULER_FACTORY;
    protected static String url;
    protected static PhoenixTestDriver driver;
    protected static boolean clusterInitialized;
    protected static HBaseTestingUtility utility;
    protected static final Configuration config;
    private static long timestamp;
    private static AtomicInteger NAME_SUFFIX;
    private static final int MAX_SUFFIX_VALUE = 1000000;
    private static final AtomicInteger TABLE_COUNTER;
    private static final int TEARDOWN_THRESHOLD = 30;
    private static AtomicInteger SEQ_NAME_SUFFIX;
    private static final int MAX_SEQ_SUFFIX_VALUE = 1000000;
    private static final AtomicInteger SEQ_COUNTER;

    protected static String getZKClientPort(Configuration conf) {
        return conf.get("hbase.zookeeper.property.clientPort");
    }

    protected static String getUrl() {
        if (!clusterInitialized) {
            throw new IllegalStateException("Cluster must be initialized before attempting to get the URL");
        }
        return url;
    }

    protected static String getUrl(String principal) throws Exception {
        if (!clusterInitialized) {
            throw new IllegalStateException("Cluster must be initialized before attempting to get the URL");
        }
        return BaseTest.getLocalClusterUrl(utility, principal);
    }

    protected static String checkClusterInitialized(ReadOnlyProps serverProps) throws Exception {
        if (!clusterInitialized) {
            url = BaseTest.setUpTestCluster(config, serverProps);
            clusterInitialized = true;
        }
        return url;
    }

    protected static String setUpTestCluster(@Nonnull Configuration conf, ReadOnlyProps overrideProps) throws Exception {
        boolean isDistributedCluster = BaseTest.isDistributedClusterModeEnabled(conf);
        if (!isDistributedCluster) {
            return BaseTest.initMiniCluster(conf, overrideProps);
        }
        return BaseTest.initClusterDistributedMode(conf, overrideProps);
    }

    protected static void destroyDriver() {
        if (driver != null) {
            try {
                Assert.assertTrue((boolean)BaseTest.destroyDriver((Driver)((Object)driver)));
            }
            catch (Throwable t) {
                LOGGER.error("Exception caught when destroying phoenix test driver", t);
            }
            finally {
                driver = null;
            }
        }
    }

    protected static synchronized void dropNonSystemTables() throws Exception {
        try {
            BaseTest.disableAndDropNonSystemTables();
        }
        finally {
            BaseTest.destroyDriver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void tearDownMiniCluster(int numTables) {
        long startTime = System.currentTimeMillis();
        try {
            ServerUtil.ConnectionFactory.shutdown();
            BaseTest.destroyDriver();
            utility.shutdownMiniMapReduceCluster();
        }
        catch (Throwable t) {
            LOGGER.error("Exception caught when shutting down mini map reduce cluster", t);
        }
        finally {
            try {
                ServerMetadataCacheTestImpl.resetCache();
                utility.shutdownMiniCluster();
            }
            catch (Throwable t) {
                LOGGER.error("Exception caught when shutting down mini cluster", t);
            }
            finally {
                clusterInitialized = false;
                utility = null;
                LOGGER.info("Time in seconds spent in shutting down mini cluster with " + numTables + " tables: " + (System.currentTimeMillis() - startTime) / 1000L);
            }
        }
    }

    public static synchronized void resetHbase() {
        try {
            ServerUtil.ConnectionFactory.shutdown();
            BaseTest.destroyDriver();
            BaseTest.disableAndDropAllTables();
        }
        catch (Exception e) {
            LOGGER.error("Error resetting HBase");
        }
    }

    protected static synchronized void setUpTestDriver(ReadOnlyProps props) throws Exception {
        BaseTest.setUpTestDriver(props, props);
    }

    protected static synchronized void setUpTestDriver(ReadOnlyProps serverProps, ReadOnlyProps clientProps) throws Exception {
        if (driver == null) {
            String url = BaseTest.checkClusterInitialized(serverProps);
            driver = BaseTest.initAndRegisterTestDriver(url, clientProps);
        }
    }

    private static boolean isDistributedClusterModeEnabled(Configuration conf) {
        boolean isDistributedCluster = false;
        isDistributedCluster = Boolean.parseBoolean(System.getProperty("hbase.test.cluster.distributed", "false"));
        if (!isDistributedCluster) {
            isDistributedCluster = conf.getBoolean("hbase.test.cluster.distributed", false);
        }
        return isDistributedCluster;
    }

    private static synchronized String initMiniCluster(Configuration conf, ReadOnlyProps overrideProps) throws Exception {
        BaseTest.setUpConfigForMiniCluster(conf, overrideProps);
        utility = new HBaseTestingUtility(conf);
        try {
            long startTime = System.currentTimeMillis();
            StartMiniClusterOption.Builder builder = StartMiniClusterOption.builder();
            builder.numMasters(overrideProps.getInt("phoenix.tests.minicluster.nummasters", 1));
            int numSlaves = overrideProps.getInt("phoenix.tests.minicluster.numregionservers", NUM_SLAVES_BASE);
            builder.numRegionServers(numSlaves);
            builder.numDataNodes(numSlaves);
            utility.startMiniCluster(builder.build());
            long startupTime = System.currentTimeMillis() - startTime;
            LOGGER.info("HBase minicluster startup complete in {} ms", (Object)startupTime);
            return BaseTest.getLocalClusterUrl(utility);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected static String getLocalClusterUrl(HBaseTestingUtility util) throws Exception {
        String url = QueryUtil.getConnectionUrl((Properties)new Properties(), (Configuration)util.getConfiguration());
        return url + "test=true";
    }

    protected static String getLocalClusterUrl(HBaseTestingUtility util, String principal) throws Exception {
        String url = QueryUtil.getConnectionUrl((Properties)new Properties(), (Configuration)util.getConfiguration(), (String)principal);
        return url + "test=true";
    }

    private static String initClusterDistributedMode(Configuration conf, ReadOnlyProps overrideProps) throws Exception {
        BaseTest.setTestConfigForDistribuedCluster(conf, overrideProps);
        try {
            IntegrationTestingUtility util = new IntegrationTestingUtility(conf);
            utility = util;
            util.initializeCluster(NUM_SLAVES_BASE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "jdbc:phoenix;test=true";
    }

    private static void setTestConfigForDistribuedCluster(Configuration conf, ReadOnlyProps overrideProps) throws Exception {
        BaseTest.setDefaultTestConfig(conf, overrideProps);
    }

    private static void setDefaultTestConfig(Configuration conf, ReadOnlyProps overrideProps) throws Exception {
        ConfigUtil.setReplicationConfigIfAbsent((Configuration)conf);
        QueryServices services = BaseTest.newTestDriver(overrideProps).getQueryServices();
        for (Map.Entry entry : services.getProps()) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        conf.setBoolean("hbase.table.sanity.checks", false);
        conf.set("hbase.region.server.rpc.scheduler.factory.class", DEFAULT_RPC_SCHEDULER_FACTORY);
        conf.setLong("zookeeper.session.timeout", 900000L);
        conf.setLong("hbase.zookeeper.property.tickTime", 6000L);
        for (Map.Entry entry : overrideProps) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static Configuration setUpConfigForMiniCluster(Configuration conf) throws Exception {
        return BaseTest.setUpConfigForMiniCluster(conf, ReadOnlyProps.EMPTY_PROPS);
    }

    public static Configuration setUpConfigForMiniCluster(Configuration conf, ReadOnlyProps overrideProps) throws Exception {
        Assert.assertNotNull((Object)conf);
        BaseTest.setDefaultTestConfig(conf, overrideProps);
        conf.setInt("hbase.regionserver.handler.count", 5);
        conf.setInt("hbase.regionserver.metahandler.count", 2);
        conf.setInt("dfs.namenode.handler.count", 2);
        conf.setInt("dfs.namenode.service.handler.count", 2);
        conf.setInt("dfs.datanode.handler.count", 2);
        conf.setInt("ipc.server.read.threadpool.size", 2);
        conf.setInt("ipc.server.handler.threadpool.size", 2);
        conf.setInt("hbase.regionserver.hlog.syncer.count", 2);
        conf.setInt("hbase.hfile.compaction.discharger.interval", 5000);
        conf.setInt("hbase.hlog.asyncer.number", 2);
        conf.setInt("hbase.assignment.zkevent.workers", 5);
        conf.setInt("hbase.assignment.threads.max", 5);
        conf.setInt("hbase.catalogjanitor.interval", 5000);
        conf.setInt("phoenix.task.handling.interval.ms", 10000);
        conf.setInt("hbase.client.retries.number", 2);
        conf.setInt("phoenix.index.writer.threads.max", 1);
        conf.setInt("phoenix.global.index.row.age.threshold.to.delete.ms", 0);
        conf.set("hbase.regionserver.wal.codec", "org.apache.hadoop.hbase.regionserver.wal.IndexedWALEditCodec");
        if (conf.getLong("phoenix.server.page.size.ms", 0L) == 0L) {
            conf.setLong("phoenix.server.page.size.ms", 0L);
        }
        BaseTest.setPhoenixRegionServerEndpoint(conf);
        return conf;
    }

    protected static void setPhoenixRegionServerEndpoint(Configuration conf) {
        Object value = conf.get("hbase.coprocessor.regionserver.classes");
        value = value == null ? PhoenixRegionServerEndpointTestImpl.class.getName() : (String)value + "," + PhoenixRegionServerEndpointTestImpl.class.getName();
        conf.set("hbase.coprocessor.regionserver.classes", (String)value);
    }

    private static PhoenixTestDriver newTestDriver(ReadOnlyProps props) throws Exception {
        PhoenixTestDriver newDriver;
        String driverClassName = props.get(DRIVER_CLASS_NAME_ATTRIB);
        if (BaseTest.isDistributedClusterModeEnabled(config)) {
            HashMap<String, String> distPropMap = new HashMap<String, String>(1);
            distPropMap.put("phoenix.schema.dropMetaData", Boolean.TRUE.toString());
            props = new ReadOnlyProps(props, distPropMap.entrySet().iterator());
        }
        if (driverClassName == null) {
            newDriver = new PhoenixTestDriver(props);
        } else {
            Class<?> clazz = Class.forName(driverClassName);
            Constructor<?> constr = clazz.getConstructor(ReadOnlyProps.class);
            newDriver = (PhoenixTestDriver)((Object)constr.newInstance(props));
        }
        return newDriver;
    }

    public static synchronized PhoenixTestDriver initAndRegisterTestDriver(String url, ReadOnlyProps props) throws Exception {
        PhoenixTestDriver newDriver = BaseTest.newTestDriver(props);
        DriverManager.registerDriver((Driver)((Object)newDriver));
        Driver oldDriver = DriverManager.getDriver(url);
        if (oldDriver != newDriver) {
            BaseTest.destroyDriver(oldDriver);
        }
        Properties driverProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = newDriver.connect(url, driverProps);
        conn.close();
        return newDriver;
    }

    protected static synchronized boolean destroyDriver(Driver driver) {
        if (driver != null) {
            boolean bl;
            assert (driver instanceof PhoenixEmbeddedDriver);
            PhoenixEmbeddedDriver pdriver = (PhoenixEmbeddedDriver)driver;
            try {
                pdriver.close();
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    DriverManager.deregisterDriver(driver);
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to close registered driver: " + driver, (Throwable)e);
                }
            }
            DriverManager.deregisterDriver(driver);
            return bl;
        }
        return false;
    }

    protected static String getOrganizationId() {
        return ORG_ID;
    }

    public static synchronized long nextTimestamp() {
        return timestamp += 100L;
    }

    public static boolean twoDoubleEquals(double a, double b) {
        if (Double.isNaN(a) ^ Double.isNaN(b)) {
            return false;
        }
        if (Double.isNaN(a)) {
            return true;
        }
        if (Double.isInfinite(a) ^ Double.isInfinite(b)) {
            return false;
        }
        if (Double.isInfinite(a)) {
            return !(a > 0.0 ^ b > 0.0);
        }
        return Math.abs(a - b) <= 1.0E-9;
    }

    protected static void ensureTableCreated(String url, String tableName) throws SQLException {
        BaseTest.ensureTableCreated(url, tableName, tableName, null, null, null);
    }

    protected static void ensureTableCreated(String url, String tableName, String tableDDLType) throws SQLException {
        BaseTest.ensureTableCreated(url, tableName, tableDDLType, null, null, null);
    }

    public static void ensureTableCreated(String url, String tableName, String tableDDLType, byte[][] splits, String tableDDLOptions) throws SQLException {
        BaseTest.ensureTableCreated(url, tableName, tableDDLType, splits, null, tableDDLOptions);
    }

    protected static void ensureTableCreated(String url, String tableName, String tableDDLType, Long ts) throws SQLException {
        BaseTest.ensureTableCreated(url, tableName, tableDDLType, null, ts, null);
    }

    protected static void ensureTableCreated(String url, String tableName, String tableDDLType, byte[][] splits, Long ts, String tableDDLOptions) throws SQLException {
        Object ddl = tableDDLMap.get(tableDDLType);
        if (!tableDDLType.equals(tableName)) {
            ddl = ((String)ddl).replace(tableDDLType, tableName);
        }
        if (tableDDLOptions != null) {
            ddl = (String)ddl + tableDDLOptions;
        }
        BaseTest.createSchema(url, tableName, ts);
        BaseTest.createTestTable(url, (String)ddl, splits, ts);
    }

    protected ResultSet executeQuery(Connection conn, QueryBuilder queryBuilder) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(queryBuilder.build());
        ResultSet rs = statement.executeQuery();
        return rs;
    }

    public static String generateUniqueName() {
        int nextName = NAME_SUFFIX.incrementAndGet();
        if (nextName >= 1000000) {
            throw new IllegalStateException("Used up all unique names");
        }
        TABLE_COUNTER.incrementAndGet();
        return "N" + Integer.toString(1000000 + nextName).substring(1);
    }

    public static String generateUniqueSequenceName() {
        int nextName = SEQ_NAME_SUFFIX.incrementAndGet();
        if (nextName >= 1000000) {
            throw new IllegalStateException("Used up all unique sequence names");
        }
        SEQ_COUNTER.incrementAndGet();
        return "S" + Integer.toString(1000000 + nextName).substring(1);
    }

    public static void assertMetadata(Connection conn, PTable.ImmutableStorageScheme expectedStorageScheme, PTable.QualifierEncodingScheme expectedColumnEncoding, String tableName) throws Exception {
        PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
        PTable table = phxConn.getTableNoCache(tableName);
        Assert.assertEquals((Object)expectedStorageScheme, (Object)table.getImmutableStorageScheme());
        Assert.assertEquals((Object)expectedColumnEncoding, (Object)table.getEncodingScheme());
    }

    public static synchronized void freeResourcesIfBeyondThreshold() throws Exception {
        if (TABLE_COUNTER.get() > 30) {
            int numTables = TABLE_COUNTER.get();
            TABLE_COUNTER.set(0);
            if (BaseTest.isDistributedClusterModeEnabled(config)) {
                LOGGER.info("Deleting old tables on distributed cluster because number of tables is likely greater than {}", (Object)30);
                BaseTest.deletePriorMetaData(Long.MAX_VALUE, url);
            } else {
                LOGGER.info("Shutting down mini cluster because number of tables on this mini cluster is likely greater than {}", (Object)30);
                BaseTest.resetHbase();
            }
        }
    }

    protected static void createTestTable(String url, String ddl) throws SQLException {
        BaseTest.createTestTable(url, ddl, null, null);
    }

    protected static void createTestTable(String url, String ddl, byte[][] splits, Long ts) throws SQLException {
        BaseTest.createTestTable(url, ddl, splits, ts, true);
    }

    public static void createSchema(String url, String tableName, Long ts) throws SQLException {
        String schema = SchemaUtil.getSchemaNameFromFullName((String)tableName);
        if (!schema.equals("")) {
            Properties props = new Properties();
            if (ts != null) {
                props.setProperty("CurrentSCN", Long.toString(ts));
            }
            try (Connection conn = DriverManager.getConnection(url, props);){
                if (SchemaUtil.isNamespaceMappingEnabled(null, (ReadOnlyProps)conn.unwrap(PhoenixConnection.class).getQueryServices().getProps())) {
                    conn.createStatement().executeUpdate("CREATE SCHEMA IF NOT EXISTS " + schema);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void createTestTable(String url, String ddl, byte[][] splits, Long ts, boolean swallowTableAlreadyExistsException) throws SQLException {
        Assert.assertNotNull((Object)ddl);
        StringBuilder buf = new StringBuilder(ddl);
        if (splits != null) {
            buf.append(" SPLIT ON (");
            for (int i = 0; i < splits.length; ++i) {
                buf.append("'").append(Bytes.toString((byte[])splits[i])).append("'").append(",");
            }
            buf.setCharAt(buf.length() - 1, ')');
        }
        ddl = buf.toString();
        Properties props = new Properties();
        if (ts != null) {
            props.setProperty("CurrentSCN", Long.toString(ts));
        }
        try (Connection conn = DriverManager.getConnection(url, props);){
            conn.createStatement().execute(ddl);
        }
    }

    protected static byte[][] getDefaultSplits(String tenantId) {
        return new byte[][]{Bytes.toBytes((String)(tenantId + "00A")), Bytes.toBytes((String)(tenantId + "00B")), Bytes.toBytes((String)(tenantId + "00C"))};
    }

    private static void deletePriorSchemas(long ts, String url) throws Exception {
        ResultSet rs;
        DatabaseMetaData dbmd;
        Properties props = new Properties();
        props.put("phoenix.query.queueSize", Integer.toString(1024));
        if (ts != Long.MAX_VALUE) {
            props.setProperty("CurrentSCN", Long.toString(ts));
        }
        try (Connection conn = DriverManager.getConnection(url, props);){
            dbmd = conn.getMetaData();
            rs = dbmd.getSchemas();
            while (rs.next()) {
                String schemaName = rs.getString("TABLE_SCHEM");
                if (schemaName.equals("SYSTEM")) continue;
                schemaName = SchemaUtil.getEscapedArgument((String)schemaName);
                String ddl = "DROP SCHEMA " + schemaName;
                conn.createStatement().executeUpdate(ddl);
            }
            rs.close();
        }
        props.remove("CurrentSCN");
        try (Connection seeLatestConn = DriverManager.getConnection(url, props);){
            String schemaName;
            dbmd = seeLatestConn.getMetaData();
            rs = dbmd.getSchemas();
            boolean hasSchemas = rs.next();
            if (hasSchemas && (schemaName = rs.getString("TABLE_SCHEM")).equals("SYSTEM")) {
                hasSchemas = rs.next();
            }
            if (hasSchemas) {
                Assert.fail((String)("The following schemas are not dropped that should be:" + BaseTest.getSchemaNames(rs)));
            }
        }
    }

    protected static synchronized void deletePriorMetaData(long ts, String url) throws Exception {
        BaseTest.deletePriorTables(ts, url);
        if (ts != Long.MAX_VALUE) {
            ts = BaseTest.nextTimestamp() - 1L;
        }
        BaseTest.deletePriorSchemas(ts, url);
    }

    private static void deletePriorTables(long ts, String url) throws Exception {
        BaseTest.deletePriorTables(ts, (String)null, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deletePriorTables(long ts, String tenantId, String url) throws Exception {
        Properties props = new Properties();
        props.put("phoenix.query.queueSize", Integer.toString(1024));
        if (ts != Long.MAX_VALUE) {
            props.setProperty("CurrentSCN", Long.toString(ts));
        }
        try (Connection conn = DriverManager.getConnection(url, props);){
            BaseTest.deletePriorTables(ts, conn, url);
            BaseTest.deletePriorSequences(ts, conn);
            props.remove("CurrentSCN");
            try (Connection seeLatestConn = DriverManager.getConnection(url, props);){
                DatabaseMetaData dbmd = seeLatestConn.getMetaData();
                ResultSet rs = dbmd.getTables(null, null, null, new String[]{PTableType.VIEW.toString(), PTableType.TABLE.toString()});
                while (rs.next()) {
                    String fullTableName = SchemaUtil.getEscapedTableName((String)rs.getString("TABLE_SCHEM"), (String)rs.getString("TABLE_NAME"));
                    try {
                        conn.unwrap(PhoenixConnection.class).getTable(fullTableName);
                        Assert.fail((String)("The following tables are not deleted that should be:" + BaseTest.getTableNames(rs)));
                    }
                    catch (TableNotFoundException tableNotFoundException) {}
                }
            }
        }
    }

    private static void deletePriorTables(long ts, Connection globalConn, String url) throws Exception {
        DatabaseMetaData dbmd = globalConn.getMetaData();
        List<String[]> tableTypesList = Arrays.asList({PTableType.VIEW.toString()}, {PTableType.TABLE.toString()});
        for (String[] tableTypes : tableTypesList) {
            ResultSet rs = dbmd.getTables(null, null, null, tableTypes);
            String lastTenantId = null;
            Connection conn = globalConn;
            while (rs.next()) {
                String fullTableName = SchemaUtil.getEscapedTableName((String)rs.getString("TABLE_SCHEM"), (String)rs.getString("TABLE_NAME"));
                String ddl = "DROP " + rs.getString("TABLE_TYPE") + " " + fullTableName + "  CASCADE";
                String tenantId = rs.getString(1);
                if (tenantId != null && !tenantId.equals(lastTenantId)) {
                    if (lastTenantId != null) {
                        conn.close();
                    }
                    Properties props = PropertiesUtil.deepCopy((Properties)globalConn.getClientInfo());
                    props.setProperty("TenantId", tenantId);
                    conn = DriverManager.getConnection(url, props);
                    lastTenantId = tenantId;
                }
                try {
                    conn.createStatement().executeUpdate(ddl);
                }
                catch (NewerTableAlreadyExistsException ex) {
                    LOGGER.info("Newer table " + fullTableName + " or its delete marker exists. Ignore current deletion");
                }
                catch (TableNotFoundException ex) {
                    LOGGER.info("Table " + fullTableName + " is already deleted.");
                }
            }
            rs.close();
            if (lastTenantId == null) continue;
            conn.close();
        }
    }

    private static String getTableNames(ResultSet rs) throws SQLException {
        StringBuilder buf = new StringBuilder();
        do {
            buf.append(" ");
            buf.append(SchemaUtil.getTableName((String)rs.getString("TABLE_SCHEM"), (String)rs.getString("TABLE_NAME")));
        } while (rs.next());
        return buf.toString();
    }

    private static String getSchemaNames(ResultSet rs) throws SQLException {
        StringBuilder buf = new StringBuilder();
        do {
            buf.append(" ");
            buf.append(rs.getString("TABLE_SCHEM"));
        } while (rs.next());
        return buf.toString();
    }

    private static void deletePriorSequences(long ts, Connection globalConn) throws Exception {
        ResultSet rs = globalConn.createStatement().executeQuery("SELECT TENANT_ID,SEQUENCE_SCHEMA,SEQUENCE_NAME FROM SYSTEM.\"SEQUENCE\"");
        String lastTenantId = null;
        Connection conn = globalConn;
        while (rs.next()) {
            String tenantId = rs.getString(1);
            if (tenantId != null && !tenantId.equals(lastTenantId)) {
                if (lastTenantId != null) {
                    conn.close();
                }
                Properties props = new Properties(globalConn.getClientInfo());
                props.setProperty("TenantId", tenantId);
                conn = DriverManager.getConnection(url, props);
                lastTenantId = tenantId;
            }
            LOGGER.info("DROP SEQUENCE STATEMENT: DROP SEQUENCE " + SchemaUtil.getEscapedTableName((String)rs.getString(2), (String)rs.getString(3)));
            conn.createStatement().execute("DROP SEQUENCE " + SchemaUtil.getEscapedTableName((String)rs.getString(2), (String)rs.getString(3)));
        }
        rs.close();
    }

    protected static void initSumDoubleValues(byte[][] splits, String url) throws Exception {
        BaseTest.initSumDoubleValues("SumDoubleTest", splits, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initSumDoubleValues(String tableName, byte[][] splits, String url) throws Exception {
        BaseTest.ensureTableCreated(url, tableName, "SumDoubleTest", splits, null);
        Properties props = new Properties();
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + "(    id,     d,     f,     ud,     uf) VALUES (?, ?, ?, ?, ?)");
            stmt.setString(1, "1");
            stmt.setDouble(2, 0.001);
            stmt.setFloat(3, 0.01f);
            stmt.setDouble(4, 0.001);
            stmt.setFloat(5, 0.01f);
            stmt.execute();
            stmt.setString(1, "2");
            stmt.setDouble(2, 0.002);
            stmt.setFloat(3, 0.02f);
            stmt.setDouble(4, 0.002);
            stmt.setFloat(5, 0.02f);
            stmt.execute();
            stmt.setString(1, "3");
            stmt.setDouble(2, 0.003);
            stmt.setFloat(3, 0.03f);
            stmt.setDouble(4, 0.003);
            stmt.setFloat(5, 0.03f);
            stmt.execute();
            stmt.setString(1, "4");
            stmt.setDouble(2, 0.004);
            stmt.setFloat(3, 0.04f);
            stmt.setDouble(4, 0.004);
            stmt.setFloat(5, 0.04f);
            stmt.execute();
            stmt.setString(1, "5");
            stmt.setDouble(2, 0.005);
            stmt.setFloat(3, 0.05f);
            stmt.setDouble(4, 0.005);
            stmt.setFloat(5, 0.05f);
            stmt.execute();
            conn.commit();
        }
    }

    protected static String initATableValues(String tenantId, byte[][] splits) throws Exception {
        return BaseTest.initATableValues(tenantId, splits, null, null, BaseTest.getUrl());
    }

    protected static String initATableValues(String tenantId, byte[][] splits, Date date, Long ts) throws Exception {
        return BaseTest.initATableValues(tenantId, splits, date, ts, BaseTest.getUrl());
    }

    protected static String initATableValues(String tenantId, byte[][] splits, String url) throws Exception {
        return BaseTest.initATableValues(tenantId, splits, null, url);
    }

    protected static String initATableValues(String tenantId, byte[][] splits, Date date, String url) throws Exception {
        return BaseTest.initATableValues(tenantId, splits, date, null, url);
    }

    protected static String initATableValues(String tenantId, byte[][] splits, Date date, Long ts, String url) throws Exception {
        return BaseTest.initATableValues(null, tenantId, splits, date, ts, url, null);
    }

    protected static String initATableValues(String tenantId, byte[][] splits, Date date, Long ts, String url, String tableDDLOptions) throws Exception {
        return BaseTest.initATableValues(null, tenantId, splits, date, ts, url, tableDDLOptions);
    }

    protected static String initATableValues(String tableName, String tenantId, byte[][] splits, Date date, Long ts, String url, String tableDDLOptions) throws Exception {
        if (tableName == null) {
            tableName = BaseTest.generateUniqueName();
        }
        String tableDDLType = "ATABLE";
        if (ts == null) {
            BaseTest.ensureTableCreated(url, tableName, tableDDLType, splits, null, tableDDLOptions);
        } else {
            BaseTest.ensureTableCreated(url, tableName, tableDDLType, splits, ts - 5L, tableDDLOptions);
        }
        Properties props = new Properties();
        if (ts != null) {
            props.setProperty("CurrentSCN", Long.toString(ts - 3L));
        }
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + "(    ORGANIZATION_ID,     ENTITY_ID,     A_STRING,     B_STRING,     A_INTEGER,     A_DATE,     X_DECIMAL,     X_LONG,     X_INTEGER,    Y_INTEGER,    A_BYTE,    A_SHORT,    A_FLOAT,    A_DOUBLE,    A_UNSIGNED_FLOAT,    A_UNSIGNED_DOUBLE)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            stmt.setString(1, tenantId);
            stmt.setString(2, "00A123122312312");
            stmt.setString(3, "a");
            stmt.setString(4, "b");
            stmt.setInt(5, 1);
            stmt.setDate(6, date);
            stmt.setBigDecimal(7, null);
            stmt.setNull(8, -5);
            stmt.setNull(9, 4);
            stmt.setNull(10, 4);
            stmt.setByte(11, (byte)1);
            stmt.setShort(12, (short)128);
            stmt.setFloat(13, 0.01f);
            stmt.setDouble(14, 1.0E-4);
            stmt.setFloat(15, 0.01f);
            stmt.setDouble(16, 1.0E-4);
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "00A223122312312");
            stmt.setString(3, "a");
            stmt.setString(4, "c");
            stmt.setInt(5, 2);
            stmt.setDate(6, date == null ? null : new Date(date.getTime() + 86400000L));
            stmt.setBigDecimal(7, null);
            stmt.setNull(8, -5);
            stmt.setNull(9, 4);
            stmt.setNull(10, 4);
            stmt.setByte(11, (byte)2);
            stmt.setShort(12, (short)129);
            stmt.setFloat(13, 0.02f);
            stmt.setDouble(14, 2.0E-4);
            stmt.setFloat(15, 0.02f);
            stmt.setDouble(16, 2.0E-4);
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "00A323122312312");
            stmt.setString(3, "a");
            stmt.setString(4, "e");
            stmt.setInt(5, 3);
            stmt.setDate(6, date == null ? null : new Date(date.getTime() + 172800000L));
            stmt.setBigDecimal(7, null);
            stmt.setNull(8, -5);
            stmt.setNull(9, 4);
            stmt.setNull(10, 4);
            stmt.setByte(11, (byte)3);
            stmt.setShort(12, (short)130);
            stmt.setFloat(13, 0.03f);
            stmt.setDouble(14, 3.0E-4);
            stmt.setFloat(15, 0.03f);
            stmt.setDouble(16, 3.0E-4);
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "00A423122312312");
            stmt.setString(3, "a");
            stmt.setString(4, "b");
            stmt.setInt(5, 4);
            stmt.setDate(6, date == null ? null : date);
            stmt.setBigDecimal(7, null);
            stmt.setNull(8, -5);
            stmt.setNull(9, 4);
            stmt.setNull(10, 4);
            stmt.setByte(11, (byte)4);
            stmt.setShort(12, (short)131);
            stmt.setFloat(13, 0.04f);
            stmt.setDouble(14, 4.0E-4);
            stmt.setFloat(15, 0.04f);
            stmt.setDouble(16, 4.0E-4);
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "00B523122312312");
            stmt.setString(3, "b");
            stmt.setString(4, "c");
            stmt.setInt(5, 5);
            stmt.setDate(6, date == null ? null : new Date(date.getTime() + 86400000L));
            stmt.setBigDecimal(7, null);
            stmt.setNull(8, -5);
            stmt.setNull(9, 4);
            stmt.setNull(10, 4);
            stmt.setByte(11, (byte)5);
            stmt.setShort(12, (short)132);
            stmt.setFloat(13, 0.05f);
            stmt.setDouble(14, 5.0E-4);
            stmt.setFloat(15, 0.05f);
            stmt.setDouble(16, 5.0E-4);
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "00B623122312312");
            stmt.setString(3, "b");
            stmt.setString(4, "e");
            stmt.setInt(5, 6);
            stmt.setDate(6, date == null ? null : new Date(date.getTime() + 172800000L));
            stmt.setBigDecimal(7, null);
            stmt.setNull(8, -5);
            stmt.setNull(9, 4);
            stmt.setNull(10, 4);
            stmt.setByte(11, (byte)6);
            stmt.setShort(12, (short)133);
            stmt.setFloat(13, 0.06f);
            stmt.setDouble(14, 6.0E-4);
            stmt.setFloat(15, 0.06f);
            stmt.setDouble(16, 6.0E-4);
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "00B723122312312");
            stmt.setString(3, "b");
            stmt.setString(4, "b");
            stmt.setInt(5, 7);
            stmt.setDate(6, date == null ? null : date);
            stmt.setBigDecimal(7, BigDecimal.valueOf(0.1));
            stmt.setLong(8, 5L);
            stmt.setInt(9, 5);
            stmt.setNull(10, 4);
            stmt.setByte(11, (byte)7);
            stmt.setShort(12, (short)134);
            stmt.setFloat(13, 0.07f);
            stmt.setDouble(14, 7.0E-4);
            stmt.setFloat(15, 0.07f);
            stmt.setDouble(16, 7.0E-4);
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "00B823122312312");
            stmt.setString(3, "b");
            stmt.setString(4, "c");
            stmt.setInt(5, 8);
            stmt.setDate(6, date == null ? null : new Date(date.getTime() + 86400000L));
            stmt.setBigDecimal(7, BigDecimal.valueOf(3.9));
            long l = -2147483649L;
            assert (l < Integer.MIN_VALUE);
            stmt.setLong(8, l);
            stmt.setInt(9, 4);
            stmt.setNull(10, 4);
            stmt.setByte(11, (byte)8);
            stmt.setShort(12, (short)135);
            stmt.setFloat(13, 0.08f);
            stmt.setDouble(14, 8.0E-4);
            stmt.setFloat(15, 0.08f);
            stmt.setDouble(16, 8.0E-4);
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "00C923122312312");
            stmt.setString(3, "c");
            stmt.setString(4, "e");
            stmt.setInt(5, 9);
            stmt.setDate(6, date == null ? null : new Date(date.getTime() + 172800000L));
            stmt.setBigDecimal(7, BigDecimal.valueOf(3.3));
            l = 0x80000000L;
            assert (l > Integer.MAX_VALUE);
            stmt.setLong(8, l);
            stmt.setInt(9, 3);
            stmt.setInt(10, 300);
            stmt.setByte(11, (byte)9);
            stmt.setShort(12, (short)0);
            stmt.setFloat(13, 0.09f);
            stmt.setDouble(14, 9.0E-4);
            stmt.setFloat(15, 0.09f);
            stmt.setDouble(16, 9.0E-4);
            stmt.execute();
            conn.commit();
        }
        return tableName;
    }

    protected static String initEntityHistoryTableValues(String tenantId, byte[][] splits, Date date, Long ts) throws Exception {
        return BaseTest.initEntityHistoryTableValues("ENTITY_HISTORY", tenantId, splits, date, ts, BaseTest.getUrl());
    }

    protected static String initEntityHistoryTableValues(String tableName, String tenantId, byte[][] splits, Date date, Long ts) throws Exception {
        return BaseTest.initEntityHistoryTableValues(tableName, tenantId, splits, date, ts, BaseTest.getUrl());
    }

    protected static String initSaltedEntityHistoryTableValues(String tableName, String tenantId, byte[][] splits, Date date, Long ts) throws Exception {
        return BaseTest.initSaltedEntityHistoryTableValues(tableName, tenantId, splits, date, ts, BaseTest.getUrl());
    }

    protected static String initEntityHistoryTableValues(String tableName, String tenantId, byte[][] splits, String url) throws Exception {
        return BaseTest.initEntityHistoryTableValues(tableName, tenantId, splits, null, null, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String initEntityHistoryTableValues(String tableName, String tenantId, byte[][] splits, Date date, Long ts, String url) throws Exception {
        if (tableName == null) {
            tableName = BaseTest.generateUniqueName();
        }
        if (ts == null) {
            BaseTest.ensureTableCreated(url, tableName, "ENTITY_HISTORY", splits, null);
        } else {
            BaseTest.ensureTableCreated(url, tableName, "ENTITY_HISTORY", splits, ts - 2L, null);
        }
        Properties props = new Properties();
        if (ts != null) {
            props.setProperty("CurrentSCN", ts.toString());
        }
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + "(    ORGANIZATION_ID,     PARENT_ID,     CREATED_DATE,     ENTITY_HISTORY_ID,     OLD_VALUE,     NEW_VALUE) VALUES (?, ?, ?, ?, ?, ?)");
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000001");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000001");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000002");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000002");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000003");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000003");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000004");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000004");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000005");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000005");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000006");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000006");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000007");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000007");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000008");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000008");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000009");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000009");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            conn.commit();
        }
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String initSaltedEntityHistoryTableValues(String tableName, String tenantId, byte[][] splits, Date date, Long ts, String url) throws Exception {
        if (tableName == null) {
            tableName = BaseTest.generateUniqueName();
        }
        if (ts == null) {
            BaseTest.ensureTableCreated(url, tableName, "ENTITY_HISTORY_SALTED", splits, null);
        } else {
            BaseTest.ensureTableCreated(url, tableName, "ENTITY_HISTORY_SALTED", splits, ts - 2L, null);
        }
        Properties props = new Properties();
        if (ts != null) {
            props.setProperty("CurrentSCN", ts.toString());
        }
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + "(    ORGANIZATION_ID,     PARENT_ID,     CREATED_DATE,     ENTITY_HISTORY_ID,     OLD_VALUE,     NEW_VALUE) VALUES (?, ?, ?, ?, ?, ?)");
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000001");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000001");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000002");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000002");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000003");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000003");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000004");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000004");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000005");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000005");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000006");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000006");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000007");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000007");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000008");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000008");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "0500x0000000009");
            stmt.setDate(3, date);
            stmt.setString(4, "017x00000000009");
            stmt.setString(5, "a");
            stmt.setString(6, "b");
            stmt.execute();
            conn.commit();
        }
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void disableAndDropNonSystemTables() throws Exception {
        if (driver == null) {
            return;
        }
        try (Admin admin = driver.getConnectionQueryServices(BaseTest.getUrl(), new Properties()).getAdmin();){
            List tables = admin.listTableDescriptors();
            for (TableDescriptor table : tables) {
                String schemaName = SchemaUtil.getSchemaNameFromFullName((byte[])table.getTableName().getName());
                if ("SYSTEM".equals(schemaName)) continue;
                BaseTest.disableAndDropTable(admin, table.getTableName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void disableAndDropTable(final Admin admin, final TableName tableName) throws Exception {
        Future<Void> future = null;
        boolean success = false;
        try {
            try {
                future = dropHTableService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (admin.isTableEnabled(tableName)) {
                            admin.disableTable(tableName);
                            admin.deleteTable(tableName);
                        }
                        return null;
                    }
                });
                future.get(120L, TimeUnit.SECONDS);
                success = true;
            }
            catch (TimeoutException e) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setMessage("Not able to disable and delete table " + tableName.getNameAsString() + " in 120 seconds.").build().buildException();
            }
            catch (Exception e) {
                throw e;
            }
        }
        finally {
            if (future != null && !success) {
                future.cancel(true);
            }
        }
    }

    private static synchronized void disableAndDropAllTables() throws IOException {
        long startTime = System.currentTimeMillis();
        long deadline = System.currentTimeMillis() + 900000L;
        final Admin admin = utility.getAdmin();
        List tableDescriptors = admin.listTableDescriptors();
        int tableCount = tableDescriptors.size();
        while (!(tableDescriptors = admin.listTableDescriptors()).isEmpty()) {
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            ExecutorService dropHTableExecutor = Executors.newFixedThreadPool(10, factory);
            for (final TableDescriptor tableDescriptor : tableDescriptors) {
                futures.add(dropHTableExecutor.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        TableName tableName = tableDescriptor.getTableName();
                        String table = tableName.toString();
                        Future disableFuture = null;
                        try {
                            LOGGER.info("Calling disable table on: {} ", (Object)table);
                            disableFuture = admin.disableTableAsync(tableName);
                            disableFuture.get(120L, TimeUnit.SECONDS);
                            LOGGER.info("Table disabled: {}", (Object)table);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Could not disable table {}", (Object)table, (Object)e);
                            try {
                                disableFuture.cancel(true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        Future deleteFuture = null;
                        try {
                            LOGGER.info("Calling delete table on: {}", (Object)table);
                            deleteFuture = admin.deleteTableAsync(tableName);
                            deleteFuture.get(120L, TimeUnit.SECONDS);
                            LOGGER.info("Table deleted: {}", (Object)table);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Could not delete table {}", (Object)table, (Object)e);
                            try {
                                deleteFuture.cancel(true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                }));
            }
            try {
                dropHTableExecutor.shutdown();
                dropHTableExecutor.awaitTermination(600L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.error("dropHTableExecutor didn't shut down in 10 minutes, calling shutdownNow()");
                dropHTableExecutor.shutdownNow();
            }
            if (System.currentTimeMillis() <= deadline) continue;
            LOGGER.error("Could not clean up HBase tables in 15 minutes, killing JVM");
            System.exit(-1);
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("Disabled and dropped {} tables in {} ms", (Object)tableCount, (Object)(endTime - startTime));
    }

    public static void assertOneOfValuesEqualsResultSet(ResultSet rs, List<List<Object>> ... expectedResultsArray) throws SQLException {
        ArrayList results = Lists.newArrayList();
        while (rs.next()) {
            ArrayList result = Lists.newArrayList();
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                result.add(rs.getObject(i + 1));
            }
            results.add(result);
        }
        for (int j = 0; j < expectedResultsArray.length; ++j) {
            List<List<Object>> expectedResults = expectedResultsArray[j];
            HashSet expectedResultsSet = Sets.newHashSet(expectedResults);
            Iterator iterator = results.iterator();
            while (iterator.hasNext()) {
                if (!expectedResultsSet.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
        if (results.isEmpty()) {
            return;
        }
        Assert.fail((String)("Unable to find " + results + " in " + Arrays.asList(expectedResultsArray)));
    }

    protected void assertValueEqualsResultSet(ResultSet rs, List<Object> expectedResults) throws SQLException {
        ArrayList nestedExpectedResults = Lists.newArrayListWithExpectedSize((int)expectedResults.size());
        for (Object expectedResult : expectedResults) {
            nestedExpectedResults.add(Arrays.asList(expectedResult));
        }
        BaseTest.assertValuesEqualsResultSet(rs, nestedExpectedResults);
    }

    public static void assertValuesEqualsResultSet(ResultSet rs, List<List<Object>> expectedResults) throws SQLException {
        int expectedCount = expectedResults.size();
        int count = 0;
        ArrayList actualResults = Lists.newArrayList();
        ArrayList errorResult = null;
        while (rs.next() && errorResult == null) {
            ArrayList result = Lists.newArrayList();
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                result.add(rs.getObject(i + 1));
            }
            if (!expectedResults.contains(result)) {
                errorResult = result;
            }
            actualResults.add(result);
            ++count;
        }
        Assert.assertTrue((String)("Could not find " + errorResult + " in expected results: " + expectedResults + " with actual results: " + actualResults), (errorResult == null ? 1 : 0) != 0);
        Assert.assertEquals((long)expectedCount, (long)count);
    }

    public static HBaseTestingUtility getUtility() {
        return utility;
    }

    public static void upsertRows(Connection conn, String fullTableName, int numRows) throws SQLException {
        for (int i = 1; i <= numRows; ++i) {
            BaseTest.upsertRow(conn, fullTableName, i, false);
        }
    }

    public static void upsertRow(Connection conn, String fullTableName, int index, boolean firstRowInBatch) throws SQLException {
        String upsert = "UPSERT INTO " + fullTableName + " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = conn.prepareStatement(upsert);
        stmt.setString(1, (String)(firstRowInBatch ? "firstRowInBatch_" : "varchar" + index));
        stmt.setString(2, "char" + index);
        stmt.setInt(3, index);
        stmt.setLong(4, index);
        stmt.setBigDecimal(5, new BigDecimal(index));
        Date date = DateUtil.parseDate((String)"2015-01-01 00:00:00");
        stmt.setDate(6, date);
        stmt.setString(7, "varchar_a");
        stmt.setString(8, "chara");
        stmt.setInt(9, index + 1);
        stmt.setLong(10, index + 1);
        stmt.setBigDecimal(11, new BigDecimal(index + 1));
        stmt.setDate(12, date);
        stmt.setString(13, "varchar_b");
        stmt.setString(14, "charb");
        stmt.setInt(15, index + 2);
        stmt.setLong(16, index + 2);
        stmt.setBigDecimal(17, new BigDecimal(index + 2));
        stmt.setDate(18, date);
        stmt.executeUpdate();
    }

    public static synchronized void populateTestTable(String fullTableName) throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseTest.getUrl(), props);){
            BaseTest.upsertRows(conn, fullTableName, 3);
            conn.commit();
        }
    }

    protected static void populateMultiCFTestTable(String tableName) throws SQLException {
        BaseTest.populateMultiCFTestTable(tableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void populateMultiCFTestTable(String tableName, Date date) throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseTest.getUrl(), props);){
            String upsert = "UPSERT INTO " + tableName + " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = conn.prepareStatement(upsert);
            stmt.setString(1, "varchar1");
            stmt.setString(2, "char1");
            stmt.setInt(3, 1);
            stmt.setLong(4, 1L);
            stmt.setBigDecimal(5, new BigDecimal("1.1"));
            stmt.setString(6, "varchar_a");
            stmt.setString(7, "chara");
            stmt.setInt(8, 2);
            stmt.setLong(9, 2L);
            stmt.setBigDecimal(10, new BigDecimal("2.1"));
            stmt.setString(11, "varchar_b");
            stmt.setString(12, "charb");
            stmt.setInt(13, 3);
            stmt.setLong(14, 3L);
            stmt.setBigDecimal(15, new BigDecimal("3.1"));
            stmt.setDate(16, date == null ? null : new Date(date.getTime() + 86400000L));
            stmt.executeUpdate();
            stmt.setString(1, "varchar2");
            stmt.setString(2, "char2");
            stmt.setInt(3, 2);
            stmt.setLong(4, 2L);
            stmt.setBigDecimal(5, new BigDecimal("2.2"));
            stmt.setString(6, "varchar_a");
            stmt.setString(7, "chara");
            stmt.setInt(8, 3);
            stmt.setLong(9, 3L);
            stmt.setBigDecimal(10, new BigDecimal("3.2"));
            stmt.setString(11, "varchar_b");
            stmt.setString(12, "charb");
            stmt.setInt(13, 4);
            stmt.setLong(14, 4L);
            stmt.setBigDecimal(15, new BigDecimal("4.2"));
            stmt.setDate(16, date);
            stmt.executeUpdate();
            stmt.setString(1, "varchar3");
            stmt.setString(2, "char3");
            stmt.setInt(3, 3);
            stmt.setLong(4, 3L);
            stmt.setBigDecimal(5, new BigDecimal("3.3"));
            stmt.setString(6, "varchar_a");
            stmt.setString(7, "chara");
            stmt.setInt(8, 4);
            stmt.setLong(9, 4L);
            stmt.setBigDecimal(10, new BigDecimal("4.3"));
            stmt.setString(11, "varchar_b");
            stmt.setString(12, "charb");
            stmt.setInt(13, 5);
            stmt.setLong(14, 5L);
            stmt.setBigDecimal(15, new BigDecimal("5.3"));
            stmt.setDate(16, date == null ? null : new Date(date.getTime() + 172800000L));
            stmt.executeUpdate();
            conn.commit();
        }
    }

    protected static void verifySequenceNotExists(String tenantID, String sequenceName, String sequenceSchemaName) throws SQLException {
        BaseTest.verifySequence(tenantID, sequenceName, sequenceSchemaName, false, 0L);
    }

    protected static void verifySequenceValue(String tenantID, String sequenceName, String sequenceSchemaName, long value) throws SQLException {
        BaseTest.verifySequence(tenantID, sequenceName, sequenceSchemaName, true, value);
    }

    private static void verifySequence(String tenantID, String sequenceName, String sequenceSchemaName, boolean exists, long value) throws SQLException {
        PhoenixConnection phxConn = DriverManager.getConnection(BaseTest.getUrl()).unwrap(PhoenixConnection.class);
        Object ddl = "SELECT TENANT_ID,SEQUENCE_SCHEMA,SEQUENCE_NAME,CURRENT_VALUE FROM SYSTEM.\"SEQUENCE\" WHERE ";
        ddl = (String)ddl + " TENANT_ID  " + (String)(tenantID == null ? "IS NULL " : " = '" + tenantID + "'");
        ddl = (String)ddl + " AND SEQUENCE_NAME " + (String)(sequenceName == null ? "IS NULL " : " = '" + sequenceName + "'");
        ddl = (String)ddl + " AND SEQUENCE_SCHEMA " + (String)(sequenceSchemaName == null ? "IS NULL " : " = '" + sequenceSchemaName + "'");
        ResultSet rs = phxConn.createStatement().executeQuery((String)ddl);
        if (exists) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)value, (long)rs.getLong(4));
        } else {
            Assert.assertFalse((boolean)rs.next());
        }
        phxConn.close();
    }

    protected static void splitTableSync(Admin admin, TableName hbaseTableName, byte[] splitPoint, int expectedRegions) throws IOException, InterruptedException {
        admin.split(hbaseTableName, splitPoint);
        for (int i = 0; i < 30; ++i) {
            List regions = BaseTest.getUtility().getHBaseCluster().getRegions(hbaseTableName);
            if (regions.size() >= expectedRegions) {
                boolean splitSuccessful = true;
                for (HRegion region : regions) {
                    if (region.isSplittable()) continue;
                    splitSuccessful = false;
                }
                if (splitSuccessful) {
                    return;
                }
            }
            LOGGER.info("Sleeping for 1000 ms while waiting for {} to split and all regions to come online", (Object)hbaseTableName.getNameAsString());
            Thread.sleep(1000L);
        }
        throw new IOException("Split did not succeed for table: " + hbaseTableName.getNameAsString() + " , expected regions after split: " + expectedRegions);
    }

    protected static boolean regionContainsMetadataRows(RegionInfo regionInfo, List<byte[]> metadataRowKeys) {
        for (byte[] rowKey : metadataRowKeys) {
            if (!regionInfo.containsRow(rowKey)) continue;
            return true;
        }
        return false;
    }

    protected static void splitTable(TableName fullTableName, List<byte[]> splitPoints) throws Exception {
        Admin admin = driver.getConnectionQueryServices(BaseTest.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
        Assert.assertTrue((String)"Needs at least two split points ", (splitPoints.size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Number of split points should be less than or equal to the number of region servers ", (splitPoints.size() <= NUM_SLAVES_BASE ? 1 : 0) != 0);
        HBaseTestingUtility util = BaseTest.getUtility();
        MiniHBaseCluster cluster = util.getHBaseCluster();
        HMaster master = cluster.getMaster();
        Assert.assertFalse((String)"Balancer must be off", (boolean)master.isBalancerOn());
        AssignmentManager am = master.getAssignmentManager();
        for (int i = 1; i < splitPoints.size(); ++i) {
            BaseTest.splitTableSync(admin, fullTableName, splitPoints.get(i), i + 1);
        }
        List regionInfoList = admin.getRegions(fullTableName);
        Assert.assertEquals((long)splitPoints.size(), (long)regionInfoList.size());
        HashMap serverToRegionsList = Maps.newHashMapWithExpectedSize((int)NUM_SLAVES_BASE);
        ArrayDeque<ServerName> availableRegionServers = new ArrayDeque<ServerName>(NUM_SLAVES_BASE);
        for (int i = 0; i < NUM_SLAVES_BASE; ++i) {
            availableRegionServers.push(util.getHBaseCluster().getRegionServer(i).getServerName());
        }
        List tableRegions = admin.getRegions(fullTableName);
        for (RegionInfo regionInfo : tableRegions) {
            if (!BaseTest.regionContainsMetadataRows(regionInfo, splitPoints)) continue;
            ServerName serverName = am.getRegionStates().getRegionServerOfRegion(regionInfo);
            if (!serverToRegionsList.containsKey(serverName)) {
                serverToRegionsList.put(serverName, new ArrayList());
            }
            ((List)serverToRegionsList.get(serverName)).add(regionInfo);
            availableRegionServers.remove(serverName);
        }
        Assert.assertFalse((String)"No region servers available to move regions on to ", (boolean)availableRegionServers.isEmpty());
        for (Map.Entry entry : serverToRegionsList.entrySet()) {
            List regions = (List)entry.getValue();
            if (regions.size() <= 1) continue;
            for (int i = 1; i < regions.size(); ++i) {
                BaseTest.moveRegion((RegionInfo)regions.get(i), (ServerName)entry.getKey(), (ServerName)availableRegionServers.pop());
            }
        }
        tableRegions = admin.getRegions(fullTableName);
        HashSet serverNames = Sets.newHashSet();
        for (RegionInfo regionInfo : tableRegions) {
            if (!BaseTest.regionContainsMetadataRows(regionInfo, splitPoints)) continue;
            ServerName serverName = am.getRegionStates().getRegionServerOfRegion(regionInfo);
            if (!serverNames.contains(serverName)) {
                serverNames.add(serverName);
                continue;
            }
            Assert.fail((String)("Multiple regions on " + serverName.getServerName()));
        }
    }

    protected static void splitSystemCatalog(Map<String, List<String>> tenantToTableAndViewMap) throws Exception {
        ArrayList splitPoints = Lists.newArrayListWithExpectedSize((int)5);
        HashSet schemaNameSet = Sets.newHashSetWithExpectedSize((int)15);
        for (Map.Entry<String, List<String>> entrySet : tenantToTableAndViewMap.entrySet()) {
            String tenantId = entrySet.getKey();
            for (String fullName : entrySet.getValue()) {
                String schemaName = SchemaUtil.getSchemaNameFromFullName((String)fullName);
                Assert.assertTrue((String)"Schema names of tables/view must be unique ", (boolean)schemaNameSet.add(tenantId + "." + schemaName));
                String tableName = SchemaUtil.getTableNameFromFullName((String)fullName);
                splitPoints.add(SchemaUtil.getTableKey((String)tenantId, (String)("".equals(schemaName) ? null : schemaName), (String)tableName));
            }
        }
        Collections.sort(splitPoints, Bytes.BYTES_COMPARATOR);
        BaseTest.splitTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME, splitPoints);
    }

    private static void moveRegion(RegionInfo regionInfo, ServerName srcServerName, ServerName dstServerName) throws Exception {
        Admin admin = driver.getConnectionQueryServices(BaseTest.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
        HBaseTestingUtility util = BaseTest.getUtility();
        MiniHBaseCluster cluster = util.getHBaseCluster();
        HMaster master = cluster.getMaster();
        AssignmentManager am = master.getAssignmentManager();
        HRegionServer dstServer = util.getHBaseCluster().getRegionServer(dstServerName);
        HRegionServer srcServer = util.getHBaseCluster().getRegionServer(srcServerName);
        byte[] encodedRegionNameInBytes = regionInfo.getEncodedNameAsBytes();
        admin.move(encodedRegionNameInBytes, dstServer.getServerName());
        while (dstServer.getOnlineRegion(regionInfo.getRegionName()) == null || dstServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameInBytes) || srcServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameInBytes)) {
            Thread.sleep(100L);
        }
    }

    protected static void unassignRegionAsync(final String tableName) throws IOException {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Admin admin = utility.getAdmin();
                    RegionInfo tableRegion = (RegionInfo)admin.getRegions(TableName.valueOf((String)tableName)).get(0);
                    admin.unassign(tableRegion.getEncodedNameAsBytes(), false);
                    admin.assign(tableRegion.getEncodedNameAsBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    protected static synchronized boolean isAnyStoreRefCountLeaked() throws IOException {
        if (BaseTest.getUtility() != null) {
            return BaseTest.isAnyStoreRefCountLeaked(BaseTest.getUtility().getAdmin());
        }
        return false;
    }

    public static synchronized boolean isAnyStoreRefCountLeaked(Admin admin) throws IOException {
        for (int retries = 5; retries > 0; --retries) {
            boolean isStoreRefCountLeaked = BaseTest.isStoreRefCountLeaked(admin);
            if (!isStoreRefCountLeaked) {
                return false;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted while sleeping", (Throwable)e);
                break;
            }
        }
        return true;
    }

    private static boolean isStoreRefCountLeaked(Admin admin) throws IOException {
        for (ServerName serverName : admin.getRegionServers()) {
            for (RegionMetrics regionMetrics : admin.getRegionMetrics(serverName)) {
                int regionTotalRefCount;
                if (regionMetrics.getNameAsString().contains(TableName.META_TABLE_NAME.getNameAsString()) || (regionTotalRefCount = regionMetrics.getStoreRefCount()) <= 0) continue;
                LOGGER.error("Region {} has refCount leak. Total refCount of all storeFiles combined for the region: {}", (Object)regionMetrics.getNameAsString(), (Object)regionTotalRefCount);
                return true;
            }
        }
        return false;
    }

    public static ThreadPoolExecutor extractThreadPoolExecutorFromCQSI(ConnectionQueryServices cqs) throws NoSuchFieldException, IllegalAccessException {
        Field props = cqs.getClass().getDeclaredField("threadPoolExecutor");
        props.setAccessible(true);
        return (ThreadPoolExecutor)props.get(cqs);
    }

    static {
        LOGGER = LoggerFactory.getLogger(BaseTest.class);
        tmpFolder = new TemporaryFolder();
        factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DROP-TABLE-BASETEST-thread-%s").build();
        dropHTableService = Executors.newSingleThreadExecutor(factory);
        SYSTEM_EXIT_RULE = new SystemExitRule();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"ENTITY_HISTORY", (Object)"create table ENTITY_HISTORY   (organization_id char(15) not null,\n    parent_id char(15) not null,\n    created_date date not null,\n    entity_history_id char(15) not null,\n    old_value varchar,\n    new_value varchar,\n    CONSTRAINT pk PRIMARY KEY (organization_id, parent_id, created_date, entity_history_id)\n)");
        builder.put((Object)"ENTITY_HISTORY_SALTED", (Object)"create table ENTITY_HISTORY_SALTED   (organization_id char(15) not null,\n    parent_id char(15) not null,\n    created_date date not null,\n    entity_history_id char(15) not null,\n    old_value varchar,\n    new_value varchar\n    CONSTRAINT pk PRIMARY KEY (organization_id, parent_id, created_date, entity_history_id))\n    SALT_BUCKETS = 4");
        builder.put((Object)"ATABLE", (Object)"create table ATABLE   (organization_id char(15) not null, \n    entity_id char(15) not null,\n    a_string varchar(100),\n    b_string varchar(100),\n    a_integer integer,\n    a_date date,\n    a_time time,\n    a_timestamp timestamp,\n    x_decimal decimal(31,10),\n    x_long bigint,\n    x_integer integer,\n    y_integer integer,\n    a_byte tinyint,\n    a_short smallint,\n    a_float float,\n    a_double double,\n    a_unsigned_float unsigned_float,\n    a_unsigned_double unsigned_double\n    CONSTRAINT pk PRIMARY KEY (organization_id, entity_id)\n) ");
        builder.put((Object)"TABLE_WITH_ARRAY", (Object)"create table TABLE_WITH_ARRAY   (organization_id char(15) not null, \n    entity_id char(15) not null,\n    a_string_array varchar(100) array[],\n    b_string varchar(100),\n    a_integer integer,\n    a_date date,\n    a_time time,\n    a_timestamp timestamp,\n    x_decimal decimal(31,10),\n    x_long_array bigint array[],\n    x_integer integer,\n    a_byte_array tinyint array[],\n    a_short smallint,\n    a_float float,\n    a_double_array double array[],\n    a_unsigned_float unsigned_float,\n    a_unsigned_double unsigned_double \n    CONSTRAINT pk PRIMARY KEY (organization_id, entity_id)\n)");
        builder.put((Object)"BTABLE", (Object)"create table BTABLE   (a_string varchar not null, \n    a_id char(3) not null,\n    b_string varchar not null, \n    a_integer integer not null, \n    c_string varchar(2) null,\n    b_integer integer,\n    c_integer integer,\n    d_string varchar(3),\n    e_string char(10)\n    CONSTRAINT my_pk PRIMARY KEY (a_string,a_id,b_string,a_integer,c_string))");
        builder.put((Object)"TABLE_WITH_SALTING", (Object)"create table TABLE_WITH_SALTING   (a_integer integer not null, \n    a_string varchar not null, \n    a_id char(3) not null,\n    b_string varchar, \n    b_integer integer \n    CONSTRAINT pk PRIMARY KEY (a_integer, a_string, a_id))\n    SALT_BUCKETS = 4");
        builder.put((Object)"STABLE", (Object)"create table STABLE   (id char(1) not null primary key,\n    \"value\" integer)");
        builder.put((Object)"PTSDB", (Object)"create table PTSDB   (inst varchar null,\n    host varchar null,\n    date date not null,\n    val decimal(31,10)\n    CONSTRAINT pk PRIMARY KEY (inst, host, date))");
        builder.put((Object)"PTSDB2", (Object)"create table PTSDB2   (inst varchar(10) not null,\n    date date not null,\n    val1 decimal,\n    val2 decimal(31,10),\n    val3 decimal\n    CONSTRAINT pk PRIMARY KEY (inst, date))");
        builder.put((Object)"PTSDB3", (Object)"create table PTSDB3   (host varchar(10) not null,\n    date date not null,\n    val1 decimal,\n    val2 decimal(31,10),\n    val3 decimal\n    CONSTRAINT pk PRIMARY KEY (host DESC, date DESC))");
        builder.put((Object)"FUNKY_NAMES", (Object)"create table FUNKY_NAMES   (\"foo!\" varchar not null primary key,\n    \"1\".\"#@$\" varchar, \n    \"1\".\"foo.bar-bas\" varchar, \n    \"1\".\"Value\" integer,\n    \"1\".\"VALUE\" integer,\n    \"1\".\"value\" integer,\n    \"1\".\"_blah^\" varchar)");
        builder.put((Object)"MULTI_CF", (Object)"create table MULTI_CF   (id char(15) not null primary key,\n    a.unique_user_count integer,\n    b.unique_org_count integer,\n    c.db_cpu_utilization decimal(31,10),\n    d.transaction_count bigint,\n    e.cpu_utilization decimal(31,10),\n    f.response_time bigint,\n    g.response_time bigint)");
        builder.put((Object)"HBASE_DYNAMIC_COLUMNS", (Object)"create table HBASE_DYNAMIC_COLUMNS   (entry varchar not null,    F varchar,    A.F1v1 varchar,    A.F1v2 varchar,    B.F2v1 varchar    CONSTRAINT pk PRIMARY KEY (entry))\n");
        builder.put((Object)"PRODUCT_METRICS", (Object)"create table PRODUCT_METRICS   (organization_id char(15) not null,    date date not null,    feature char(1) not null,    unique_users integer not null,\n    db_utilization decimal(31,10),\n    transactions bigint,\n    cpu_utilization decimal(31,10),\n    response_time bigint,\n    io_time bigint,\n    region varchar,\n    unset_column decimal(31,10)\n    CONSTRAINT pk PRIMARY KEY (organization_id, \"DATE\", feature, UNIQUE_USERS))");
        builder.put((Object)"CORE.CUSTOM_ENTITY_DATA", (Object)"create table CORE.CUSTOM_ENTITY_DATA   (organization_id char(15) not null, \n    key_prefix char(3) not null,\n    custom_entity_data_id char(12) not null,\n    created_by varchar,\n    created_date date,\n    currency_iso_code char(3),\n    deleted char(1),\n    division decimal(31,10),\n    last_activity date,\n    last_update date,\n    last_update_by varchar,\n    name varchar(240),\n    owner varchar,\n    record_type_id char(15),\n    setup_owner varchar,\n    system_modstamp date,\n    b.val0 varchar,\n    b.val1 varchar,\n    b.val2 varchar,\n    b.val3 varchar,\n    b.val4 varchar,\n    b.val5 varchar,\n    b.val6 varchar,\n    b.val7 varchar,\n    b.val8 varchar,\n    b.val9 varchar\n    CONSTRAINT pk PRIMARY KEY (organization_id, key_prefix, custom_entity_data_id))");
        builder.put((Object)"IntKeyTest", (Object)"create table IntKeyTest   (i integer not null primary key)");
        builder.put((Object)"IntIntKeyTest", (Object)"create table IntIntKeyTest   (i integer not null primary key, j integer)");
        builder.put((Object)"PKIntValueTest", (Object)"create table PKIntValueTest   (pk integer not null primary key)");
        builder.put((Object)"PKBigIntValueTest", (Object)"create table PKBigIntValueTest   (pk bigint not null primary key)");
        builder.put((Object)"PKUnsignedIntValueTest", (Object)"create table PKUnsignedIntValueTest   (pk unsigned_int not null primary key)");
        builder.put((Object)"PKUnsignedLongValueTest", (Object)"create table PKUnsignedLongValueTest   (pk unsigned_long not null\n    CONSTRAINT pk PRIMARY KEY (pk))");
        builder.put((Object)"KVIntValueTest", (Object)"create table KVIntValueTest   (pk integer not null primary key,\n    kv integer)\n");
        builder.put((Object)"KVBigIntValueTest", (Object)"create table KVBigIntValueTest   (pk integer not null primary key,\n    kv bigint)\n");
        builder.put((Object)"SumDoubleTest", (Object)"create table SumDoubleTest   (id varchar not null primary key, d DOUBLE, f FLOAT, ud UNSIGNED_DOUBLE, uf UNSIGNED_FLOAT, i integer, de decimal)");
        builder.put((Object)"BinaryTable", (Object)"create table BinaryTable   (a_binary BINARY(16) not null, \n    b_binary BINARY(16), \n    a_varbinary VARBINARY, \n    b_varbinary VARBINARY, \n    CONSTRAINT pk PRIMARY KEY (a_binary)\n) ");
        tableDDLMap = builder.build();
        NUM_SLAVES_BASE = 1;
        DEFAULT_RPC_SCHEDULER_FACTORY = PhoenixRpcSchedulerFactory.class.getName();
        clusterInitialized = false;
        config = HBaseConfiguration.create();
        NAME_SUFFIX = new AtomicInteger(0);
        TABLE_COUNTER = new AtomicInteger(0);
        SEQ_NAME_SUFFIX = new AtomicInteger(0);
        SEQ_COUNTER = new AtomicInteger(0);
    }
}

