/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.exception.PhoenixParserException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.BindableStatement;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.CreateCDCStatement;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.DropCDCStatement;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.UpsertStatement;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.junit.Assert;
import org.junit.Test;

public class QueryParserTest {
    private <T extends BindableStatement> T parseQuery(String sql, Class<T> type) throws IOException, SQLException {
        SQLParser parser = new SQLParser((Reader)new StringReader(sql));
        BindableStatement stmt = null;
        stmt = parser.parseStatement();
        if (stmt.getOperation() != PhoenixStatement.Operation.QUERY) {
            return (T)(type != null ? (BindableStatement)type.cast(stmt) : null);
        }
        String newSQL = stmt.toString();
        SQLParser newParser = new SQLParser((Reader)new StringReader(newSQL));
        BindableStatement newStmt = null;
        try {
            newStmt = newParser.parseStatement();
        }
        catch (SQLException e) {
            Assert.fail((String)("Unable to parse new:\n" + newSQL));
        }
        Assert.assertEquals((String)("Expected equality:\n" + sql + "\n" + newSQL), (Object)stmt, (Object)newStmt);
        return (T)(type != null ? (BindableStatement)type.cast(stmt) : null);
    }

    private <T extends BindableStatement> T parseQuery(String sql) throws IOException, SQLException {
        return this.parseQuery(sql, null);
    }

    private void parseQueryThatShouldFail(String sql) throws Exception {
        try {
            this.parseQuery(sql);
            Assert.fail((String)("Query should throw a PhoenixParserException \n " + sql));
        }
        catch (PhoenixParserException phoenixParserException) {
            // empty catch block
        }
    }

    private void parseQueryThatShouldFailWithSQLException(String sql) throws Exception {
        try {
            this.parseQuery(sql);
            Assert.fail((String)("Query should throw a PhoenixParserException \n " + sql));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testParseGrantQuery() throws Exception {
        String sql0 = "GRANT 'RX' ON SYSTEM.\"SEQUENCE\" TO 'user'";
        this.parseQuery(sql0);
        String sql1 = "GRANT 'RWXCA' ON TABLE some_table0 TO 'user0'";
        this.parseQuery(sql1);
        String sql2 = "GRANT 'RWX' ON some_table1 TO 'user1'";
        this.parseQuery(sql2);
        String sql3 = "GRANT 'CA' ON SCHEMA some_schema2 TO 'user2'";
        this.parseQuery(sql3);
        String sql4 = "GRANT 'RXW' ON some_table3 TO GROUP 'group3'";
        this.parseQuery(sql4);
        String sql5 = "GRANT 'RXW' ON \"some_schema5\".\"some_table5\" TO GROUP 'group5'";
        this.parseQuery(sql5);
        String sql6 = "GRANT 'RWA' TO 'user6'";
        this.parseQuery(sql6);
        String sql7 = "GRANT 'A' TO GROUP 'group7'";
        this.parseQuery(sql7);
        String sql8 = "GRANT 'ARXRRRRR' TO GROUP 'group8'";
        this.parseQueryThatShouldFail(sql8);
    }

    @Test
    public void testParseRevokeQuery() throws Exception {
        String sql0 = "REVOKE ON SCHEMA SYSTEM FROM 'user0'";
        this.parseQuery(sql0);
        String sql1 = "REVOKE ON SYSTEM.\"SEQUENCE\" FROM 'user1'";
        this.parseQuery(sql1);
        String sql2 = "REVOKE ON TABLE some_table2 FROM GROUP 'group2'";
        this.parseQuery(sql2);
        String sql3 = "REVOKE ON some_table3 FROM GROUP 'group2'";
        this.parseQuery(sql3);
        String sql4 = "REVOKE FROM 'user4'";
        this.parseQuery(sql4);
        String sql5 = "REVOKE FROM GROUP 'group5'";
        this.parseQuery(sql5);
        String sql6 = "REVOKE 'RRWWXAAA' FROM GROUP 'group6'";
        this.parseQueryThatShouldFail(sql6);
    }

    @Test
    public void testParsePreQuery0() throws Exception {
        String sql = "select a from b\nwhere ((ind.name = 'X')and rownum <= (1000 + 1000))\n";
        this.parseQuery(sql);
    }

    @Test
    public void testParsePreQuery1() throws Exception {
        String sql = "select /*gatherSlowStats*/ count(1) from core.search_name_lookup ind\nwhere( (ind.name = 'X'\nand rownum <= 1 + 2)\nand (ind.organization_id = '000000000000000')\nand (ind.key_prefix = '00T')\nand (ind.name_type = 't'))";
        this.parseQuery(sql);
    }

    @Test
    public void testParsePreQuery2() throws Exception {
        String sql = "select /*gatherSlowStats*/ count(1) from core.custom_index_value ind\nwhere (ind.string_value in ('a', 'b', 'c', 'd'))\nand rownum <= ( 3 + 1 )\nand (ind.organization_id = '000000000000000')\nand (ind.key_prefix = '00T')\nand (ind.deleted = '0')\nand (ind.index_num = 1)";
        this.parseQuery(sql);
    }

    @Test
    public void testParsePreQuery3() throws Exception {
        String sql = "select /*gatherSlowStats*/ count(1) from core.custom_index_value ind\nwhere (ind.number_value > 3)\nand rownum <= 1000\nand (ind.organization_id = '000000000000000')\nand (ind.key_prefix = '001'\nand (ind.deleted = '0'))\nand (ind.index_num = 2)";
        this.parseQuery(sql);
    }

    @Test
    public void testParsePreQuery4() throws Exception {
        String sql = "select /*+ index(t iecustom_entity_data_created) */ /*gatherSlowStats*/ count(1) from core.custom_entity_data t\nwhere (t.created_date > to_date('01/01/2001'))\nand rownum <= 4500\nand (t.organization_id = '000000000000000')\nand (t.key_prefix = '001')";
        this.parseQuery(sql);
    }

    @Test
    public void testCountDistinctQuery() throws Exception {
        String sql = "select count(distinct foo) from core.custom_entity_data t\nwhere (t.created_date > to_date('01/01/2001'))\nand (t.organization_id = '000000000000000')\nand (t.key_prefix = '001')\nlimit 4500";
        this.parseQuery(sql);
    }

    @Test
    public void testIsNullQuery() throws Exception {
        String sql = "select count(foo) from core.custom_entity_data t\nwhere (t.created_date is null)\nand (t.organization_id is not null)\n";
        this.parseQuery(sql);
    }

    @Test
    public void testAsInColumnAlias() throws Exception {
        String sql = "select count(foo) AS c from core.custom_entity_data t\nwhere (t.created_date is null)\nand (t.organization_id is not null)\n";
        this.parseQuery(sql);
    }

    @Test
    public void testParseJoin1() throws Exception {
        String sql = "select /*SOQL*/ \"Id\"\nfrom (select /*+ ordered index(cft) */\ncft.val188 \"Marketing_Offer_Code__c\",\nt.account_id \"Id\"\nfrom sales.account_cfdata cft,\nsales.account t\nwhere (cft.account_cfdata_id = t.account_id)\nand (cft.organization_id = '00D300000000XHP')\nand (t.organization_id = '00D300000000XHP')\nand (t.deleted = '0')\nand (t.account_id != '000000000000000'))\nwhere (\"Marketing_Offer_Code__c\" = 'FSCR')";
        this.parseQuery(sql);
    }

    @Test
    public void testParseJoin2() throws Exception {
        String sql = "select /*rptacctlist 00O40000002C3of*/ \"00N40000001M8VK\",\n\"00N40000001M8VK.ID\",\n\"00N30000000r0K2\",\n\"00N30000000jgjo\"\nfrom (select /*+ ordered use_hash(aval368) index(cfa) */\na.record_type_id \"RECORDTYPE\",\naval368.last_name,aval368.first_name || ' ' || aval368.last_name,aval368.name \"00N40000001M8VK\",\na.last_update \"LAST_UPDATE\",\ncfa.val368 \"00N40000001M8VK.ID\",\nTO_DATE(cfa.val282) \"00N30000000r0K2\",\ncfa.val252 \"00N30000000jgjo\"\nfrom sales.account a,\nsales.account_cfdata cfa,\ncore.name_denorm aval368\nwhere (cfa.account_cfdata_id = a.account_id)\nand (aval368.entity_id = cfa.val368)\nand (a.deleted = '0')\nand (a.organization_id = '00D300000000EaE')\nand (a.account_id <> '000000000000000')\nand (cfa.organization_id = '00D300000000EaE')\nand (aval368.organization_id = '00D300000000EaE')\nand (aval368.entity_id like '005%'))\nwhere (\"RECORDTYPE\" = '0123000000002Gv')\nAND (\"00N40000001M8VK\" is null or \"00N40000001M8VK\" in ('BRIAN IRWIN', 'BRIAN MILLER', 'COLLEEN HORNYAK', 'ERNIE ZAVORAL JR', 'JAMIE TRIMBUR', 'JOE ANTESBERGER', 'MICHAEL HYTLA', 'NATHAN DELSIGNORE', 'SANJAY GANDHI', 'TOM BASHIOUM'))\nAND (\"LAST_UPDATE\" >= to_date('2009-08-01 07:00:00'))";
        this.parseQuery(sql);
    }

    @Test
    public void testNegative1() throws Exception {
        String sql = "select /*gatherSlowStats*/ count(1) core.search_name_lookup ind\nwhere (ind.name = 'X')\nand rownum <= 2000\nand (ind.organization_id = '000000000000000')\nand (ind.key_prefix = '00T')\nand (ind.name_type = 't')";
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.MISSING_TOKEN.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testNegative2() throws Exception {
        String sql = "seelect /*gatherSlowStats*/ count(1) from core.search_name_lookup ind\nwhere (ind.name = 'X')\nand rownum <= 2000\nand (ind.organization_id = '000000000000000')\nand (ind.key_prefix = '00T')\nand (ind.name_type = 't')";
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 601 (42P00): Syntax error. Encountered \"seelect\" at line 1, column 1."));
        }
    }

    @Test
    public void testNegative3() throws Exception {
        String sql = "select /*gatherSlowStats*/ count(1) from core.search_name_lookup ind\nwhere (ind.name = 'X')\nand rownum <= 2000\nand (ind.organization_id = '000000000000000')\nand (ind.key_prefix = '00T')\nand (ind.name_type = 't'))";
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 603 (42P00): Syntax error. Unexpected input. Expecting \"EOF\", got \")\" at line 6, column 26."));
        }
    }

    @Test
    public void testNegativeCountDistinct() throws Exception {
        String sql = "select /*gatherSlowStats*/ max( distinct 1) from core.search_name_lookup ind\nwhere (ind.name = 'X')\nand rownum <= 2000\nand (ind.organization_id = '000000000000000')\nand (ind.key_prefix = '00T')\nand (ind.name_type = 't')";
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    @Test
    public void testNegativeCountStar() throws Exception {
        String sql = "select /*gatherSlowStats*/ max(*) from core.search_name_lookup ind\nwhere (ind.name = 'X')\nand rownum <= 2000\nand (ind.organization_id = '000000000000000')\nand (ind.key_prefix = '00T')\nand (ind.name_type = 't')";
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 601 (42P00): Syntax error. Encountered \"*\" at line 1, column 32."));
        }
    }

    @Test
    public void testNegativeNonBooleanWhere() throws Exception {
        String sql = "select /*gatherSlowStats*/ max( distinct 1) from core.search_name_lookup ind\nwhere 1";
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    @Test
    public void testCommentQuery() throws Exception {
        String sql = "select a from b -- here we come\nwhere ((ind.name = 'X') // to save the day\nand rownum /* won't run */ <= (1000 + 1000))\n";
        this.parseQuery(sql);
    }

    @Test
    public void testQuoteEscapeQuery() throws Exception {
        String sql = "select a from b\nwhere ind.name = 'X''Y'\n";
        this.parseQuery(sql);
    }

    @Test
    public void testSubtractionInSelect() throws Exception {
        String sql = "select a, 3-1-2, -4- -1-1 from b\nwhere d = c - 1\n";
        this.parseQuery(sql);
    }

    @Test
    public void testParsingStatementWithMispellToken() throws Exception {
        String sql;
        try {
            sql = "selects a from b\nwhere e = d\n";
            this.parseQuery(sql);
            Assert.fail((String)"Should have caught exception.");
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 601 (42P00): Syntax error. Encountered \"selects\" at line 1, column 1."));
        }
        try {
            sql = "select a froms b\nwhere e = d\n";
            this.parseQuery(sql);
            Assert.fail((String)"Should have caught exception.");
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 602 (42P00): Syntax error. Missing \"EOF\" at line 1, column 16."));
        }
    }

    @Test
    public void testParsingStatementWithExtraToken() throws Exception {
        String sql;
        try {
            sql = "select a,, from b\nwhere e = d\n";
            this.parseQuery(sql);
            Assert.fail((String)"Should have caught exception.");
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 601 (42P00): Syntax error. Encountered \",\" at line 1, column 10."));
        }
        try {
            sql = "select a from from b\nwhere e = d\n";
            this.parseQuery(sql);
            Assert.fail((String)"Should have caught exception.");
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 601 (42P00): Syntax error. Encountered \"from\" at line 1, column 15."));
        }
    }

    @Test
    public void testParseCreateTableInlinePrimaryKeyWithOrder() throws Exception {
        for (String order : new String[]{"asc", "desc"}) {
            String s = "create table core.entity_history_archive (id char(15) primary key ${o})".replace("${o}", order);
            CreateTableStatement stmt = (CreateTableStatement)new SQLParser(s).parseStatement();
            List columnDefs = stmt.getColumnDefs();
            Assert.assertEquals((long)1L, (long)columnDefs.size());
            Assert.assertEquals((Object)SortOrder.fromDDLValue((String)order), (Object)((ColumnDef)columnDefs.iterator().next()).getSortOrder());
        }
    }

    @Test
    public void testParseCreateTableOrderWithoutPrimaryKeyFails() throws Exception {
        for (String order : new String[]{"asc", "desc"}) {
            String stmt = "create table core.entity_history_archive (id varchar(20) ${o})".replace("${o}", order);
            try {
                new SQLParser(stmt).parseStatement();
                Assert.fail((String)"Expected parse exception to be thrown");
            }
            catch (SQLException e) {
                String errorMsg = "ERROR 603 (42P00): Syntax error. Unexpected input. Expecting \"RPAREN\", got \"${o}\"".replace("${o}", order);
                Assert.assertTrue((String)("Expected message to contain \"" + errorMsg + "\" but got \"" + e.getMessage() + "\""), (boolean)e.getMessage().contains(errorMsg));
            }
        }
    }

    @Test
    public void testParseCreateTablePrimaryKeyConstraintWithOrder() throws Exception {
        for (String order : new String[]{"asc", "desc"}) {
            String s = "create table core.entity_history_archive (id CHAR(15), name VARCHAR(150), constraint pk primary key (id ${o}, name ${o}))".replace("${o}", order);
            CreateTableStatement stmt = (CreateTableStatement)new SQLParser(s).parseStatement();
            PrimaryKeyConstraint pkConstraint = stmt.getPrimaryKeyConstraint();
            List columns = pkConstraint.getColumnNames();
            Assert.assertEquals((long)2L, (long)columns.size());
            for (Pair pair : columns) {
                Assert.assertEquals((Object)SortOrder.fromDDLValue((String)order), (Object)pkConstraint.getColumnWithSortOrder((ColumnName)pair.getFirst()).getSecond());
            }
        }
    }

    @Test
    public void testParseCreateTableCommaBeforePrimaryKeyConstraint() throws Exception {
        for (String leadingComma : new String[]{",", ""}) {
            String s = "create table core.entity_history_archive (id CHAR(15), name VARCHAR(150)${o} constraint pk primary key (id))".replace("${o}", leadingComma);
            CreateTableStatement stmt = (CreateTableStatement)new SQLParser(s).parseStatement();
            Assert.assertEquals((long)2L, (long)stmt.getColumnDefs().size());
            Assert.assertNotNull((Object)stmt.getPrimaryKeyConstraint());
        }
    }

    private CreateCDCStatement parseCreateCDCSimple(String sql, boolean ifNotExists) throws Exception {
        CreateCDCStatement stmt = this.parseQuery(sql, CreateCDCStatement.class);
        Assert.assertEquals((Object)"FOO", (Object)stmt.getCdcObjName().getName());
        Assert.assertEquals((Object)"BAR", (Object)stmt.getDataTable().getTableName());
        Assert.assertEquals((Object)ifNotExists, (Object)stmt.isIfNotExists());
        return stmt;
    }

    @Test
    public void testCreateCDCSimple() throws Exception {
        this.parseCreateCDCSimple("create cdc foo on bar", false);
        this.parseCreateCDCSimple("create cdc foo on s.bar", false);
        this.parseCreateCDCSimple("create cdc if not exists foo on bar", true);
        this.parseCreateCDCSimple("create cdc foo on bar", false);
        CreateCDCStatement stmt = null;
        stmt = this.parseCreateCDCSimple("create cdc foo on bar TTL=100", false);
        Assert.assertEquals(Arrays.asList(new Pair((Object)"TTL", (Object)100)), (Object)stmt.getProps().get((Object)""));
        stmt = this.parseCreateCDCSimple("create cdc foo on bar include (pre)", false);
        Assert.assertEquals(new HashSet<PTable.CDCChangeScope>(Arrays.asList(PTable.CDCChangeScope.PRE)), (Object)stmt.getIncludeScopes());
        stmt = this.parseCreateCDCSimple("create cdc foo on bar include (pre, post, change)", false);
        Assert.assertEquals(new HashSet<PTable.CDCChangeScope>(Arrays.asList(PTable.CDCChangeScope.PRE, PTable.CDCChangeScope.POST, PTable.CDCChangeScope.CHANGE)), (Object)stmt.getIncludeScopes());
        stmt = this.parseCreateCDCSimple("create cdc foo on bar include (pre, pre, post)", false);
        Assert.assertEquals(new HashSet<PTable.CDCChangeScope>(Arrays.asList(PTable.CDCChangeScope.PRE, PTable.CDCChangeScope.POST)), (Object)stmt.getIncludeScopes());
        stmt = this.parseCreateCDCSimple("create cdc if not exists foo on bar abc=def", true);
        Assert.assertEquals(Arrays.asList(new Pair((Object)"ABC", (Object)"def")), (Object)stmt.getProps().get((Object)""));
        stmt = this.parseCreateCDCSimple("create cdc if not exists foo on bar abc=def, prop=val", true);
        Assert.assertEquals(Arrays.asList(new Pair((Object)"ABC", (Object)"def"), new Pair((Object)"PROP", (Object)"val")), (Object)stmt.getProps().get((Object)""));
    }

    @Test
    public void testCreateCDCWithErrors() throws Exception {
        this.parseQueryThatShouldFail("create cdc foo");
        this.parseQueryThatShouldFail("create cdc foo on bar include (abc)");
    }

    private void parseInvalidCreateCDC(String sql, int expRrrorCode) throws IOException {
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)expRrrorCode, (long)e.getErrorCode());
        }
    }

    @Test
    public void testInvalidCreateCDC() throws Exception {
        this.parseInvalidCreateCDC("create cdc foo bar", SQLExceptionCode.MISSING_TOKEN.getErrorCode());
        this.parseInvalidCreateCDC("create cdc foo bar ts", SQLExceptionCode.MISSING_TOKEN.getErrorCode());
        this.parseInvalidCreateCDC("create cdc foo bar(ts)", SQLExceptionCode.MISSING_TOKEN.getErrorCode());
        this.parseInvalidCreateCDC("create cdc s.foo on bar(ts)", SQLExceptionCode.MISMATCHED_TOKEN.getErrorCode());
        this.parseInvalidCreateCDC("create cdc foo bar(ts1, ts2)", SQLExceptionCode.MISSING_TOKEN.getErrorCode());
    }

    @Test
    public void testInvalidTrailingCommaOnCreateTable() throws Exception {
        String sql = "create table foo (c1 varchar primary key, c2 varchar,)";
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.MISMATCHED_TOKEN.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testCreateSequence() throws Exception {
        String sql = "create sequence foo.bar\nstart with 0\nincrement by 1\n";
        this.parseQuery(sql);
    }

    private DropCDCStatement parseDropCDCSimple(String sql, boolean ifNotExists) throws Exception {
        DropCDCStatement stmt = this.parseQuery(sql, DropCDCStatement.class);
        Assert.assertEquals((Object)"FOO", (Object)stmt.getCdcObjName().getName());
        Assert.assertEquals((Object)"BAR", (Object)stmt.getTableName().getTableName());
        Assert.assertEquals((Object)ifNotExists, (Object)stmt.ifExists());
        return stmt;
    }

    @Test
    public void testDropCDCSimple() throws Exception {
        Object stmt = null;
        this.parseDropCDCSimple("drop cdc foo on bar", false);
        this.parseDropCDCSimple("drop cdc if exists foo on bar", true);
        this.parseDropCDCSimple("drop cdc if exists foo on s.bar", true);
    }

    private void parseInvalidDropCDC(String sql, int expRrrorCode) throws IOException {
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)expRrrorCode, (long)e.getErrorCode());
        }
    }

    @Test
    public void testInvalidDropCDC() throws Exception {
        this.parseInvalidDropCDC("drop cdc foo bar", SQLExceptionCode.MISSING_TOKEN.getErrorCode());
        this.parseInvalidDropCDC("drop cdc s.foo on bar", SQLExceptionCode.MISMATCHED_TOKEN.getErrorCode());
        this.parseInvalidDropCDC("drop cdc foo on bar(ts)", SQLExceptionCode.MISSING_TOKEN.getErrorCode());
    }

    private void parseInvalidAlterCDC(String sql, int expRrrorCode) throws IOException {
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)expRrrorCode, (long)e.getErrorCode());
        }
    }

    @Test
    public void testNextValueForSelect() throws Exception {
        String sql = "select next value for foo.bar \nfrom core.custom_entity_data\n";
        this.parseQuery(sql);
    }

    @Test
    public void testNextValueForWhere() throws Exception {
        String sql = "upsert into core.custom_entity_data\nselect next value for foo.bar from core.custom_entity_data\n";
        this.parseQuery(sql);
    }

    @Test
    public void testBadCharDef() throws Exception {
        String sql;
        try {
            sql = "CREATE TABLE IF NOT EXISTS testBadVarcharDef  (pk VARCHAR NOT NULL PRIMARY KEY, col CHAR(0))";
            this.parseQuery(sql);
            Assert.fail((String)"Should have caught bad char definition.");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.NONPOSITIVE_MAX_LENGTH.getErrorCode(), (long)e.getErrorCode());
        }
        try {
            sql = "CREATE TABLE IF NOT EXISTS testBadVarcharDef  (pk VARCHAR NOT NULL PRIMARY KEY, col CHAR)";
            this.parseQuery(sql);
            Assert.fail((String)"Should have caught bad char definition.");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.MISSING_MAX_LENGTH.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testBadVarcharDef() throws Exception {
        try {
            String sql = "CREATE TABLE IF NOT EXISTS testBadVarcharDef  (pk VARCHAR NOT NULL PRIMARY KEY, col VARCHAR(0))";
            this.parseQuery(sql);
            Assert.fail((String)"Should have caught bad varchar definition.");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.NONPOSITIVE_MAX_LENGTH.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testBadDecimalDef() throws Exception {
        String sql;
        try {
            sql = "CREATE TABLE IF NOT EXISTS testBadDecimalDef  (pk VARCHAR NOT NULL PRIMARY KEY, col DECIMAL(0, 5))";
            this.parseQuery(sql);
            Assert.fail((String)"Should have caught bad decimal definition.");
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 209 (22003): Decimal precision outside of range. Should be within 1 and 38. columnName=COL"));
        }
        try {
            sql = "CREATE TABLE IF NOT EXISTS testBadDecimalDef  (pk VARCHAR NOT NULL PRIMARY KEY, col DECIMAL(40, 5))";
            this.parseQuery(sql);
            Assert.fail((String)"Should have caught bad decimal definition.");
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 209 (22003): Decimal precision outside of range. Should be within 1 and 38. columnName=COL"));
        }
    }

    @Test
    public void testBadBinaryDef() throws Exception {
        String sql;
        try {
            sql = "CREATE TABLE IF NOT EXISTS testBadBinaryDef  (pk VARCHAR NOT NULL PRIMARY KEY, col BINARY(0))";
            this.parseQuery(sql);
            Assert.fail((String)"Should have caught bad binary definition.");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.NONPOSITIVE_MAX_LENGTH.getErrorCode(), (long)e.getErrorCode());
        }
        try {
            sql = "CREATE TABLE IF NOT EXISTS testBadVarcharDef  (pk VARCHAR NOT NULL PRIMARY KEY, col BINARY)";
            this.parseQuery(sql);
            Assert.fail((String)"Should have caught bad char definition.");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.MISSING_MAX_LENGTH.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testPercentileQuery1() throws Exception {
        String sql = "select PERCENTILE_CONT(0.9) WITHIN GROUP (ORDER BY salary DESC) from core.custom_index_value ind";
        this.parseQuery(sql);
    }

    @Test
    public void testPercentileQuery2() throws Exception {
        String sql = "select PERCENTILE_CONT(0.5) WITHIN GROUP (ORDER BY mark ASC) from core.custom_index_value ind";
        this.parseQuery(sql);
    }

    @Test
    public void testRowValueConstructorQuery() throws Exception {
        String sql = "select a_integer FROM aTable where (x_integer, y_integer) > (3, 4)";
        this.parseQuery(sql);
    }

    @Test
    public void testSingleTopLevelNot() throws Exception {
        String sql = "select * from t where not c = 5";
        this.parseQuery(sql);
    }

    @Test
    public void testTopLevelNot() throws Exception {
        String sql = "select * from t where not c";
        this.parseQuery(sql);
    }

    @Test
    public void testRVCInList() throws Exception {
        String sql = "select * from t where k in ( (1,2), (3,4) )";
        this.parseQuery(sql);
    }

    @Test
    public void testInList() throws Exception {
        String sql = "select * from t where k in ( 1,2 )";
        this.parseQuery(sql);
    }

    @Test
    public void testInvalidSelectStar() throws Exception {
        String sql = "select *,k from t where k in ( 1,2 )";
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.MISSING_TOKEN.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testTableNameStartsWithUnderscore() throws Exception {
        String sql = "select* from _t where k in ( 1,2 )";
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.PARSER_ERROR.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testValidUpsertSelectHint() throws Exception {
        String sql = "upsert /*+ NO_INDEX */ into t select k from t where k in ( 1,2 )";
        this.parseQuery(sql);
    }

    @Test
    public void testPlainUpsertReturningRow() throws Exception {
        String sql = "upsert into t (k, v) values ( 1, 2 ) RETURNING *";
        UpsertStatement stmt = this.parseQuery(sql, UpsertStatement.class);
        Assert.assertTrue((boolean)stmt.isReturningRow());
    }

    @Test
    public void testPlainUpsertNotReturningRow() throws Exception {
        String sql = "upsert into t (k, v) values ( 1, 2 )";
        UpsertStatement stmt = this.parseQuery(sql, UpsertStatement.class);
        Assert.assertFalse((boolean)stmt.isReturningRow());
    }

    @Test
    public void testUpsertWithOnDuplicateKey() throws Exception {
        String sql = "upsert into t (k, v) values ( 1, 2 ) ON DUPLICATE KEY UPDATE k = k + 1";
        this.parseQuery(sql);
    }

    @Test
    public void testUpsertInvalidReturningProjections() throws Exception {
        String sql = "upsert into t (k, v) values ( 1, 2 ) ON DUPLICATE KEY UPDATE k = k + 1 RETURNING k";
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (PhoenixParserException e) {
            Assert.assertEquals((long)SQLExceptionCode.MISMATCHED_TOKEN.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testUpsertReturningRow() throws Exception {
        String sql = "upsert into t (k, v) values ( 1, 2 ) ON DUPLICATE KEY UPDATE k = k + 1 RETURNING *";
        UpsertStatement stmt = this.parseQuery(sql, UpsertStatement.class);
        Assert.assertTrue((boolean)stmt.isReturningRow());
    }

    @Test
    public void testDeleteReturningRow() throws Exception {
        String sql = "delete from t RETURNING *";
        this.parseQuery(sql);
    }

    @Test
    public void testDeleteWhereReturningRow() throws Exception {
        String sql = "DELETE FROM T WHERE PK1 = ? AND PK2 = ? RETURNING *";
        this.parseQuery(sql);
    }

    @Test
    public void testDeleteWithOrderLimitWhereReturningRow() throws Exception {
        String sql = "DELETE FROM T WHERE PK1 = ? AND PK2 = ? ORDER BY PK2 LIMIT 1 RETURNING *";
        this.parseQuery(sql);
    }

    @Test
    public void testDeleteInvalidReturningRow() throws Exception {
        String sql = "DELETE FROM T RETURNING PK1";
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (PhoenixParserException e) {
            Assert.assertEquals((long)SQLExceptionCode.MISMATCHED_TOKEN.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testHavingWithNot() throws Exception {
        String sql = "select\n\"WEB_STAT_ALIAS\".\"DOMAIN\" as \"c0\"\nfrom \"WEB_STAT\" \"WEB_STAT_ALIAS\"\ngroup by \"WEB_STAT_ALIAS\".\"DOMAIN\" having\n(\n(\nNOT\n(\n(sum(\"WEB_STAT_ALIAS\".\"ACTIVE_VISITOR\") is null)\n)\nOR NOT((sum(\"WEB_STAT_ALIAS\".\"ACTIVE_VISITOR\") is null))\n)\nOR NOT((sum(\"WEB_STAT_ALIAS\".\"ACTIVE_VISITOR\") is null))\n)\norder by CASE WHEN \"WEB_STAT_ALIAS\".\"DOMAIN\" IS NULL THEN 1 ELSE 0 END,\n\"WEB_STAT_ALIAS\".\"DOMAIN\" ASC";
        this.parseQuery(sql);
    }

    @Test
    public void testToDateInList() throws Exception {
        String sql = "select * from date_test where d in (to_date('2013-11-04 09:12:00'))";
        this.parseQuery(sql);
    }

    @Test
    public void testDateLiteral() throws Exception {
        String sql = "select * from t where d = DATE '2013-11-04 09:12:00'";
        this.parseQuery(sql);
    }

    @Test
    public void testTimeLiteral() throws Exception {
        String sql = "select * from t where d = TIME '2013-11-04 09:12:00'";
        this.parseQuery(sql);
    }

    @Test
    public void testTimestampLiteral() throws Exception {
        String sql = "select * from t where d = TIMESTAMP '2013-11-04 09:12:00'";
        this.parseQuery(sql);
    }

    @Test
    public void testUnsignedDateLiteral() throws Exception {
        String sql = "select * from t where d = UNSIGNED_DATE '2013-11-04 09:12:00'";
        this.parseQuery(sql);
    }

    @Test
    public void testUnsignedTimeLiteral() throws Exception {
        String sql = "select * from t where d = UNSIGNED_TIME '2013-11-04 09:12:00'";
        this.parseQuery(sql);
    }

    @Test
    public void testUnsignedTimestampLiteral() throws Exception {
        String sql = "select * from t where d = UNSIGNED_TIMESTAMP '2013-11-04 09:12:00'";
        this.parseQuery(sql);
    }

    @Test
    public void testParseDateEquality() throws Exception {
        SQLParser parser = new SQLParser((Reader)new StringReader("select a from b\nwhere date '2014-01-04' = date '2014-01-04'"));
        parser.parseStatement();
    }

    @Test
    public void testParseDateIn() throws Exception {
        SQLParser parser = new SQLParser((Reader)new StringReader("select a from b\nwhere date '2014-01-04' in (date '2014-01-04')"));
        parser.parseStatement();
    }

    @Test
    public void testUnknownLiteral() throws Exception {
        String sql = "select * from t where d = FOO '2013-11-04 09:12:00'";
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.ILLEGAL_DATA.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testUnsupportedLiteral() throws Exception {
        String sql = "select * from t where d = DECIMAL '2013-11-04 09:12:00'";
        try {
            this.parseQuery(sql);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TYPE_MISMATCH.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testAnyElementExpression1() throws Exception {
        String sql = "select * from t where 'a' = ANY(a)";
        this.parseQuery(sql);
    }

    @Test
    public void testAnyElementExpression2() throws Exception {
        String sql = "select * from t where 'a' <= ANY(a-b+1)";
        this.parseQuery(sql);
    }

    @Test
    public void testAllElementExpression() throws Exception {
        String sql = "select * from t where 'a' <= ALL(a-b+1)";
        this.parseQuery(sql);
    }

    @Test
    public void testDoubleBackslash() throws Exception {
        String sql = "SELECT * FROM T WHERE A LIKE 'a\\(d'";
        this.parseQuery(sql);
    }

    @Test
    public void testUnicodeSpace() throws Exception {
        String unicodeEnSpace = String.valueOf(Character.toChars(8194));
        String sql = Joiner.on((String)unicodeEnSpace).join((Object[])new String[]{"SELECT", "*", "FROM", "T"});
        this.parseQuery(sql);
    }

    @Test
    public void testInvalidTableOrSchemaName() throws Exception {
        this.parseQueryThatShouldFail("create table a:b (id varchar not null primary key)");
        this.parseQueryThatShouldFail("create table \"a:b\" (id varchar not null primary key)");
        this.parseQueryThatShouldFail("create table a.b.c.d (id varchar not null primary key)");
        this.parseQuery("create table \"a.b\".\"c.d\" (id varchar not null primary key)");
        this.parseQuery("create table \"a.b.c.d\" (id varchar not null primary key)");
    }

    @Test
    public void testIntegerInOffsetSelect() throws Exception {
        String sql = "SELECT * FROM T OFFSET 1";
        this.parseQuery(sql);
    }

    @Test
    public void testRVCInOffsetSelect() throws Exception {
        String sql = "SELECT * FROM T OFFSET (A,B,C)=('a','b','c')";
        this.parseQuery(sql);
    }

    @Test
    public void testBindInOffsetSelect() throws Exception {
        String sql = "SELECT * FROM T OFFSET ?";
        this.parseQuery(sql);
    }

    @Test
    public void testLongQuery() throws Exception {
        String sql = "SELECT * FROM T WHERE a IN (1) OFFSET 1";
        this.parseQuery(sql);
    }

    @Test
    public void testLimitOffsetQuery() throws Exception {
        String sql = "SELECT * FROM T LIMIT 10 OFFSET 1";
        this.parseQuery(sql);
    }

    @Test
    public void testLimitRVCOffsetQuery() throws Exception {
        String sql = "SELECT * FROM T LIMIT 10 OFFSET (A,B,C)=('a','b','c')";
        this.parseQuery(sql);
    }

    @Test
    public void testShowStmt() throws Exception {
        this.parseQuery("show schemas");
        this.parseQuery("show schemas like 'foo%'");
        this.parseQuery("show tables");
        this.parseQuery("show tables in foo");
        this.parseQuery("show tables in foo like 'bar%'");
        this.parseQuery("show tables like 'bar%'");
        this.parseQueryThatShouldFail("show schemas like foo");
        this.parseQueryThatShouldFail("show schemas in foo");
        this.parseQueryThatShouldFail("show tables 'foo'");
        this.parseQueryThatShouldFail("show tables in 'foo'");
        this.parseQueryThatShouldFail("show tables like foo");
    }

    @Test
    public void testCreateSchema() throws Exception {
        String sql0 = "create schema \"schema1\"";
        this.parseQuery(sql0);
        String sql1 = "create schema schema1";
        this.parseQuery(sql1);
        String sql2 = "create schema \"default\"";
        this.parseQuery(sql2);
        String sql3 = "create schema \"DEFAULT\"";
        this.parseQuery(sql3);
    }

    @Test
    public void testShowCreateTable() throws Exception {
        this.parseQuery("SHOW CREATE TABLE FOO");
        this.parseQuery("show create table FOO");
        this.parseQuery("SHOW CREATE TABLE s.FOO");
        this.parseQuery("SHOW CREATE TABLE \"foo\"");
        this.parseQuery("SHOW CREATE TABLE s.\"foo\"");
        this.parseQuery("SHOW CREATE TABLE \"s\".FOO");
        this.parseQueryThatShouldFail("SHOW CREATE VIEW foo");
        this.parseQueryThatShouldFail("SHOW CREATE TABLE 'foo'");
    }

    @Test
    public void testBinaryLiteral() throws Exception {
        this.parseQuery("SELECT b, x from x WHERE x = x'00'");
        this.parseQuery("SELECT b, x from x WHERE x = x'0 12 ' --comment \n /* comment */ '34 567' \n \n 'aA'");
        this.parseQuery("SELECT b, x from x WHERE x = b'0 10 ' --comment \n /* comment */ '10 101' \n \n '00000000'");
        this.parseQueryThatShouldFailWithSQLException("SELECT b, x from x WHERE x = x '00'");
        this.parseQueryThatShouldFailWithSQLException("SELECT b, x from x WHERE b = b '00'");
        this.parseQueryThatShouldFail("SELECT b, x from x WHERE x = x'X0 12 ' --comment \n /* comment */ '34 5670' \n \n 'aA'");
        this.parseQueryThatShouldFail("SELECT b, x from b WHERE b = b'B0 10 ' --comment \n /* comment */ '10 101' \n \n '000000000'");
        this.parseQueryThatShouldFail("SELECT b, x from x WHERE x = x'0 12 ' --comment \n /* comment */ '34 5670' \n \n 'aA_'");
        this.parseQueryThatShouldFail("SELECT b, x from x WHERE x = b'0 10 ' --comment \n /* comment */ '00 0000' \n \n '00_'");
        this.parseQueryThatShouldFail("SELECT b, x from x WHERE x = x'0 12 ' --comment \n /* comment */ '34 5670' \n \n ''");
        this.parseQueryThatShouldFail("SELECT b, x from x WHERE x = b'0 10 ' --comment \n /* comment */ '00 000' \n \n ''");
    }
}

