/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.util.List;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.PartitionIdParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.junit.Assert;
import org.junit.Test;

public class PartitionIdFunctionTest {
    @Test
    public void testExpressionWithPartitionId() throws Exception {
        ParseNode parseNode = SQLParser.parseCondition((String)"(PARTITION_ID() = PK2)");
        boolean hasPartitionIdParseNode = false;
        for (ParseNode childNode : parseNode.getChildren()) {
            if (!childNode.getClass().isAssignableFrom(PartitionIdParseNode.class)) continue;
            Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
            hasPartitionIdParseNode = true;
        }
        Assert.assertTrue((boolean)hasPartitionIdParseNode);
    }

    @Test
    public void testExpressionWithPhoenixRowTimestampWithParams() throws Exception {
        ParseNode parseNode = SQLParser.parseCondition((String)"(PARTITION_ID(COL1) = PK2)");
        for (ParseNode childNode : parseNode.getChildren()) {
            Assert.assertFalse((String)"PartitionIdFunction does not take any parameters", (boolean)childNode.getClass().isAssignableFrom(PartitionIdParseNode.class));
        }
    }

    @Test
    public void testSelectWithPhoenixRowTimestamp() throws Exception {
        SQLParser parser = new SQLParser("SELECT PARTITION_ID() FROM xyz");
        List nodes = parser.parseQuery().getSelect();
        Assert.assertEquals((long)1L, (long)nodes.size());
        Assert.assertTrue((String)"PARTITION_ID() should parse to PartitionIdParseNode", (boolean)((AliasedNode)nodes.get(0)).getNode().getClass().isAssignableFrom(PartitionIdParseNode.class));
        Assert.assertEquals((long)0L, (long)((AliasedNode)nodes.get(0)).getNode().getChildren().size());
    }
}

