/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import org.apache.phoenix.parse.DecodeViewIndexIdParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.junit.Assert;
import org.junit.Test;

public class DecodeViewIndexIdFunctionTest {
    @Test
    public void testExpressionWithDecodeViewIndexIdFunction() throws Exception {
        ParseNode parseNode = SQLParser.parseCondition((String)"DECODE_VIEW_INDEX_ID(VIEW_INDEX_ID, VIEW_INDEX_ID_DATA_TYPE) = 32768");
        boolean hasGetViewIndexIdParseNode = false;
        for (ParseNode childNode : parseNode.getChildren()) {
            if (!childNode.getClass().isAssignableFrom(DecodeViewIndexIdParseNode.class)) continue;
            Assert.assertEquals((long)2L, (long)childNode.getChildren().size());
            hasGetViewIndexIdParseNode = true;
        }
        Assert.assertTrue((boolean)hasGetViewIndexIdParseNode);
    }

    @Test
    public void testValidationForDecodeViewIndexIdFunction() throws Exception {
        boolean hasGetViewIndexIdParseNode = false;
        try {
            ParseNode parseNode = SQLParser.parseCondition((String)"DECODE_VIEW_INDEX_ID(VIEW_INDEX_ID, b) = 32768");
            for (ParseNode childNode : parseNode.getChildren()) {
                if (!childNode.getClass().isAssignableFrom(DecodeViewIndexIdParseNode.class)) continue;
                Assert.assertEquals((long)2L, (long)childNode.getChildren().size());
                hasGetViewIndexIdParseNode = true;
            }
        }
        catch (Exception e) {
            hasGetViewIndexIdParseNode = false;
        }
        Assert.assertFalse((boolean)hasGetViewIndexIdParseNode);
    }
}

