/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import org.apache.phoenix.parse.DeclareCursorStatement;
import org.apache.phoenix.parse.FetchStatement;
import org.apache.phoenix.parse.OpenStatement;
import org.apache.phoenix.parse.SQLParser;
import org.junit.Assert;
import org.junit.Test;

public class CursorParserTest {
    private void parseCursor(String sql) throws IOException, SQLException {
        SQLParser parser = new SQLParser((Reader)new StringReader(sql));
        DeclareCursorStatement stmt = null;
        try {
            stmt = parser.parseDeclareCursor();
        }
        catch (SQLException e) {
            Assert.fail((String)("Unable to parse:\n" + sql));
        }
    }

    private void parseFetch(String sql) throws IOException, SQLException {
        SQLParser parser = new SQLParser((Reader)new StringReader(sql));
        FetchStatement stmt = null;
        try {
            stmt = parser.parseFetch();
        }
        catch (SQLException e) {
            Assert.fail((String)("Unable to parse:\n" + sql));
        }
    }

    private void parseOpen(String sql) throws IOException, SQLException {
        SQLParser parser = new SQLParser((Reader)new StringReader(sql));
        OpenStatement stmt = null;
        try {
            stmt = parser.parseOpen();
        }
        catch (SQLException e) {
            Assert.fail((String)("Unable to parse:\n" + sql));
        }
    }

    @Test
    public void testParseCursor0() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select a from b\nwhere ((ind.name = 'X')and rownum <= (1000 + 1000))\n";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testParseCursor1() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select /*gatherSlowStats*/ count(1) from core.search_name_lookup ind\nwhere( (ind.name = 'X'\nand rownum <= 1 + 2)\nand (ind.organization_id = '000000000000000')\nand (ind.key_prefix = '00T')\nand (ind.name_type = 't'))";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testParseCursor2() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select /*gatherSlowStats*/ count(1) from core.custom_index_value ind\nwhere (ind.string_value in ('a', 'b', 'c', 'd'))\nand rownum <= ( 3 + 1 )\nand (ind.organization_id = '000000000000000')\nand (ind.key_prefix = '00T')\nand (ind.deleted = '0')\nand (ind.index_num = 1)";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testParseCursor3() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select /*gatherSlowStats*/ count(1) from core.custom_index_value ind\nwhere (ind.number_value > 3)\nand rownum <= 1000\nand (ind.organization_id = '000000000000000')\nand (ind.key_prefix = '001'\nand (ind.deleted = '0'))\nand (ind.index_num = 2)";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testParseCursor4() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select /*+ index(t iecustom_entity_data_created) */ /*gatherSlowStats*/ count(1) from core.custom_entity_data t\nwhere (t.created_date > to_date('01/01/2001'))\nand rownum <= 4500\nand (t.organization_id = '000000000000000')\nand (t.key_prefix = '001')";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testCountDistinctCursor() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select count(distinct foo) from core.custom_entity_data t\nwhere (t.created_date > to_date('01/01/2001'))\nand (t.organization_id = '000000000000000')\nand (t.key_prefix = '001')\nlimit 4500";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testIsNullCursor() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select count(foo) from core.custom_entity_data t\nwhere (t.created_date is null)\nand (t.organization_id is not null)\n";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testAsInColumnAlias() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select count(foo) AS c from core.custom_entity_data t\nwhere (t.created_date is null)\nand (t.organization_id is not null)\n";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testParseJoin1() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select /*SOQL*/ \"Id\"\nfrom (select /*+ ordered index(cft) */\ncft.val188 \"Marketing_Offer_Code__c\",\nt.account_id \"Id\"\nfrom sales.account_cfdata cft,\nsales.account t\nwhere (cft.account_cfdata_id = t.account_id)\nand (cft.organization_id = '00D300000000XHP')\nand (t.organization_id = '00D300000000XHP')\nand (t.deleted = '0')\nand (t.account_id != '000000000000000'))\nwhere (\"Marketing_Offer_Code__c\" = 'FSCR')";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testParseJoin2() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select /*rptacctlist 00O40000002C3of*/ \"00N40000001M8VK\",\n\"00N40000001M8VK.ID\",\n\"00N30000000r0K2\",\n\"00N30000000jgjo\"\nfrom (select /*+ ordered use_hash(aval368) index(cfa) */\na.record_type_id \"RECORDTYPE\",\naval368.last_name,aval368.first_name || ' ' || aval368.last_name,aval368.name \"00N40000001M8VK\",\na.last_update \"LAST_UPDATE\",\ncfa.val368 \"00N40000001M8VK.ID\",\nTO_DATE(cfa.val282) \"00N30000000r0K2\",\ncfa.val252 \"00N30000000jgjo\"\nfrom sales.account a,\nsales.account_cfdata cfa,\ncore.name_denorm aval368\nwhere (cfa.account_cfdata_id = a.account_id)\nand (aval368.entity_id = cfa.val368)\nand (a.deleted = '0')\nand (a.organization_id = '00D300000000EaE')\nand (a.account_id <> '000000000000000')\nand (cfa.organization_id = '00D300000000EaE')\nand (aval368.organization_id = '00D300000000EaE')\nand (aval368.entity_id like '005%'))\nwhere (\"RECORDTYPE\" = '0123000000002Gv')\nAND (\"00N40000001M8VK\" is null or \"00N40000001M8VK\" in ('BRIAN IRWIN', 'BRIAN MILLER', 'COLLEEN HORNYAK', 'ERNIE ZAVORAL JR', 'JAMIE TRIMBUR', 'JOE ANTESBERGER', 'MICHAEL HYTLA', 'NATHAN DELSIGNORE', 'SANJAY GANDHI', 'TOM BASHIOUM'))\nAND (\"LAST_UPDATE\" >= to_date('2009-08-01 07:00:00'))";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testCommentCursor() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select a from b -- here we come\nwhere ((ind.name = 'X') // to save the day\nand rownum /* won't run */ <= (1000 + 1000))\n";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testQuoteEscapeCursor() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select a from b\nwhere ind.name = 'X''Y'\n";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testSubtractionInSelect() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select a, 3-1-2, -4- -1-1 from b\nwhere d = c - 1\n";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testNextValueForSelect() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select next value for foo.bar \nfrom core.custom_entity_data\n";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testPercentileQuery1() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select PERCENTILE_CONT(0.9) WITHIN GROUP (ORDER BY salary DESC) from core.custom_index_value ind";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testPercentileQuery2() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select PERCENTILE_CONT(0.5) WITHIN GROUP (ORDER BY mark ASC) from core.custom_index_value ind";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testRowValueConstructorQuery() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select a_integer FROM aTable where (x_integer, y_integer) > (3, 4)";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testSingleTopLevelNot() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select * from t where not c = 5";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testHavingWithNot() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "select\n\"WEB_STAT_ALIAS\".\"DOMAIN\" as \"c0\"\nfrom \"WEB_STAT\" \"WEB_STAT_ALIAS\"\ngroup by \"WEB_STAT_ALIAS\".\"DOMAIN\" having\n(\n(\nNOT\n(\n(sum(\"WEB_STAT_ALIAS\".\"ACTIVE_VISITOR\") is null)\n)\nOR NOT((sum(\"WEB_STAT_ALIAS\".\"ACTIVE_VISITOR\") is null))\n)\nOR NOT((sum(\"WEB_STAT_ALIAS\".\"ACTIVE_VISITOR\") is null))\n)\norder by CASE WHEN \"WEB_STAT_ALIAS\".\"DOMAIN\" IS NULL THEN 1 ELSE 0 END,\n\"WEB_STAT_ALIAS\".\"DOMAIN\" ASC";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testDoubleBackslash() throws Exception {
        String expectedNameToken = "testCursor";
        String expectedSelectStatement = "SELECT * FROM T WHERE A LIKE 'a\\(d'";
        String sql = "DECLARE " + expectedNameToken + " CURSOR FOR " + expectedSelectStatement;
        this.parseCursor(sql);
    }

    @Test
    public void testOpenCursor() throws Exception {
        String expectedNameToken = "testCursor";
        String sql = "OPEN " + expectedNameToken;
        this.parseOpen(sql);
    }

    @Test
    public void testFetchNext() throws Exception {
        String expectedNameToken = "testCursor";
        String sql = "FETCH NEXT FROM " + expectedNameToken;
        this.parseFetch(sql);
    }
}

