/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring.connectionqueryservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.monitoring.ConnectionQueryServicesMetric;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.connectionqueryservice.ConnectionQueryServicesMetrics;
import org.apache.phoenix.monitoring.connectionqueryservice.ConnectionQueryServicesNameMetricsTest;
import org.junit.Assert;
import org.junit.Test;

public class ConnectionQueryServicesMetricsTest {
    static Map<String, ConnectionQueryServicesMetrics> phoenixConnectionQueryServiceSet = new HashMap<String, ConnectionQueryServicesMetrics>();

    public boolean verifyConnectionQueryServiceName() {
        if (phoenixConnectionQueryServiceSet.isEmpty()) {
            return false;
        }
        for (String connectionQueryServiceName : ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames) {
            ConnectionQueryServicesMetrics instance = phoenixConnectionQueryServiceSet.get(connectionQueryServiceName);
            if (instance.getConnectionQueryServiceName().equals(connectionQueryServiceName)) continue;
            return false;
        }
        return true;
    }

    public void verifyMetricsFromPhoenixConnectionQueryServiceMetrics() {
        Assert.assertFalse((boolean)phoenixConnectionQueryServiceSet.isEmpty());
        for (int i = 0; i < ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames.length; ++i) {
            ConnectionQueryServicesMetrics instance = phoenixConnectionQueryServiceSet.get(ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames[i]);
            Assert.assertEquals((Object)instance.getConnectionQueryServiceName(), (Object)ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames[i]);
            List metricList = instance.getAllMetrics();
            for (ConnectionQueryServicesMetric metric : metricList) {
                if (metric.getMetricType().equals((Object)MetricType.OPEN_INTERNAL_PHOENIX_CONNECTIONS_COUNTER)) {
                    Assert.assertEquals((long)ConnectionQueryServicesNameMetricsTest.openInternalPhoenixConnCounter[i], (long)metric.getValue());
                }
                if (!metric.getMetricType().equals((Object)MetricType.OPEN_PHOENIX_CONNECTIONS_COUNTER)) continue;
                Assert.assertEquals((long)ConnectionQueryServicesNameMetricsTest.openPhoenixConnCounter[i], (long)metric.getValue());
            }
        }
    }

    @Test
    public void testPhoenixConnectionQueryServiceMetricsForPhoenixConnectionQueryServiceName() {
        Configuration conf = new Configuration();
        for (int i = 0; i < ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames.length; ++i) {
            ConnectionQueryServicesMetrics instance = new ConnectionQueryServicesMetrics(ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames[i], conf);
            phoenixConnectionQueryServiceSet.put(ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames[i], instance);
        }
        Assert.assertTrue((boolean)this.verifyConnectionQueryServiceName());
    }

    @Test
    public void testPhoenixConnectionQueryServiceMetrics() {
        Configuration conf = new Configuration();
        for (int i = 0; i < ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames.length; ++i) {
            ConnectionQueryServicesMetrics instance = new ConnectionQueryServicesMetrics(ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames[i], conf);
            phoenixConnectionQueryServiceSet.put(ConnectionQueryServicesNameMetricsTest.connectionQueryServiceNames[i], instance);
            instance.setMetricValue(MetricType.OPEN_INTERNAL_PHOENIX_CONNECTIONS_COUNTER, ConnectionQueryServicesNameMetricsTest.openInternalPhoenixConnCounter[i]);
            instance.setMetricValue(MetricType.OPEN_PHOENIX_CONNECTIONS_COUNTER, ConnectionQueryServicesNameMetricsTest.openPhoenixConnCounter[i]);
        }
        this.verifyMetricsFromPhoenixConnectionQueryServiceMetrics();
        phoenixConnectionQueryServiceSet.clear();
    }
}

