/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring.connectionqueryservice;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.monitoring.ConnectionQueryServicesMetric;
import org.apache.phoenix.monitoring.HistogramDistribution;
import org.apache.phoenix.monitoring.Metric;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConfigurationFactory;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.util.InstanceResolver;
import org.apache.phoenix.util.PhoenixRuntime;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ConnectionQueryServicesMetricsIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionQueryServicesMetricsIT.class);
    private AtomicInteger counter = new AtomicInteger();
    private static HBaseTestingUtility hbaseTestUtil;
    private String tableName;
    private static final String CONN_QUERY_SERVICE_1 = "CONN_QUERY_SERVICE_1";
    private static final String CONN_QUERY_SERVICE_CHECK_CONN_THROTTLE = "CONN_QUERY_SERVICE_CHECK_CONN_THROTTLE";
    private static final String CONN_QUERY_SERVICE_2 = "CONN_QUERY_SERVICE_2";
    private static final String CONN_QUERY_SERVICE_NULL;

    @BeforeClass
    public static void doSetup() throws Exception {
        InstanceResolver.clearSingletons();
        InstanceResolver.getSingleton(ConfigurationFactory.class, (Object)new ConfigurationFactory(){

            public Configuration getConfiguration() {
                Configuration conf = HBaseConfiguration.create();
                conf.set("phoenix.conn.query.service.metrics.enabled", String.valueOf(true));
                conf.set("phoenix.client.connection.max.allowed.connections", "2");
                conf.set("phoenix.internal.connection.max.allowed.connections", "1");
                return conf;
            }

            public Configuration getConfiguration(Configuration confToClone) {
                Configuration conf = HBaseConfiguration.create();
                conf.set("phoenix.conn.query.service.metrics.enabled", String.valueOf(true));
                conf.set("phoenix.client.connection.max.allowed.connections", "2");
                conf.set("phoenix.internal.connection.max.allowed.connections", "1");
                Configuration copy = new Configuration(conf);
                copy.addResource(confToClone);
                return copy;
            }
        });
        Configuration conf = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        conf.set("phoenix.task.handling.interval.ms", Long.toString(Long.MAX_VALUE));
        conf.set("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        hbaseTestUtil = new HBaseTestingUtility(conf);
        ConnectionQueryServicesMetricsIT.setUpConfigForMiniCluster(conf);
        conf.set("phoenix.jdbc.extra.arguments", "");
        hbaseTestUtil.startMiniCluster();
        String zkQuorum = "localhost:" + hbaseTestUtil.getZkCluster().getClientPort();
        url = "jdbc:phoenix:" + zkQuorum;
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
    }

    @AfterClass
    public static void tearDownMiniCluster() {
        try {
            if (hbaseTestUtil != null) {
                hbaseTestUtil.shutdownMiniCluster();
            }
        }
        catch (Exception exception) {
        }
        finally {
            ServerMetadataCacheTestImpl.resetCache();
        }
    }

    @Before
    public void resetTableLevelMetrics() {
        PhoenixRuntime.clearAllConnectionQueryServiceMetrics();
        this.tableName = ConnectionQueryServicesMetricsIT.generateUniqueName();
    }

    @After
    public void cleanUp() {
        PhoenixRuntime.clearAllConnectionQueryServiceMetrics();
    }

    private String connUrlWithPrincipal(String principalName) throws SQLException {
        return ConnectionInfo.create((String)url, null, null).withPrincipal(principalName).toUrl();
    }

    @Test
    public void testMultipleCQSIMetricsInParallel() throws Exception {
        Thread csqi1 = new Thread(() -> {
            try {
                this.checkConnectionQueryServiceMetricsValues(CONN_QUERY_SERVICE_1);
                this.counter.incrementAndGet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Thread csqi2 = new Thread(() -> {
            block2: {
                try {
                    this.checkConnectionQueryServiceMetricsValues(CONN_QUERY_SERVICE_CHECK_CONN_THROTTLE);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e.getMessage().equals("This should not be thrown for CONN_QUERY_SERVICE_CHECK_CONN_THROTTLE")) break block2;
                    this.counter.incrementAndGet();
                }
            }
        });
        Thread csqi3 = new Thread(() -> {
            try {
                this.checkConnectionQueryServiceMetricsValues(CONN_QUERY_SERVICE_2);
                this.counter.incrementAndGet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Thread csqi4 = new Thread(() -> {
            try {
                this.checkConnectionQueryServiceMetricsValues(CONN_QUERY_SERVICE_NULL);
                this.counter.incrementAndGet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        csqi1.start();
        csqi1.join();
        csqi2.start();
        csqi3.start();
        csqi4.start();
        csqi2.join();
        csqi3.join();
        csqi4.join();
        Assert.assertEquals((String)"Number of passing CSQI Metrics check should be : ", (long)4L, (long)this.counter.get());
    }

    private void checkConnectionQueryServiceMetricsValues(String queryServiceName) throws Exception {
        String CREATE_TABLE_DDL = "CREATE TABLE IF NOT EXISTS %s (K VARCHAR(10) NOT NULL PRIMARY KEY, V VARCHAR)";
        String princURL = this.connUrlWithPrincipal(queryServiceName);
        LOGGER.info("Connection Query Service : " + queryServiceName + " URL : " + princURL);
        try (Connection conn = DriverManager.getConnection(princURL);
             Statement stmt = conn.createStatement();){
            String connQueryServiceName;
            queryServiceName = connQueryServiceName = conn.unwrap(PhoenixConnection.class).getQueryServices().getConfiguration().get("phoenix.query.services.name");
            stmt.execute(String.format(CREATE_TABLE_DDL, this.tableName + "_" + connQueryServiceName));
            if (connQueryServiceName.equals(CONN_QUERY_SERVICE_CHECK_CONN_THROTTLE)) {
                Connection conn1 = DriverManager.getConnection(princURL);
                try {
                    this.assertMetricValues(connQueryServiceName, 2, 0, 0);
                    this.assertHistogramMetricsForMutations(connQueryServiceName, 2, 0, 0, 0);
                    Connection conn2 = DriverManager.getConnection(princURL);
                    try {
                        throw new RuntimeException("This should not be thrown for CONN_QUERY_SERVICE_CHECK_CONN_THROTTLE");
                    }
                    catch (Throwable throwable) {
                        if (conn2 != null) {
                            try {
                                conn2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    if (conn1 != null) {
                        try {
                            conn1.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
            }
            this.assertMetricValues(connQueryServiceName, 1, 0, 0);
            this.assertHistogramMetricsForMutations(connQueryServiceName, 1, 0, 0, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (queryServiceName.equals(CONN_QUERY_SERVICE_CHECK_CONN_THROTTLE)) {
                this.assertMetricValues(queryServiceName, 0, 1, 0);
                this.assertHistogramMetricsForMutations(queryServiceName, 2, 0, 0, 0);
            } else {
                this.assertMetricValues(queryServiceName, 0, 0, 0);
                this.assertHistogramMetricsForMutations(queryServiceName, 1, 0, 0, 0);
            }
        }
    }

    private void assertHistogramMetricsForMutations(String queryServiceName, int oMaxValue, int oMinValue, int ioMaxValue, int ioMinValue) {
        Map listOfHistoDistribution = PhoenixRuntime.getAllConnectionQueryServicesHistograms();
        for (HistogramDistribution histo : (List)listOfHistoDistribution.get(queryServiceName)) {
            this.assertHistogram(histo, "PhoenixInternalOpenConn", ioMaxValue, ioMinValue, CompareOp.EQ);
            this.assertHistogram(histo, "PhoenixOpenConn", oMaxValue, oMinValue, CompareOp.EQ);
        }
    }

    public void assertHistogram(HistogramDistribution histo, String histoName, long maxValue, long minValue, CompareOp op) {
        if (histo.getHistoName().equals(histoName)) {
            switch (op) {
                case EQ: {
                    Assert.assertEquals((long)maxValue, (long)histo.getMax());
                    Assert.assertEquals((long)minValue, (long)histo.getMin());
                }
            }
        }
    }

    public void assertMetricValues(String queryServiceName, int o, int ct, int io) {
        Map listOfMetrics = PhoenixRuntime.getAllConnectionQueryServicesCounters();
        Assert.assertEquals((long)3L, (long)((List)listOfMetrics.get(queryServiceName)).size());
        for (ConnectionQueryServicesMetric metric : (List)listOfMetrics.get(queryServiceName)) {
            ConnectionQueryServicesMetricsIT.assertMetricValue((Metric)metric, MetricType.OPEN_PHOENIX_CONNECTIONS_COUNTER, o, CompareOp.EQ);
            ConnectionQueryServicesMetricsIT.assertMetricValue((Metric)metric, MetricType.PHOENIX_CONNECTIONS_THROTTLED_COUNTER, ct, CompareOp.EQ);
            ConnectionQueryServicesMetricsIT.assertMetricValue((Metric)metric, MetricType.OPEN_INTERNAL_PHOENIX_CONNECTIONS_COUNTER, io, CompareOp.EQ);
        }
    }

    public void assertMetricListIsEmpty() {
        Map listOfMetrics = PhoenixRuntime.getAllConnectionQueryServicesCounters();
        Assert.assertTrue((boolean)listOfMetrics.isEmpty());
    }

    private static void assertMetricValue(Metric m, MetricType checkType, long compareValue, CompareOp op) {
        if (m.getMetricType().equals((Object)checkType)) {
            switch (op) {
                case EQ: {
                    Assert.assertEquals((long)compareValue, (long)m.getValue());
                    break;
                }
                case LT: {
                    Assert.assertTrue((m.getValue() < compareValue ? 1 : 0) != 0);
                    break;
                }
                case LTEQ: {
                    Assert.assertTrue((m.getValue() <= compareValue ? 1 : 0) != 0);
                    break;
                }
                case GT: {
                    Assert.assertTrue((m.getValue() > compareValue ? 1 : 0) != 0);
                    break;
                }
                case GTEQ: {
                    Assert.assertTrue((m.getValue() >= compareValue ? 1 : 0) != 0);
                }
            }
        }
    }

    static {
        CONN_QUERY_SERVICE_NULL = null;
    }

    private static enum CompareOp {
        LT,
        EQ,
        GT,
        LTEQ,
        GTEQ;

    }
}

