/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring.connectionqueryservice;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.monitoring.connectionqueryservice.ConnectionQueryServicesHistogram;
import org.junit.Assert;
import org.junit.Test;

public class ConnectionQueryServicesHistogramTest {
    @Test
    public void testConnectionQueryServiceHistogramRangeOverride() {
        String histoName = "PhoenixInternalOpenConn";
        Configuration conf = new Configuration();
        conf.set("phoenix.conn.query.service.histogram.size.ranges", "2, 5, 8");
        ConnectionQueryServicesHistogram histogram = new ConnectionQueryServicesHistogram(histoName, "histogram for Number of open internal phoenix connections", conf);
        Assert.assertEquals((Object)histoName, (Object)histogram.getName());
        long[] ranges = histogram.getRanges();
        Assert.assertNotNull((Object)ranges);
        long[] expectRanges = new long[]{2L, 5L, 8L};
        Assert.assertArrayEquals((long[])expectRanges, (long[])ranges);
    }

    @Test
    public void testEveryRangeInDefaultRange() {
        Configuration conf = new Configuration();
        String histoName = "PhoenixInternalOpenConn";
        conf.unset("phoenix.conn.query.service.histogram.size.ranges");
        ConnectionQueryServicesHistogram histogram = new ConnectionQueryServicesHistogram(histoName, "histogram for Number of open internal phoenix connections", conf);
        Assert.assertEquals((Object)histoName, (Object)histogram.getName());
        Assert.assertEquals((Object)ConnectionQueryServicesHistogram.DEFAULT_RANGE, (Object)histogram.getRanges());
        histogram.add(1L);
        histogram.add(3L);
        histogram.add(7L);
        histogram.add(9L);
        histogram.add(15L);
        histogram.add(30L);
        histogram.add(120L);
        histogram.add(600L);
        Map distribution = histogram.getRangeHistogramDistribution().getRangeDistributionMap();
        HashMap<String, Long> expectedMap = new HashMap<String, Long>();
        expectedMap.put("0,1", 1L);
        expectedMap.put("1,10", 3L);
        expectedMap.put("10,100", 2L);
        expectedMap.put("100,500", 1L);
        expectedMap.put("500,1000", 1L);
        Assert.assertEquals(expectedMap, (Object)distribution);
    }
}

