/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.PhoenixTableMetric;
import org.apache.phoenix.monitoring.TableClientMetrics;
import org.apache.phoenix.monitoring.TableLevelMetricsTestData;
import org.junit.Assert;
import org.junit.Test;

public class TableClientMetricsTest {
    private static Map<String, TableClientMetrics> tableMetricsSet = new HashMap<String, TableClientMetrics>();

    public void verifyMetricsFromTableClientMetrics() {
        Assert.assertFalse((boolean)tableMetricsSet.isEmpty());
        for (int i = 0; i < TableLevelMetricsTestData.tableNames.length; ++i) {
            TableClientMetrics instance = tableMetricsSet.get(TableLevelMetricsTestData.tableNames[i]);
            Assert.assertEquals((Object)instance.getTableName(), (Object)TableLevelMetricsTestData.tableNames[i]);
            List metricList = instance.getMetricMap();
            for (PhoenixTableMetric metric : metricList) {
                if (metric.getMetricType().equals((Object)MetricType.MUTATION_BATCH_SIZE)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.mutationBatchSizeCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.UPSERT_MUTATION_BYTES)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.upsertMutationBytesCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.UPSERT_MUTATION_SQL_COUNTER)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.upsertMutationSqlCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.DELETE_MUTATION_BYTES)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.deleteMutationByesCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.DELETE_MUTATION_SQL_COUNTER)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.deleteMutationSqlCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.MUTATION_SQL_COUNTER)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.mutationSqlCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.MUTATION_COMMIT_TIME)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.mutationSqlCommitTimeCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.TASK_END_TO_END_TIME)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.taskEndToEndTimeCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.COUNT_ROWS_SCANNED)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.countRowsScannedCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.QUERY_FAILED_COUNTER)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.queryFailedCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.QUERY_TIMEOUT_COUNTER)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.queryTimeOutCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.SCAN_BYTES)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.scanBytesCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.SELECT_POINTLOOKUP_SUCCESS_SQL_COUNTER)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.selectPointLookUpSuccessCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.SELECT_POINTLOOKUP_FAILED_SQL_COUNTER)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.selectPointLookUpFailedCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.SELECT_SQL_QUERY_TIME)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.selectSqlQueryTimeCounter[i], (long)metric.getValue());
                }
                if (metric.getMetricType().equals((Object)MetricType.SELECT_SCAN_FAILED_SQL_COUNTER)) {
                    Assert.assertEquals((long)TableLevelMetricsTestData.selectScanFailedCounter[i], (long)metric.getValue());
                }
                if (!metric.getMetricType().equals((Object)MetricType.SELECT_SCAN_SUCCESS_SQL_COUNTER)) continue;
                Assert.assertEquals((long)TableLevelMetricsTestData.selectScanSuccessCounter[i], (long)metric.getValue());
            }
        }
    }

    public boolean verifyTableName() {
        if (tableMetricsSet.isEmpty()) {
            return false;
        }
        for (String tableName : TableLevelMetricsTestData.tableNames) {
            TableClientMetrics instance = tableMetricsSet.get(tableName);
            if (instance.getTableName().equals(tableName)) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testTableClientMetrics() {
        Configuration conf = new Configuration();
        for (int i = 0; i < TableLevelMetricsTestData.tableNames.length; ++i) {
            TableClientMetrics tableClientMetrics = new TableClientMetrics(TableLevelMetricsTestData.tableNames[i], conf);
            tableMetricsSet.put(TableLevelMetricsTestData.tableNames[i], tableClientMetrics);
            tableClientMetrics.changeMetricValue(MetricType.MUTATION_BATCH_SIZE, TableLevelMetricsTestData.mutationBatchSizeCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.UPSERT_MUTATION_BYTES, TableLevelMetricsTestData.upsertMutationBytesCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.UPSERT_MUTATION_SQL_COUNTER, TableLevelMetricsTestData.upsertMutationSqlCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.DELETE_MUTATION_BYTES, TableLevelMetricsTestData.deleteMutationByesCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.DELETE_MUTATION_SQL_COUNTER, TableLevelMetricsTestData.deleteMutationSqlCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.MUTATION_SQL_COUNTER, TableLevelMetricsTestData.mutationSqlCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.MUTATION_COMMIT_TIME, TableLevelMetricsTestData.mutationSqlCommitTimeCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.TASK_END_TO_END_TIME, TableLevelMetricsTestData.taskEndToEndTimeCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.COUNT_ROWS_SCANNED, TableLevelMetricsTestData.countRowsScannedCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.QUERY_FAILED_COUNTER, TableLevelMetricsTestData.queryFailedCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.QUERY_TIMEOUT_COUNTER, TableLevelMetricsTestData.queryTimeOutCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.SCAN_BYTES, TableLevelMetricsTestData.scanBytesCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.SELECT_POINTLOOKUP_SUCCESS_SQL_COUNTER, TableLevelMetricsTestData.selectPointLookUpSuccessCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.SELECT_POINTLOOKUP_FAILED_SQL_COUNTER, TableLevelMetricsTestData.selectPointLookUpFailedCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.SELECT_SQL_QUERY_TIME, TableLevelMetricsTestData.selectSqlQueryTimeCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.SELECT_SCAN_SUCCESS_SQL_COUNTER, TableLevelMetricsTestData.selectScanSuccessCounter[i]);
            tableClientMetrics.changeMetricValue(MetricType.SELECT_SCAN_FAILED_SQL_COUNTER, TableLevelMetricsTestData.selectScanFailedCounter[i]);
        }
        this.verifyMetricsFromTableClientMetrics();
        tableMetricsSet.clear();
    }

    @Test
    public void testTableClientMetricsforTableName() {
        Configuration conf = new Configuration();
        for (int i = 0; i < TableLevelMetricsTestData.tableNames.length; ++i) {
            TableClientMetrics tableClientMetrics = new TableClientMetrics(TableLevelMetricsTestData.tableNames[i], conf);
            tableMetricsSet.put(TableLevelMetricsTestData.tableNames[i], tableClientMetrics);
        }
        Assert.assertTrue((boolean)this.verifyTableName());
    }
}

