/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.PhoenixTableMetricImpl;
import org.junit.Assert;
import org.junit.Test;

public class PhoenixTableMetricImplTest {
    @Test
    public void testTableMetricImplAvailableMethods() {
        int i;
        PhoenixTableMetricImpl metric = new PhoenixTableMetricImpl(MetricType.SELECT_SQL_COUNTER);
        for (i = 0; i < 10; ++i) {
            metric.increment();
        }
        Assert.assertEquals((long)10L, (long)metric.getValue());
        metric.reset();
        Assert.assertEquals((long)0L, (long)metric.getValue());
        for (i = 0; i < 5; ++i) {
            metric.change((long)i);
        }
        Assert.assertEquals((long)10L, (long)metric.getValue());
        metric.reset();
        Assert.assertEquals((long)0L, (long)metric.getValue());
        metric.change(10L);
        Assert.assertEquals((long)10L, (long)metric.getValue());
        for (i = 0; i < 5; ++i) {
            metric.decrement();
        }
        Assert.assertEquals((long)5L, (long)metric.getValue());
    }

    @Test
    public void testPhoenixImplchange() {
        PhoenixTableMetricImpl metric = new PhoenixTableMetricImpl(MetricType.SELECT_SQL_COUNTER);
        for (int i = 0; i < 5; ++i) {
            metric.change((long)i);
        }
        Assert.assertEquals((long)10L, (long)metric.getValue());
    }

    @Test
    public void testPhoenixImplIncrement() {
        PhoenixTableMetricImpl metric = new PhoenixTableMetricImpl(MetricType.SELECT_SQL_COUNTER);
        for (int i = 0; i < 10; ++i) {
            metric.increment();
        }
        Assert.assertEquals((long)10L, (long)metric.getValue());
    }

    @Test
    public void testPhoenixImplDecrement() {
        PhoenixTableMetricImpl metric = new PhoenixTableMetricImpl(MetricType.SELECT_SQL_COUNTER);
        metric.change(10L);
        for (int i = 0; i < 5; ++i) {
            metric.decrement();
        }
        Assert.assertEquals((long)5L, (long)metric.getValue());
    }

    @Test
    public void testPhoenixImplReset() {
        PhoenixTableMetricImpl metric = new PhoenixTableMetricImpl(MetricType.SELECT_SQL_COUNTER);
        metric.change(10L);
        metric.reset();
        Assert.assertEquals((long)0L, (long)metric.getValue());
    }

    @Test
    public void testPhoenixImplGetValue() {
        PhoenixTableMetricImpl metric = new PhoenixTableMetricImpl(MetricType.SELECT_SQL_COUNTER);
        metric.change(10L);
        Assert.assertEquals((long)10L, (long)metric.getValue());
    }
}

