/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.CommitException;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.LatencyHistogram;
import org.apache.phoenix.monitoring.Metric;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.PhoenixMetricsIT;
import org.apache.phoenix.monitoring.PhoenixTableMetric;
import org.apache.phoenix.monitoring.SizeHistogram;
import org.apache.phoenix.monitoring.TableMetricsManager;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConfigurationFactory;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.query.QueryServicesTestImpl;
import org.apache.phoenix.util.DelayedOrFailingRegionServer;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.InstanceResolver;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ValidateLastDDLTimestampUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PhoenixTableLevelMetricsIT
extends BaseTest {
    private static final String CREATE_TABLE_DDL = "CREATE TABLE %s (K VARCHAR(%d) NOT NULL PRIMARY KEY, V VARCHAR)";
    private static final String UPSERT_DML = "UPSERT INTO %s VALUES (?, ?)";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static boolean failExecuteQueryAndClientSideDeletes;
    private static long injectDelay;
    private static HBaseTestingUtility hbaseTestUtil;

    @BeforeClass
    public static void doSetup() throws Exception {
        final Configuration conf = HBaseConfiguration.create();
        PhoenixTableLevelMetricsIT.setUpConfigForMiniCluster(conf);
        conf.set("phoenix.monitoring.tableMetrics.enabled", String.valueOf(true));
        conf.set("phoenix.monitoring.metricsPublisher.enabled", String.valueOf(true));
        conf.set("phoenix.query.request.metrics.enabled", String.valueOf(true));
        InstanceResolver.clearSingletons();
        InstanceResolver.getSingleton(ConfigurationFactory.class, (Object)new ConfigurationFactory(){

            public Configuration getConfiguration() {
                return conf;
            }

            public Configuration getConfiguration(Configuration confToClone) {
                Configuration copy = new Configuration(conf);
                copy.addResource(confToClone);
                return copy;
            }
        });
        hbaseTestUtil = new HBaseTestingUtility(conf);
        hbaseTestUtil.startMiniCluster(1, 1, null, null, DelayedOrFailingRegionServer.class);
        String zkQuorum = "localhost:" + hbaseTestUtil.getZkCluster().getClientPort();
        url = "jdbc:phoenix+zk:" + zkQuorum;
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.driver.class.name", PhoenixMetricsTestingDriver.class.getName());
        props.put("phoenix.client.enable.server.upsert.select", "true");
        PhoenixTableLevelMetricsIT.initAndRegisterTestDriver(url, new ReadOnlyProps(props.entrySet().iterator()));
    }

    @AfterClass
    public static void tearDownMiniCluster() {
        try {
            if (hbaseTestUtil != null) {
                hbaseTestUtil.shutdownMiniCluster();
            }
        }
        catch (Exception exception) {
        }
        finally {
            ServerMetadataCacheTestImpl.resetCache();
        }
    }

    public static void checkSystemCatalogTableMetric() {
        for (PhoenixTableMetric metric : (List)PhoenixRuntime.getPhoenixTableClientMetrics().get(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME)) {
            if (metric.getMetricType().equals((Object)MetricType.NUM_SYSTEM_TABLE_RPC_SUCCESS)) {
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.NUM_SYSTEM_TABLE_RPC_SUCCESS, 0L, CompareOp.GT);
            }
            if (!metric.getMetricType().equals((Object)MetricType.TIME_SPENT_IN_SYSTEM_TABLE_RPC_CALLS)) continue;
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.TIME_SPENT_IN_SYSTEM_TABLE_RPC_CALLS, 0L, CompareOp.GT);
        }
    }

    static void assertSelectQueryTableMetrics(String tableName, boolean isPointLookup, long expectedSelectAggregateSuccessCt, long expectedSelectAggregateFailureCt, long expectedSqlSuccessCt, long expectedSqlFailureCt, long expectedMinTimeElapsed, boolean hasResultSetIterationStarted, long expectedResultSetIterFailedCounter, long expectedResultSetIterTimeoutCounter, ResultSet rs) throws SQLException {
        if (hasResultSetIterationStarted) {
            Assert.assertTrue((rs != null && rs.isClosed() ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((rs == null || rs.isBeforeFirst() ? 1 : 0) != 0);
        }
        Assert.assertFalse((boolean)PhoenixRuntime.getPhoenixTableClientMetrics().isEmpty());
        Assert.assertFalse((boolean)((List)PhoenixRuntime.getPhoenixTableClientMetrics().get(tableName)).isEmpty());
        long expectedTimeToFetchAllRecordsRsNext = rs == null ? 0L : (Long)PhoenixRuntime.getOverAllReadRequestMetricInfo((ResultSet)rs).get(MetricType.RESULT_SET_TIME_MS);
        long expectedScanBytes = rs == null || rs.isBeforeFirst() ? 0L : (Long)((Map)PhoenixRuntime.getRequestReadMetricInfo((ResultSet)rs).get(tableName)).get(MetricType.SCAN_BYTES);
        long expectedSqlCounter = expectedSqlSuccessCt + expectedSqlFailureCt;
        for (PhoenixTableMetric metric : (List)PhoenixRuntime.getPhoenixTableClientMetrics().get(tableName)) {
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.SELECT_SQL_COUNTER, expectedSqlCounter, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.SELECT_AGGREGATE_FAILURE_SQL_COUNTER, expectedSelectAggregateFailureCt, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.SELECT_AGGREGATE_SUCCESS_SQL_COUNTER, expectedSelectAggregateSuccessCt, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.SELECT_SUCCESS_SQL_COUNTER, expectedSqlSuccessCt, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isPointLookup ? MetricType.SELECT_POINTLOOKUP_SUCCESS_SQL_COUNTER : MetricType.SELECT_SCAN_SUCCESS_SQL_COUNTER, expectedSqlSuccessCt, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.SELECT_FAILED_SQL_COUNTER, expectedSqlFailureCt, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isPointLookup ? MetricType.SELECT_POINTLOOKUP_FAILED_SQL_COUNTER : MetricType.SELECT_SCAN_FAILED_SQL_COUNTER, expectedSqlFailureCt, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.SELECT_SQL_QUERY_TIME, expectedMinTimeElapsed, CompareOp.GT);
            if (hasResultSetIterationStarted) {
                if (expectedResultSetIterFailedCounter == 0L) {
                    PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.SCAN_BYTES, 0L, CompareOp.GT);
                    PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.RESULT_SET_TIME_MS, 0L, CompareOp.GT);
                } else {
                    PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.SCAN_BYTES, 0L, CompareOp.EQ);
                }
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.SCAN_BYTES, expectedScanBytes, CompareOp.EQ);
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.QUERY_FAILED_COUNTER, expectedResultSetIterFailedCounter, CompareOp.EQ);
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isPointLookup ? MetricType.QUERY_POINTLOOKUP_FAILED_COUNTER : MetricType.QUERY_SCAN_FAILED_COUNTER, expectedResultSetIterFailedCounter, CompareOp.EQ);
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.QUERY_TIMEOUT_COUNTER, expectedResultSetIterTimeoutCounter, CompareOp.EQ);
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isPointLookup ? MetricType.QUERY_POINTLOOKUP_TIMEOUT_COUNTER : MetricType.QUERY_SCAN_TIMEOUT_COUNTER, expectedResultSetIterTimeoutCounter, CompareOp.EQ);
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.RESULT_SET_TIME_MS, expectedTimeToFetchAllRecordsRsNext, CompareOp.EQ);
                continue;
            }
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.SCAN_BYTES, 0L, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.QUERY_FAILED_COUNTER, 0L, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isPointLookup ? MetricType.QUERY_POINTLOOKUP_FAILED_COUNTER : MetricType.QUERY_SCAN_FAILED_COUNTER, 0L, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.QUERY_TIMEOUT_COUNTER, 0L, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isPointLookup ? MetricType.QUERY_POINTLOOKUP_TIMEOUT_COUNTER : MetricType.QUERY_SCAN_TIMEOUT_COUNTER, 0L, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.RESULT_SET_TIME_MS, 0L, CompareOp.EQ);
        }
    }

    private static void assertMutationTableMetrics(boolean isUpsert, String tableName, long expectedUpsertOrDeleteSuccessSqlCt, long expectedUpsertOrDeleteFailedSqlCt, long expectedMinUpsertOrDeleteSqlQueryTime, boolean hasMutationBeenExplicitlyCommitted, long expectedMutBatchSize, long expectedMinUpsertOrDeleteCommitTime, long expectedUpsertOrDeleteBatchFailedSize, long expectedUpsertOrDeleteAggregateSuccessCt, long expectedUpsertOrDeleteAggregateFailureCt, Map<MetricType, Long> writeMutMetrics, Connection conn, boolean expectedSystemCatalogMetric, long expectedMutationBatchCount) throws SQLException {
        Assert.assertTrue((conn != null && conn.isClosed() ? 1 : 0) != 0);
        Assert.assertFalse((hasMutationBeenExplicitlyCommitted && writeMutMetrics == null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)PhoenixRuntime.getPhoenixTableClientMetrics().isEmpty());
        Assert.assertFalse((boolean)((List)PhoenixRuntime.getPhoenixTableClientMetrics().get(tableName)).isEmpty());
        long expectedUpsertOrDeleteSqlCt = expectedUpsertOrDeleteSuccessSqlCt + expectedUpsertOrDeleteFailedSqlCt;
        for (PhoenixTableMetric metric : (List)PhoenixRuntime.getPhoenixTableClientMetrics().get(tableName)) {
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_SQL_COUNTER : MetricType.DELETE_SQL_COUNTER, expectedUpsertOrDeleteSqlCt, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_SUCCESS_SQL_COUNTER : MetricType.DELETE_SUCCESS_SQL_COUNTER, expectedUpsertOrDeleteSuccessSqlCt, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_FAILED_SQL_COUNTER : MetricType.DELETE_FAILED_SQL_COUNTER, expectedUpsertOrDeleteFailedSqlCt, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_SQL_QUERY_TIME : MetricType.DELETE_SQL_QUERY_TIME, expectedMinUpsertOrDeleteSqlQueryTime, CompareOp.GTEQ);
            if (expectedSystemCatalogMetric) {
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.NUM_SYSTEM_TABLE_RPC_SUCCESS, 0L, CompareOp.GT);
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.TIME_SPENT_IN_SYSTEM_TABLE_RPC_CALLS, 0L, CompareOp.GT);
            }
            if (!hasMutationBeenExplicitlyCommitted) continue;
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_SIZE, writeMutMetrics.get(MetricType.MUTATION_BATCH_SIZE), CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_SIZE, expectedMutBatchSize, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BYTES, writeMutMetrics.get(MetricType.MUTATION_BYTES), CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_FAILED_SIZE, writeMutMetrics.get(MetricType.MUTATION_BATCH_FAILED_SIZE), CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_FAILED_SIZE, expectedUpsertOrDeleteBatchFailedSize, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_COMMIT_TIME : MetricType.DELETE_COMMIT_TIME, writeMutMetrics.get(isUpsert ? MetricType.UPSERT_COMMIT_TIME : MetricType.DELETE_COMMIT_TIME), CompareOp.EQ);
            if (expectedUpsertOrDeleteAggregateSuccessCt > 0L) {
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_AGGREGATE_SUCCESS_SQL_COUNTER : MetricType.DELETE_AGGREGATE_SUCCESS_SQL_COUNTER, expectedUpsertOrDeleteAggregateSuccessCt, CompareOp.EQ);
            }
            if (expectedUpsertOrDeleteAggregateFailureCt > 0L) {
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_AGGREGATE_FAILURE_SQL_COUNTER : MetricType.DELETE_AGGREGATE_FAILURE_SQL_COUNTER, expectedUpsertOrDeleteAggregateFailureCt, CompareOp.EQ);
            }
            if (expectedUpsertOrDeleteBatchFailedSize > 0L) {
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_COMMIT_TIME : MetricType.DELETE_COMMIT_TIME, 0L, CompareOp.EQ);
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_MUTATION_SQL_COUNTER : MetricType.DELETE_MUTATION_SQL_COUNTER, 0L, CompareOp.EQ);
            } else {
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_COMMIT_TIME : MetricType.DELETE_COMMIT_TIME, expectedMinUpsertOrDeleteCommitTime, CompareOp.GTEQ);
                PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_MUTATION_SQL_COUNTER : MetricType.DELETE_MUTATION_SQL_COUNTER, expectedMutBatchSize, CompareOp.EQ);
            }
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_MUTATION_BYTES : MetricType.DELETE_MUTATION_BYTES, writeMutMetrics.get(isUpsert ? MetricType.UPSERT_MUTATION_BYTES : MetricType.DELETE_MUTATION_BYTES), CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_MUTATION_SQL_COUNTER : MetricType.DELETE_MUTATION_SQL_COUNTER, writeMutMetrics.get(isUpsert ? MetricType.UPSERT_MUTATION_SQL_COUNTER : MetricType.DELETE_MUTATION_SQL_COUNTER), CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_BATCH_FAILED_SIZE : MetricType.DELETE_BATCH_FAILED_SIZE, writeMutMetrics.get(isUpsert ? MetricType.UPSERT_BATCH_FAILED_SIZE : MetricType.DELETE_BATCH_FAILED_SIZE), CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_BATCH_FAILED_SIZE : MetricType.DELETE_BATCH_FAILED_SIZE, expectedUpsertOrDeleteBatchFailedSize, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, isUpsert ? MetricType.UPSERT_BATCH_FAILED_COUNTER : MetricType.DELETE_BATCH_FAILED_COUNTER, writeMutMetrics.get(isUpsert ? MetricType.UPSERT_BATCH_FAILED_COUNTER : MetricType.DELETE_BATCH_FAILED_COUNTER), CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_COUNTER, writeMutMetrics.get(MetricType.MUTATION_BATCH_COUNTER), CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_COUNTER, expectedMutationBatchCount, CompareOp.EQ);
        }
        if (expectedSystemCatalogMetric) {
            PhoenixTableLevelMetricsIT.checkSystemCatalogTableMetric();
        }
    }

    private void assertHistogramMetricsForMutations(String tableName, boolean isUpsert, long ltCount, long szCount, boolean verifyMetricValues) {
        SizeHistogram szHisto;
        LatencyHistogram ltHisto;
        if (isUpsert) {
            ltHisto = TableMetricsManager.getUpsertLatencyHistogramForTable((String)tableName);
            szHisto = TableMetricsManager.getUpsertSizeHistogramForTable((String)tableName);
        } else {
            ltHisto = TableMetricsManager.getDeleteLatencyHistogramForTable((String)tableName);
            szHisto = TableMetricsManager.getDeleteSizeHistogramForTable((String)tableName);
        }
        Assert.assertNotNull((Object)ltHisto);
        Assert.assertNotNull((Object)szHisto);
        Assert.assertEquals((long)ltCount, (long)ltHisto.getHistogram().getTotalCount());
        Assert.assertEquals((long)szCount, (long)szHisto.getHistogram().getTotalCount());
        if (verifyMetricValues) {
            long sqlTime = isUpsert ? this.getMetricFromTableMetrics(tableName, MetricType.UPSERT_SQL_QUERY_TIME) : this.getMetricFromTableMetrics(tableName, MetricType.DELETE_SQL_QUERY_TIME);
            long commitTime = this.getMetricFromTableMetrics(tableName, MetricType.MUTATION_COMMIT_TIME);
            long totalCommitTimeFromMetrics = sqlTime + commitTime;
            Assert.assertTrue((boolean)ltHisto.getHistogram().valuesAreEquivalent(totalCommitTimeFromMetrics, ltHisto.getHistogram().getMaxValue()));
            long mutationBytesFromGlobalMetrics = GlobalClientMetrics.GLOBAL_MUTATION_BYTES.getMetric().getValue();
            Assert.assertTrue((boolean)szHisto.getHistogram().valuesAreEquivalent(mutationBytesFromGlobalMetrics, szHisto.getHistogram().getMaxValue()));
        }
    }

    private static void assertMetricValue(Metric m, MetricType checkType, long compareValue, CompareOp op) {
        if (m.getMetricType().equals((Object)checkType)) {
            switch (op) {
                case EQ: {
                    Assert.assertEquals((long)compareValue, (long)m.getValue());
                    break;
                }
                case LT: {
                    Assert.assertTrue((m.getValue() < compareValue ? 1 : 0) != 0);
                    break;
                }
                case LTEQ: {
                    Assert.assertTrue((m.getValue() <= compareValue ? 1 : 0) != 0);
                    break;
                }
                case GT: {
                    Assert.assertTrue((m.getValue() > compareValue ? 1 : 0) != 0);
                    break;
                }
                case GTEQ: {
                    Assert.assertTrue((m.getValue() >= compareValue ? 1 : 0) != 0);
                }
            }
        }
    }

    @Before
    public void resetTableLevelMetrics() {
        PhoenixRuntime.clearTableLevelMetrics();
        failExecuteQueryAndClientSideDeletes = false;
        injectDelay = 0L;
        EnvironmentEdgeManager.reset();
        DelayedOrFailingRegionServer.setDelayEnabled(false);
        DelayedOrFailingRegionServer.injectFailureForRegionOfTable(null);
    }

    @Test
    public void testTableLevelMetricsforSuccessfulPointLookupQuery() throws Exception {
        ResultSet rs;
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        try (Connection conn = this.getConnFromTestDriver();){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, false, false, 20, true, conn, false);
        }
        conn = this.getConnFromTestDriver();
        try (Statement stmt = conn.createStatement();){
            rs = stmt.executeQuery(String.format("SELECT J, G, E, (NOW() - I)*24*60*60*1000 FROM %s WHERE A='keyA1' AND B='keyB1' AND C='keyC1' AND D='keyD1'", tableName));
            PhoenixTableLevelMetricsIT.assertSelectQueryTableMetrics(tableName, true, 0L, 0L, 1L, 0L, 0L, false, 0L, 0L, rs);
            rs.next();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        PhoenixTableLevelMetricsIT.assertSelectQueryTableMetrics(tableName, true, 1L, 0L, 1L, 0L, 0L, true, 0L, 0L, rs);
    }

    @Test
    public void testTableLevelMetricsforSuccessfulScanQuery() throws Exception {
        ResultSet rs;
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        try (Connection conn = this.getConnFromTestDriver();){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, false, false, 20, true, conn, false);
        }
        conn = this.getConnFromTestDriver();
        try (Statement stmt = conn.createStatement();){
            rs = stmt.executeQuery(String.format("SELECT A, B, C FROM %s WHERE A='keyA1' AND B='keyB1' AND C > 'keyC0'", tableName));
            PhoenixTableLevelMetricsIT.assertSelectQueryTableMetrics(tableName, false, 0L, 0L, 1L, 0L, 0L, false, 0L, 0L, rs);
            while (rs.next()) {
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        PhoenixTableLevelMetricsIT.assertSelectQueryTableMetrics(tableName, false, 1L, 0L, 1L, 0L, 0L, true, 0L, 0L, rs);
    }

    @Ignore
    @Test
    public void testTableLevelMetricsforFailingSelectQuery() throws Exception {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        try (Connection conn = this.getConnFromTestDriver();){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, false, false, 10, true, conn, false);
        }
        conn = this.getConnFromTestDriver();
        try (Statement stmt = conn.createStatement();){
            failExecuteQueryAndClientSideDeletes = true;
            try {
                stmt.executeQuery(String.format("SELECT J, G, E, (NOW() - I)*24*60*60*1000 FROM %s WHERE A='keyA1' AND B='keyB1' AND C='keyC1' AND D='keyD1'", tableName));
                Assert.fail();
            }
            catch (SQLException sqlE) {
                Assert.assertEquals((long)SQLExceptionCode.GET_TABLE_REGIONS_FAIL.getErrorCode(), (long)sqlE.getErrorCode());
                PhoenixTableLevelMetricsIT.assertSelectQueryTableMetrics(tableName, true, 0L, 1L, 0L, 1L, 0L, false, 0L, 0L, null);
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Ignore
    @Test
    public void testTableLevelMetricsforDelayedSelectQuery() throws Exception {
        ResultSet rs;
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        try (Connection conn = this.getConnFromTestDriver();){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, false, false, 10, true, conn, false);
        }
        conn = this.getConnFromTestDriver();
        try (Statement stmt = conn.createStatement();){
            injectDelay = 1000L;
            rs = stmt.executeQuery(String.format("SELECT J, G, E, (NOW() - I)*24*60*60*1000 FROM %s WHERE A='keyA1' AND B='keyB1' AND C='keyC1' AND D='keyD1'", tableName));
            PhoenixTableLevelMetricsIT.assertSelectQueryTableMetrics(tableName, true, 0L, 0L, 1L, 0L, injectDelay, false, 0L, 0L, rs);
            rs.next();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        PhoenixTableLevelMetricsIT.assertSelectQueryTableMetrics(tableName, true, 1L, 0L, 1L, 0L, injectDelay, true, 0L, 0L, rs);
    }

    @Test
    public void testTableLevelMetricsForSelectFetchResultsTimeout() throws SQLException {
        ResultSet rs;
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        int queryTimeout = 10;
        try (Connection conn = this.getConnFromTestDriver();){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, false, false, 2, true, conn, false);
        }
        conn = this.getConnFromTestDriver();
        try (Statement stmt = conn.createStatement();){
            stmt.setQueryTimeout(10);
            rs = stmt.executeQuery(String.format("SELECT J, G, E, (NOW() - I)*24*60*60*1000 FROM %s WHERE A='keyA1' AND B='keyB1' AND C='keyC1' AND D='keyD1'", tableName));
            PhoenixTableLevelMetricsIT.assertSelectQueryTableMetrics(tableName, true, 0L, 0L, 1L, 0L, 0L, false, 0L, 0L, rs);
            MyClock clock = new MyClock(10L, 20000L);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
            try {
                rs.next();
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.OPERATION_TIMED_OUT.getErrorCode(), (long)e.getErrorCode());
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        PhoenixTableLevelMetricsIT.assertSelectQueryTableMetrics(tableName, true, 0L, 1L, 1L, 0L, 0L, true, 1L, 1L, rs);
    }

    @Test
    public void testTableLevelMetricsForSelectFetchResultsTimeoutSlowScanner() throws SQLException {
        ResultSet rs;
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        int queryTimeout = 10;
        try (Connection conn = this.getConnFromTestDriver();){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, false, false, 10, true, conn, false);
        }
        conn = this.getConnFromTestDriver();
        try (Statement stmt = conn.createStatement();){
            stmt.setQueryTimeout(10);
            rs = stmt.executeQuery(String.format("SELECT J, G, E, (NOW() - I)*24*60*60*1000 FROM %s WHERE A='keyA1' AND B='keyB1' AND C='keyC1' AND D='keyD1'", tableName));
            PhoenixTableLevelMetricsIT.assertSelectQueryTableMetrics(tableName, true, 0L, 0L, 1L, 0L, 0L, false, 0L, 0L, rs);
            DelayedOrFailingRegionServer.setDelayEnabled(true);
            DelayedOrFailingRegionServer.setDelayScan(10001);
            try {
                rs.next();
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.OPERATION_TIMED_OUT.getErrorCode(), (long)e.getErrorCode());
                Assert.assertTrue(((Long)PhoenixRuntime.getOverAllReadRequestMetricInfo((ResultSet)rs).get(MetricType.RESULT_SET_TIME_MS) >= 10000L ? 1 : 0) != 0);
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        PhoenixTableLevelMetricsIT.assertSelectQueryTableMetrics(tableName, true, 0L, 1L, 1L, 0L, 0L, true, 1L, 1L, rs);
    }

    @Test
    public void testTableLevelMetricsForSelectFetchResultsServerSideFailure() throws SQLException {
        ResultSet rs;
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        try (Connection conn = this.getConnFromTestDriver();){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, false, false, 10, true, conn, false);
        }
        conn = this.getConnFromTestDriver();
        try (Statement stmt = conn.createStatement();){
            rs = stmt.executeQuery(String.format("SELECT J, G, E, (NOW() - I)*24*60*60*1000 FROM %s WHERE A='keyA1' AND B='keyB1' AND C='keyC1' AND D='keyD1'", tableName));
            PhoenixTableLevelMetricsIT.assertSelectQueryTableMetrics(tableName, true, 0L, 0L, 1L, 0L, 0L, false, 0L, 0L, rs);
            DelayedOrFailingRegionServer.injectFailureForRegionOfTable(tableName);
            try {
                while (rs.next()) {
                }
                Assert.fail();
            }
            catch (PhoenixIOException e) {
                Throwable doNotRetryIOException = null;
                for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
                    if (!(t instanceof DoNotRetryIOException)) continue;
                    doNotRetryIOException = t;
                    break;
                }
                Assert.assertNotNull(doNotRetryIOException);
                Assert.assertTrue((boolean)doNotRetryIOException.getMessage().contains("Injected exception message"));
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        PhoenixTableLevelMetricsIT.assertSelectQueryTableMetrics(tableName, true, 0L, 1L, 1L, 0L, 0L, true, 1L, 0L, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableLevelMetricsForUpsert() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        int numRows = 10000;
        Connection conn = null;
        Throwable exception = null;
        try {
            conn = this.getConnFromTestDriver();
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, false, numRows, true, conn, false);
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(true, tableName, numRows, 0L, 0L, true, numRows, 0L, 0L, 1L, 0L, writeMutMetrics, conn, true, 100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableLevelMetricsForBatchUpserts() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        int numRows = 20;
        Connection conn = null;
        Throwable exception = null;
        try {
            conn = this.getConnFromTestDriver();
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, false, numRows, true, conn, true);
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(true, tableName, numRows, 0L, 0L, true, numRows, 0L, 0L, 1L, 0L, writeMutMetrics, conn, true, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableLevelMetricsAutoCommitTrueUpsert() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        String ddl = String.format(CREATE_TABLE_DDL, tableName, 20);
        int numRows = 10;
        try (Connection conn = this.getConnFromTestDriver();
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
        }
        String dml = String.format(UPSERT_DML, tableName);
        Connection conn = null;
        Throwable exception = null;
        try {
            conn = this.getConnFromTestDriver();
            try (PreparedStatement prepStmt = conn.prepareStatement(dml);){
                conn.setAutoCommit(true);
                for (int i = 0; i < numRows; ++i) {
                    prepStmt.setString(1, KEY + i);
                    prepStmt.setString(2, VALUE + i);
                    prepStmt.executeUpdate();
                }
            }
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(true, tableName, numRows, 0L, (Long)writeMutMetrics.get(MetricType.UPSERT_COMMIT_TIME), true, numRows, 0L, 0L, numRows, 0L, writeMutMetrics, conn, true, 10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableLevelMetricsforFailingUpsert() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        String ddl = String.format(CREATE_TABLE_DDL, tableName, 2);
        try (Connection conn = this.getConnFromTestDriver();
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
        }
        String dml = String.format(UPSERT_DML, tableName);
        Connection conn = null;
        Throwable exception = null;
        try {
            conn = this.getConnFromTestDriver();
            try (PreparedStatement prepStmt = conn.prepareStatement(dml);){
                prepStmt.setString(1, KEY);
                prepStmt.setString(2, VALUE);
                try {
                    prepStmt.executeUpdate();
                    Assert.fail();
                }
                catch (SQLException sqlE) {
                    Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)sqlE.getErrorCode());
                }
            }
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(true, tableName, 0L, 1L, 0L, false, 0L, 0L, 0L, 1L, 0L, null, conn, true, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableLevelMetricsforUpsertSqlTime() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        String ddl = String.format(CREATE_TABLE_DDL, tableName, 10);
        int numRows = 10;
        long delay = 300L;
        try (Connection conn = this.getConnFromTestDriver();
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
        }
        String dml = String.format(UPSERT_DML, tableName);
        Connection conn = null;
        Throwable exception = null;
        try {
            conn = this.getConnFromTestDriver();
            try (PreparedStatement prepStmt = conn.prepareStatement(dml);){
                MyClock clock = new MyClock(10L, delay);
                EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
                for (int i = 0; i < numRows; ++i) {
                    prepStmt.setString(1, KEY + i);
                    prepStmt.setString(2, VALUE + i);
                    prepStmt.executeUpdate();
                }
            }
            conn.commit();
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(true, tableName, numRows, 0L, delay, true, numRows, 0L, 0L, 1L, 0L, writeMutMetrics, conn, true, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableLevelMetricsUpsertCommitFailedWithAutoCommitTrue() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        String ddl = String.format(CREATE_TABLE_DDL, tableName, 10);
        int numRows = 10;
        try (Connection conn = this.getConnFromTestDriver();
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
        }
        String dml = String.format(UPSERT_DML, tableName);
        Connection conn = null;
        Throwable exception = null;
        try {
            conn = this.getConnFromTestDriver();
            conn.setAutoCommit(true);
            DelayedOrFailingRegionServer.injectFailureForRegionOfTable(tableName);
            try (PreparedStatement prepStmt = conn.prepareStatement(dml);){
                for (int i = 0; i < numRows; ++i) {
                    prepStmt.setString(1, KEY + i);
                    prepStmt.setString(2, VALUE + i);
                    prepStmt.executeUpdate();
                }
            }
        }
        catch (CommitException e) {
            Throwable retriesExhaustedEx = null;
            for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
                if (!(t instanceof RetriesExhaustedWithDetailsException)) continue;
                retriesExhaustedEx = t;
                break;
            }
            Assert.assertNotNull(retriesExhaustedEx);
            Assert.assertTrue((boolean)retriesExhaustedEx.getMessage().contains("Injected exception message"));
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(true, tableName, 0L, 1L, 0L, true, 1L, 0L, 1L, 0L, 1L, writeMutMetrics, conn, true, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableLevelMetricsUpsertCommitFailed() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        String ddl = String.format(CREATE_TABLE_DDL, tableName, 10);
        int numRows = 10;
        try (Connection conn = this.getConnFromTestDriver();
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
        }
        String dml = String.format(UPSERT_DML, tableName);
        Connection conn = null;
        Throwable exception = null;
        try {
            conn = this.getConnFromTestDriver();
            try (PreparedStatement prepStmt = conn.prepareStatement(dml);){
                for (int i = 0; i < numRows; ++i) {
                    prepStmt.setString(1, KEY + i);
                    prepStmt.setString(2, VALUE + i);
                    prepStmt.executeUpdate();
                }
            }
            DelayedOrFailingRegionServer.injectFailureForRegionOfTable(tableName);
            try {
                conn.commit();
                Assert.fail();
            }
            catch (CommitException e) {
                Throwable retriesExhaustedEx = null;
                for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
                    if (!(t instanceof RetriesExhaustedWithDetailsException)) continue;
                    retriesExhaustedEx = t;
                    break;
                }
                Assert.assertNotNull(retriesExhaustedEx);
                Assert.assertTrue((boolean)retriesExhaustedEx.getMessage().contains("Injected exception message"));
            }
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(true, tableName, numRows, 0L, 0L, true, numRows, 0L, numRows, 0L, 1L, writeMutMetrics, conn, true, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertCommitTimeSlowRS() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        String ddl = String.format(CREATE_TABLE_DDL, tableName, 10);
        int numRows = 10;
        int delayRs = 5000;
        try (Connection conn = this.getConnFromTestDriver();
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
        }
        String dml = String.format(UPSERT_DML, tableName);
        Connection conn = null;
        Throwable exception = null;
        try {
            conn = this.getConnFromTestDriver();
            try (PreparedStatement prepStmt = conn.prepareStatement(dml);){
                for (int i = 0; i < numRows; ++i) {
                    prepStmt.setString(1, KEY + i);
                    prepStmt.setString(2, VALUE + i);
                    prepStmt.executeUpdate();
                }
            }
            DelayedOrFailingRegionServer.setDelayEnabled(true);
            DelayedOrFailingRegionServer.setDelayMultiOp(5000);
            conn.commit();
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(true, tableName, numRows, 0L, 0L, true, numRows, 5000L, 0L, 1L, 0L, writeMutMetrics, conn, true, 1L);
        }
    }

    @Test
    public void testUpsertSelectWithRunOnServerAsTrue() throws SQLException {
        Map writeMutMetrics;
        String srcTableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        String destTableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        int numRows = 10;
        try (Connection conn = this.getConnFromTestDriver();){
            PhoenixMetricsIT.createTableAndInsertValues(srcTableName, true, true, numRows, true, conn, false);
        }
        conn = this.getConnFromTestDriver();
        try {
            conn.setAutoCommit(true);
            PhoenixMetricsIT.createTableAndRunUpsertSelect(destTableName, srcTableName, true, true, true, conn);
            writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(destTableName);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Assert.assertNull((Object)writeMutMetrics);
        for (PhoenixTableMetric metric : (List)PhoenixRuntime.getPhoenixTableClientMetrics().get(destTableName)) {
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_COUNTER, 0L, CompareOp.EQ);
        }
    }

    @Test
    public void testUpsertSelectWithRunOnServerAsFalse() throws SQLException {
        Map writeMutMetrics;
        String srcTableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        String destTableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        int numRows = 10;
        try (Connection conn = this.getConnFromTestDriver();){
            PhoenixMetricsIT.createTableAndInsertValues(srcTableName, true, true, numRows, true, conn, false);
        }
        conn = this.getConnFromTestDriver();
        try {
            PhoenixMetricsIT.createTableAndRunUpsertSelect(destTableName, srcTableName, true, true, true, conn);
            writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(destTableName);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Assert.assertNotNull((Object)writeMutMetrics);
        for (PhoenixTableMetric metric : (List)PhoenixRuntime.getPhoenixTableClientMetrics().get(destTableName)) {
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_COUNTER, (Long)writeMutMetrics.get(MetricType.MUTATION_BATCH_COUNTER), CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_COUNTER, 1L, CompareOp.EQ);
        }
    }

    @Test
    public void testUpsertWithOverriddenUpsertBatchSize() throws SQLException {
        Map writeMutMetrics;
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        int numRows = 100;
        Properties props = new Properties();
        props.put("UpsertBatchSize", "5");
        try (Connection conn = DriverManager.getConnection(url, props);){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, true, numRows, true, conn, false);
            writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
        }
        Assert.assertNotNull((Object)writeMutMetrics);
        for (PhoenixTableMetric metric : (List)PhoenixRuntime.getPhoenixTableClientMetrics().get(tableName)) {
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_COUNTER, (Long)writeMutMetrics.get(MetricType.MUTATION_BATCH_COUNTER), CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_COUNTER, 20L, CompareOp.EQ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableLevelMetricsForPointDelete() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        int numRows = 15;
        Connection conn = null;
        Throwable exception = null;
        try {
            conn = this.getConnFromTestDriver();
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, true, numRows, true, conn, false);
            PhoenixRuntime.resetMetrics((Connection)conn);
            PhoenixRuntime.clearTableLevelMetrics();
            PhoenixMetricsIT.doPointDeleteFromTable(tableName, conn);
            conn.commit();
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(false, tableName, 1L, 0L, 0L, true, 1L, 0L, 0L, 1L, 0L, writeMutMetrics, conn, false, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableLevelMetricsForDeleteAll() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        int numRows = 15;
        Connection conn = null;
        Throwable exception = null;
        try {
            conn = this.getConnFromTestDriver();
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, true, numRows, true, conn, false);
            PhoenixRuntime.resetMetrics((Connection)conn);
            PhoenixRuntime.clearTableLevelMetrics();
            PhoenixMetricsIT.doDeleteAllFromTable(tableName, conn);
            conn.commit();
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(false, tableName, 1L, 0L, 0L, true, numRows, 0L, 0L, 1L, 0L, writeMutMetrics, conn, false, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableLevelMetricsAutoCommitTrueDelete() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        int numRows = 15;
        Connection conn = null;
        Throwable exception = null;
        try (Connection ddlAndUpsertConn = this.getConnFromTestDriver();){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, true, numRows, true, ddlAndUpsertConn, false);
            PhoenixRuntime.resetMetrics((Connection)ddlAndUpsertConn);
            PhoenixRuntime.clearTableLevelMetrics();
        }
        try {
            conn = this.getConnFromTestDriver();
            conn.setAutoCommit(true);
            PhoenixMetricsIT.doPointDeleteFromTable(tableName, conn);
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
            Assert.assertNull((Object)writeMutMetrics);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(false, tableName, 1L, 0L, 0L, false, 0L, 0L, 0L, 0L, 0L, writeMutMetrics, conn, false, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testTableLevelMetricsforFailingDelete() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        int numRows = 15;
        Connection conn = null;
        Throwable exception = null;
        try {
            conn = this.getConnFromTestDriver();
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, true, numRows, true, conn, false);
            PhoenixRuntime.resetMetrics((Connection)conn);
            PhoenixRuntime.clearTableLevelMetrics();
            failExecuteQueryAndClientSideDeletes = true;
            try {
                PhoenixMetricsIT.doPointDeleteFromTable(tableName, conn);
                Assert.fail();
            }
            catch (SQLException sqlE) {
                Assert.assertEquals((long)SQLExceptionCode.GET_TABLE_REGIONS_FAIL.getErrorCode(), (long)sqlE.getErrorCode());
            }
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
            Assert.assertNull((Object)writeMutMetrics);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(false, tableName, 0L, 1L, 0L, false, 0L, 0L, 0L, 0L, 1L, null, conn, false, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testTableLevelMetricsforDelayedDeleteQuery() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        Connection conn = null;
        Throwable exception = null;
        try {
            conn = this.getConnFromTestDriver();
            PhoenixMetricsIT.createTableAndInsertValues(tableName, false, true, 10, true, conn, false);
            PhoenixRuntime.resetMetrics((Connection)conn);
            PhoenixRuntime.clearTableLevelMetrics();
            injectDelay = 3000L;
            PhoenixMetricsIT.doPointDeleteFromTable(tableName, conn);
            conn.commit();
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(false, tableName, 1L, 0L, injectDelay, true, 1L, 0L, 0L, 1L, 0L, writeMutMetrics, conn, false, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableLevelMetricsDeleteCommitFailed() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        int numRows = 15;
        Connection conn = null;
        Throwable exception = null;
        try {
            conn = this.getConnFromTestDriver();
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, true, numRows, true, conn, false);
            PhoenixRuntime.resetMetrics((Connection)conn);
            PhoenixRuntime.clearTableLevelMetrics();
            PhoenixMetricsIT.doDeleteAllFromTable(tableName, conn);
            DelayedOrFailingRegionServer.injectFailureForRegionOfTable(tableName);
            try {
                conn.commit();
                Assert.fail();
            }
            catch (CommitException e) {
                Throwable retriesExhaustedEx = null;
                for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
                    if (!(t instanceof RetriesExhaustedWithDetailsException)) continue;
                    retriesExhaustedEx = t;
                    break;
                }
                Assert.assertNotNull(retriesExhaustedEx);
                Assert.assertTrue((boolean)retriesExhaustedEx.getMessage().contains("Injected exception message"));
            }
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(false, tableName, 1L, 0L, 0L, true, numRows, 0L, numRows, 0L, 1L, writeMutMetrics, conn, false, 1L);
        }
    }

    @Test
    public void testMetricsWithIndexUsage() throws Exception {
        Map writeMutMetrics;
        String dataTable = PhoenixTableLevelMetricsIT.generateUniqueName();
        String indexName = PhoenixTableLevelMetricsIT.generateUniqueName() + "_IDX";
        try (Connection conn = this.getConnFromTestDriver();){
            String tableDdl = "CREATE TABLE " + dataTable + " (K VARCHAR NOT NULL, V INTEGER, CONSTRAINT PK PRIMARY KEY(K)) IMMUTABLE_ROWS = true";
            conn.createStatement().execute(tableDdl);
            String indexDdl = "CREATE INDEX " + indexName + " ON " + dataTable + " (V)";
            conn.createStatement().execute(indexDdl);
        }
        String insertData = "UPSERT INTO " + dataTable + " VALUES (?, ?)";
        try (Object conn = this.getConnFromTestDriver();
             PreparedStatement stmt = conn.prepareStatement(insertData);){
            for (int i = 1; i <= 10; ++i) {
                stmt.setString(1, KEY + i);
                stmt.setInt(2, i);
                stmt.executeUpdate();
            }
            conn.commit();
            writeMutMetrics = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn);
        }
        for (PhoenixTableMetric metric : (List)PhoenixRuntime.getPhoenixTableClientMetrics().get(dataTable)) {
            if (!metric.getMetricType().equals((Object)MetricType.MUTATION_BATCH_COUNTER)) continue;
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_COUNTER, 1L, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_COUNTER, (Long)((Map)writeMutMetrics.get(dataTable)).get(MetricType.MUTATION_BATCH_COUNTER), CompareOp.EQ);
        }
        for (PhoenixTableMetric metric : (List)PhoenixRuntime.getPhoenixTableClientMetrics().get(indexName)) {
            if (!metric.getMetricType().equals((Object)MetricType.MUTATION_BATCH_COUNTER)) continue;
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_COUNTER, 2L, CompareOp.EQ);
            PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.MUTATION_BATCH_COUNTER, (Long)((Map)writeMutMetrics.get(indexName)).get(MetricType.MUTATION_BATCH_COUNTER), CompareOp.EQ);
        }
        conn = this.getConnFromTestDriver();
        try {
            String query = "SELECT * FROM " + dataTable + " WHERE V = ?";
            try (PreparedStatement stmt = conn.prepareStatement(query);){
                stmt.setInt(1, 5);
                PhoenixRuntime.clearTableLevelMetrics();
                try (ResultSet resultSet = stmt.executeQuery();){
                    while (resultSet.next()) {
                    }
                }
                Assert.assertTrue((!((List)PhoenixRuntime.getPhoenixTableClientMetrics().get(indexName)).isEmpty() ? 1 : 0) != 0);
                boolean metricExists = false;
                for (PhoenixTableMetric metric : (List)PhoenixRuntime.getPhoenixTableClientMetrics().get(indexName)) {
                    if (!metric.getMetricType().equals((Object)MetricType.SELECT_SQL_COUNTER)) continue;
                    metricExists = true;
                    PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.SELECT_SQL_COUNTER, 1L, CompareOp.EQ);
                    break;
                }
                Assert.assertTrue((boolean)metricExists);
                metricExists = false;
                if (ValidateLastDDLTimestampUtil.getValidateLastDdlTimestampEnabled((PhoenixConnection)conn.unwrap(PhoenixConnection.class))) {
                    Assert.assertFalse((boolean)PhoenixRuntime.getPhoenixTableClientMetrics().containsKey(dataTable));
                } else {
                    for (PhoenixTableMetric metric : (List)PhoenixRuntime.getPhoenixTableClientMetrics().get(dataTable)) {
                        if (!metric.getMetricType().equals((Object)MetricType.SELECT_SQL_COUNTER)) continue;
                        metricExists = true;
                        PhoenixTableLevelMetricsIT.assertMetricValue((Metric)metric, MetricType.SELECT_SQL_COUNTER, 0L, CompareOp.EQ);
                        break;
                    }
                    Assert.assertTrue((boolean)metricExists);
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteCommitTimeSlowRS() throws Throwable {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        int numRows = 15;
        Connection conn = null;
        Throwable exception = null;
        int delayRs = 5000;
        try {
            conn = this.getConnFromTestDriver();
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, true, numRows, true, conn, false);
            PhoenixRuntime.resetMetrics((Connection)conn);
            PhoenixRuntime.clearTableLevelMetrics();
            PhoenixMetricsIT.doDeleteAllFromTable(tableName, conn);
            DelayedOrFailingRegionServer.setDelayEnabled(true);
            DelayedOrFailingRegionServer.setDelayMultiOp(5000);
            conn.commit();
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            if (exception != null) {
                throw exception;
            }
            Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
            Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
            conn.close();
            PhoenixTableLevelMetricsIT.assertMutationTableMetrics(false, tableName, 1L, 0L, 0L, true, numRows, 5000L, 0L, 1L, 0L, writeMutMetrics, conn, false, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableLevelMetricsForAtomicUpserts() throws Throwable {
        int numAtomicUpserts;
        Connection conn;
        String tableName;
        block6: {
            tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
            conn = null;
            Throwable exception = null;
            numAtomicUpserts = 4;
            try {
                conn = this.getConnFromTestDriver();
                String ddl = "create table " + tableName + "(pk varchar primary key, counter1 bigint)";
                conn.createStatement().execute(ddl);
                String dml = String.format("UPSERT INTO %s VALUES('a', 0)", tableName);
                conn.createStatement().execute(dml);
                dml = String.format("UPSERT INTO %s VALUES('a', 0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1", tableName);
                for (int i = 0; i < numAtomicUpserts; ++i) {
                    conn.createStatement().execute(dml);
                }
                conn.commit();
                String dql = String.format("SELECT counter1 FROM %s WHERE counter1 > 0", tableName);
                ResultSet rs = conn.createStatement().executeQuery(dql);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)4L, (long)rs.getInt(1));
                if (exception == null) break block6;
            }
            catch (Throwable t) {
                block7: {
                    try {
                        exception = t;
                        if (exception == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (exception != null) {
                            throw exception;
                        }
                        Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
                        Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
                        conn.close();
                        PhoenixTableLevelMetricsIT.assertMutationTableMetrics(true, tableName, 1 + numAtomicUpserts, 0L, 0L, true, 2L, 0L, 0L, 2L, 0L, writeMutMetrics, conn, false, 2L);
                        Assert.assertEquals((long)numAtomicUpserts, (long)this.getMetricFromTableMetrics(tableName, MetricType.ATOMIC_UPSERT_SQL_COUNTER));
                        Assert.assertTrue((this.getMetricFromTableMetrics(tableName, MetricType.ATOMIC_UPSERT_COMMIT_TIME) > 0L ? 1 : 0) != 0);
                        throw throwable;
                    }
                    throw exception;
                }
                Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
                Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
                conn.close();
                PhoenixTableLevelMetricsIT.assertMutationTableMetrics(true, tableName, 1 + numAtomicUpserts, 0L, 0L, true, 2L, 0L, 0L, 2L, 0L, writeMutMetrics, conn, false, 2L);
                Assert.assertEquals((long)numAtomicUpserts, (long)this.getMetricFromTableMetrics(tableName, MetricType.ATOMIC_UPSERT_SQL_COUNTER));
                Assert.assertTrue((this.getMetricFromTableMetrics(tableName, MetricType.ATOMIC_UPSERT_COMMIT_TIME) > 0L ? 1 : 0) != 0);
            }
            throw exception;
        }
        Assert.assertNotNull((String)"Failed to get a connection!", (Object)conn);
        Map writeMutMetrics = (Map)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).get(tableName);
        conn.close();
        PhoenixTableLevelMetricsIT.assertMutationTableMetrics(true, tableName, 1 + numAtomicUpserts, 0L, 0L, true, 2L, 0L, 0L, 2L, 0L, writeMutMetrics, conn, false, 2L);
        Assert.assertEquals((long)numAtomicUpserts, (long)this.getMetricFromTableMetrics(tableName, MetricType.ATOMIC_UPSERT_SQL_COUNTER));
        Assert.assertTrue((this.getMetricFromTableMetrics(tableName, MetricType.ATOMIC_UPSERT_COMMIT_TIME) > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testHistogramMetricsForMutations() throws Exception {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        try (Connection conn = this.getConnFromTestDriver();){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, true, 10, true, conn, false);
        }
        this.assertHistogramMetricsForMutations(tableName, true, 1L, 1L, true);
        PhoenixRuntime.clearTableLevelMetrics();
        PhoenixMetricsIT.resetGlobalMetrics();
        try (Connection connection = this.getConnFromTestDriver();
             Statement statement = connection.createStatement();){
            String delete = "DELETE FROM " + tableName;
            statement.execute(delete);
            connection.commit();
        }
        this.assertHistogramMetricsForMutations(tableName, false, 1L, 1L, true);
        PhoenixRuntime.clearTableLevelMetrics();
    }

    @Test
    public void testHistogramMetricsForMutationsAutoCommitTrue() throws Exception {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        try (Connection conn = this.getConnFromTestDriver();){
            conn.setAutoCommit(true);
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, true, 10, false, conn, false);
        }
        this.assertHistogramMetricsForMutations(tableName, true, 10L, 10L, false);
        PhoenixRuntime.clearTableLevelMetrics();
        PhoenixMetricsIT.resetGlobalMetrics();
        try (Connection connection = this.getConnFromTestDriver();
             Statement statement = connection.createStatement();){
            connection.setAutoCommit(true);
            String delete = "DELETE FROM " + tableName;
            statement.execute(delete);
        }
        this.assertHistogramMetricsForMutations(tableName, false, 1L, 0L, false);
        PhoenixRuntime.clearTableLevelMetrics();
    }

    @Test
    public void testHistogramMetricsForQueries() throws Exception {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        try (Connection conn = this.getConnFromTestDriver();){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, true, 10, true, conn, true);
        }
        PhoenixRuntime.clearTableLevelMetrics();
        PhoenixMetricsIT.resetGlobalMetrics();
        DelayedOrFailingRegionServer.setDelayEnabled(true);
        DelayedOrFailingRegionServer.setDelayScan(30);
        conn = this.getConnFromTestDriver();
        try (Statement statement = conn.createStatement();){
            String select = "SELECT * FROM " + tableName;
            ResultSet resultSet = statement.executeQuery(select);
            while (resultSet.next()) {
            }
            resultSet.close();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        LatencyHistogram ltHisto = TableMetricsManager.getQueryLatencyHistogramForTable((String)tableName);
        SizeHistogram szHisto = TableMetricsManager.getQuerySizeHistogramForTable((String)tableName);
        this.assertHistogramMetricsForQueries(tableName, ltHisto, szHisto, 1, 1);
    }

    @Test
    public void testHistogramMetricsForRangeScan() throws Exception {
        String tableName = PhoenixTableLevelMetricsIT.generateUniqueName();
        try (Connection conn = this.getConnFromTestDriver();){
            PhoenixMetricsIT.createTableAndInsertValues(tableName, true, true, 10, true, conn, true);
        }
        PhoenixMetricsIT.resetGlobalMetrics();
        PhoenixRuntime.clearTableLevelMetrics();
        conn = this.getConnFromTestDriver();
        try (Statement statement = conn.createStatement();){
            String select = "SELECT * FROM " + tableName;
            ResultSet resultSet = statement.executeQuery(select);
            while (resultSet.next()) {
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        LatencyHistogram pointLookupLtHisto = TableMetricsManager.getPointLookupLatencyHistogramForTable((String)tableName);
        SizeHistogram pointLookupSzHisto = TableMetricsManager.getPointLookupSizeHistogramForTable((String)tableName);
        Assert.assertEquals((long)0L, (long)pointLookupLtHisto.getHistogram().getTotalCount());
        Assert.assertEquals((long)0L, (long)pointLookupSzHisto.getHistogram().getTotalCount());
        LatencyHistogram ltHistogram = TableMetricsManager.getRangeScanLatencyHistogramForTable((String)tableName);
        Assert.assertEquals((long)1L, (long)ltHistogram.getHistogram().getTotalCount());
        SizeHistogram sizeHistogram = TableMetricsManager.getRangeScanSizeHistogramForTable((String)tableName);
        Assert.assertEquals((long)1L, (long)sizeHistogram.getHistogram().getTotalCount());
        this.assertHistogramMetricsForQueries(tableName, ltHistogram, sizeHistogram, 1, 1);
    }

    private void assertHistogramMetricsForQueries(String tableName, LatencyHistogram ltHistogram, SizeHistogram sizeHistogram, int ltCount, int szCount) {
        Assert.assertEquals((long)ltCount, (long)ltHistogram.getHistogram().getTotalCount());
        Assert.assertEquals((long)szCount, (long)sizeHistogram.getHistogram().getTotalCount());
        Long queryTime = GlobalClientMetrics.GLOBAL_QUERY_TIME.getMetric().getValue();
        long rsNextTime = this.getMetricFromTableMetrics(tableName, MetricType.RESULT_SET_TIME_MS);
        long totalLatency = queryTime + rsNextTime;
        long maxLtValue = ltHistogram.getHistogram().getMaxValue();
        Assert.assertTrue((boolean)ltHistogram.getHistogram().valuesAreEquivalent(totalLatency, maxLtValue));
        Long scanBytes = GlobalClientMetrics.GLOBAL_SCAN_BYTES.getMetric().getValue();
        long maxSzValue = sizeHistogram.getHistogram().getMaxValue();
        Assert.assertTrue((boolean)sizeHistogram.getHistogram().valuesAreEquivalent(scanBytes.longValue(), maxSzValue));
    }

    private Connection getConnFromTestDriver() throws SQLException {
        Connection conn = DriverManager.getConnection(url);
        Assert.assertTrue((boolean)(conn.unwrap(PhoenixConnection.class).getQueryServices() instanceof PhoenixMetricsTestingQueryServices));
        return conn;
    }

    private long getMetricFromTableMetrics(String tableName, MetricType type) {
        Long value = TableMetricsManager.getMetricValue((String)tableName, (MetricType)type);
        Assert.assertNotNull((Object)value);
        return value;
    }

    public static class PhoenixMetricsTestingDriver
    extends PhoenixTestDriver {
        @GuardedBy(value="this")
        private final Map<ConnectionInfo, ConnectionQueryServices> connectionQueryServicesMap = new HashMap<ConnectionInfo, ConnectionQueryServices>();
        private final QueryServices qsti;
        private ReadOnlyProps overrideProps;

        public PhoenixMetricsTestingDriver(ReadOnlyProps props) {
            this.overrideProps = props;
            this.qsti = new QueryServicesTestImpl(this.getDefaultProps(), this.overrideProps);
        }

        @Override
        public boolean acceptsURL(String url) {
            return true;
        }

        @Override
        public synchronized ConnectionQueryServices getConnectionQueryServices(String url, Properties info) throws SQLException {
            ConnectionInfo connInfo = ConnectionInfo.create((String)url, null, (Properties)info);
            Object connectionQueryServices = this.connectionQueryServicesMap.get(connInfo);
            if (connectionQueryServices != null) {
                return connectionQueryServices;
            }
            connectionQueryServices = new PhoenixMetricsTestingQueryServices(this.qsti, connInfo, info);
            connectionQueryServices.init(url, info);
            this.connectionQueryServicesMap.put(connInfo, (ConnectionQueryServices)connectionQueryServices);
            return connectionQueryServices;
        }
    }

    private static enum CompareOp {
        LT,
        EQ,
        GT,
        LTEQ,
        GTEQ;

    }

    private static class MyClock
    extends EnvironmentEdge {
        private final long delay;
        private AtomicLong time;

        public MyClock(long time, long delay) {
            this.time = new AtomicLong(time);
            this.delay = delay;
        }

        public long currentTime() {
            long currentTime = this.time.get();
            this.time.addAndGet(this.delay);
            return currentTime;
        }
    }

    private static class PhoenixMetricsTestingQueryServices
    extends ConnectionQueryServicesImpl {
        PhoenixMetricsTestingQueryServices(QueryServices services, ConnectionInfo connectionInfo, Properties info) {
            super(services, connectionInfo, info);
        }

        public List<HRegionLocation> getAllTableRegions(byte[] tableName) throws SQLException {
            if (failExecuteQueryAndClientSideDeletes) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.GET_TABLE_REGIONS_FAIL).build().buildException();
            }
            try {
                Thread.sleep(injectDelay);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return super.getAllTableRegions(tableName);
        }

        public List<HRegionLocation> getAllTableRegions(byte[] tableName, int queryTimeout) throws SQLException {
            if (failExecuteQueryAndClientSideDeletes) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.GET_TABLE_REGIONS_FAIL).build().buildException();
            }
            try {
                Thread.sleep(injectDelay);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return super.getAllTableRegions(tableName, queryTimeout);
        }

        public List<HRegionLocation> getTableRegions(byte[] tableName, byte[] startRowKey, byte[] endRowKey) throws SQLException {
            if (failExecuteQueryAndClientSideDeletes) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.GET_TABLE_REGIONS_FAIL).build().buildException();
            }
            try {
                Thread.sleep(injectDelay);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return super.getTableRegions(tableName, startRowKey, endRowKey);
        }

        public List<HRegionLocation> getTableRegions(byte[] tableName, byte[] startRowKey, byte[] endRowKey, int queryTimeout) throws SQLException {
            if (failExecuteQueryAndClientSideDeletes) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.GET_TABLE_REGIONS_FAIL).build().buildException();
            }
            try {
                Thread.sleep(injectDelay);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return super.getTableRegions(tableName, startRowKey, endRowKey, queryTimeout);
        }
    }
}

