/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.sql.Driver;
import java.sql.DriverManager;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.monitoring.GlobalMetric;
import org.apache.phoenix.monitoring.NoOpGlobalMetricImpl;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConfigurationFactory;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.InstanceResolver;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PhoenixMetricsDisabledIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        final Configuration conf = HBaseConfiguration.create();
        conf.set("phoenix.query.global.metrics.enabled", String.valueOf(false));
        conf.set("phoenix.scanner.lease.renew.enabled", String.valueOf(false));
        InstanceResolver.clearSingletons();
        InstanceResolver.getSingleton(ConfigurationFactory.class, (Object)new ConfigurationFactory(){

            public Configuration getConfiguration() {
                return conf;
            }

            public Configuration getConfiguration(Configuration confToClone) {
                Configuration copy = new Configuration(conf);
                copy.addResource(confToClone);
                return copy;
            }
        });
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        PhoenixMetricsDisabledIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
    }

    @Test
    public void testResetGlobalPhoenixMetrics() {
        for (GlobalMetric m : PhoenixRuntime.getGlobalPhoenixClientMetrics()) {
            Assert.assertTrue((boolean)(m instanceof NoOpGlobalMetricImpl));
            Assert.assertEquals((long)NoOpGlobalMetricImpl.NO_VALUE, (long)m.getValue());
            Assert.assertEquals((long)NoOpGlobalMetricImpl.NO_SAMPLES, (long)m.getNumberOfSamples());
        }
    }
}

