/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.LoggingPhoenixConnection;
import org.apache.phoenix.jdbc.LoggingPhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixMetricsLog;
import org.apache.phoenix.monitoring.BasePhoenixMetricsIT;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PhoenixLoggingMetricsIT
extends BasePhoenixMetricsIT {
    private static final int NUM_ROWS = 10;
    private final Map<MetricType, Long> overAllQueryMetricsMap = Maps.newHashMap();
    private final Map<String, Map<MetricType, Long>> requestReadMetricsMap = Maps.newHashMap();
    private final Map<String, Map<MetricType, Long>> mutationWriteMetricsMap = Maps.newHashMap();
    private final Map<String, Map<MetricType, Long>> mutationReadMetricsMap = Maps.newHashMap();
    private String tableName1;
    private String tableName2;
    private LoggingPhoenixConnection loggedConn;
    private String loggedSql;
    private int logOverAllReadRequestMetricsFuncCallCount;
    private int logRequestReadMetricsFuncCallCount;

    @Before
    public void beforeTest() throws Exception {
        this.clearAllTestMetricMaps();
        this.tableName1 = PhoenixLoggingMetricsIT.generateUniqueName();
        String ddl = "CREATE TABLE " + this.tableName1 + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR)";
        Connection setupConn = DriverManager.getConnection(PhoenixLoggingMetricsIT.getUrl());
        setupConn.createStatement().execute(ddl);
        setupConn.close();
        this.insertRowsInTable(this.tableName1, 10L);
        this.tableName2 = PhoenixLoggingMetricsIT.generateUniqueName();
        ddl = "CREATE TABLE " + this.tableName2 + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR)";
        setupConn = DriverManager.getConnection(PhoenixLoggingMetricsIT.getUrl());
        setupConn.createStatement().execute(ddl);
        setupConn.close();
        Connection testConn = DriverManager.getConnection(PhoenixLoggingMetricsIT.getUrl());
        this.loggedConn = this.getLoggingPhoenixConnection(testConn);
    }

    @Test
    public void testResultSetTypeForQueries() throws Exception {
        String tableName3 = PhoenixLoggingMetricsIT.generateUniqueName();
        String create = "CREATE TABLE " + tableName3 + " (K INTEGER PRIMARY KEY)";
        Assert.assertNull((Object)this.executeAndGetResultSet(create));
        String upsert = "UPSERT INTO " + tableName3 + " VALUES (42)";
        Assert.assertNull((Object)this.executeAndGetResultSet(upsert));
        String select = "SELECT * FROM " + tableName3;
        Assert.assertTrue((boolean)(this.executeAndGetResultSet(select) instanceof LoggingPhoenixResultSet));
        String createView = "CREATE VIEW TEST_VIEW (K1 INTEGER) AS SELECT * FROM " + tableName3;
        Assert.assertNull((Object)this.executeAndGetResultSet(createView));
        String createIndex = "CREATE INDEX TEST_INDEX ON " + tableName3 + " (K)";
        Assert.assertNull((Object)this.executeAndGetResultSet(createIndex));
        String dropIndex = "DROP INDEX TEST_INDEX ON " + tableName3;
        Assert.assertNull((Object)this.executeAndGetResultSet(dropIndex));
        String dropView = "DROP VIEW TEST_VIEW";
        Assert.assertNull((Object)this.executeAndGetResultSet(dropView));
        String dropTable = "DROP TABLE " + tableName3;
        Assert.assertNull((Object)this.executeAndGetResultSet(dropTable));
    }

    @Test
    public void testPhoenixMetricsLoggedOnCommit() throws Exception {
        String query = "SELECT * FROM " + this.tableName1;
        ResultSet rs = this.upsertRows(query);
        this.verifyQueryLevelMetricsLogging(query, rs);
        String upsertSelect = "UPSERT INTO " + this.tableName2 + " SELECT * FROM " + this.tableName1;
        this.loggedConn.createStatement().executeUpdate(upsertSelect);
        this.loggedConn.commit();
        Assert.assertTrue((String)("Mutation write metrics for not found for " + this.tableName2), (this.mutationWriteMetricsMap.get(this.tableName2).size() > 0 ? 1 : 0) != 0);
        PhoenixLoggingMetricsIT.assertMutationMetrics(this.tableName2, 10, true, this.mutationWriteMetricsMap);
        Assert.assertTrue((String)("Mutation read metrics for not found for " + this.tableName1), (this.mutationReadMetricsMap.get(this.tableName1).size() > 0 ? 1 : 0) != 0);
        this.assertReadMetricsForMutatingSql(this.tableName1, 1L, this.mutationReadMetricsMap);
        this.clearAllTestMetricMaps();
        this.loggedConn.close();
        Assert.assertTrue((String)"Mutation write metrics are not logged again.", (this.mutationWriteMetricsMap.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Mutation read metrics are not logged again.", (this.mutationReadMetricsMap.size() == 0 ? 1 : 0) != 0);
        this.clearAllTestMetricMaps();
        this.loggedConn.close();
        Assert.assertTrue((String)"Mutation write metrics are not logged again.", (this.mutationWriteMetricsMap.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Mutation read metrics are not logged again.", (this.mutationReadMetricsMap.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPhoenixMetricsLoggedOnClose() throws Exception {
        String query = "SELECT * FROM " + this.tableName1;
        ResultSet rs = this.upsertRows(query);
        this.verifyQueryLevelMetricsLogging(query, rs);
        String upsertSelect = "UPSERT INTO " + this.tableName2 + " SELECT * FROM " + this.tableName1;
        this.loggedConn.createStatement().executeUpdate(upsertSelect);
        this.loggedConn.close();
        Assert.assertTrue((String)("Mutation write metrics are not logged for " + this.tableName2), (this.mutationWriteMetricsMap.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Mutation read metrics for not found for " + this.tableName1), (this.mutationReadMetricsMap.get(this.tableName1).size() > 0 ? 1 : 0) != 0);
        this.assertReadMetricsForMutatingSql(this.tableName1, 1L, this.mutationReadMetricsMap);
        this.clearAllTestMetricMaps();
        this.loggedConn.close();
        Assert.assertTrue((String)"Mutation write metrics are not logged again.", (this.mutationWriteMetricsMap.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Mutation read metrics are not logged again.", (this.mutationReadMetricsMap.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPhoenixMetricsLoggedOnAutoCommitTrue() throws Exception {
        this.loggedConn.setAutoCommit(true);
        String query = "SELECT * FROM " + this.tableName1;
        ResultSet rs = this.upsertRows(query);
        this.verifyQueryLevelMetricsLogging(query, rs);
        String upsertSelect = "UPSERT INTO " + this.tableName2 + " SELECT * FROM " + this.tableName1;
        this.loggedConn.createStatement().executeUpdate(upsertSelect);
        Assert.assertTrue((String)("Mutation write metrics are not logged for " + this.tableName2), (this.mutationWriteMetricsMap.get(this.tableName2).size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Mutation read metrics are not found for " + this.tableName1), (this.mutationReadMetricsMap.get(this.tableName1).size() > 0 ? 1 : 0) != 0);
        this.clearAllTestMetricMaps();
        this.loggedConn.createStatement().execute(query);
        Assert.assertTrue((String)("Read metrics found for " + this.tableName1), (this.mutationReadMetricsMap.size() == 0 ? 1 : 0) != 0);
        this.loggedConn.createStatement().execute(upsertSelect);
        Assert.assertTrue((String)("Mutation write metrics are not logged for " + this.tableName2 + " in createStatement"), (this.mutationWriteMetricsMap.get(this.tableName2).size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Mutation read metrics are not found for " + this.tableName1 + " in createStatement"), (this.mutationReadMetricsMap.get(this.tableName1).size() > 0 ? 1 : 0) != 0);
        this.clearAllTestMetricMaps();
        this.loggedConn.prepareStatement(query).executeQuery();
        Assert.assertTrue((String)("Read metrics found for " + this.tableName1), (this.mutationReadMetricsMap.size() == 0 ? 1 : 0) != 0);
        this.loggedConn.prepareStatement(upsertSelect).executeUpdate();
        Assert.assertTrue((String)("Mutation write metrics are not logged for " + this.tableName2 + " in prepareStatement"), (this.mutationWriteMetricsMap.get(this.tableName2).size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Mutation read metrics are not found for " + this.tableName1 + " in prepareStatement"), (this.mutationReadMetricsMap.get(this.tableName1).size() > 0 ? 1 : 0) != 0);
    }

    private ResultSet executeAndGetResultSet(String query) throws Exception {
        Statement stmt = this.loggedConn.createStatement();
        stmt.execute(query);
        return stmt.getResultSet();
    }

    private ResultSet upsertRows(String query) throws SQLException {
        Statement stmt = this.loggedConn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        Assert.assertTrue((boolean)(rs instanceof LoggingPhoenixResultSet));
        int rowsRetrievedCounter = 0;
        while (rs.next()) {
            ++rowsRetrievedCounter;
        }
        rs.close();
        Assert.assertTrue((rowsRetrievedCounter == 10 ? 1 : 0) != 0);
        return rs;
    }

    private void verifyQueryLevelMetricsLogging(String query, ResultSet rs) throws SQLException {
        Assert.assertTrue((String)("Read metrics for not found for " + this.tableName1), (this.requestReadMetricsMap.get(this.tableName1).size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Logged query doesn't match actual query", (boolean)this.loggedSql.equals(query));
        Assert.assertTrue((this.logOverAllReadRequestMetricsFuncCallCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.logRequestReadMetricsFuncCallCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Overall read metrics for not found ", (this.overAllQueryMetricsMap.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Logged query doesn't match actual query", (boolean)this.loggedSql.equals(query));
        rs.close();
        Assert.assertTrue((this.logOverAllReadRequestMetricsFuncCallCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.logRequestReadMetricsFuncCallCount == 1 ? 1 : 0) != 0);
    }

    void clearAllTestMetricMaps() {
        this.overAllQueryMetricsMap.clear();
        this.requestReadMetricsMap.clear();
        this.mutationWriteMetricsMap.clear();
        this.mutationReadMetricsMap.clear();
    }

    LoggingPhoenixConnection getLoggingPhoenixConnection(Connection conn) {
        return new LoggingPhoenixConnection(conn, new PhoenixMetricsLog(){

            public void logOverAllReadRequestMetrics(Map<MetricType, Long> overAllQueryMetrics, String sql) {
                PhoenixLoggingMetricsIT.this.overAllQueryMetricsMap.putAll(overAllQueryMetrics);
                PhoenixLoggingMetricsIT.this.loggedSql = sql;
                ++PhoenixLoggingMetricsIT.this.logOverAllReadRequestMetricsFuncCallCount;
            }

            public void logRequestReadMetrics(Map<String, Map<MetricType, Long>> requestReadMetrics, String sql) {
                PhoenixLoggingMetricsIT.this.requestReadMetricsMap.putAll(requestReadMetrics);
                PhoenixLoggingMetricsIT.this.loggedSql = sql;
                ++PhoenixLoggingMetricsIT.this.logRequestReadMetricsFuncCallCount;
            }

            public void logWriteMetricsfoForMutationsSinceLastReset(Map<String, Map<MetricType, Long>> mutationWriteMetrics) {
                PhoenixLoggingMetricsIT.this.mutationWriteMetricsMap.putAll(mutationWriteMetrics);
            }

            public void logReadMetricInfoForMutationsSinceLastReset(Map<String, Map<MetricType, Long>> mutationReadMetrics) {
                PhoenixLoggingMetricsIT.this.mutationReadMetricsMap.putAll(mutationReadMetrics);
            }
        });
    }
}

